/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.exceptions.DuplicateColumnNameException;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.table.CorrespondentColumnsMapping;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public final class ColumnCreator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");

    private ColumnCreator() {
    }

    public static DatastoreField createAdapterColumn(JavaTypeMapping adapterMapping, StoreManager storeMgr, ClassLoaderResolver clr, DatastoreContainerObject table, ColumnMetaData colmd, boolean pk) {
        DatastoreIdentifier identifier = null;
        identifier = colmd != null && colmd.getName() != null ? storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmd.getName()) : ((RDBMSIdentifierFactory)storeMgr.getIdentifierFactory()).newAdapterIndexFieldIdentifier();
        DatastoreField adapterColumn = table.addDatastoreField(adapterMapping.getType(), identifier, adapterMapping, colmd);
        storeMgr.getMappingManager().createDatastoreMapping(adapterMapping, storeMgr, adapterColumn, adapterMapping.getJavaType().getName());
        if (pk) {
            adapterColumn.setAsPrimaryKey();
        }
        return adapterColumn;
    }

    public static JavaTypeMapping createColumnsForJoinTables(Class javaType, AbstractPropertyMetaData fmd, ColumnMetaData[] columnMetaData, StoreManager storeMgr, DatastoreContainerObject table, boolean primaryKey, boolean nullable, boolean serialised, boolean embedded, int fieldRole, ClassLoaderResolver clr, JavaTypeMapping adapterColumnMapping, boolean adapterColumnMandatory) {
        return ColumnCreator.createColumnsForField(javaType, null, table, storeMgr, fmd, primaryKey, nullable, serialised, embedded, fieldRole, adapterColumnMapping, adapterColumnMandatory, columnMetaData, clr, false);
    }

    public static void createColumnsForFieldUsingSubclassTable(JavaTypeMapping mapping, DatastoreContainerObject table, AbstractPropertyMetaData fmd, ClassLoaderResolver clr) {
        StoreManager storeMgr = table.getStoreManager();
        AbstractClassMetaData refCmd = storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getType(), clr);
        if (refCmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.SUBCLASS_TABLE) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.ColumnCreation.FieldShouldBeSubclassTableButIsnt", fmd.getFullFieldName()));
        }
        AbstractClassMetaData[] subclassCmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
        boolean pk = false;
        if (subclassCmds.length > 1) {
            pk = false;
        }
        boolean nullable = true;
        if (subclassCmds.length > 1) {
            nullable = true;
        }
        int colPos = 0;
        for (int i = 0; i < subclassCmds.length; ++i) {
            Class type = clr.classForName(subclassCmds[i].getFullClassName());
            DatastoreClass dc = storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), clr);
            JavaTypeMapping m = dc.getIDMapping();
            ColumnMetaData[] columnMetaDataForType = null;
            if (fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0) {
                if (fmd.getColumnMetaData().length < colPos + m.getNumberOfDatastoreFields()) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.ColumnCreation.DeclaredColumnsError", fmd.getFullFieldName(), "" + fmd.getColumnMetaData().length, "" + (colPos + m.getNumberOfDatastoreFields())));
                }
                columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreFields()];
                System.arraycopy(fmd.getColumnMetaData(), colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                colPos += columnMetaDataForType.length;
            }
            ColumnCreator.createColumnsForField(type, mapping, table, storeMgr, fmd, pk, nullable, false, false, 2, null, false, columnMetaDataForType, clr, true);
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.ColumnCreation.ColumnAddedForSubclassType", type, fmd.getName()));
        }
    }

    public static void createColumnsForFieldUsingReference(JavaTypeMapping mapping, DatastoreContainerObject table, AbstractPropertyMetaData fmd, ClassLoaderResolver clr, boolean embedded) {
        ColumnCreator.createColumnsForReferenceField(mapping, table, fmd, false, true, false, embedded, 2, fmd.getColumnMetaData(), null, false, clr);
    }

    private static void createColumnsForReferenceField(JavaTypeMapping mapping, DatastoreContainerObject table, AbstractPropertyMetaData fmd, boolean isPrimaryKey, boolean isNullable, boolean serialised, boolean embedded, int fieldRole, ColumnMetaData[] columnMetaData, JavaTypeMapping adapterColumnMapping, boolean adapterColumnMandatory, ClassLoaderResolver clr) {
        String[] implTypes = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(fmd, fieldRole, clr);
        String fieldTypeName = fmd.getTypeName();
        if (fmd.hasCollection()) {
            fieldTypeName = fmd.getCollection().getElementType();
        } else if (fmd.hasArray()) {
            fieldTypeName = fmd.getArray().getElementType();
        } else if (fmd.hasMap()) {
            if (fieldRole == 5) {
                fieldTypeName = fmd.getMap().getKeyType();
            } else if (fieldRole == 6) {
                fieldTypeName = fmd.getMap().getValueType();
            }
        }
        StoreManager storeMgr = table.getStoreManager();
        boolean isPersistentInterfaceField = storeMgr.getMetaDataManager().isPersistentInterface(fieldTypeName);
        boolean pk = isPrimaryKey;
        boolean nullable = isNullable;
        if (implTypes.length > 1) {
            pk = false;
        }
        if (implTypes.length > 1 && !pk) {
            nullable = true;
        }
        int colPos = 0;
        int numberOfDatastoreFieldsPerMapping = 0;
        int numberOfRequiredImpls = 0;
        Class[] implTypeClasses = new Class[implTypes.length];
        for (int i = 0; i < implTypes.length; ++i) {
            JavaTypeMapping m;
            String implName = implTypes[i];
            Class type = clr.classForName(implName);
            if (type == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.ColumnCreation.ImplementationClassNotFound", fmd.getTypeName(), implName));
            }
            if (type.isInterface()) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.ColumnCreation.ImplementationClassIsInterface", fmd.getTypeName(), implName));
            }
            implTypeClasses[i] = type;
            boolean columnsNeeded = true;
            for (int j = 0; j < i; ++j) {
                if (!type.isAssignableFrom(implTypeClasses[j]) && !implTypeClasses[j].isAssignableFrom(type)) continue;
                columnsNeeded = false;
                break;
            }
            if (isPersistentInterfaceField && !storeMgr.getMetaDataManager().isPersistentInterfaceImplementation(fieldTypeName, implName)) {
                columnsNeeded = false;
            }
            if (!columnsNeeded) continue;
            if (storeMgr.getOMFContext().getTypeManager().isSupportedType(type.getName())) {
                m = storeMgr.getDatastoreAdapter().getMapping(type, serialised, embedded, fmd.getFullFieldName(), storeMgr);
            } else {
                try {
                    DatastoreClass dc = storeMgr.getDatastoreClass(type.getName(), clr);
                    m = dc.getIDMapping();
                }
                catch (NoTableManagedException ex) {
                    throw new JPOXUserException("Cannot define columns for " + fmd.getFullFieldName() + " due to " + ex.getMessage(), ex);
                }
            }
            numberOfDatastoreFieldsPerMapping = m.getNumberOfDatastoreFields();
            ++numberOfRequiredImpls;
            ColumnMetaData[] columnMetaDataForType = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                if (columnMetaData.length < colPos + m.getNumberOfDatastoreFields()) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.ColumnCreation.DeclaredColumnsError", fmd.getFullFieldName(), "" + columnMetaData.length, "" + (colPos + m.getNumberOfDatastoreFields())));
                }
                columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreFields()];
                System.arraycopy(columnMetaData, colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                colPos += columnMetaDataForType.length;
            }
            ColumnCreator.createColumnsForField(type, mapping, table, storeMgr, fmd, pk, nullable, serialised, embedded, fieldRole, adapterColumnMapping, adapterColumnMandatory, columnMetaDataForType, clr, true);
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.ColumnCreation.ColumnAddedForReferenceType", type, fmd.getName()));
        }
        if (isPrimaryKey && numberOfDatastoreFieldsPerMapping * numberOfRequiredImpls > 1) {
            ColumnMetaData colmd = null;
            if (fmd.hasExtension("adapter-column-name")) {
                colmd = new ColumnMetaData((ExtendableMetaData)fmd, fmd.getValueForExtension("adapter-column-name"));
            }
            ColumnCreator.createAdapterColumn(adapterColumnMapping, storeMgr, clr, table, colmd, true);
        }
    }

    private static JavaTypeMapping createColumnsForField(Class javaType, JavaTypeMapping mapping, DatastoreContainerObject table, StoreManager storeMgr, AbstractPropertyMetaData fmd, boolean isPrimaryKey, boolean isNullable, boolean serialised, boolean embedded, int fieldRole, JavaTypeMapping adapterColumnMapping, boolean adapterColumnMandatory, ColumnMetaData[] columnMetaData, ClassLoaderResolver clr, boolean isReferenceField) {
        if (mapping == null) {
            mapping = storeMgr.getDatastoreAdapter().getMapping(javaType, serialised, embedded, fmd != null ? fmd.getFullFieldName() : null, storeMgr);
        }
        if (mapping instanceof InterfaceMapping && fmd != null && fmd.hasExtension("implementation-classes")) {
            ((InterfaceMapping)mapping).setImplementationClasses(fmd.getValueForExtension("implementation-classes"));
        }
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        if (storeMgr.getOMFContext().getTypeManager().isReferenceType(javaType) && !serialised && !embedded) {
            ColumnCreator.createColumnsForReferenceField(mapping, table, fmd, isPrimaryKey, isNullable, serialised, embedded, fieldRole, columnMetaData, adapterColumnMapping, adapterColumnMandatory, clr);
        } else if (mapping instanceof ReferenceMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping || mapping instanceof PersistenceCapableMapping) {
            JavaTypeMapping container = mapping;
            if (mapping instanceof ReferenceMapping) {
                container = storeMgr.getDatastoreAdapter().getMapping(javaType, serialised, embedded, fmd != null ? fmd.getFullFieldName() : null, storeMgr);
                ((ReferenceMapping)mapping).addJavaTypeMapping(container);
            }
            if (container instanceof SerialisedPCMapping || container instanceof SerialisedReferenceMapping) {
                return mapping;
            }
            DatastoreClass destinationTable = storeMgr.getDatastoreClass(javaType.getName(), clr);
            if (destinationTable == null) {
                AbstractClassMetaData ownerCmd = storeMgr.getMetaDataManager().getMetaDataForClass(javaType, clr);
                AbstractClassMetaData[] ownerCmds = storeMgr.getClassesManagingTableForClass(ownerCmd, clr);
                if (ownerCmds == null || ownerCmds.length == 0) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.OwnerHasNoTable", javaType.getName())).setFatal();
                }
                destinationTable = storeMgr.getDatastoreClass(ownerCmds[0].getFullClassName(), clr);
            }
            if (destinationTable != null) {
                JavaTypeMapping m = destinationTable.getIDMapping();
                ColumnMetaDataContainer columnContainer = null;
                if (columnMetaData != null && columnMetaData.length > 0) {
                    columnContainer = (ColumnMetaDataContainer)((Object)columnMetaData[0].getParent());
                }
                CorrespondentColumnsMapping correspondentColumnsMapping = new CorrespondentColumnsMapping(columnContainer, columnMetaData, m, true);
                for (int i = 0; i < m.getNumberOfDatastoreFields(); ++i) {
                    JavaTypeMapping refDatastoreMapping = storeMgr.getDatastoreAdapter().getMapping(m.getDataStoreMapping(i).getJavaTypeMapping().getJavaType(), storeMgr);
                    ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(m.getDataStoreMapping(i).getDatastoreField().getIdentifier());
                    try {
                        DatastoreIdentifier identifier = null;
                        identifier = colmd.getName() == null ? (isReferenceField ? idFactory.newReferenceFieldIdentifier(fmd, storeMgr.getMetaDataManager().getMetaDataForClass(javaType, clr), m.getDataStoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole) : ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, fmd.getRelatedFieldMetaData(clr), m.getDataStoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole)) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        DatastoreField column = table.addDatastoreField(javaType.getName(), identifier, refDatastoreMapping, colmd);
                        ((Column)m.getDataStoreMapping(i).getDatastoreField()).copyConfigurationTo(column);
                        if (isPrimaryKey) {
                            column.setAsPrimaryKey();
                        }
                        if (isNullable) {
                            column.setNullable();
                        }
                        storeMgr.getMappingManager().createDatastoreMapping(refDatastoreMapping, storeMgr, column, m.getDataStoreMapping(i).getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                    }
                    catch (DuplicateColumnNameException ex) {
                        throw new JPOXUserException("Cannot create column for field " + fmd.getFullFieldName() + " column metadata " + colmd, ex);
                    }
                    ((PersistenceCapableMapping)container).addJavaTypeMapping(refDatastoreMapping);
                }
            }
        } else {
            DatastoreField column = null;
            ColumnMetaData colmd = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                colmd = columnMetaData[0];
            }
            DatastoreIdentifier identifier = null;
            identifier = colmd != null && colmd.getName() != null ? idFactory.newDatastoreFieldIdentifier(colmd.getName()) : ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, null, null, storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole);
            column = table.addDatastoreField(javaType.getName(), identifier, mapping, colmd);
            storeMgr.getMappingManager().createDatastoreMapping(mapping, storeMgr, column, mapping.getJavaTypeForDatastoreMapping(0));
            if (isPrimaryKey) {
                if (adapterColumnMapping != null && !((RDBMSAdapter)storeMgr.getDatastoreAdapter()).isValidPrimaryKeyType(((Column)column).getJdbcType())) {
                    colmd = null;
                    if (fmd.hasExtension("adapter-column-name")) {
                        colmd = new ColumnMetaData((ExtendableMetaData)fmd, fmd.getValueForExtension("adapter-column-name"));
                    }
                    ColumnCreator.createAdapterColumn(adapterColumnMapping, storeMgr, clr, table, colmd, true);
                } else {
                    column.setAsPrimaryKey();
                }
            }
            if (isNullable) {
                column.setNullable();
            }
        }
        return mapping;
    }
}

