/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.util.HashMap;
import java.util.Map;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MultiMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.util.Localiser;

public class CorrespondentColumnsMapping {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private final Map columnMetaDataBySideBIdentifier = new HashMap();
    private final String columnsName;

    public CorrespondentColumnsMapping(ColumnMetaDataContainer columnContainer, ColumnMetaData[] colmds, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null && colmds != null) {
            int i;
            int noOfUserColumns = colmds.length;
            StringBuffer str = new StringBuffer("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfDatastoreFields()) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.ColumnNumbersMismatch", this.columnsName, "" + noOfUserColumns, "" + mappingSideB.getNumberOfDatastoreFields())).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfDatastoreFields()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfDatastoreFields()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfDatastoreFields(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getDataStoreMapping(i3).getDatastoreField().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = null;
            sideBidMappings = mappingSideB instanceof PersistenceCapableMapping ? ((PersistenceCapableMapping)mappingSideB).getJavaTypeMapping() : ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetField()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getFieldMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifier();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getIdentifier().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.ColumnTargetDoesntExist", this.columnsName, colmds[i].getName(), targetColumnName)).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.NoRemainingColumnsToMapTo", this.columnsName, "" + i)).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData((ExtendableMetaData)((Object)columnContainer), (String)null);
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getDataStoreMapping(i).getDatastoreField().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData((ExtendableMetaData)((Object)columnContainer), (String)null);
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public CorrespondentColumnsMapping(ColumnMetaDataContainer columnContainer, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null) {
            int i;
            int noOfUserColumns = columnContainer.getColumnMetaData().length;
            ColumnMetaData[] colmds = columnContainer.getColumnMetaData();
            StringBuffer str = new StringBuffer("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfDatastoreFields()) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.ColumnNumbersMismatch", this.columnsName, "" + noOfUserColumns, "" + mappingSideB.getNumberOfDatastoreFields())).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfDatastoreFields()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfDatastoreFields()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfDatastoreFields(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getDataStoreMapping(i3).getDatastoreField().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = null;
            sideBidMappings = mappingSideB instanceof PersistenceCapableMapping ? ((PersistenceCapableMapping)mappingSideB).getJavaTypeMapping() : ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetField()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getFieldMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifier();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getIdentifier().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.ColumnTargetDoesntExist", this.columnsName, colmds[i].getName(), targetColumnName)).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.NoRemainingColumnsToMapTo", this.columnsName, "" + i)).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData((ExtendableMetaData)((Object)columnContainer), (String)null);
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getDataStoreMapping(i).getDatastoreField().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData((ExtendableMetaData)((Object)columnContainer), (String)null);
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public ColumnMetaData getColumnMetaDataByIdentifier(DatastoreIdentifier name) {
        return (ColumnMetaData)this.columnMetaDataBySideBIdentifier.get(name);
    }

    private void putColumn(DatastoreIdentifier identifier, ColumnMetaData colmd) {
        if (this.columnMetaDataBySideBIdentifier.put(identifier, colmd) != null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.CorrespondentColumnsMapping.ColumnMappedTwice", identifier, this.columnsName)).setFatal();
        }
    }
}

