/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.MapMetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.mapping.EmbeddedKeyPCMapping;
import org.jpox.store.mapping.EmbeddedMapping;
import org.jpox.store.mapping.EmbeddedValuePCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Index;
import org.jpox.store.rdbms.table.ColumnCreator;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.SCOTable;
import org.jpox.store.rdbms.table.TableUtils;
import org.jpox.util.JPOXLogger;

public class MapTable
extends JoinTable
implements SCOTable {
    private JavaTypeMapping keyMapping;
    private JavaTypeMapping valueMapping;
    private JavaTypeMapping adapterMapping;
    protected Map embeddedKeyMappingsMap;
    protected Map embeddedValueMappingsMap;

    public MapTable(DatastoreIdentifier tableName, AbstractPropertyMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        MapMetaData mmd = this.fmd.getMap();
        if (mmd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.MapMetaDataError", this.fmd));
        }
        PrimaryKeyMetaData pkmd = this.fmd.getJoinMetaData() != null ? this.fmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null && pkmd.getColumnMetaData() != null;
        boolean pkRequired = this.requiresPrimaryKey();
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(this.ownerType), this.fmd, this.fmd.getJoinMetaData() == null ? null : this.fmd.getJoinMetaData().getColumnMetaData(), this.storeMgr, this, true, false, false, false, 1, clr, null, false);
        if (this.isSerialisedKey() || this.isEmbeddedKeyPC()) {
            if (!(!pkRequired || pkColsSpecified || this.isEmbeddedKeyPC() && this.fmd.getMap().getKeyClassMetaData().getIdentityType() == IdentityType.APPLICATION)) {
                ColumnMetaData colmd = null;
                if (this.fmd.hasExtension("adapter-column-name")) {
                    colmd = new ColumnMetaData((ExtendableMetaData)this.fmd, this.fmd.getValueForExtension("adapter-column-name"));
                }
                this.adapterMapping = this.dba.getMapping(Long.TYPE, this.storeMgr);
                ColumnCreator.createAdapterColumn(this.adapterMapping, this.storeMgr, clr, this, colmd, pkRequired);
            }
            this.keyMapping = this.dba.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 3);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                this.debugMapping(this.keyMapping);
            }
            if (pkRequired && !pkColsSpecified && this.isEmbeddedKeyPC() && this.fmd.getMap().getKeyClassMetaData().getIdentityType() == IdentityType.APPLICATION) {
                int numberOfKeyColumns = this.keyMapping.getNumberOfDatastoreFields();
                for (int i = 0; i < numberOfKeyColumns; ++i) {
                    if (!this.keyMapping.getDataStoreMapping(i).getJavaTypeMapping().getFieldMetaData().isPrimaryKey()) continue;
                    this.keyMapping.getDataStoreMapping(i).getDatastoreField().setAsPrimaryKey();
                }
            }
        } else {
            this.adapterMapping = this.dba.getMapping(Long.TYPE, this.storeMgr);
            this.keyMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(mmd.getKeyType()), this.fmd, this.fmd.getKeyMetaData() == null ? null : this.fmd.getKeyMetaData().getColumnMetaData(), this.storeMgr, this, pkRequired && !pkColsSpecified, false, this.fmd.getMap().isSerializedKey(), false, 5, clr, this.adapterMapping, false);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                this.debugMapping(this.keyMapping);
            }
            if (this.adapterMapping.getNumberOfDatastoreFields() < 1) {
                this.adapterMapping = null;
            }
        }
        if (this.isSerialisedValue() || this.isEmbeddedValuePC()) {
            this.valueMapping = this.dba.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 4);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                this.debugMapping(this.valueMapping);
            }
        } else {
            this.valueMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(mmd.getValueType()), this.fmd, this.fmd.getValueMetaData() == null ? null : this.fmd.getValueMetaData().getColumnMetaData(), this.storeMgr, this, false, true, this.fmd.getMap().isSerializedValue(), false, 6, clr, null, false);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                this.debugMapping(this.valueMapping);
            }
        }
        if (pkRequired && pkColsSpecified) {
            this.applyUserPrimaryKeySpecification(pkmd);
        }
        this.state = 2;
    }

    protected void applyUserPrimaryKeySpecification(PrimaryKeyMetaData pkmd) {
        ColumnMetaData[] pkCols = pkmd.getColumnMetaData();
        for (int i = 0; i < pkCols.length; ++i) {
            int j;
            String colName = pkCols[i].getName();
            boolean found = false;
            for (j = 0; j < this.ownerMapping.getNumberOfDatastoreFields(); ++j) {
                if (!this.ownerMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                this.ownerMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                found = true;
            }
            if (!found) {
                for (j = 0; j < this.keyMapping.getNumberOfDatastoreFields(); ++j) {
                    if (!this.keyMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                    this.keyMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (!found) {
                for (j = 0; j < this.valueMapping.getNumberOfDatastoreFields(); ++j) {
                    if (!this.valueMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                    this.valueMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (found) continue;
            throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.PrimaryKeyColumnNotFound", this.toString(), colName));
        }
    }

    public boolean isEmbeddedKey() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey()) {
            return false;
        }
        if (this.fmd.getMap().getKeyClassMetaData() == null) {
            return true;
        }
        return this.fmd.getKeyMetaData() != null && this.fmd.getKeyMetaData().getEmbeddedMetaData() != null;
    }

    public boolean isSerialisedKey() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey();
    }

    public boolean isSerialisedKeyPC() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey() && this.fmd.getMap().getKeyClassMetaData() != null;
    }

    public boolean isEmbeddedKeyPC() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey()) {
            return false;
        }
        return this.fmd.getKeyMetaData() != null && this.fmd.getKeyMetaData().getEmbeddedMetaData() != null;
    }

    public boolean isEmbeddedValue() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue()) {
            return false;
        }
        if (this.fmd.getMap().getValueClassMetaData() == null) {
            return true;
        }
        return this.fmd.getValueMetaData() != null && this.fmd.getValueMetaData().getEmbeddedMetaData() != null;
    }

    public boolean isSerialisedValue() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue();
    }

    public boolean isSerialisedValuePC() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue() && this.fmd.getMap().getValueClassMetaData() != null;
    }

    public boolean isEmbeddedValuePC() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue()) {
            return false;
        }
        return this.fmd.getValueMetaData() != null && this.fmd.getValueMetaData().getEmbeddedMetaData() != null;
    }

    public JavaTypeMapping getKeyMapping() {
        this.assertIsInitialized();
        return this.keyMapping;
    }

    public JavaTypeMapping getValueMapping() {
        this.assertIsInitialized();
        return this.valueMapping;
    }

    public String getKeyType() {
        return this.fmd.getMap().getKeyType();
    }

    public String getValueType() {
        return this.fmd.getMap().getValueType();
    }

    public JavaTypeMapping getAdapterMapping() {
        this.assertIsInitialized();
        return this.adapterMapping;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getForeignKeyCreateMode() == "AUTO") {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKey fk;
            Collection fks;
            AbstractPropertyMetaData embFmd;
            JavaTypeMapping embFieldMapping;
            EmbeddedMapping embMapping;
            ForeignKey fk2;
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.ownerType, clr);
            if (referencedTable != null) {
                fkmd = null;
                if (this.fmd.getJoinMetaData() != null) {
                    fkmd = this.fmd.getJoinMetaData().getForeignKeyMetaData();
                }
                if (fkmd != null || autoMode) {
                    fk2 = new ForeignKey(this.ownerMapping, this.dba, referencedTable, true);
                    fk2.setForMetaData(fkmd);
                    foreignKeys.add(fk2);
                }
            }
            if (!this.isSerialisedValuePC()) {
                if (this.isEmbeddedValuePC()) {
                    embMapping = (EmbeddedValuePCMapping)this.valueMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getFieldMetaData();
                        if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else {
                    referencedTable = this.storeMgr.getDatastoreClass(this.fmd.getMap().getValueType(), clr);
                    if (referencedTable != null) {
                        fkmd = null;
                        if (this.fmd.getValueMetaData() != null) {
                            fkmd = this.fmd.getValueMetaData().getForeignKeyMetaData();
                        }
                        if (fkmd != null || autoMode) {
                            fk2 = new ForeignKey(this.valueMapping, this.dba, referencedTable, true);
                            fk2.setForMetaData(fkmd);
                            foreignKeys.add(fk2);
                        }
                    }
                }
            }
            if (!this.isSerialisedKeyPC()) {
                if (this.isEmbeddedKeyPC()) {
                    embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getFieldMetaData();
                        if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else {
                    referencedTable = this.storeMgr.getDatastoreClass(this.fmd.getMap().getKeyType(), clr);
                    if (referencedTable != null) {
                        fkmd = null;
                        if (this.fmd.getKeyMetaData() != null) {
                            fkmd = this.fmd.getKeyMetaData().getForeignKeyMetaData();
                        }
                        if (fkmd != null || autoMode) {
                            fk2 = new ForeignKey(this.keyMapping, this.dba, referencedTable, true);
                            fk2.setForMetaData(fkmd);
                            foreignKeys.add(fk2);
                        }
                    }
                }
            }
        }
        catch (NoTableManagedException e) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Index index;
        IndexMetaData imd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedMapping embMapping;
        Set indices = super.getExpectedIndices(clr);
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        CandidateKey ck;
        UniqueMetaData umd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedMapping embMapping;
        List candidateKeys = super.getExpectedCandidateKeys();
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    public JavaTypeMapping getFieldMapping(AbstractPropertyMetaData fmd) {
        return null;
    }
}

