/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jpox.transaction.HeuristicMixedException;
import org.jpox.transaction.HeuristicRollbackException;
import org.jpox.transaction.RollbackException;
import org.jpox.transaction.XidImpl;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.omg.CORBA.SystemException;

public class Transaction {
    private static final int nodeId = new Random().nextInt();
    private static int nextGlobalTransactionId = 1;
    private int nextBranchId = 1;
    private final Xid xid;
    private int status;
    private boolean completing = false;
    private List synchronization = new ArrayList();
    private List enlistedResources = new ArrayList();
    private Map branches = new HashMap();
    private Map activeBranches = new HashMap();
    private Map suspendedResources = new HashMap();
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");

    Transaction() {
        this.xid = new XidImpl(nodeId, 0, nextGlobalTransactionId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.completing) {
            return;
        }
        if (this.status == 1) {
            this.rollback();
            return;
        }
        try {
            XAResource resourceManager;
            Object key;
            this.completing = true;
            if (this.status != 0) {
                throw new IllegalStateException();
            }
            Iterator syncIterator = this.synchronization.iterator();
            while (syncIterator.hasNext()) {
                Synchronization sync = (Synchronization)syncIterator.next();
                sync.beforeCompletion();
            }
            ArrayList<Throwable> failures = null;
            boolean failed = false;
            Iterator branchKeys = this.branches.keySet().iterator();
            if (this.enlistedResources.size() == 1) {
                this.status = 8;
                while (branchKeys.hasNext()) {
                    key = branchKeys.next();
                    resourceManager = (XAResource)this.branches.get(key);
                    try {
                        if (!failed) {
                            resourceManager.commit(this.xid, true);
                            continue;
                        }
                        resourceManager.rollback(this.xid);
                    }
                    catch (Throwable e) {
                        if (failures == null) {
                            failures = new ArrayList<Throwable>();
                        }
                        failures.add(e);
                        failed = true;
                        this.status = 1;
                        LOCALISER.msg("Transaction.Fail", "commit", resourceManager, Transaction.getXAErrorCode(e), this.toString());
                    }
                }
                this.status = !failed ? 3 : 4;
            } else if (this.enlistedResources.size() > 0) {
                this.status = 7;
                while (!failed && branchKeys.hasNext()) {
                    key = branchKeys.next();
                    resourceManager = (XAResource)this.branches.get(key);
                    try {
                        resourceManager.prepare((Xid)key);
                    }
                    catch (Throwable e) {
                        if (failures == null) {
                            failures = new ArrayList();
                        }
                        failures.add(e);
                        failed = true;
                        this.status = 1;
                        LOCALISER.msg("Transaction.Fail", "prepare", resourceManager, Transaction.getXAErrorCode(e), this.toString());
                    }
                }
                if (!failed) {
                    this.status = 2;
                }
                if (failed) {
                    this.status = 9;
                    failed = false;
                    branchKeys = this.branches.keySet().iterator();
                    while (branchKeys.hasNext()) {
                        key = branchKeys.next();
                        resourceManager = (XAResource)this.branches.get(key);
                        try {
                            resourceManager.rollback((Xid)key);
                        }
                        catch (Throwable e) {
                            LOCALISER.msg("Transaction.Fail", "rollback", resourceManager, Transaction.getXAErrorCode(e), this.toString());
                            if (failures == null) {
                                failures = new ArrayList();
                            }
                            failures.add(e);
                            failed = true;
                        }
                    }
                    this.status = 4;
                } else {
                    this.status = 8;
                    branchKeys = this.branches.keySet().iterator();
                    while (branchKeys.hasNext()) {
                        key = branchKeys.next();
                        resourceManager = (XAResource)this.branches.get(key);
                        try {
                            resourceManager.commit((Xid)key, false);
                        }
                        catch (Throwable e) {
                            LOCALISER.msg("Transaction.Fail", "commit", resourceManager, Transaction.getXAErrorCode(e), this.toString());
                            if (failures == null) {
                                failures = new ArrayList();
                            }
                            failures.add(e);
                            failed = true;
                        }
                    }
                    this.status = 3;
                }
            }
            syncIterator = this.synchronization.iterator();
            while (syncIterator.hasNext()) {
                Synchronization sync = (Synchronization)syncIterator.next();
                sync.afterCompletion(this.status);
            }
            if (this.status == 4) {
                if (failed) {
                    throw new HeuristicRollbackException();
                }
                throw new RollbackException();
            }
            if (this.status == 3 && failed) {
                throw new HeuristicMixedException();
            }
        }
        finally {
            this.completing = false;
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (xaRes == null) {
            return false;
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Xid xid = (Xid)this.activeBranches.get(xaRes);
        if (xid == null) {
            throw new IllegalStateException();
        }
        this.activeBranches.remove(xaRes);
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.error(LOCALISER.msg("Transaction.Running", "delist", xaRes, Transaction.getXAFlag(flag), this.toString()));
        }
        XAException exception = null;
        try {
            xaRes.end(xid, flag);
        }
        catch (XAException e) {
            exception = e;
        }
        if (exception != null) {
            JPOXLogger.TRANSACTION.error(LOCALISER.msg("Transaction.Fail", "delist", xaRes, Transaction.getXAErrorCode(exception), this.toString()));
            return false;
        }
        if (flag == 0x2000000) {
            this.suspendedResources.put(xaRes, xid);
        }
        return true;
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (xaRes == null) {
            return false;
        }
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Xid activeXid = (Xid)this.activeBranches.get(xaRes);
        if (activeXid != null) {
            return false;
        }
        boolean alreadyEnlisted = false;
        int flag = 0;
        Xid branchXid = (Xid)this.suspendedResources.get(xaRes);
        if (branchXid == null) {
            Iterator enlistedIterator = this.enlistedResources.iterator();
            while (!alreadyEnlisted && enlistedIterator.hasNext()) {
                XAResource resourceManager = (XAResource)enlistedIterator.next();
                try {
                    if (!resourceManager.isSameRM(xaRes)) continue;
                    flag = 0x200000;
                    alreadyEnlisted = true;
                }
                catch (XAException e) {}
            }
            branchXid = new XidImpl(this.nextBranchId++, this.xid.getFormatId(), this.xid.getGlobalTransactionId());
        } else {
            alreadyEnlisted = true;
            flag = 0x8000000;
            this.suspendedResources.remove(xaRes);
        }
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.Running", "enlist", xaRes, Transaction.getXAFlag(flag), this.toString()));
        }
        try {
            xaRes.start(branchXid, flag);
        }
        catch (XAException e) {
            JPOXLogger.TRANSACTION.error(LOCALISER.msg("Transaction.Fail", "enlist", xaRes, Transaction.getXAErrorCode(e), this.toString()));
            return false;
        }
        if (!alreadyEnlisted) {
            this.enlistedResources.add(xaRes);
        }
        this.branches.put(branchXid, xaRes);
        this.activeBranches.put(xaRes, branchXid);
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization arg0) throws RollbackException, IllegalStateException, SystemException {
        if (arg0 == null) {
            return;
        }
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        this.synchronization.add(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        if (this.completing) {
            return;
        }
        try {
            this.completing = true;
            if (this.status != 0 && this.status != 1) {
                throw new IllegalStateException();
            }
            ArrayList<Throwable> failures = null;
            Iterator branchKeys = this.branches.keySet().iterator();
            this.status = 9;
            while (branchKeys.hasNext()) {
                Xid xid = (Xid)branchKeys.next();
                XAResource resourceManager = (XAResource)this.branches.get(xid);
                try {
                    resourceManager.rollback(xid);
                }
                catch (Throwable e) {
                    if (failures == null) {
                        failures = new ArrayList<Throwable>();
                    }
                    failures.add(e);
                    LOCALISER.msg("Transaction.Fail", "rollback", resourceManager, Transaction.getXAErrorCode(e), this.toString());
                }
            }
            this.status = 4;
            Iterator syncIterator = this.synchronization.iterator();
            while (syncIterator.hasNext()) {
                Synchronization sync = (Synchronization)syncIterator.next();
                sync.afterCompletion(this.status);
            }
        }
        finally {
            this.completing = false;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public static String getXAErrorCode(Throwable xae) {
        if (!(xae instanceof XAException)) {
            return "UNKNOWN";
        }
        switch (((XAException)xae).errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 100: {
                return "XA_RBBASE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBBEADLOCK";
            }
            case 107: {
                return "XA_RBEND";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "UNKNOWN";
    }

    private static String getXAFlag(int flag) {
        switch (flag) {
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
        }
        return "UNKNOWN";
    }
}

