/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class AIDUtils {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    static /* synthetic */ Class class$javax$jdo$identity$SingleFieldIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$LongIdentity;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$jdo$identity$IntIdentity;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$jdo$identity$StringIdentity;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$jdo$identity$ByteIdentity;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$javax$jdo$identity$ShortIdentity;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$javax$jdo$identity$CharIdentity;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;

    private AIDUtils() {
    }

    public static Object getPKFieldValueFromId(Object id, int fieldNumber, AbstractClassMetaData cmd) {
        if (cmd.getIdentityType() != IdentityType.APPLICATION) {
            return null;
        }
        AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(fieldNumber);
        if (!fmd.isPrimaryKey()) {
            return null;
        }
        String fieldName = fmd.getName();
        try {
            Field fld = id.getClass().getDeclaredField(fieldName);
            Object value = fld.get(id);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getNewObjectId(PersistenceCapable pc, AbstractClassMetaData cmd) {
        Object userOid = pc.jdoNewObjectIdInstance();
        if (!cmd.usesSingleFieldIdentityClass()) {
            pc.jdoCopyKeyFieldsToObjectId(userOid);
        }
        return userOid;
    }

    public static SingleFieldIdentity getNewSingleFieldIdentity(Class idType, Class pcType, Object value) {
        if (idType == null) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.IdTypeNull", pcType)).setFatal();
        }
        if (pcType == null) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.PcTypeNull", idType)).setFatal();
        }
        if (value == null) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueNull", idType, pcType)).setFatal();
        }
        if (!(class$javax$jdo$identity$SingleFieldIdentity == null ? (class$javax$jdo$identity$SingleFieldIdentity = AIDUtils.class$("javax.jdo.identity.SingleFieldIdentity")) : class$javax$jdo$identity$SingleFieldIdentity).isAssignableFrom(idType)) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.IdTypeInvalid", idType.getName(), pcType.getName())).setFatal();
        }
        SingleFieldIdentity id = null;
        Class keyType = null;
        if (idType == (class$javax$jdo$identity$LongIdentity == null ? (class$javax$jdo$identity$LongIdentity = AIDUtils.class$("javax.jdo.identity.LongIdentity")) : class$javax$jdo$identity$LongIdentity)) {
            Class clazz = keyType = class$java$lang$Long == null ? (class$java$lang$Long = AIDUtils.class$("java.lang.Long")) : class$java$lang$Long;
            if (!(value instanceof Long)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Long")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = AIDUtils.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity)) {
            Class clazz = keyType = class$java$lang$Integer == null ? (class$java$lang$Integer = AIDUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
            if (!(value instanceof Integer)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Integer")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$StringIdentity == null ? (class$javax$jdo$identity$StringIdentity = AIDUtils.class$("javax.jdo.identity.StringIdentity")) : class$javax$jdo$identity$StringIdentity)) {
            Class clazz = keyType = class$java$lang$String == null ? (class$java$lang$String = AIDUtils.class$("java.lang.String")) : class$java$lang$String;
            if (!(value instanceof String)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "String")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$ByteIdentity == null ? (class$javax$jdo$identity$ByteIdentity = AIDUtils.class$("javax.jdo.identity.ByteIdentity")) : class$javax$jdo$identity$ByteIdentity)) {
            Class clazz = keyType = class$java$lang$Byte == null ? (class$java$lang$Byte = AIDUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
            if (!(value instanceof Byte)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Byte")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$ShortIdentity == null ? (class$javax$jdo$identity$ShortIdentity = AIDUtils.class$("javax.jdo.identity.ShortIdentity")) : class$javax$jdo$identity$ShortIdentity)) {
            Class clazz = keyType = class$java$lang$Short == null ? (class$java$lang$Short = AIDUtils.class$("java.lang.Short")) : class$java$lang$Short;
            if (!(value instanceof Short)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Short")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$CharIdentity == null ? (class$javax$jdo$identity$CharIdentity = AIDUtils.class$("javax.jdo.identity.CharIdentity")) : class$javax$jdo$identity$CharIdentity)) {
            Class clazz = keyType = class$java$lang$Character == null ? (class$java$lang$Character = AIDUtils.class$("java.lang.Character")) : class$java$lang$Character;
            if (!(value instanceof Character)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Character")).setFatal();
            }
        } else {
            keyType = class$java$lang$Object == null ? (class$java$lang$Object = AIDUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        try {
            Class[] ctrArgs = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = AIDUtils.class$("java.lang.Class")) : class$java$lang$Class, keyType};
            Constructor ctr = idType.getConstructor(ctrArgs);
            Object[] args = new Object[]{pcType, value};
            id = (SingleFieldIdentity)ctr.newInstance(args);
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error("Error encountered while creating SingleFieldIdentity instance of type \"" + idType.getName() + "\"");
            JPOXLogger.PERSISTENCE.error(e);
            return null;
        }
        return id;
    }

    public static boolean isSingleFieldIdentityClass(String className) {
        if (className == null || className.length() < 1) {
            return false;
        }
        return className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_BYTE_IDENTITY) || className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_CHAR_IDENTITY) || className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_INT_IDENTITY) || className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_LONG_IDENTITY) || className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_OBJECT_IDENTITY) || className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_SHORT_IDENTITY) || className.equals(ClassNameConstants.JAVAX_JDO_IDENTITY_STRING_IDENTITY);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

