/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.util.Locale;

public final class I18nUtils {
    private I18nUtils() {
    }

    public static Locale getLocaleFromString(String localeString) {
        if (localeString == null) {
            return null;
        }
        if ((localeString = localeString.trim()).toLowerCase().equals("default")) {
            return Locale.getDefault();
        }
        int languageIndex = localeString.indexOf(95);
        if (languageIndex == -1) {
            return new Locale(localeString, "");
        }
        int countryIndex = localeString.indexOf(95, languageIndex + 1);
        String country = null;
        if (countryIndex == -1) {
            if (localeString.length() > languageIndex) {
                country = localeString.substring(languageIndex + 1, localeString.length());
            } else {
                return null;
            }
        }
        int variantIndex = -1;
        if (countryIndex != -1) {
            countryIndex = localeString.indexOf(95, countryIndex + 1);
        }
        String language = localeString.substring(0, languageIndex);
        String variant = null;
        if (variantIndex != -1) {
            variant = localeString.substring(variantIndex + 1, localeString.length());
        }
        if (variant != null) {
            return new Locale(language, country, variant);
        }
        return new Locale(language, country);
    }
}

