/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerImpl;
import org.jpox.Transaction;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.exceptions.TransactionActiveOnCloseException;
import org.jpox.jdo.JDOExtent;
import org.jpox.jdo.JDOFetchPlan;
import org.jpox.jdo.JDOQuery;
import org.jpox.jdo.JDOTransaction;
import org.jpox.jdo.JPOXJDOHelper;
import org.jpox.jdo.exceptions.TransactionNotActiveException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.QueryLanguage;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.state.DetachState;
import org.jpox.state.FetchPlanState;
import org.jpox.store.query.Query;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class AbstractPersistenceManager
implements PersistenceManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private Map userObjectMap;
    private Object userObject;
    protected ObjectManager objectMgr;
    protected javax.jdo.Transaction jdotx;
    protected AbstractPersistenceManagerFactory apmf;
    protected JDOFetchPlan fetchPlan = null;
    static /* synthetic */ Class class$org$jpox$store$SCOID;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractPersistenceManager(AbstractPersistenceManagerFactory apmf, String userName, String password) {
        this.objectMgr = new ObjectManagerImpl(apmf, this, userName, password);
        this.apmf = apmf;
        this.userObject = null;
        this.userObjectMap = null;
        this.fetchPlan = new JDOFetchPlan(this.objectMgr.getFetchPlan());
    }

    public ObjectManager getObjectManager() {
        return this.objectMgr;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        throw new JDOException(LOCALISER.msg("PM.GetPersistenceManagerFactoryNotImplemented"));
    }

    public AbstractPersistenceManagerFactory getAbstractPersistenceManagerFactory() {
        return this.apmf;
    }

    public boolean getDetachAllOnCommit() {
        return this.objectMgr.getDetachAllOnCommit();
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean getIgnoreCache() {
        return this.objectMgr.getIgnoreCache();
    }

    public boolean getMultithreaded() {
        return this.objectMgr.getMultithreaded();
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.objectMgr.setDetachAllOnCommit(flag);
    }

    public void setIgnoreCache(boolean flag) {
        this.objectMgr.setIgnoreCache(flag);
    }

    public void setMultithreaded(boolean flag) {
        this.objectMgr.setMultithreaded(flag);
    }

    public Date getServerDate() {
        try {
            return this.objectMgr.getStoreManager().getDatastoreDate();
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void close() {
        this.userObject = null;
        this.userObjectMap = null;
        try {
            this.objectMgr.close();
            this.apmf.releasePersistenceManager(this);
            this.objectMgr.postClose();
        }
        catch (TransactionActiveOnCloseException tae) {
            throw new JDOUserException(tae.getMessage(), (Object)this);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public boolean isClosed() {
        return this.objectMgr.isClosed();
    }

    public javax.jdo.Transaction currentTransaction() {
        this.assertIsOpen();
        return this.jdotx;
    }

    protected void setTransaction(Transaction tx) {
        this.jdotx = new JDOTransaction(this, tx);
    }

    private void jdoEvict(Object obj) {
        try {
            this.objectMgr.evictObject(obj);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void evict(Object obj) {
        this.assertIsOpen();
        this.jdoEvict(obj);
    }

    public synchronized void evictAll(Class cls, boolean subclasses) {
        try {
            this.objectMgr.evictObjects(cls, subclasses);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void evictAll(Object[] pcs) {
        this.evictAll(Arrays.asList(pcs));
    }

    public synchronized void evictAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoEvict(i.next());
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.EvictError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void evictAll() {
        this.assertIsOpen();
        this.objectMgr.evictAllObjects();
    }

    private void jdoRefresh(Object obj) {
        try {
            this.objectMgr.refreshObject(obj);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void refresh(Object obj) {
        this.assertIsOpen();
        this.jdoRefresh(obj);
    }

    public synchronized void refreshAll(Object[] pcs) {
        this.refreshAll(Arrays.asList(pcs));
    }

    public synchronized void refreshAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        Iterator iter = pcs.iterator();
        while (iter.hasNext()) {
            try {
                this.jdoRefresh(iter.next());
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.RefreshError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void refreshAll() {
        this.assertIsOpen();
        try {
            this.objectMgr.refreshAllObjects();
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void refreshAll(JDOException exc) {
        Throwable[] nested_excs;
        Object obj = exc.getFailedObject();
        if (obj != null) {
            this.refresh(obj);
        }
        if ((nested_excs = exc.getNestedExceptions()) != null) {
            for (int i = 0; i < nested_excs.length; ++i) {
                if (!(nested_excs[i] instanceof JDOException)) continue;
                this.refreshAll((JDOException)nested_excs[i]);
            }
        }
    }

    private void jdoRetrieve(Object obj, boolean fgOnly) {
        try {
            this.objectMgr.retrieveObject(obj, fgOnly);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void retrieve(Object pc, boolean fgOnly) {
        this.assertIsOpen();
        this.jdoRetrieve(pc, fgOnly);
    }

    public synchronized void retrieve(Object pc) {
        this.retrieve(pc, false);
    }

    public synchronized void retrieveAll(Object[] pcs) {
        this.retrieveAll(Arrays.asList(pcs), false);
    }

    public void retrieveAll(Object[] pcs, boolean fgOnly) {
        this.retrieveAll(Arrays.asList(pcs), fgOnly);
    }

    public void retrieveAll(Collection pcs, boolean fgOnly) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoRetrieve(i.next(), fgOnly);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.RetrieveError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void retrieveAll(Collection pcs) {
        this.retrieveAll(pcs.toArray(), false);
    }

    private Object jdoMakePersistent(Object obj) {
        try {
            return this.objectMgr.persistObject(obj);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized Object makePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        if (obj == null) {
            return null;
        }
        return this.jdoMakePersistent(obj);
    }

    public synchronized Object[] makePersistentAll(Object[] pcs) {
        return this.makePersistentAll(Arrays.asList(pcs)).toArray();
    }

    public synchronized Collection makePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        ArrayList<RuntimeException> failures = null;
        Iterator i = pcs.iterator();
        ArrayList<Object> persistedPcs = new ArrayList<Object>();
        while (i.hasNext()) {
            try {
                Object persistedPc = this.jdoMakePersistent(i.next());
                persistedPcs.add(persistedPc);
            }
            catch (RuntimeException e) {
                if (failures == null) {
                    failures = new ArrayList<RuntimeException>();
                }
                failures.add(e);
            }
        }
        if (failures != null) {
            throw new JDOUserException(LOCALISER.msg("PM.MakePersistentError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
        return persistedPcs;
    }

    private void jdoDeletePersistent(Object obj) {
        try {
            this.objectMgr.deleteObject(obj);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void deletePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        this.jdoDeletePersistent(obj);
    }

    public synchronized void deletePersistentAll(Object[] pcs) {
        this.deletePersistentAll(Arrays.asList(pcs));
    }

    public synchronized void deletePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoDeletePersistent(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.DeletePersistentError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private void jdoMakeTransient(Object pc, FetchPlanState state) {
        try {
            this.objectMgr.makeObjectTransient(pc, state);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void makeTransient(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        this.jdoMakeTransient(pc, state);
    }

    public synchronized void makeTransient(Object pc) {
        this.makeTransient(pc, false);
    }

    public synchronized void makeTransientAll(Object[] pcs) {
        this.makeTransientAll(Arrays.asList(pcs));
    }

    public synchronized void makeTransientAll(Object[] pcs, boolean includeFetchPlan) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    public synchronized void makeTransientAll(Collection pcs, boolean useFetchPlan) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        while (i.hasNext()) {
            try {
                this.jdoMakeTransient(i.next(), state);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeTransientError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void makeTransientAll(Collection pcs) {
        this.makeTransientAll(pcs, false);
    }

    private void jdoMakeTransactional(Object pc) {
        try {
            this.objectMgr.makeObjectTransactional(pc);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void makeTransactional(Object pc) {
        this.assertIsOpen();
        this.jdoMakeTransactional(pc);
    }

    public synchronized void makeTransactionalAll(Object[] pcs) {
        this.makeTransactionalAll(Arrays.asList(pcs));
    }

    public synchronized void makeTransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoMakeTransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeTransactionalError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private void jdoMakeNontransactional(Object obj) {
        try {
            this.objectMgr.makeObjectNontransactional(obj);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void makeNontransactional(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return;
        }
        if (this.objectMgr.getTransaction().isActive()) {
            this.assertActiveTransaction();
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && !((PersistenceCapable)pc).jdoIsPersistent()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeNontransactionalOnNontransactionalTransientInstances"));
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && ((PersistenceCapable)pc).jdoIsPersistent()) {
            return;
        }
        this.jdoMakeNontransactional(pc);
    }

    public synchronized void makeNontransactionalAll(Object[] pcs) {
        this.makeNontransactionalAll(Arrays.asList(pcs));
    }

    public synchronized void makeNontransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoMakeNontransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeNonTransactionalError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private Object jdoDetachCopy(Object obj, FetchPlanState state) {
        try {
            return this.objectMgr.detachObjectCopy(obj, state);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized Object detachCopy(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return null;
        }
        try {
            this.objectMgr.assertClassPersistable(pc.getClass());
            this.assertReadable("detachCopy");
            return this.jdoDetachCopy(pc, new DetachState(this.objectMgr.getApiAdapter()));
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized Object[] detachCopyAll(Object[] pcs) {
        return this.detachCopyAll(Arrays.asList(pcs)).toArray();
    }

    public synchronized Collection detachCopyAll(Collection pcs) {
        this.assertIsOpen();
        this.assertReadable("detachCopyAll");
        DetachState state = new DetachState(this.objectMgr.getApiAdapter());
        ArrayList<Object> detacheds = new ArrayList<Object>();
        Iterator it = pcs.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null) {
                detacheds.add(null);
                continue;
            }
            detacheds.add(this.jdoDetachCopy(obj, state));
        }
        return detacheds;
    }

    public synchronized javax.jdo.Query newQuery() {
        return this.newQuery("javax.jdo.query.JDOQL", null);
    }

    public synchronized javax.jdo.Query newQuery(Object obj) {
        if (obj != null && obj instanceof JDOQuery) {
            String language = ((JDOQuery)obj).getLanguage();
            return this.newQuery(language, obj);
        }
        return this.newQuery(null, obj);
    }

    public synchronized javax.jdo.Query newQuery(String query) {
        return this.newQuery("javax.jdo.query.JDOQL", (Object)query);
    }

    public synchronized javax.jdo.Query newQuery(String language, Object query) {
        this.assertIsOpen();
        if (language == null) {
            language = "javax.jdo.query.JDOQL";
        }
        if (!this.objectMgr.getStoreManager().supportsQueryLanguage(language)) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.LanguageNotSupportedByStore", language));
        }
        Query internalQuery = null;
        try {
            internalQuery = query != null && query instanceof JDOQuery ? this.objectMgr.getStoreManager().newQuery(language, this.objectMgr, ((JDOQuery)query).getInternalQuery()) : this.objectMgr.getStoreManager().newQuery(language, this.objectMgr, query);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
        return new JDOQuery(this, internalQuery, language);
    }

    public synchronized javax.jdo.Query newQuery(Class cls) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Extent cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Class cls, Collection cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Class cls, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setFilter(filter);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Class cls, Collection cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Extent cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public synchronized javax.jdo.Query newNamedQuery(Class cls, String queryName) {
        this.assertIsOpen();
        if (queryName == null) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryNotFound", queryName, cls));
        }
        ClassLoaderResolver clr = this.objectMgr.getClassLoaderResolver();
        QueryMetaData qmd = this.objectMgr.getMetaDataManager().getMetaDataForQuery(cls, clr, queryName);
        if (qmd == null) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryNotFound", queryName, cls));
        }
        javax.jdo.Query query = this.newQuery(qmd.getLanguage().toString(), (Object)qmd.getQuery());
        if (cls != null) {
            query.setClass(cls);
            if (!this.objectMgr.getStoreManager().managesClass(cls.getName())) {
                this.objectMgr.getStoreManager().addClass(cls.getName(), clr);
            }
        }
        if (qmd.getLanguage() == QueryLanguage.JDOQL && (qmd.isUnique() || qmd.getResultClass() != null)) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryJDOQLOnlySingleString", queryName));
        }
        if (qmd.isUnique()) {
            query.setUnique(true);
        }
        if (qmd.getResultClass() != null) {
            Class resultCls = null;
            try {
                resultCls = clr.classForName(qmd.getResultClass());
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    String resultClassName = cls.getPackage().getName() + "." + qmd.getResultClass();
                    resultCls = clr.classForName(resultClassName);
                }
                catch (ClassNotResolvedException cnre2) {
                    throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryResultClassNotFound", queryName, qmd.getResultClass()));
                }
            }
            query.setResultClass(resultCls);
        }
        if (qmd.getLanguage() == QueryLanguage.JPOXSQL) {
            if (qmd.hasExtension("imports")) {
                query.declareImports(qmd.getValueForExtension("imports"));
            }
            if (qmd.hasExtension("parameters")) {
                query.declareParameters(qmd.getValueForExtension("parameters"));
            }
        }
        if (qmd.isUnmodifiable()) {
            query.setUnmodifiable();
        }
        return query;
    }

    public synchronized Extent getExtent(Class pcClass, boolean subclasses) {
        return new JDOExtent(this, this.objectMgr.getExtent(pcClass, subclasses));
    }

    public synchronized Extent getExtent(Class pcClass) {
        return this.getExtent(pcClass, true);
    }

    public Object newInstance(Class persistenceCapable) {
        try {
            return this.objectMgr.newInstance(persistenceCapable);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public Object newObjectIdInstance(Class pcClass, Object key) {
        try {
            return this.objectMgr.newObjectId(pcClass, key);
        }
        catch (JPOXException jpe) {
            return JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized Object getObjectById(Object id) {
        return this.getObjectById(id, true);
    }

    public synchronized Object getObjectById(Object id, boolean validate) {
        this.assertIsOpen();
        if (id == null) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectByIdNullId"));
        }
        try {
            boolean checkInheritance = this.getObjectManager().getOMFContext().getPersistenceConfiguration().getFindObjectCheckInheritance();
            return this.objectMgr.findObject(id, validate, checkInheritance, null);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public Collection getObjectsById(Collection oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null || oids.size() == 0) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectsByIdNullId"));
        }
        ArrayList<Object> objects = new ArrayList<Object>(oids.size());
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            Object oid = iter.next();
            objects.add(this.getObjectById(oid, validate));
        }
        return objects;
    }

    public Object[] getObjectsById(Object[] oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectsByIdNullId"));
        }
        Object[] objects = new Object[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            objects[i] = this.getObjectById(oids[i], validate);
        }
        return objects;
    }

    public Collection getObjectsById(Collection oids) {
        return this.getObjectsById(oids, true);
    }

    public Object[] getObjectsById(Object[] oids) {
        return this.getObjectsById(oids, true);
    }

    public Object getObjectById(Class cls, Object key) {
        return this.getObjectById(this.newObjectIdInstance(cls, key), true);
    }

    public Object getObjectId(Object pc) {
        PersistenceCapable p;
        this.assertIsOpen();
        if (pc != null && pc instanceof PersistenceCapable && ((p = (PersistenceCapable)pc).jdoIsPersistent() || p.jdoIsDetached())) {
            return p.jdoGetObjectId();
        }
        return null;
    }

    public Object getTransactionalObjectId(Object pc) {
        this.assertIsOpen();
        return ((PersistenceCapable)pc).jdoGetTransactionalObjectId();
    }

    public Class getObjectIdClass(Class cls) {
        this.assertIsOpen();
        if (!this.getObjectManager().getOMFContext().getApiAdapter().isPersistable(cls) || !this.hasPersistenceInformationForClass(cls)) {
            return null;
        }
        ClassLoaderResolver clr = this.objectMgr.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.objectMgr.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.objectMgr.getOMFContext().getDatastoreIdentityClass();
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                return this.objectMgr.getClassLoaderResolver().classForName(this.objectMgr.getMetaDataManager().getMetaDataForClass(cls, clr).getObjectidClass(), null);
            }
            catch (ClassNotResolvedException e) {
                String msg = LOCALISER.msg("PM.ObjectIdClassNotFound", cls.getName());
                JPOXLogger.GENERAL.error(msg);
                throw new JDOException(msg);
            }
        }
        if (cmd.isRequiresExtent()) {
            return this.objectMgr.getOMFContext().getDatastoreIdentityClass();
        }
        return class$org$jpox$store$SCOID == null ? (class$org$jpox$store$SCOID = AbstractPersistenceManager.class$("org.jpox.store.SCOID")) : class$org$jpox$store$SCOID;
    }

    public synchronized Object putUserObject(Object key, Object value) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            this.userObjectMap = new HashMap();
        }
        if (value == null) {
            return this.userObjectMap.remove(key);
        }
        return this.userObjectMap.put(key, value);
    }

    public synchronized Object getUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.get(key);
    }

    public synchronized Object removeUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.remove(key);
    }

    public synchronized void setUserObject(Object userObject) {
        this.assertIsOpen();
        this.userObject = userObject;
    }

    public synchronized Object getUserObject() {
        this.assertIsOpen();
        return this.userObject;
    }

    public synchronized void flush() {
        try {
            this.objectMgr.flush(true);
        }
        catch (JPOXException jpe) {
            if (jpe instanceof JPOXOptimisticException) {
                Throwable[] nested = jpe.getNestedExceptions();
                JDOOptimisticVerificationException[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                for (int i = 0; i < nested.length; ++i) {
                    jdoNested[i] = (JDOOptimisticVerificationException)JPOXJDOHelper.getJDOExceptionForJPOXException((JPOXException)nested[i]);
                }
                throw new JDOOptimisticVerificationException(jpe.getMessage(), (Throwable[])jdoNested);
            }
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public void checkConsistency() {
        this.assertIsOpen();
        if (!this.objectMgr.getTransaction().isActive()) {
            return;
        }
        if (this.objectMgr.getTransaction().getOptimistic()) {
            throw new JDOUserException("checkConsistency() not yet implemented for optimistic transactions");
        }
        this.flush();
    }

    public Sequence getSequence(String sequenceName) {
        this.assertIsOpen();
        SequenceMetaData seqmd = this.objectMgr.getMetaDataManager().getMetaDataForSequence(this.objectMgr.getClassLoaderResolver(), sequenceName);
        if (seqmd == null) {
            throw new JDOUserException(LOCALISER.msg("Sequence.SequenceNotFound", sequenceName));
        }
        Sequence seq = null;
        if (seqmd.getFactoryClass() != null) {
            seq = this.getAbstractPersistenceManagerFactory().getSequenceForFactoryClass(seqmd.getFactoryClass());
            if (seq == null) {
                Class factory = this.objectMgr.getClassLoaderResolver().classForName(seqmd.getFactoryClass());
                if (factory == null) {
                    throw new JDOUserException(LOCALISER.msg("Sequence.FactoryClassNotFound", sequenceName, seqmd.getFactoryClass()));
                }
                Class[] argTypes = null;
                Object[] arguments = null;
                if (seqmd.getStrategy() != null) {
                    argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String};
                    arguments = new Object[]{seqmd.getName(), seqmd.getStrategy().toString()};
                } else {
                    argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String};
                    arguments = new Object[]{seqmd.getName()};
                }
                try {
                    Method newInstanceMethod = factory.getMethod("newInstance", argTypes);
                    seq = (Sequence)newInstanceMethod.invoke(null, arguments);
                }
                catch (Exception e) {
                    throw new JDOUserException(LOCALISER.msg("Sequence.FactoryClassInvocationError", seqmd.getFactoryClass(), e.getMessage()));
                }
                this.getAbstractPersistenceManagerFactory().addSequenceForFactoryClass(seqmd.getFactoryClass(), seq);
            }
        } else {
            seq = (Sequence)this.objectMgr.getStoreManager().getJPOXSequence(this.objectMgr, seqmd);
        }
        return seq;
    }

    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        this.objectMgr.addListener(listener, classes);
    }

    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.objectMgr.removeListener(listener);
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("PM.IsClosed"));
        }
    }

    protected void assertActiveTransaction() {
        if (!this.objectMgr.getTransaction().isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertWritable() {
        if (!this.objectMgr.getTransaction().isActive() && !this.objectMgr.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertReadable(String operation) {
        if (!this.objectMgr.getTransaction().isActive() && !this.objectMgr.getTransaction().getNontransactionalRead()) {
            throw new JDOUserException(LOCALISER.msg("PM.NonTransactionalOperationInvalid", operation));
        }
    }

    protected boolean hasPersistenceInformationForClass(Class cls) {
        return this.objectMgr.hasPersistenceInformationForClass(cls);
    }

    public JDOConnection getDataStoreConnection() {
        try {
            return (JDOConnection)this.objectMgr.getStoreManager().getJPOXConnection(this.objectMgr);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

