/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jpox.ObjectManager;
import org.jpox.TransactionImpl;
import org.jpox.transaction.JPOXTransactionException;
import org.jpox.util.JPOXLogger;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private TransactionManager tm;
    private Transaction jtaTx;
    private boolean markedForRollback = false;

    JTATransactionImpl(ObjectManager om) {
        super(om);
        if (!om.getOMFContext().getPersistenceConfiguration().isJcaMode()) {
            this.joinTransaction();
        }
    }

    public boolean isActive() {
        boolean isActive = super.isActive();
        if (isActive) {
            return true;
        }
        this.joinTransaction();
        return this.active;
    }

    public void begin() {
        this.internalBegin();
    }

    protected void internalRollback() {
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.RollbackForObjectManager", this.om));
        }
        this.om.preRollback();
    }

    private synchronized void joinTransaction() {
        if (this.active) {
            return;
        }
        try {
            if (this.tm == null) {
                this.tm = this.obtainTransactionManager();
            }
            this.jtaTx = this.tm.getTransaction();
            if (this.jtaTx != null && this.jtaTx.getStatus() == 0) {
                this.jtaTx.registerSynchronization((Synchronization)this);
                this.begin();
            } else if (this.markedForRollback) {
                this.rollback();
                this.markedForRollback = false;
            }
        }
        catch (SystemException se) {
            throw new JPOXTransactionException(LOCALISER.msg("Transaction.JTA.ErrorSynchronizing"), se);
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    private TransactionManager obtainTransactionManager() {
        TransactionManager tm = this.om.getOMFContext().getJtaTransactionManager();
        if (tm == null) {
            throw new JPOXTransactionException(LOCALISER.msg("Transaction.JTA.ErrorObtainingTransactionManager"));
        }
        return tm;
    }

    public void beforeCompletion() {
        this.internalPreCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCompletion(int status) {
        block5: {
            try {
                if (status == 4) {
                    this.rollback();
                    break block5;
                }
                if (status == 3) {
                    this.internalPostCommit();
                    break block5;
                }
                throw new JPOXTransactionException("Received unexpected transaction status + " + status);
            }
            finally {
                this.jtaTx = null;
            }
        }
    }
}

