/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.jpox.ClassLoaderResolver;
import org.jpox.OMFContext;
import org.jpox.PersistenceConfiguration;
import org.jpox.cache.Level2Cache;
import org.jpox.cache.NullLevel2Cache;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.store.StoreManager;
import org.jpox.store.StoreManagerFactory;
import org.jpox.transaction.TransactionUtils;
import org.jpox.util.JPOXLogger;

public class ObjectManagerFactoryImpl
extends PersistenceConfiguration {
    private static String jpoxVersion = null;
    private static String jpoxVendor = null;
    protected OMFContext omfContext;
    protected Level2Cache cache;
    private boolean closed;
    static /* synthetic */ Class class$java$util$Properties;

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JPOXUserException(LOCALISER.msg("OMF.IsClosed"));
        }
    }

    protected void logConfiguration() {
        JPOXLogger.PERSISTENCE.info("================= Persistence Configuration ===============");
        JPOXLogger.PERSISTENCE.info(LOCALISER.msg("OMF.Version", ObjectManagerFactoryImpl.getVendorName(), ObjectManagerFactoryImpl.getVersionNumber()));
        JPOXLogger.PERSISTENCE.info(LOCALISER.msg("OMF.Initialised", this.getConnectionURL(), this.getConnectionDriverName(), this.getConnectionUserName()));
        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            String timeZoneID;
            JPOXLogger.PERSISTENCE.debug("JDK : " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
            JPOXLogger.PERSISTENCE.debug("Persistence API : " + this.getOMFContext().getApi());
            JPOXLogger.PERSISTENCE.debug("Plugin Registry : " + this.getOMFContext().getPluginManager().getRegistryClassName());
            if (this.getPersistenceUnitName() != null) {
                JPOXLogger.PERSISTENCE.debug("Persistence-Unit : " + this.getPersistenceUnitName());
            }
            if ((timeZoneID = this.getServerTimeZoneID()) == null) {
                timeZoneID = TimeZone.getDefault().getID();
            }
            JPOXLogger.PERSISTENCE.debug("Standard Options : " + (this.getMultithreaded() ? "multithreaded" : "singlethreaded") + (this.getRetainValues() ? ", retain-values" : "") + (this.getRestoreValues() ? ", restore-values" : "") + (this.getNontransactionalRead() ? ", nontransactional-read" : "") + (this.getNontransactionalWrite() ? ", nontransactional-write" : "") + (this.getIgnoreCache() ? ", ignoreCache" : "") + ", serverTimeZone=" + timeZoneID);
            JPOXLogger.PERSISTENCE.debug("Persistence Options :" + (this.getPersistenceByReachabilityAtCommit() ? " reachability-at-commit" : "") + (this.getDetachAllOnCommit() ? " detach-all-on-commit" : "") + (this.getDetachOnClose() ? " detach-on-close" : "") + " deletion-policy=" + this.getDeletionPolicy());
            JPOXLogger.PERSISTENCE.debug("Types : string-default-length=" + this.getStringDefaultLength());
            JPOXLogger.PERSISTENCE.debug("Transactions : type=" + this.getTransactionType() + " mode=" + (this.getOptimistic() ? "optimistic" : "datastore") + " isolation=" + TransactionUtils.getNameForTransactionIsolationLevel(this.getTransactionIsolation()));
            JPOXLogger.PERSISTENCE.debug("Identity Generation : txn-isolation=" + TransactionUtils.getNameForTransactionIsolationLevel(this.getPoidTransactionIsolationLevel()) + " connection=" + (this.getPoidTransactionAttribute().equalsIgnoreCase("New") ? "New" : "PM"));
            JPOXLogger.PERSISTENCE.debug("ClassLoading : " + this.getClassLoaderResolverName() + (this.getPrimaryClassLoader() != null ? "primary=" + this.getPrimaryClassLoader() : ""));
            JPOXLogger.PERSISTENCE.debug("Cache : Level1 (" + this.getCacheLevel1Type() + ")" + (this.getCacheLevel2() ? ", Level2 (" + this.getCacheLevel2Type() + ")" : "") + (this.getCacheCollections() ? ", Collections/Maps " : ""));
        }
        JPOXLogger.PERSISTENCE.info("===========================================================");
    }

    protected void initialiseOMFContext() {
        this.omfContext = new OMFContext(this);
    }

    protected void initialiseStoreManager(ClassLoaderResolver clr) {
        int idx;
        Extension[] exts = this.getOMFContext().getPluginManager().getExtensionPoint("org.jpox.store_manager").getExtensions();
        String url = this.getConnectionURL();
        if (url != null && (idx = url.indexOf(58)) > -1) {
            url = url.substring(0, idx);
        }
        StoreManager srm = null;
        for (int e = 0; srm == null && e < exts.length; ++e) {
            ConfigurationElement[] confElm = exts[e].getConfigurationElements();
            for (int c = 0; srm == null && c < confElm.length; ++c) {
                String storeMgrClassName = confElm[c].getAttribute("class-name");
                String key = confElm[c].getAttribute("key");
                if (url != null && !key.equalsIgnoreCase(url)) continue;
                srm = StoreManagerFactory.getStoreManager(storeMgrClassName, clr, this);
            }
        }
        if (srm == null) {
            srm = StoreManagerFactory.getStoreManager(exts[0].getConfigurationElements()[0].getAttribute("class-name"), clr, this);
        }
    }

    protected void initialiseLevel2Cache() {
        if (this.getCacheLevel2()) {
            String level2Type = this.getCacheLevel2Type();
            String level2ClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.cache_level2", "name", level2Type, "class-name");
            if (level2ClassName == null) {
                throw new JPOXUserException(LOCALISER.msg("Cache.Level2.PluginNotFound", level2Type)).setFatal();
            }
            try {
                Properties cacheProps = new Properties();
                if (this.getCacheLevel2CacheName() != null) {
                    cacheProps.put("CacheName", this.getCacheLevel2CacheName());
                }
                if (this.getCacheLevel2ConfigurationFile() != null) {
                    cacheProps.put("ConfigurationFile", this.getCacheLevel2ConfigurationFile());
                }
                Class<?> level2CacheClass = Class.forName(level2ClassName);
                Class[] ctrArgsClasses = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = ObjectManagerFactoryImpl.class$("java.util.Properties")) : class$java$util$Properties};
                Object[] ctrArgs = new Object[]{cacheProps};
                Constructor<?> ctr = level2CacheClass.getConstructor(ctrArgsClasses);
                this.cache = (Level2Cache)ctr.newInstance(ctrArgs);
                JPOXLogger.CACHE.info(LOCALISER.msg("Cache.Level2.Initialised", level2ClassName));
            }
            catch (Exception e) {
                throw new JPOXUserException(LOCALISER.msg("Cache.Level2.PluginClassNotFound", level2Type, level2ClassName), e).setFatal();
            }
        } else {
            this.cache = new NullLevel2Cache();
        }
    }

    public synchronized void close() {
        if (this.getCacheLevel2() && this.cache != null) {
            this.cache.clear();
            JPOXLogger.CACHE.info(LOCALISER.msg("Cache.Level2.Cleared"));
        }
        if (this.omfContext != null) {
            this.omfContext.close();
            this.omfContext = null;
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public OMFContext getOMFContext() {
        if (this.omfContext == null) {
            this.initialiseOMFContext();
        }
        return this.omfContext;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this;
    }

    public Level2Cache getLevel2Cache() {
        return this.cache;
    }

    public static String getVersionNumber() {
        if (jpoxVersion != null) {
            return jpoxVersion;
        }
        String version = "Unknown";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.JPOXVersion");
            try {
                version = bundle.getString("jpox.version");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVersion = version;
        return jpoxVersion;
    }

    public static String getVendorName() {
        if (jpoxVendor != null) {
            return jpoxVendor;
        }
        String vendor = "JPOX";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.JPOXVersion");
            try {
                vendor = bundle.getString("jpox.vendor");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVendor = vendor;
        return jpoxVendor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

