/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.jdo.JDOUserException;
import org.jpox.ResourceType;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.TransactionType;
import org.jpox.transaction.TransactionUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class PersistenceConfiguration {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    public static final String JDO_DATASTORE_DRIVERNAME_PROPERTY = "javax.jdo.option.ConnectionDriverName";
    public static final String JDO_DATASTORE_URL_PROPERTY = "javax.jdo.option.ConnectionURL";
    public static final String JDO_DATASTORE_USERNAME_PROPERTY = "javax.jdo.option.ConnectionUserName";
    public static final String JDO_DATASTORE_PASSWORD_PROPERTY = "javax.jdo.option.ConnectionPassword";
    public static final String JDO_CONNECTION_FACTORY_NAME_PROPERTY = "javax.jdo.option.ConnectionFactoryName";
    public static final String JDO_CONNECTION_FACTORY2_NAME_PROPERTY = "javax.jdo.option.ConnectionFactory2Name";
    public static final String JDO_CONNECTION_FACTORY_PROPERTY = "javax.jdo.option.ConnectionFactory";
    public static final String JDO_CONNECTION_FACTORY2_PROPERTY = "javax.jdo.option.ConnectionFactory2";
    public static final String JDO_IGNORECACHE_PROPERTY = "javax.jdo.option.IgnoreCache";
    public static final String JDO_OPTIMISTIC_PROPERTY = "javax.jdo.option.Optimistic";
    public static final String JDO_MULTITHREADED_PROPERTY = "javax.jdo.option.Multithreaded";
    public static final String JDO_RETAINVALUES_PROPERTY = "javax.jdo.option.RetainValues";
    public static final String JDO_RESTOREVALUES_PROPERTY = "javax.jdo.option.RestoreValues";
    public static final String JDO_NONTRANSACTIONAL_READ_PROPERTY = "javax.jdo.option.NontransactionalRead";
    public static final String JDO_NONTRANSACTIONAL_WRITE_PROPERTY = "javax.jdo.option.NontransactionalWrite";
    public static final String JDO_MAPPING_PROPERTY = "javax.jdo.option.Mapping";
    public static final String JDO_MAPPING_CATALOG_PROPERTY = "javax.jdo.mapping.Catalog";
    public static final String JDO_MAPPING_SCHEMA_PROPERTY = "javax.jdo.mapping.Schema";
    public static final String JDO_DETACHALLONCOMMIT_PROPERTY = "javax.jdo.option.DetachAllOnCommit";
    public static final String JDO_COPYONATTACH_PROPERTY = "javax.jdo.option.CopyOnAttach";
    public static final String JDO_TRANSACTION_TYPE_PROPERTY = "javax.jdo.option.TransactionType";
    public static final String JDO_NAME_PROPERTY = "javax.jdo.option.Name";
    public static final String JDO_PERSISTENCE_UNIT_NAME_PROPERTY = "javax.jdo.option.PersistenceUnitName";
    public static final String JDO_SERVER_TIMEZONE_ID_PROPERTY = "javax.jdo.option.ServerTimeZoneID";
    public static final String JPA_TRANSACTION_TYPE_PROPERTY = "javax.persistence.TransactionType";
    public static final String JPA_ONE_TO_MANY_UNI_FK_PROPERTY = "org.jpox.jpa.oneToManyUniFkRelations";
    public static final String PERSISTENCE_API_NAME = "org.jpox.persistenceApiName";
    public static final String CLASS_LOADER_RESOLVER_NAME_PROPERTY = "org.jpox.classLoaderResolverName";
    public static final String IMPLEMENTATION_CREATOR_NAME_PROPERTY = "org.jpox.implementationCreatorName";
    public static final String DATASTORE_IDENTITY_CLASS_NAME_PROPERTY = "org.jpox.datastoreIdentityClassName";
    public static final String DETACH_ON_CLOSE_PROPERTY = "org.jpox.DetachOnClose";
    public static final String ATTACH_SAME_DATASTORE_PROPERTY = "org.jpox.attachSameDatastore";
    public static final String FIND_OBJECT_CHECK_INHERITANCE_PROPERTY = "org.jpox.findObjectCheckInheritance";
    public static final String DATASTORE_ADAPTER_CLASSNAME_PROPERTY = "org.jpox.datastoreAdapterClassName";
    public static final String VALIDATE_TABLES_PROPERTY = "org.jpox.validateTables";
    public static final String VALIDATE_COLUMNS_PROPERTY = "org.jpox.validateColumns";
    public static final String VALIDATE_CONSTRAINTS_PROPERTY = "org.jpox.validateConstraints";
    public static final String AUTO_CREATE_WARN_ON_ERROR_PROPERTY = "org.jpox.autoCreateWarnOnError";
    public static final String AUTO_CREATE_SCHEMA_PROPERTY = "org.jpox.autoCreateSchema";
    public static final String AUTO_CREATE_TABLES_PROPERTY = "org.jpox.autoCreateTables";
    public static final String AUTO_CREATE_COLUMNS_PROPERTY = "org.jpox.autoCreateColumns";
    public static final String AUTO_CREATE_CONSTRAINTS_PROPERTY = "org.jpox.autoCreateConstraints";
    public static final String READ_ONLY_DATASTORE_PROPERTY = "org.jpox.readOnlyDatastore";
    public static final String READ_ONLY_DATASTORE_ACTION_PROPERTY = "org.jpox.readOnlyDatastoreAction";
    public static final String FIXED_DATASTORE_PROPERTY = "org.jpox.fixedDatastore";
    public static final String DELETION_POLICY_PROPERTY = "org.jpox.deletionPolicy";
    public static final String DEFAULT_INHERITANCE_STRATEGY_PROPERTY = "org.jpox.defaultInheritanceStrategy";
    public static final String TRANSACTION_ISOLATION_PROPERTY = "org.jpox.transactionIsolation";
    public static final String JTA_LOCATOR_PROPERTY = "org.jpox.jtaLocator";
    public static final String JTA_JNDI_LOCATION_PROPERTY = "org.jpox.jtaJndiLocation";
    public static final String DATASTORE_TXN_DELAY_OPERATIONS_PROPERTY = "org.jpox.datastoreTransactionDelayOperations";
    public static final String DATASTORE_TXN_FLUSH_LIMIT_PROPERTY = "org.jpox.datastoreTransactionFlushLimit";
    public static final String POID_TRANSACTION_ISOLATION_PROPERTY = "org.jpox.poid.transactionIsolation";
    public static final String POID_TRANSACTION_ATTRIBUTE_PROPERTY = "org.jpox.poid.transactionAttribute";
    public static final String AUTO_START_MECHANISM_PROPERTY = "org.jpox.autoStartMechanism";
    public static final String AUTO_START_MECHANISM_MODE_PROPERTY = "org.jpox.autoStartMechanismMode";
    public static final String AUTO_START_MECHANISM_XML_FILE_PROPERTY = "org.jpox.autoStartMechanismXmlFile";
    public static final String AUTO_START_CLASS_NAMES_PROPERTY = "org.jpox.autoStartClassNames";
    public static final String PERSISTENCE_BY_REACHABILITY_AT_COMMIT = "org.jpox.persistenceByReachabilityAtCommit";
    public static final String MAX_FETCH_DEPTH_PROPERTY = "org.jpox.maxFetchDepth";
    public static final String IDENTIFIER_FACTORY_PROPERTY = "org.jpox.identifierFactory";
    public static final String IDENTIFIER_CASE_PROPERTY = "org.jpox.identifier.case";
    public static final String IDENTIFIER_WORD_SEPARATOR_PROPERTY = "org.jpox.identifier.wordSeparator";
    public static final String IDENTIFIER_TABLE_PREFIX_PROPERTY = "org.jpox.identifier.tablePrefix";
    public static final String IDENTIFIER_TABLE_SUFFIX_PROPERTY = "org.jpox.identifier.tableSuffix";
    public static final String PROPERTIES_FILE = "org.jpox.propertiesFile";
    public static final String CONNECTION_POOLING_TYPE_PROPERTY = "org.jpox.connectionPoolingType";
    public static final String CONNECTION_POOLING_CONFIGURATION_FILE_PROPERTY = "org.jpox.connectionPoolingConfigurationFile";
    public static final String CACHE_LEVEL_1_TYPE_PROPERTY = "org.jpox.cache.level1.type";
    public static final String CACHE_LEVEL_2_PROPERTY = "org.jpox.cache.level2";
    public static final String CACHE_LEVEL_2_TYPE_PROPERTY = "org.jpox.cache.level2.type";
    public static final String CACHE_LEVEL_2_CACHE_NAME_PROPERTY = "org.jpox.cache.level2.cacheName";
    public static final String CACHE_LEVEL_2_CONFIGURATION_FILE_PROPERTY = "org.jpox.cache.level2.configurationFile";
    public static final String CACHE_COLLECTIONS_PROPERTY = "org.jpox.cache.collections";
    public static final String CACHE_COLLECTIONS_LAZY_PROPERTY = "org.jpox.cache.collections.lazy";
    public static final String METADATA_VALIDATE_PROPERTY = "org.jpox.metadata.validate";
    public static final String METADATA_JDO_FILE_EXTENSION_PROPERTY = "org.jpox.metadata.jdoFileExtension";
    public static final String METADATA_ORM_FILE_EXTENSION_PROPERTY = "org.jpox.metadata.ormFileExtension";
    public static final String METADATA_JDOQUERY_FILE_EXTENSION_PROPERTY = "org.jpox.metadata.jdoqueryFileExtension";
    public static final String METADATA_ANNOTATIONS_MANAGER_PROPERTY = "org.jpox.metadata.annotationManager";
    public static final String PLUGIN_REGISTRY_CLASS_NAME = "org.jpox.plugin.pluginRegistryClassName";
    public static final String PLUGIN_REGISTRY_BUNDLE_CHECK = "org.jpox.plugin.pluginRegistryBundleCheck";
    public static final String QUERY_FLUSH_BEFORE_EXECUTION_PROPERTY = "org.jpox.query.flushBeforeExecution";
    public static final String QUERY_USE_FETCH_PLAN_PROPERTY = "org.jpox.query.useFetchPlan";
    public static final String QUERY_TIMEOUT_PROPERTY = "org.jpox.query.timeout";
    public static final String QUERY_FETCH_SIZE_PROPERTY = "org.jpox.query.fetchSize";
    public static final String QUERY_FETCH_DIRECTION_PROPERTY = "org.jpox.query.fetchDirection";
    public static final String QUERY_ALLOW_ALL_SQL_STATEMENTS = "org.jpox.query.allowAllSQLStatements";
    public static final String DATASTORE_CLASS_ADDITION_MAX_RETRIES_PROPERTY = "org.jpox.store.classAdditionMaxRetries";
    public static final String CONNECTION_PROVIDER_NAME_PROPERTY = "org.jpox.store.connectionProvider.Name";
    public static final String CONNECTION_PROVIDER_FAILONERROR_PROPERTY = "org.jpox.store.connectionProvider.FailOnError";
    public static final String PRIMARY_CLASS_LOADER_PROPERTY = "org.jpox.primaryClassLoader";
    public static final String CONNECTION_RESOURCE_TYPE = "org.jpox.connection.resourceType";
    public static final String CONNECTION2_RESOURCE_TYPE = "org.jpox.connection2.resourceType";
    public static final String QUERY_USE_INNER_JOINS_ONLY_PROPERTY = "org.jpox.rdbms.jdoql.useInnerJoinsOnly";
    public static final String QUERY_RESULT_SET_TYPE_PROPERTY = "org.jpox.rdbms.query.resultSetType";
    public static final String QUERY_RESULT_SET_CONCURRENCY_PROPERTY = "org.jpox.rdbms.query.resultSetConcurrency";
    public static final String STATEMENT_BATCH_LIMIT_PROPERTY = "org.jpox.rdbms.statementBatchLimit";
    public static final String USE_UPDATE_LOCK_PROPERTY = "org.jpox.rdbms.useUpdateLock";
    public static final String RDBMS_CONSTRAINT_CREATE_MODE_PROPERTY = "org.jpox.rdbms.constraintCreateMode";
    public static final String ADD_UNIQUE_CONSTRAINT_MAP_INVERSE_PROPERTY = "org.jpox.rdbms.uniqueConstraints.mapInverse";
    public static final String INITIALIZE_COLUMN_INFO_PROPERTY = "org.jpox.rdbms.initializeColumnInfo";
    public static final String CHECK_EXIST_TABLES_VIEWS_PROPERTY = "org.jpox.rdbms.CheckExistTablesOrViews";
    public static final String STRING_DEFAULT_LENGTH_PROPERTY = "org.jpox.rdbms.stringDefaultLength";
    public static final String ORACLE_SORT_ORDER_PROPERTY = "org.jpox.rdbms.oracleNlsSortOrder";
    public static final String DB4O_OUTPUT_FILE_PROPERTY = "org.jpox.db4o.outputFile";
    private final Map PROPERTY_SETTERS = this.initPropertySetters();
    private Map options;
    private Calendar dateTimezoneCalendar = null;
    private String driverName = null;
    private String url = null;
    private String userName = null;
    private String password = null;
    private Object connectionFactory = null;
    private String connectionFactoryName = null;
    private Object connectionFactory2 = null;
    private String connectionFactory2Name = null;
    private boolean multithreaded = false;
    private boolean optimistic = false;
    private boolean retainValues = false;
    private boolean restoreValues = false;
    private boolean nontransactionalRead = false;
    private boolean nontransactionalWrite = false;
    private boolean ignoreCache = false;
    private boolean detachAllOnCommit = false;
    private boolean copyOnAttach = true;
    private String catalogName = null;
    private String schemaName = null;
    private String mapping = null;
    private String transactionType = null;
    private Boolean jca = null;
    private String serverTimeZoneID = null;
    private boolean jpaOneToManyUniFkRelations = false;
    private String name = null;
    private String persistenceUnitName = null;
    private String persistenceApiName = "JDO";
    private boolean queryFlushBeforeExecution = false;
    private boolean queryUseFetchPlan = true;
    private int queryTimeout = 0;
    private int queryFetchSize = 0;
    private String queryFetchDirection = "forward";
    private String queryResultSetType = "forward-only";
    private String queryResultSetConcurrency = "read-only";
    private boolean queryAllowAllSQLStatements = false;
    private boolean queryUseInnerJoinsOnly = false;
    private String oracleNlsSortOrder = "LATIN";
    private static final int JDO2_STRING_DEFAULT_LENGTH = 256;
    private int stringDefaultLength = 256;
    private boolean detachOnClose = false;
    private boolean findObjectCheckInheritance = true;
    private boolean attachSameDatastore = false;
    private boolean persistenceByReachabilityAtCommit = true;
    private int maxFetchDepth = 1;
    private String classLoaderResolverName = "jdo";
    private ClassLoader primaryClassLoader = null;
    private String implementationCreatorName = null;
    private String datastoreIdentityClassName = "jpox";
    private String datastoreAdapterClassName = null;
    private boolean useUpdateLock = false;
    private int datastoreClassAdditionMaxRetries = 3;
    private boolean uniqueConstraintsMapInverse = true;
    private String defaultInheritanceStrategy = "JDO2";
    private String identifierFactory = "jpox";
    private String identifierCase = "UpperCase";
    private String identifierWordSeparator = null;
    private String identifierTablePrefix = null;
    private String identifierTableSuffix = null;
    private boolean readOnlyDatastore = false;
    private String readOnlyDatastoreAction = "EXCEPTION";
    private boolean fixedDatastore = false;
    private String rdbmsConstraintCreateMode = "JPOX";
    private String deletionPolicy = "JDO2";
    private boolean checkExistTablesOrViews = true;
    private boolean validateTables = true;
    private boolean validateColumns = true;
    private boolean validateConstraints = true;
    private boolean autoCreateTables = false;
    private boolean autoCreateColumns = false;
    private boolean autoCreateConstraints = false;
    private boolean autoCreateWarnOnError = false;
    private String initializeColumnInfo = "ALL";
    private int statementBatchLimit = 50;
    private String autoStartMechanism = null;
    private String autoStartMechanismXmlFile = "jpoxAutoStart.xml";
    private String autoStartMechanismMode = "Quiet";
    private String autoStartClassNames = null;
    private int isolationLevel = 2;
    private String jtaLocator = null;
    private String jtaJndiLocation = null;
    private int poidIsolationLevel = 2;
    private String poidTransactionAttribute = "New";
    private int datastoreTransactionFlushLimit = 1;
    private boolean datastoreTransactionDelayOperations = false;
    private String connectionPoolingType = "None";
    private String connectionPoolingConfigurationFile = null;
    private boolean cacheCollections = true;
    private Boolean cacheCollectionsLazy;
    private String cacheLevel1Type = "weak";
    private boolean cacheLevel2 = false;
    private String cacheLevel2Type = "default";
    private String cacheLevel2CacheName = null;
    private String cacheLevel2ConfigurationFile = null;
    private String jdoMetaDataFileExtension = "jdo";
    private String ormMetaDataFileExtension = "orm";
    private String jdoqueryMetaDataFileExtension = "jdoquery";
    private boolean metadataValidate = true;
    private String metadataAnnotationsManager = "org.jpox.metadata.annotations.AnnotationManagerImpl";
    private String propertiesFileName = null;
    private String pluginRegistryClassName = null;
    private String pluginRegistryBundleCheck = "EXCEPTION";
    protected transient boolean configurable = true;
    private String connectionProviderName = "PriorityList";
    private boolean connectionProviderFailOnError = false;
    private String connectionResourceType = null;
    private String connection2ResourceType = null;
    private String db4oOutputFile = null;
    static /* synthetic */ Class class$org$jpox$PersistenceConfiguration;

    public PersistenceConfiguration() {
        try {
            String queryFetchSizeString;
            String extension;
            this.datastoreAdapterClassName = System.getProperty(DATASTORE_ADAPTER_CLASSNAME_PROPERTY);
            this.validateTables = new Boolean(System.getProperty(VALIDATE_TABLES_PROPERTY, "true"));
            this.validateColumns = new Boolean(System.getProperty(VALIDATE_COLUMNS_PROPERTY, "true"));
            this.validateConstraints = new Boolean(System.getProperty(VALIDATE_CONSTRAINTS_PROPERTY, "true"));
            this.initializeColumnInfo = System.getProperty(INITIALIZE_COLUMN_INFO_PROPERTY, "ALL");
            if (!this.validateTables) {
                this.validateColumns = false;
            }
            this.autoCreateTables = new Boolean(System.getProperty(AUTO_CREATE_TABLES_PROPERTY, "false"));
            this.autoCreateColumns = new Boolean(System.getProperty(AUTO_CREATE_COLUMNS_PROPERTY, "false"));
            this.autoCreateConstraints = new Boolean(System.getProperty(AUTO_CREATE_CONSTRAINTS_PROPERTY, "false"));
            this.setAutoCreateSchema(new Boolean(System.getProperty(AUTO_CREATE_SCHEMA_PROPERTY, "false")));
            this.autoCreateWarnOnError = new Boolean(System.getProperty(AUTO_CREATE_WARN_ON_ERROR_PROPERTY, "false"));
            this.readOnlyDatastore = new Boolean(System.getProperty(READ_ONLY_DATASTORE_PROPERTY, "false"));
            this.setReadOnlyDatastore(this.readOnlyDatastore);
            if (System.getProperty(READ_ONLY_DATASTORE_ACTION_PROPERTY) != null) {
                this.setReadOnlyDatastoreAction(System.getProperty(READ_ONLY_DATASTORE_ACTION_PROPERTY));
            }
            this.setFixedDatastore(new Boolean(System.getProperty(FIXED_DATASTORE_PROPERTY, "false")));
            String datastoreClassAdditionMaxRetriesString = System.getProperty(DATASTORE_CLASS_ADDITION_MAX_RETRIES_PROPERTY);
            if (datastoreClassAdditionMaxRetriesString != null) {
                try {
                    this.datastoreClassAdditionMaxRetries = new Integer(datastoreClassAdditionMaxRetriesString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this.mapping = System.getProperty(JDO_MAPPING_PROPERTY);
            this.catalogName = System.getProperty(JDO_MAPPING_CATALOG_PROPERTY);
            this.schemaName = System.getProperty(JDO_MAPPING_SCHEMA_PROPERTY);
            this.setTransactionType(System.getProperty(JDO_TRANSACTION_TYPE_PROPERTY, this.transactionType));
            this.name = System.getProperty(JDO_NAME_PROPERTY);
            this.persistenceUnitName = System.getProperty(JDO_PERSISTENCE_UNIT_NAME_PROPERTY);
            this.persistenceApiName = System.getProperty(PERSISTENCE_API_NAME, "JDO");
            if (this.readOnlyDatastore || this.fixedDatastore) {
                if (this.autoCreateTables) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateTables"));
                    this.autoCreateTables = false;
                }
                if (this.autoCreateColumns) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateColumns"));
                    this.autoCreateColumns = false;
                }
                if (this.autoCreateConstraints) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateConstraints"));
                    this.autoCreateConstraints = false;
                }
            }
            if (System.getProperty(RDBMS_CONSTRAINT_CREATE_MODE_PROPERTY) != null) {
                this.setRDBMSConstraintCreateMode(System.getProperty(RDBMS_CONSTRAINT_CREATE_MODE_PROPERTY));
            }
            this.deletionPolicy = System.getProperty(DELETION_POLICY_PROPERTY, "JDO2");
            this.identifierFactory = System.getProperty(IDENTIFIER_FACTORY_PROPERTY, "jpox");
            this.identifierCase = System.getProperty(IDENTIFIER_CASE_PROPERTY, "UpperCase");
            if (System.getProperty(IDENTIFIER_WORD_SEPARATOR_PROPERTY) != null) {
                this.setIdentifierWordSeparator(System.getProperty(IDENTIFIER_WORD_SEPARATOR_PROPERTY));
            }
            if (System.getProperty(IDENTIFIER_TABLE_PREFIX_PROPERTY) != null) {
                this.setIdentifierTablePrefix(System.getProperty(IDENTIFIER_TABLE_PREFIX_PROPERTY));
            }
            if (System.getProperty(IDENTIFIER_TABLE_SUFFIX_PROPERTY) != null) {
                this.setIdentifierTableSuffix(System.getProperty(IDENTIFIER_TABLE_SUFFIX_PROPERTY));
            }
            this.classLoaderResolverName = System.getProperty(CLASS_LOADER_RESOLVER_NAME_PROPERTY, "jdo");
            this.datastoreIdentityClassName = System.getProperty(DATASTORE_IDENTITY_CLASS_NAME_PROPERTY, "jpox");
            this.connectionPoolingType = System.getProperty(CONNECTION_POOLING_TYPE_PROPERTY, "None");
            this.connectionPoolingConfigurationFile = System.getProperty(CONNECTION_POOLING_CONFIGURATION_FILE_PROPERTY);
            this.defaultInheritanceStrategy = System.getProperty(DEFAULT_INHERITANCE_STRATEGY_PROPERTY, "JDO2");
            this.autoStartMechanism = System.getProperty(AUTO_START_MECHANISM_PROPERTY);
            this.autoStartMechanismXmlFile = System.getProperty(AUTO_START_MECHANISM_XML_FILE_PROPERTY, "jpoxAutoStart.xml");
            this.autoStartMechanismMode = System.getProperty(AUTO_START_MECHANISM_MODE_PROPERTY, "Quiet");
            this.autoStartClassNames = System.getProperty(AUTO_START_CLASS_NAMES_PROPERTY);
            this.poidTransactionAttribute = System.getProperty(POID_TRANSACTION_ATTRIBUTE_PROPERTY, "New");
            if (System.getProperty(IDENTIFIER_CASE_PROPERTY) != null) {
                this.setIdentifierCase(System.getProperty(IDENTIFIER_CASE_PROPERTY));
            }
            if (!StringUtils.isWhitespace(extension = System.getProperty(METADATA_JDO_FILE_EXTENSION_PROPERTY))) {
                this.jdoMetaDataFileExtension = extension;
            }
            if (!StringUtils.isWhitespace(extension = System.getProperty(METADATA_ORM_FILE_EXTENSION_PROPERTY))) {
                this.ormMetaDataFileExtension = extension;
            }
            if (!StringUtils.isWhitespace(extension = System.getProperty(METADATA_JDOQUERY_FILE_EXTENSION_PROPERTY))) {
                this.jdoqueryMetaDataFileExtension = extension;
            }
            this.metadataValidate = new Boolean(System.getProperty(METADATA_VALIDATE_PROPERTY, "true"));
            extension = System.getProperty(METADATA_ANNOTATIONS_MANAGER_PROPERTY);
            if (!StringUtils.isWhitespace(extension)) {
                this.metadataAnnotationsManager = extension;
            }
            this.cacheCollections = new Boolean(System.getProperty(CACHE_COLLECTIONS_PROPERTY, "true"));
            if (System.getProperty(CACHE_COLLECTIONS_LAZY_PROPERTY) != null) {
                this.cacheCollectionsLazy = new Boolean(System.getProperty(CACHE_COLLECTIONS_LAZY_PROPERTY));
            }
            this.cacheLevel1Type = System.getProperty(CACHE_LEVEL_1_TYPE_PROPERTY, "weak");
            this.cacheLevel2 = new Boolean(System.getProperty(CACHE_LEVEL_2_PROPERTY, "false"));
            this.cacheLevel2Type = System.getProperty(CACHE_LEVEL_2_TYPE_PROPERTY, "default");
            this.cacheLevel2CacheName = System.getProperty(CACHE_LEVEL_2_CACHE_NAME_PROPERTY);
            this.cacheLevel2ConfigurationFile = System.getProperty(CACHE_LEVEL_2_CONFIGURATION_FILE_PROPERTY);
            this.queryFlushBeforeExecution = new Boolean(System.getProperty(QUERY_FLUSH_BEFORE_EXECUTION_PROPERTY, "false"));
            this.queryUseFetchPlan = new Boolean(System.getProperty(QUERY_USE_FETCH_PLAN_PROPERTY, "true"));
            String queryTimeoutString = System.getProperty(QUERY_TIMEOUT_PROPERTY);
            if (queryTimeoutString != null) {
                try {
                    this.queryTimeout = new Integer(queryTimeoutString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((queryFetchSizeString = System.getProperty(QUERY_FETCH_SIZE_PROPERTY)) != null) {
                try {
                    this.queryFetchSize = new Integer(queryFetchSizeString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this.queryFetchDirection = System.getProperty(QUERY_FETCH_DIRECTION_PROPERTY, "forward");
            this.queryResultSetType = System.getProperty(QUERY_RESULT_SET_TYPE_PROPERTY, "forward-only");
            this.queryResultSetConcurrency = System.getProperty(QUERY_RESULT_SET_CONCURRENCY_PROPERTY, "read-only");
            this.queryAllowAllSQLStatements = new Boolean(System.getProperty(QUERY_ALLOW_ALL_SQL_STATEMENTS, "false"));
            this.queryUseInnerJoinsOnly = new Boolean(System.getProperty(QUERY_USE_INNER_JOINS_ONLY_PROPERTY, "false"));
            String stringLengthTemp = System.getProperty(STRING_DEFAULT_LENGTH_PROPERTY);
            if (stringLengthTemp != null) {
                try {
                    this.stringDefaultLength = new Integer(stringLengthTemp);
                }
                catch (NumberFormatException nfe) {
                    this.stringDefaultLength = 256;
                }
            }
            this.oracleNlsSortOrder = System.getProperty(ORACLE_SORT_ORDER_PROPERTY, "LATIN");
            this.connectionProviderName = System.getProperty(CONNECTION_PROVIDER_NAME_PROPERTY, "PriorityList");
            this.connectionProviderFailOnError = new Boolean(System.getProperty(CONNECTION_PROVIDER_FAILONERROR_PROPERTY, "false"));
            this.setPropertiesFile(System.getProperty(PROPERTIES_FILE));
            this.connectionResourceType = System.getProperty(CONNECTION_RESOURCE_TYPE);
            this.connection2ResourceType = System.getProperty(CONNECTION2_RESOURCE_TYPE);
            this.db4oOutputFile = System.getProperty(DB4O_OUTPUT_FILE_PROPERTY);
        }
        catch (Exception e) {
            JPOXLogger.GENERAL.error(e);
        }
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistenceConfiguration)) {
            return false;
        }
        PersistenceConfiguration config = (PersistenceConfiguration)obj;
        boolean isEquals = true;
        isEquals &= this.equalsVariable(this.driverName, config.driverName);
        isEquals &= this.equalsVariable(this.url, config.url);
        isEquals &= this.equalsVariable(this.userName, config.userName);
        isEquals &= this.equalsVariable(this.password, config.password);
        isEquals &= this.equalsVariable(this.connectionFactory, config.connectionFactory);
        isEquals &= this.equalsVariable(this.connectionFactoryName, config.connectionFactoryName);
        isEquals &= this.equalsVariable(this.connectionFactory2, config.connectionFactory2);
        isEquals &= this.equalsVariable(this.connectionFactory2Name, config.connectionFactory2Name);
        isEquals &= this.equalsVariable(this.mapping, config.mapping);
        isEquals &= this.equalsVariable(this.catalogName, config.catalogName);
        isEquals &= this.equalsVariable(this.schemaName, config.schemaName);
        isEquals &= this.equalsVariable(this.transactionType, config.transactionType);
        isEquals &= this.equalsVariable(this.serverTimeZoneID, config.serverTimeZoneID);
        isEquals &= this.equalsVariable(this.name, config.name);
        isEquals &= this.equalsVariable(this.persistenceApiName, config.persistenceApiName);
        isEquals &= this.equalsVariable(this.persistenceUnitName, config.persistenceUnitName);
        isEquals &= this.equalsVariable(this.cacheLevel1Type, config.cacheLevel1Type);
        isEquals &= this.equalsVariable(this.cacheLevel2Type, config.cacheLevel2Type);
        isEquals &= this.equalsVariable(this.cacheLevel2CacheName, config.cacheLevel2CacheName);
        isEquals &= this.equalsVariable(this.cacheLevel2ConfigurationFile, config.cacheLevel2ConfigurationFile);
        isEquals &= this.cacheLevel2 == config.cacheLevel2;
        isEquals &= this.cacheCollections == config.cacheCollections;
        isEquals &= this.cacheCollectionsLazy == config.cacheCollectionsLazy;
        isEquals &= this.equalsVariable(this.datastoreAdapterClassName, config.datastoreAdapterClassName);
        isEquals &= this.equalsVariable(this.autoStartMechanism, config.autoStartMechanism);
        isEquals &= this.equalsVariable(this.autoStartMechanismXmlFile, config.autoStartMechanismXmlFile);
        isEquals &= this.equalsVariable(this.autoStartMechanismMode, config.autoStartMechanismMode);
        isEquals &= this.equalsVariable(this.autoStartClassNames, config.autoStartClassNames);
        isEquals &= this.equalsVariable(this.poidTransactionAttribute, config.poidTransactionAttribute);
        isEquals &= this.checkExistTablesOrViews == config.checkExistTablesOrViews;
        isEquals &= this.equalsVariable(this.defaultInheritanceStrategy, config.defaultInheritanceStrategy);
        isEquals &= this.stringDefaultLength == config.stringDefaultLength;
        isEquals &= this.statementBatchLimit == config.statementBatchLimit;
        isEquals &= this.equalsVariable(this.oracleNlsSortOrder, config.oracleNlsSortOrder);
        isEquals &= this.equalsVariable(this.jdoMetaDataFileExtension, config.jdoMetaDataFileExtension);
        isEquals &= this.equalsVariable(this.ormMetaDataFileExtension, config.ormMetaDataFileExtension);
        isEquals &= this.equalsVariable(this.jdoqueryMetaDataFileExtension, config.jdoqueryMetaDataFileExtension);
        isEquals &= this.metadataValidate == config.metadataValidate;
        isEquals &= this.equalsVariable(this.metadataAnnotationsManager, config.metadataAnnotationsManager);
        isEquals &= this.queryFlushBeforeExecution == config.queryFlushBeforeExecution;
        isEquals &= this.queryUseFetchPlan == config.queryUseFetchPlan;
        isEquals &= this.queryAllowAllSQLStatements == config.queryAllowAllSQLStatements;
        isEquals &= this.queryTimeout == config.queryTimeout;
        isEquals &= this.queryFetchSize == config.queryFetchSize;
        isEquals &= this.equalsVariable(this.queryFetchDirection, config.queryFetchDirection);
        isEquals &= this.equalsVariable(this.queryResultSetConcurrency, config.queryResultSetConcurrency);
        isEquals &= this.equalsVariable(this.queryResultSetType, config.queryResultSetType);
        isEquals &= this.queryUseInnerJoinsOnly == config.queryUseInnerJoinsOnly;
        isEquals &= this.persistenceByReachabilityAtCommit == config.persistenceByReachabilityAtCommit;
        isEquals &= this.maxFetchDepth == config.maxFetchDepth;
        isEquals &= this.primaryClassLoader == config.primaryClassLoader;
        isEquals &= this.equalsVariable(this.classLoaderResolverName, config.classLoaderResolverName);
        isEquals &= this.equalsVariable(this.implementationCreatorName, config.implementationCreatorName);
        isEquals &= this.equalsVariable(this.datastoreIdentityClassName, config.datastoreIdentityClassName);
        isEquals &= this.equalsVariable(this.connectionPoolingType, config.connectionPoolingType);
        isEquals &= this.equalsVariable(this.connectionPoolingConfigurationFile, config.connectionPoolingConfigurationFile);
        isEquals &= this.datastoreClassAdditionMaxRetries == config.datastoreClassAdditionMaxRetries;
        isEquals &= this.isolationLevel == config.isolationLevel;
        isEquals &= this.equalsVariable(this.jtaLocator, config.jtaLocator);
        isEquals &= this.equalsVariable(this.jtaJndiLocation, config.jtaJndiLocation);
        isEquals &= this.datastoreTransactionDelayOperations == config.datastoreTransactionDelayOperations;
        isEquals &= this.datastoreTransactionFlushLimit == config.datastoreTransactionFlushLimit;
        isEquals &= this.poidIsolationLevel == config.poidIsolationLevel;
        isEquals &= this.multithreaded == config.multithreaded;
        isEquals &= this.optimistic == config.optimistic;
        isEquals &= this.retainValues == config.retainValues;
        isEquals &= this.restoreValues == config.restoreValues;
        isEquals &= this.nontransactionalRead == config.nontransactionalRead;
        isEquals &= this.nontransactionalWrite == config.nontransactionalWrite;
        isEquals &= this.ignoreCache == config.ignoreCache;
        isEquals &= this.detachAllOnCommit == config.detachAllOnCommit;
        isEquals &= this.copyOnAttach == config.copyOnAttach;
        isEquals &= this.detachOnClose == config.detachOnClose;
        isEquals &= this.findObjectCheckInheritance == config.findObjectCheckInheritance;
        isEquals &= this.attachSameDatastore == config.attachSameDatastore;
        isEquals &= this.jpaOneToManyUniFkRelations == config.jpaOneToManyUniFkRelations;
        isEquals &= this.validateTables == config.validateTables;
        isEquals &= this.validateColumns == config.validateColumns;
        isEquals &= this.validateConstraints == config.validateConstraints;
        isEquals &= this.autoCreateTables == config.autoCreateTables;
        isEquals &= this.autoCreateColumns == config.autoCreateColumns;
        isEquals &= this.autoCreateConstraints == config.autoCreateConstraints;
        isEquals &= this.autoCreateWarnOnError == config.autoCreateWarnOnError;
        isEquals &= this.equalsVariable(this.initializeColumnInfo, config.initializeColumnInfo);
        isEquals &= this.readOnlyDatastore == config.readOnlyDatastore;
        isEquals &= this.fixedDatastore == config.fixedDatastore;
        isEquals &= this.equalsVariable(this.rdbmsConstraintCreateMode, config.rdbmsConstraintCreateMode);
        isEquals &= this.equalsVariable(this.deletionPolicy, config.deletionPolicy);
        isEquals &= this.uniqueConstraintsMapInverse == config.uniqueConstraintsMapInverse;
        isEquals &= this.equalsVariable(this.propertiesFileName, config.propertiesFileName);
        isEquals &= this.equalsVariable(this.connectionProviderName, config.connectionProviderName);
        isEquals &= this.connectionProviderFailOnError == config.connectionProviderFailOnError;
        isEquals &= this.equalsVariable(this.connectionResourceType, config.connectionResourceType);
        isEquals &= this.equalsVariable(this.connection2ResourceType, config.connection2ResourceType);
        return isEquals &= this.equalsVariable(this.db4oOutputFile, config.db4oOutputFile);
    }

    private boolean equalsVariable(Object var1, Object var2) {
        return !(var1 == null ? var2 != null : !var1.equals(var2));
    }

    public synchronized void setConnectionUserName(String userName) {
        this.assertConfigurable();
        this.userName = userName;
    }

    public String getConnectionUserName() {
        return this.userName;
    }

    public synchronized void setConnectionPassword(String password) {
        this.assertConfigurable();
        this.password = password;
    }

    public synchronized void setConnectionURL(String url) {
        this.assertConfigurable();
        this.url = url;
    }

    public String getConnectionURL() {
        return this.url;
    }

    public synchronized void setConnectionDriverName(String driverName) {
        this.assertConfigurable();
        this.driverName = driverName;
    }

    public String getConnectionDriverName() {
        return this.driverName;
    }

    public String getConnectionPassword() {
        return this.password;
    }

    public synchronized void setConnectionFactoryName(String connectionFactoryName) {
        this.assertConfigurable();
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public synchronized void setConnectionFactory(Object connectionFactory) {
        this.assertConfigurable();
        this.connectionFactory = connectionFactory;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public synchronized void setConnectionFactory2Name(String connectionFactoryName) {
        this.assertConfigurable();
        this.connectionFactory2Name = connectionFactoryName;
    }

    public String getConnectionFactory2Name() {
        return this.connectionFactory2Name;
    }

    public synchronized void setConnectionFactory2(Object connectionFactory) {
        this.assertConfigurable();
        this.connectionFactory2 = connectionFactory;
    }

    public Object getConnectionFactory2() {
        return this.connectionFactory2;
    }

    public synchronized void setMultithreaded(boolean flag) {
        this.assertConfigurable();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        return this.multithreaded;
    }

    public synchronized void setOptimistic(boolean flag) {
        this.assertConfigurable();
        this.optimistic = flag;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public synchronized void setRetainValues(boolean flag) {
        this.assertConfigurable();
        this.retainValues = flag;
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public synchronized void setRestoreValues(boolean flag) {
        this.assertConfigurable();
        this.restoreValues = flag;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public synchronized void setNontransactionalRead(boolean flag) {
        this.assertConfigurable();
        this.nontransactionalRead = flag;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean flag) {
        this.assertConfigurable();
        this.nontransactionalWrite = flag;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public synchronized void setIgnoreCache(boolean flag) {
        this.assertConfigurable();
        this.ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public synchronized void setDetachAllOnCommit(boolean flag) {
        this.assertConfigurable();
        this.detachAllOnCommit = flag;
    }

    public boolean getDetachAllOnCommit() {
        return this.detachAllOnCommit;
    }

    public synchronized void setCopyOnAttach(boolean flag) {
        this.assertConfigurable();
        this.copyOnAttach = flag;
    }

    public boolean getCopyOnAttach() {
        return this.copyOnAttach;
    }

    public synchronized void setMapping(String mapping) {
        this.assertConfigurable();
        this.mapping = mapping;
    }

    public String getMapping() {
        return this.mapping;
    }

    public synchronized void setCatalog(String catalog) {
        this.assertConfigurable();
        this.catalogName = catalog;
    }

    public String getCatalog() {
        return this.catalogName;
    }

    public synchronized void setSchema(String schema) {
        this.assertConfigurable();
        this.schemaName = schema;
    }

    public String getSchema() {
        return this.schemaName;
    }

    public synchronized void setTransactionType(String type) {
        this.assertConfigurable();
        if (type == null) {
            return;
        }
        if (!type.equalsIgnoreCase(TransactionType.JTA.toString()) && !type.equalsIgnoreCase(TransactionType.RESOURCE_LOCAL.toString())) {
            throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", JDO_TRANSACTION_TYPE_PROPERTY, type));
        }
        this.transactionType = type;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setServerTimeZoneID(String id) {
        String[] availableIDs = TimeZone.getAvailableIDs();
        boolean validZone = false;
        for (int i = 0; i < availableIDs.length; ++i) {
            if (!availableIDs[i].equals(id)) continue;
            validZone = true;
            break;
        }
        if (!validZone) {
            throw new JDOUserException("Invalid TimeZone ID specified");
        }
        this.serverTimeZoneID = id;
    }

    public String getServerTimeZoneID() {
        return this.serverTimeZoneID;
    }

    public Calendar getCalendarForDateTimezone() {
        if (this.dateTimezoneCalendar == null) {
            TimeZone tz = this.serverTimeZoneID != null ? TimeZone.getTimeZone(this.serverTimeZoneID) : TimeZone.getDefault();
            this.dateTimezoneCalendar = new GregorianCalendar(tz);
        }
        return this.dateTimezoneCalendar;
    }

    public synchronized void setName(String name) {
        this.assertConfigurable();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setPersistenceUnitName(String name) {
        this.assertConfigurable();
        this.persistenceUnitName = name;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public synchronized void setJpaOneToManyUniFkRelations(boolean flag) {
        this.assertConfigurable();
        this.jpaOneToManyUniFkRelations = flag;
    }

    public boolean getJpaOneToManyUniFkRelations() {
        return this.jpaOneToManyUniFkRelations;
    }

    public synchronized void setJCAMode(Boolean jca) {
        this.assertConfigurable();
        this.jca = jca;
    }

    public boolean isJcaMode() {
        return this.jca != null && this.jca != false;
    }

    public synchronized void setConnectionResourceType(String resourceType) {
        this.assertConfigurable();
        this.connectionResourceType = ResourceType.getValue(resourceType).toString();
    }

    public String getConnectionResourceType() {
        return this.connectionResourceType;
    }

    public synchronized void setConnection2ResourceType(String resourceType) {
        this.assertConfigurable();
        this.connection2ResourceType = ResourceType.getValue(resourceType).toString();
    }

    public String getConnection2ResourceType() {
        return this.connection2ResourceType;
    }

    public synchronized void setFindObjectCheckInheritance(boolean flag) {
        this.assertConfigurable();
        this.findObjectCheckInheritance = flag;
    }

    public boolean getFindObjectCheckInheritance() {
        return this.findObjectCheckInheritance;
    }

    public synchronized void setAttachSameDatastore(boolean flag) {
        this.assertConfigurable();
        this.attachSameDatastore = flag;
    }

    public boolean getAttachSameDatastore() {
        return this.attachSameDatastore;
    }

    public synchronized void setDetachOnClose(boolean flag) {
        this.assertConfigurable();
        if (flag) {
            JPOXLogger.PERSISTENCE.warn("Use of org.jpox.detachOnClose is deprecated and likely to be removed in a later release. Please use javax.jdo.option.DetachAllOnCommit");
        }
        this.detachOnClose = flag;
    }

    public boolean getDetachOnClose() {
        return this.detachOnClose;
    }

    public synchronized void setConnectionProviderName(String name) {
        this.assertConfigurable();
        this.connectionProviderName = name;
    }

    public String getConnectionProviderName() {
        return this.connectionProviderName;
    }

    public synchronized void setConnectionProviderFailOnError(boolean flag) {
        this.assertConfigurable();
        this.connectionProviderFailOnError = flag;
    }

    public boolean getConnectionProviderFailOnError() {
        return this.connectionProviderFailOnError;
    }

    public synchronized void setPersistenceApiName(String name) {
        this.assertConfigurable();
        this.persistenceApiName = name;
    }

    public String getPersistenceApiName() {
        return this.persistenceApiName;
    }

    public synchronized void setDatastoreAdapterClassName(String adapterClassName) {
        this.assertConfigurable();
        this.datastoreAdapterClassName = adapterClassName;
    }

    public String getDatastoreAdapterClassName() {
        return this.datastoreAdapterClassName;
    }

    public synchronized void setConnectionPoolingType(String type) {
        this.assertConfigurable();
        if (type == null) {
            type = "None";
        }
        this.connectionPoolingType = type;
    }

    public String getConnectionPoolingType() {
        return this.connectionPoolingType;
    }

    public synchronized void setConnectionPoolingConfigurationFile(String file) {
        this.assertConfigurable();
        this.connectionPoolingConfigurationFile = file;
    }

    public String getConnectionPoolingConfigurationFile() {
        return this.connectionPoolingConfigurationFile;
    }

    public synchronized void setStatementBatchLimit(int limit) {
        this.assertConfigurable();
        this.statementBatchLimit = limit;
    }

    public int getStatementBatchLimit() {
        return this.statementBatchLimit;
    }

    public synchronized void setCheckExistTablesOrViews(boolean flag) {
        this.assertConfigurable();
        this.checkExistTablesOrViews = flag;
    }

    public boolean getCheckExistTablesOrViews() {
        return this.checkExistTablesOrViews;
    }

    public synchronized void setValidateTables(boolean flag) {
        this.assertConfigurable();
        this.validateTables = flag;
        if (!this.validateTables) {
            this.setValidateColumns(false);
        }
    }

    public boolean getValidateTables() {
        return this.validateTables;
    }

    public synchronized void setInitializeColumnInfo(String flag) {
        this.assertConfigurable();
        if (flag != null && (flag.equalsIgnoreCase("ALL") || flag.equalsIgnoreCase("NONE") || flag.equalsIgnoreCase("PK"))) {
            this.initializeColumnInfo = flag;
        }
    }

    public String getInitializeColumnInfo() {
        return this.initializeColumnInfo;
    }

    public synchronized void setValidateColumns(boolean flag) {
        this.assertConfigurable();
        this.validateColumns = flag;
    }

    public boolean getValidateColumns() {
        return this.validateColumns;
    }

    public synchronized void setValidateConstraints(boolean flag) {
        this.assertConfigurable();
        this.validateConstraints = flag;
    }

    public boolean getValidateConstraints() {
        return this.validateConstraints;
    }

    public synchronized void setReadOnlyDatastore(boolean flag) {
        this.assertConfigurable();
        this.readOnlyDatastore = flag;
        if (flag) {
            this.setAutoCreateTables(false);
            this.setAutoCreateColumns(false);
            this.setAutoCreateConstraints(false);
        }
    }

    public boolean getReadOnlyDatastore() {
        return this.readOnlyDatastore;
    }

    public synchronized void setReadOnlyDatastoreAction(String action) {
        this.assertConfigurable();
        this.readOnlyDatastoreAction = action;
    }

    public String getReadOnlyDatastoreAction() {
        return this.readOnlyDatastoreAction;
    }

    public synchronized void setFixedDatastore(boolean flag) {
        this.assertConfigurable();
        this.fixedDatastore = flag;
        if (flag) {
            this.setAutoCreateTables(false);
            this.setAutoCreateColumns(false);
            this.setAutoCreateConstraints(false);
        }
    }

    public boolean getFixedDatastore() {
        return this.fixedDatastore;
    }

    public synchronized void setRDBMSConstraintCreateMode(String mode) {
        this.assertConfigurable();
        if (mode.equalsIgnoreCase("JPOX") || mode.equalsIgnoreCase("JDO2")) {
            this.rdbmsConstraintCreateMode = mode;
        }
    }

    public String getRDBMSConstraintCreateMode() {
        return this.rdbmsConstraintCreateMode;
    }

    public synchronized void setDeletionPolicy(String policy) {
        this.assertConfigurable();
        if (policy.equalsIgnoreCase("JPOX") || policy.equalsIgnoreCase("JDO2")) {
            this.deletionPolicy = policy;
        }
    }

    public String getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public synchronized void setIdentifierFactory(String factory) {
        this.assertConfigurable();
        this.identifierFactory = factory;
    }

    public String getIdentifierFactory() {
        return this.identifierFactory;
    }

    public synchronized void setIdentifierCase(String idCase) {
        this.assertConfigurable();
        if (idCase.equalsIgnoreCase("UpperCase") || idCase.equalsIgnoreCase("LowerCase") || idCase.equalsIgnoreCase("PreserveCase")) {
            this.identifierCase = idCase;
        }
    }

    public String getIdentifierCase() {
        return this.identifierCase;
    }

    public synchronized void setIdentifierWordSeparator(String word) {
        this.assertConfigurable();
        this.identifierWordSeparator = word;
    }

    public String getIdentifierWordSeparator() {
        return this.identifierWordSeparator;
    }

    public synchronized void setIdentifierTablePrefix(String prefix) {
        this.assertConfigurable();
        this.identifierTablePrefix = prefix;
    }

    public String getIdentifierTablePrefix() {
        return this.identifierTablePrefix;
    }

    public synchronized void setIdentifierTableSuffix(String suffix) {
        this.assertConfigurable();
        this.identifierTableSuffix = suffix;
    }

    public String getIdentifierTableSuffix() {
        return this.identifierTableSuffix;
    }

    public synchronized void setUniqueConstraintsMapInverse(boolean flag) {
        this.assertConfigurable();
        this.uniqueConstraintsMapInverse = flag;
    }

    public boolean getUniqueConstraintsMapInverse() {
        return this.uniqueConstraintsMapInverse;
    }

    public boolean getUseUpdateLock() {
        return this.useUpdateLock;
    }

    public synchronized void setUseUpdateLock(boolean flag) {
        this.assertConfigurable();
        this.useUpdateLock = flag;
    }

    public int getDatastoreClassAdditionMaxRetries() {
        return this.datastoreClassAdditionMaxRetries;
    }

    public void setDatastoreClassAdditionMaxRetries(int max) {
        this.datastoreClassAdditionMaxRetries = max;
    }

    public boolean getPersistenceByReachabilityAtCommit() {
        return this.persistenceByReachabilityAtCommit;
    }

    public synchronized void setPersistenceByReachabilityAtCommit(boolean flag) {
        this.assertConfigurable();
        this.persistenceByReachabilityAtCommit = flag;
    }

    public int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public synchronized void setMaxFetchDepth(int value) {
        this.assertConfigurable();
        this.maxFetchDepth = value;
    }

    public String getClassLoaderResolverName() {
        return this.classLoaderResolverName;
    }

    public synchronized void setClassLoaderResolverName(String clrName) {
        this.assertConfigurable();
        this.classLoaderResolverName = clrName;
    }

    public ClassLoader getPrimaryClassLoader() {
        return this.primaryClassLoader;
    }

    public synchronized void setPrimaryClassLoaderResolver(ClassLoader clr) {
        this.assertConfigurable();
        this.primaryClassLoader = clr;
    }

    public String getDatastoreIdentityClassName() {
        return this.datastoreIdentityClassName;
    }

    public synchronized void setDatastoreIdentityClassName(String name) {
        this.assertConfigurable();
        this.datastoreIdentityClassName = name;
    }

    public String getImplementationCreatorName() {
        return this.implementationCreatorName;
    }

    public synchronized void setImplementationCreatorName(String implCreatorName) {
        this.assertConfigurable();
        this.implementationCreatorName = implCreatorName;
    }

    public String getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    public synchronized void setDefaultInheritanceStrategy(String strategy) {
        this.assertConfigurable();
        if (strategy == null) {
            return;
        }
        if (!strategy.equalsIgnoreCase("JDO2") && !strategy.equalsIgnoreCase("JPOX")) {
            return;
        }
        this.defaultInheritanceStrategy = strategy;
    }

    public synchronized void setAutoCreateSchema(boolean flag) {
        this.assertConfigurable();
        if (flag) {
            this.setAutoCreateTables(true);
            this.setAutoCreateConstraints(true);
        }
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateSchema"));
        }
    }

    public boolean getAutoCreateSchema() {
        return this.autoCreateTables && this.autoCreateConstraints;
    }

    public synchronized void setAutoCreateTables(boolean flag) {
        this.assertConfigurable();
        this.autoCreateTables = flag;
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            this.autoCreateTables = false;
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateTables"));
        }
    }

    public boolean getAutoCreateTables() {
        return this.autoCreateTables;
    }

    public synchronized void setAutoCreateColumns(boolean flag) {
        this.assertConfigurable();
        this.autoCreateColumns = flag;
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            this.autoCreateTables = false;
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateColumns"));
        }
    }

    public boolean getAutoCreateColumns() {
        return this.autoCreateColumns;
    }

    public synchronized void setAutoCreateConstraints(boolean flag) {
        this.assertConfigurable();
        this.autoCreateConstraints = flag;
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            this.autoCreateConstraints = false;
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyUnusableForSchema", "autoCreateConstraints"));
        }
    }

    public boolean getAutoCreateConstraints() {
        return this.autoCreateConstraints;
    }

    public synchronized void setAutoCreateWarnOnError(boolean flag) {
        this.assertConfigurable();
        this.autoCreateWarnOnError = flag;
    }

    public boolean getAutoCreateWarnOnError() {
        return this.autoCreateWarnOnError;
    }

    public String getAutoStartMechanism() {
        return this.autoStartMechanism;
    }

    public synchronized void setAutoStartMechanism(String mechanism) {
        this.assertConfigurable();
        this.autoStartMechanism = mechanism;
    }

    public String getAutoStartMechanismXmlFile() {
        return this.autoStartMechanismXmlFile;
    }

    public synchronized void setAutoStartMechanismXmlFile(String xmlFile) {
        this.autoStartMechanismXmlFile = xmlFile;
    }

    public String getAutoStartMechanismMode() {
        if (this.autoStartMechanismMode != null && this.autoStartMechanismMode.equalsIgnoreCase("Checked")) {
            return "Checked";
        }
        if (this.autoStartMechanismMode != null && this.autoStartMechanismMode.equalsIgnoreCase("Ignored")) {
            return "Ignored";
        }
        return "Quiet";
    }

    public synchronized void setAutoStartMechanismMode(String mode) {
        this.assertConfigurable();
        if (!(mode.equals("Checked") || mode.equals("Ignored") || mode.equals("Quiet"))) {
            throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", AUTO_START_MECHANISM_MODE_PROPERTY, mode));
        }
        this.autoStartMechanismMode = mode;
    }

    public String getAutoStartClassNames() {
        return this.autoStartClassNames;
    }

    public synchronized void setAutoStartClassNames(String classNames) {
        this.autoStartClassNames = classNames;
    }

    public int getPoidTransactionIsolationLevel() {
        return this.poidIsolationLevel;
    }

    protected synchronized void setPoidTransactionIsolation(String isolationLevelName) {
        String iln = isolationLevelName.trim().replace(' ', '_').toUpperCase();
        this.poidIsolationLevel = TransactionUtils.getTransactionIsolationLevelForName(iln);
        if (this.poidIsolationLevel < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", POID_TRANSACTION_ISOLATION_PROPERTY, isolationLevelName));
        }
    }

    public synchronized void setPoidTransactionIsolation(int isolationLevel) {
        switch (isolationLevel) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", POID_TRANSACTION_ISOLATION_PROPERTY, "" + isolationLevel));
            }
        }
        this.poidIsolationLevel = isolationLevel;
    }

    public String getPoidTransactionAttribute() {
        return this.poidTransactionAttribute;
    }

    public void setPoidTransactionAttribute(String poidTransactionAttribute) {
        if (poidTransactionAttribute == null) {
            throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", POID_TRANSACTION_ATTRIBUTE_PROPERTY, poidTransactionAttribute));
        }
        if (!poidTransactionAttribute.equals("New") && !poidTransactionAttribute.equals("UsePM")) {
            throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", POID_TRANSACTION_ATTRIBUTE_PROPERTY, poidTransactionAttribute));
        }
        this.poidTransactionAttribute = poidTransactionAttribute;
    }

    public boolean getQueryFlushBeforeExecution() {
        return this.queryFlushBeforeExecution;
    }

    public void setQueryFlushBeforeExecution(boolean flush) {
        this.queryFlushBeforeExecution = flush;
    }

    public boolean getQueryUseFetchPlan() {
        return this.queryUseFetchPlan;
    }

    public void setQueryUseFetchPlan(boolean useFetchPlan) {
        this.queryUseFetchPlan = useFetchPlan;
    }

    public boolean isQueryAllowAllSQLStatements() {
        return this.queryAllowAllSQLStatements;
    }

    public void setQueryAllowAllSQLStatements(boolean allow) {
        this.queryAllowAllSQLStatements = allow;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int timeout) {
        this.queryTimeout = timeout;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setQueryFetchSize(int size) {
        this.queryFetchSize = size;
    }

    public String getQueryFetchDirection() {
        return this.queryFetchDirection;
    }

    public void setQueryFetchDirection(String dir) {
        if (!(dir != null && dir.equals("forward") && dir.equals("reverse") && dir.equals("unknown"))) {
            return;
        }
        this.queryFetchDirection = dir;
    }

    public String getQueryResultSetType() {
        return this.queryResultSetType;
    }

    public void setQueryResultSetType(String type) {
        if (type == null || !type.equals("forward-only") && !type.equals("scroll-sensitive") && !type.equals("scroll-insensitive")) {
            return;
        }
        this.queryResultSetType = type;
    }

    public String getQueryResultSetConcurrency() {
        return this.queryResultSetConcurrency;
    }

    public void setQueryResultSetConcurrency(String concur) {
        if (concur == null || !concur.equals("read-only") && !concur.equals("updateable")) {
            return;
        }
        this.queryResultSetConcurrency = concur;
    }

    public boolean getQueryUseInnerJoinsOnly() {
        return this.queryUseInnerJoinsOnly;
    }

    public void setQueryUseInnerJoinsOnly(boolean useInner) {
        this.queryUseInnerJoinsOnly = useInner;
    }

    public int getStringDefaultLength() {
        return this.stringDefaultLength;
    }

    public void setStringDefaultLength(int len) {
        this.stringDefaultLength = len;
    }

    public String getOracleNlsSortOrder() {
        return this.oracleNlsSortOrder;
    }

    public void setOracleNlsSortOrder(String order) {
        this.oracleNlsSortOrder = order;
    }

    public boolean getCacheCollections() {
        return this.cacheCollections;
    }

    public synchronized void setCacheCollections(boolean cache) {
        this.assertConfigurable();
        this.cacheCollections = cache;
    }

    public Boolean getCacheCollectionsLazy() {
        return this.cacheCollectionsLazy;
    }

    public synchronized void setCacheCollectionsLazy(Boolean lazy) {
        this.assertConfigurable();
        if (lazy != null) {
            this.cacheCollectionsLazy = lazy;
        }
    }

    public String getCacheLevel1Type() {
        return this.cacheLevel1Type;
    }

    public synchronized void setCacheLevel1Type(String type) {
        this.assertConfigurable();
        this.cacheLevel1Type = type;
    }

    public boolean getCacheLevel2() {
        return this.cacheLevel2;
    }

    public synchronized void setCacheLevel2(boolean cache) {
        this.assertConfigurable();
        this.cacheLevel2 = cache;
    }

    public String getCacheLevel2Type() {
        return this.cacheLevel2Type;
    }

    public synchronized void setCacheLevel2Type(String type) {
        this.assertConfigurable();
        this.cacheLevel2Type = type;
    }

    public String getCacheLevel2CacheName() {
        return this.cacheLevel2CacheName;
    }

    public synchronized void setCacheLevel2CacheName(String name) {
        this.assertConfigurable();
        this.cacheLevel2CacheName = name;
    }

    public String getCacheLevel2ConfigurationFile() {
        return this.cacheLevel2ConfigurationFile;
    }

    public synchronized void setCacheLevel2ConfigurationFile(String confFile) {
        this.assertConfigurable();
        this.cacheLevel2ConfigurationFile = confFile;
    }

    protected synchronized void setTransactionIsolation(String isolationLevelName) {
        this.assertConfigurable();
        String iln = isolationLevelName.trim().replace(' ', '_').toUpperCase();
        this.isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(iln);
        if (this.isolationLevel < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", TRANSACTION_ISOLATION_PROPERTY, isolationLevelName));
        }
    }

    public synchronized void setTransactionIsolation(int isolationLevel) {
        this.assertConfigurable();
        switch (isolationLevel) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(LOCALISER.msg("OMF.PropertyValueInvalid", TRANSACTION_ISOLATION_PROPERTY, "" + isolationLevel));
            }
        }
        this.isolationLevel = isolationLevel;
    }

    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    protected synchronized void setJtaLocator(String locator) {
        this.assertConfigurable();
        this.jtaLocator = locator;
    }

    public String getJtaLocator() {
        return this.jtaLocator;
    }

    protected synchronized void setJtaJndiLocation(String jndi) {
        this.assertConfigurable();
        this.jtaJndiLocation = jndi;
    }

    public String getJtaJndiLocation() {
        return this.jtaJndiLocation;
    }

    public synchronized void setDatastoreTransactionsDelayOperations(boolean flag) {
        this.assertConfigurable();
        this.datastoreTransactionDelayOperations = flag;
    }

    public boolean getDatastoreTransactionsDelayOperations() {
        return this.datastoreTransactionDelayOperations;
    }

    protected synchronized void setDatastoreTransactionFlushLimit(int limit) {
        this.assertConfigurable();
        this.datastoreTransactionFlushLimit = limit;
    }

    public int getDatastoreTransactionFlushLimit() {
        return this.datastoreTransactionFlushLimit;
    }

    public synchronized void setDb4oOutputFile(String file) {
        this.assertConfigurable();
        this.db4oOutputFile = file;
    }

    public String getDb4oOutputFile() {
        return this.db4oOutputFile;
    }

    public synchronized void setPropertiesFile(String value) {
        this.assertConfigurable();
        if (value == null) {
            return;
        }
        if (this.propertiesFileName != null) {
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.PropertyFileAlreadyLoaded", this.propertiesFileName, value));
            return;
        }
        Properties props = new Properties();
        File file = new File(value);
        if (file.exists()) {
            this.propertiesFileName = value;
            try {
                FileInputStream is = new FileInputStream(file);
                props.load(is);
                ((InputStream)is).close();
            }
            catch (FileNotFoundException e) {
                this.propertiesFileName = null;
                throw new JPOXUserException(LOCALISER.msg("OMF.PropertyFileLoadError", value), e).setFatal();
            }
            catch (IOException e) {
                this.propertiesFileName = null;
                throw new JPOXUserException(LOCALISER.msg("OMF.PropertyFileLoadError", value), e).setFatal();
            }
        }
        try {
            InputStream is = (class$org$jpox$PersistenceConfiguration == null ? (class$org$jpox$PersistenceConfiguration = PersistenceConfiguration.class$("org.jpox.PersistenceConfiguration")) : class$org$jpox$PersistenceConfiguration).getClassLoader().getResourceAsStream(value);
            props.load(is);
            is.close();
            this.propertiesFileName = value;
        }
        catch (Exception e) {
            throw new JPOXUserException(LOCALISER.msg("OMF.PropertyFileLoadError", value), e).setFatal();
        }
        this.setOptions(props);
    }

    public String getJdoMetaDataFileExtension() {
        return this.jdoMetaDataFileExtension;
    }

    public void setJdoMetaDataFileExtension(String metadataFileExtension) {
        this.jdoMetaDataFileExtension = metadataFileExtension;
    }

    public String getOrmMetaDataFileExtension() {
        return this.ormMetaDataFileExtension;
    }

    public void setOrmMetaDataFileExtension(String metadataFileExtension) {
        this.ormMetaDataFileExtension = metadataFileExtension;
    }

    public String getJdoqueryMetaDataFileExtension() {
        return this.jdoqueryMetaDataFileExtension;
    }

    public void setJdoqueryMetaDataFileExtension(String metadataFileExtension) {
        this.jdoqueryMetaDataFileExtension = metadataFileExtension;
    }

    public boolean getMetaDataValidate() {
        return this.metadataValidate;
    }

    public void setMetaDataValidate(boolean validate) {
        this.metadataValidate = validate;
    }

    public String getMetaDataAnnotationsManager() {
        return this.metadataAnnotationsManager;
    }

    public void setMetaDataAnnotationsManager(String mgr) {
        this.metadataAnnotationsManager = mgr;
    }

    public String getPluginRegistryClassName() {
        return this.pluginRegistryClassName;
    }

    public void setPluginRegistryClassName(String pluginRegistryClassName) {
        this.pluginRegistryClassName = pluginRegistryClassName;
    }

    public String getPluginRegistryBundleCheck() {
        return this.pluginRegistryBundleCheck;
    }

    public void setPluginRegistryBundleCheck(String check) {
        if (StringUtils.isWhitespace(check) || !check.equalsIgnoreCase("EXCEPTION") && !check.equalsIgnoreCase("LOG") && !check.equalsIgnoreCase("NONE")) {
            return;
        }
        this.pluginRegistryBundleCheck = check.toUpperCase();
    }

    protected void assertConfigurable() {
        if (!this.configurable) {
            throw new JDOUserException(LOCALISER.msg("OMF.NotConfigurableAfterGeneration"));
        }
    }

    protected Map initPropertySetters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(JDO_OPTIMISTIC_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setOptimistic(Boolean.valueOf(s));
            }
        });
        map.put(JDO_RETAINVALUES_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setRetainValues(Boolean.valueOf(s));
            }
        });
        map.put(JDO_RESTOREVALUES_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setRestoreValues(Boolean.valueOf(s));
            }
        });
        map.put(JDO_IGNORECACHE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setIgnoreCache(Boolean.valueOf(s));
            }
        });
        map.put(JDO_DETACHALLONCOMMIT_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDetachAllOnCommit(Boolean.valueOf(s));
            }
        });
        map.put(JDO_COPYONATTACH_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCopyOnAttach(Boolean.valueOf(s));
            }
        });
        map.put(JDO_NONTRANSACTIONAL_READ_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setNontransactionalRead(Boolean.valueOf(s));
            }
        });
        map.put(JDO_NONTRANSACTIONAL_WRITE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setNontransactionalWrite(Boolean.valueOf(s));
            }
        });
        map.put(JDO_MULTITHREADED_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setMultithreaded(Boolean.valueOf(s));
            }
        });
        map.put(JDO_DATASTORE_USERNAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionUserName(s);
            }
        });
        map.put(JDO_DATASTORE_PASSWORD_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionPassword(s);
            }
        });
        map.put(JDO_DATASTORE_DRIVERNAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionDriverName(s);
            }
        });
        map.put(JDO_DATASTORE_URL_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionURL(s);
            }
        });
        map.put(JDO_CONNECTION_FACTORY_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionFactoryName(s);
            }
        });
        map.put(JDO_CONNECTION_FACTORY2_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionFactory2Name(s);
            }
        });
        map.put(JDO_CONNECTION_FACTORY_PROPERTY, new ObjectPropertySetter(){

            public void set(PersistenceConfiguration configuration, Object obj) {
                configuration.setConnectionFactory(obj);
            }
        });
        map.put(JDO_CONNECTION_FACTORY2_PROPERTY, new ObjectPropertySetter(){

            public void set(PersistenceConfiguration configuration, Object obj) {
                configuration.setConnectionFactory2(obj);
            }
        });
        map.put(JDO_MAPPING_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setMapping(s);
            }
        });
        map.put(JDO_MAPPING_CATALOG_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCatalog(s);
            }
        });
        map.put(JDO_MAPPING_SCHEMA_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setSchema(s);
            }
        });
        map.put(JDO_TRANSACTION_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setTransactionType(s);
            }
        });
        map.put(JDO_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setName(s);
            }
        });
        map.put(JDO_PERSISTENCE_UNIT_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPersistenceUnitName(s);
            }
        });
        map.put(JDO_SERVER_TIMEZONE_ID_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setServerTimeZoneID(s);
            }
        });
        map.put(JPA_TRANSACTION_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setTransactionType(s);
            }
        });
        map.put(JPA_ONE_TO_MANY_UNI_FK_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setJpaOneToManyUniFkRelations(Boolean.valueOf(s));
            }
        });
        map.put(PERSISTENCE_API_NAME, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPersistenceApiName(s);
            }
        });
        map.put(FIND_OBJECT_CHECK_INHERITANCE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setFindObjectCheckInheritance(Boolean.valueOf(s));
            }
        });
        map.put(ATTACH_SAME_DATASTORE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAttachSameDatastore(Boolean.valueOf(s));
            }
        });
        map.put(DETACH_ON_CLOSE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDetachOnClose(Boolean.valueOf(s));
            }
        });
        map.put(DATASTORE_ADAPTER_CLASSNAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDatastoreAdapterClassName(s);
            }
        });
        map.put(STATEMENT_BATCH_LIMIT_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setStatementBatchLimit(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(CHECK_EXIST_TABLES_VIEWS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCheckExistTablesOrViews(Boolean.valueOf(s));
            }
        });
        map.put(VALIDATE_TABLES_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setValidateTables(Boolean.valueOf(s));
            }
        });
        map.put(VALIDATE_COLUMNS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setValidateColumns(Boolean.valueOf(s));
            }
        });
        map.put(ADD_UNIQUE_CONSTRAINT_MAP_INVERSE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setUniqueConstraintsMapInverse(Boolean.valueOf(s));
            }
        });
        map.put(VALIDATE_CONSTRAINTS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setValidateConstraints(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_SCHEMA_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoCreateSchema(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_TABLES_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoCreateTables(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_COLUMNS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoCreateColumns(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_CONSTRAINTS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoCreateConstraints(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_WARN_ON_ERROR_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoCreateWarnOnError(Boolean.valueOf(s));
            }
        });
        map.put(INITIALIZE_COLUMN_INFO_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setInitializeColumnInfo(s);
            }
        });
        map.put(AUTO_START_MECHANISM_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoStartMechanism(s);
            }
        });
        map.put(AUTO_START_MECHANISM_XML_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoStartMechanismXmlFile(s);
            }
        });
        map.put(AUTO_START_MECHANISM_MODE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoStartMechanismMode(s);
            }
        });
        map.put(AUTO_START_CLASS_NAMES_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setAutoStartClassNames(s);
            }
        });
        map.put(READ_ONLY_DATASTORE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setReadOnlyDatastore(Boolean.valueOf(s));
            }
        });
        map.put(READ_ONLY_DATASTORE_ACTION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setReadOnlyDatastoreAction(s);
            }
        });
        map.put(FIXED_DATASTORE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setFixedDatastore(Boolean.valueOf(s));
            }
        });
        map.put(RDBMS_CONSTRAINT_CREATE_MODE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setRDBMSConstraintCreateMode(s);
            }
        });
        map.put(DELETION_POLICY_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDeletionPolicy(s);
            }
        });
        map.put(IDENTIFIER_FACTORY_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setIdentifierFactory(s);
            }
        });
        map.put(IDENTIFIER_CASE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setIdentifierCase(s);
            }
        });
        map.put(IDENTIFIER_WORD_SEPARATOR_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setIdentifierWordSeparator(s);
            }
        });
        map.put(IDENTIFIER_TABLE_PREFIX_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setIdentifierTablePrefix(s);
            }
        });
        map.put(IDENTIFIER_TABLE_SUFFIX_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setIdentifierTableSuffix(s);
            }
        });
        map.put(CONNECTION_POOLING_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionPoolingType(s);
            }
        });
        map.put(CONNECTION_POOLING_CONFIGURATION_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionPoolingConfigurationFile(s);
            }
        });
        map.put(DEFAULT_INHERITANCE_STRATEGY_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDefaultInheritanceStrategy(s);
            }
        });
        map.put(USE_UPDATE_LOCK_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setUseUpdateLock(Boolean.valueOf(s));
            }
        });
        map.put(DATASTORE_CLASS_ADDITION_MAX_RETRIES_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setDatastoreClassAdditionMaxRetries(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(TRANSACTION_ISOLATION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setTransactionIsolation(s);
            }
        });
        map.put(JTA_LOCATOR_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setJtaLocator(s);
            }
        });
        map.put(JTA_JNDI_LOCATION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setJtaJndiLocation(s);
            }
        });
        map.put(DATASTORE_TXN_DELAY_OPERATIONS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDatastoreTransactionsDelayOperations(Boolean.valueOf(s));
            }
        });
        map.put(DATASTORE_TXN_FLUSH_LIMIT_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setDatastoreTransactionFlushLimit(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(POID_TRANSACTION_ATTRIBUTE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPoidTransactionAttribute(s);
            }
        });
        map.put(POID_TRANSACTION_ISOLATION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPoidTransactionIsolation(s);
            }
        });
        map.put(PERSISTENCE_BY_REACHABILITY_AT_COMMIT, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPersistenceByReachabilityAtCommit(Boolean.valueOf(s));
            }
        });
        map.put(MAX_FETCH_DEPTH_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setMaxFetchDepth(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(CLASS_LOADER_RESOLVER_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setClassLoaderResolverName(s);
            }
        });
        map.put(IMPLEMENTATION_CREATOR_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setImplementationCreatorName(s);
            }
        });
        map.put(DATASTORE_IDENTITY_CLASS_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDatastoreIdentityClassName(s);
            }
        });
        map.put(QUERY_FLUSH_BEFORE_EXECUTION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    boolean use = new Boolean(s);
                    configuration.setQueryFlushBeforeExecution(use);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_USE_FETCH_PLAN_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    boolean use = new Boolean(s);
                    configuration.setQueryUseFetchPlan(use);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_TIMEOUT_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setQueryTimeout(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_FETCH_SIZE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setQueryFetchSize(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_FETCH_DIRECTION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setQueryFetchDirection(s);
            }
        });
        map.put(QUERY_RESULT_SET_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setQueryResultSetType(s);
            }
        });
        map.put(QUERY_RESULT_SET_CONCURRENCY_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setQueryResultSetConcurrency(s);
            }
        });
        map.put(QUERY_USE_INNER_JOINS_ONLY_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setQueryUseInnerJoinsOnly(Boolean.valueOf(s));
            }
        });
        map.put(QUERY_ALLOW_ALL_SQL_STATEMENTS, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    boolean allow = new Boolean(s);
                    configuration.setQueryAllowAllSQLStatements(allow);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(STRING_DEFAULT_LENGTH_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setStringDefaultLength(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(ORACLE_SORT_ORDER_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setOracleNlsSortOrder(s);
            }
        });
        map.put(CACHE_COLLECTIONS_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCacheCollections(Boolean.valueOf(s));
            }
        });
        map.put(CACHE_COLLECTIONS_LAZY_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                boolean lazy = Boolean.valueOf(s);
                if (lazy) {
                    configuration.setCacheCollectionsLazy(Boolean.TRUE);
                } else {
                    configuration.setCacheCollectionsLazy(Boolean.FALSE);
                }
            }
        });
        map.put(CACHE_LEVEL_1_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCacheLevel1Type(s);
            }
        });
        map.put(CACHE_LEVEL_2_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCacheLevel2(Boolean.valueOf(s));
            }
        });
        map.put(CACHE_LEVEL_2_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCacheLevel2Type(s);
            }
        });
        map.put(CACHE_LEVEL_2_CACHE_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCacheLevel2CacheName(s);
            }
        });
        map.put(CACHE_LEVEL_2_CONFIGURATION_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setCacheLevel2ConfigurationFile(s);
            }
        });
        map.put(METADATA_JDO_FILE_EXTENSION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setJdoMetaDataFileExtension(s);
            }
        });
        map.put(METADATA_ORM_FILE_EXTENSION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setOrmMetaDataFileExtension(s);
            }
        });
        map.put(METADATA_JDOQUERY_FILE_EXTENSION_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setJdoqueryMetaDataFileExtension(s);
            }
        });
        map.put(METADATA_VALIDATE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setMetaDataValidate(Boolean.valueOf(s));
            }
        });
        map.put(METADATA_ANNOTATIONS_MANAGER_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setMetaDataAnnotationsManager(s);
            }
        });
        map.put(PROPERTIES_FILE, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPropertiesFile(s);
            }
        });
        map.put(PLUGIN_REGISTRY_CLASS_NAME, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPluginRegistryClassName(s);
            }
        });
        map.put(PLUGIN_REGISTRY_BUNDLE_CHECK, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setPluginRegistryBundleCheck(s);
            }
        });
        map.put(CONNECTION_PROVIDER_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionProviderName(s);
            }
        });
        map.put(CONNECTION_PROVIDER_FAILONERROR_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionProviderFailOnError(Boolean.valueOf(s));
            }
        });
        map.put(PRIMARY_CLASS_LOADER_PROPERTY, new ObjectPropertySetter(){

            public void set(PersistenceConfiguration configuration, Object o) {
                configuration.setPrimaryClassLoaderResolver((ClassLoader)o);
            }
        });
        map.put(CONNECTION_RESOURCE_TYPE, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnectionResourceType(s);
            }
        });
        map.put(CONNECTION2_RESOURCE_TYPE, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setConnection2ResourceType(s);
            }
        });
        map.put(DB4O_OUTPUT_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                configuration.setDb4oOutputFile(s);
            }
        });
        return map;
    }

    protected void setOptions(Properties props) {
        this.options = props;
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            StringPropertySetter setter = (StringPropertySetter)this.PROPERTY_SETTERS.get(prop);
            if (prop != null && setter != null) {
                String value = props.getProperty(prop);
                setter.set(this, value);
                continue;
            }
            if (prop == null || setter != null || prop.equals("javax.jdo.PersistenceManagerFactoryClass")) continue;
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.UnknownProperty", prop));
        }
    }

    protected void setOptions(Map props) {
        this.options = props;
        Set keys = props.keySet();
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            Object keyObj = keyIter.next();
            if (!(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            Object valueObj = props.get(keyObj);
            if (valueObj instanceof String) {
                String valueStr = ((String)valueObj).trim();
                StringPropertySetter setter = (StringPropertySetter)this.PROPERTY_SETTERS.get(key);
                if (key != null && setter != null) {
                    setter.set(this, valueStr);
                    continue;
                }
                if (key == null || setter != null || key.equals("javax.jdo.PersistenceManagerFactoryClass")) continue;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.UnknownProperty", key));
                continue;
            }
            ObjectPropertySetter setter = (ObjectPropertySetter)this.PROPERTY_SETTERS.get(key);
            if (key != null && setter != null) {
                setter.set(this, valueObj);
                continue;
            }
            if (key == null || setter != null || key.equals("javax.jdo.PersistenceManagerFactoryClass")) continue;
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OMF.UnknownProperty", key));
        }
    }

    public Map getOptions() {
        return this.options;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface ObjectPropertySetter {
        public void set(PersistenceConfiguration var1, Object var2);
    }

    protected static interface StringPropertySetter {
        public void set(PersistenceConfiguration var1, String var2);
    }
}

