/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassNameConstants;
import org.jpox.ConnectionManagerImpl;
import org.jpox.LifecycleListenerForClass;
import org.jpox.PersistenceManagerImpl;
import org.jpox.api.ApiAdapterFactory;
import org.jpox.exceptions.JPOXException;
import org.jpox.jdo.JDOClassNameConstants;
import org.jpox.metadata.PersistenceUnitMetaData;
import org.jpox.metadata.TransactionType;
import org.jpox.util.JPOXLogger;

public class PersistenceManagerFactoryImpl
extends AbstractPersistenceManagerFactory
implements PersistenceManagerFactory,
ObjectFactory,
Referenceable {
    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Properties overridingProps) {
        HashMap<String, String> overridingMap = new HashMap<String, String>();
        Enumeration<?> e = overridingProps.propertyNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            overridingMap.put(param, overridingProps.getProperty(param));
        }
        PersistenceManagerFactoryImpl pmf = new PersistenceManagerFactoryImpl();
        PersistenceManagerFactoryImpl.setPMFOptions(pmf, overridingMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overridingProps) {
        HashMap<String, String> overridingMap = null;
        if (overridingProps instanceof Properties) {
            overridingMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overridingProps)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridingMap.put(param, ((Properties)((Object)overridingProps)).getProperty(param));
            }
        } else {
            overridingMap = overridingProps;
        }
        PersistenceManagerFactoryImpl pmf = new PersistenceManagerFactoryImpl();
        PersistenceManagerFactoryImpl.setPMFOptions(pmf, overridingMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    protected static void setPMFOptions(PersistenceManagerFactoryImpl pmf, Map overridingProps) {
        if (overridingProps != null) {
            HashMap startupProps = null;
            if (overridingProps.containsKey("org.jpox.plugin.pluginRegistryClassName")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("org.jpox.plugin.pluginRegistryClassName", overridingProps.get("org.jpox.plugin.pluginRegistryClassName"));
            }
            if (overridingProps.containsKey("org.jpox.plugin.pluginRegistryBundleCheck")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("org.jpox.plugin.pluginRegistryBundleCheck", overridingProps.get("org.jpox.plugin.pluginRegistryBundleCheck"));
            }
            if (overridingProps.containsKey("org.jpox.classLoaderResolverName")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("org.jpox.classLoaderResolverName", overridingProps.get("org.jpox.classLoaderResolverName"));
            }
            if (startupProps != null) {
                pmf.setOptions(startupProps);
            }
        }
        pmf.initialiseOMFContext();
        pmf.getOMFContext().setConnectionManager(new ConnectionManagerImpl(pmf.getOMFContext()));
        HashMap<Object, Object> pmfProps = new HashMap<Object, Object>();
        String api = "JDO";
        if (overridingProps.get("org.jpox.persistenceApiName") != null) {
            api = (String)overridingProps.get("org.jpox.persistenceApiName");
        }
        pmfProps.putAll(ApiAdapterFactory.getInstance().getApiAdapter(api).getDefaultFactoryProperties());
        pmf.getOMFContext().setApi(api);
        pmfProps.put("javax.jdo.option.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
        String persistenceUnitName = (String)overridingProps.get("javax.jdo.option.PersistenceUnitName");
        if (persistenceUnitName != null) {
            try {
                PersistenceUnitMetaData pumd = pmf.getOMFContext().getMetaDataManager().getMetaDataForPersistenceUnit(persistenceUnitName);
                if (pumd != null) {
                    if (pumd.getProperties() != null) {
                        pmfProps.putAll(pumd.getProperties());
                    }
                } else {
                    throw new JDOUserException(LOCALISER.msg("PMF.PersistenceUnit.NotFound", persistenceUnitName));
                }
                pumd.clearJarFiles();
                pmf.getOMFContext().getMetaDataManager().initialise(pumd, pmf.getOMFContext().getClassLoaderResolver(null));
            }
            catch (JPOXException jpe) {
                throw new JDOUserException(LOCALISER.msg("PMF.PersistenceUnit.PersistenceXMLNotFound", persistenceUnitName));
            }
        }
        pmfProps.putAll(overridingProps);
        pmf.setOptions(pmfProps);
    }

    protected void freezeConfiguration() {
        if (this.configurable) {
            if (this.omfContext == null) {
                this.initialiseOMFContext();
                this.omfContext.setConnectionManager(new ConnectionManagerImpl(this.omfContext));
            }
            super.freezeConfiguration();
        }
    }

    public synchronized PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.getPersistenceConfiguration().getConnectionUserName(), this.getPersistenceConfiguration().getConnectionPassword());
    }

    public synchronized PersistenceManager getPersistenceManager(String userName, String password) {
        this.assertIsOpen();
        this.freezeConfiguration();
        PersistenceManagerImpl pm = new PersistenceManagerImpl(this, userName, password);
        if (this.lifecycleListeners != null) {
            Iterator listenerIter = this.lifecycleListeners.iterator();
            while (listenerIter.hasNext()) {
                LifecycleListenerForClass listener = (LifecycleListenerForClass)listenerIter.next();
                pm.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        this.getPmCache().add(pm);
        return pm;
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistenceManagerFactoryImpl)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        PersistenceManagerFactoryImpl pmf = null;
        if (JPOXLogger.NAMING.isDebugEnabled()) {
            JPOXLogger.NAMING.debug("Creating PersistenceManagerFactory instance via JNDI with values [object] " + (obj == null ? "" : obj.toString()) + " " + "[name] " + (name == null ? "" : name.toString()) + " " + "[context] " + (ctx == null ? "" : ctx.toString()) + " " + "[env] " + (env == null ? "" : env.toString()) + " ");
        }
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(ClassNameConstants.PersistenceManagerFactoryImpl) || ref.getClassName().equals(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory)) {
                Properties p = new Properties();
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    StringRefAddr sra = (StringRefAddr)e.nextElement();
                    p.setProperty(sra.getType(), (String)sra.getContent());
                }
                pmf = new PersistenceManagerFactoryImpl();
                PersistenceManagerFactoryImpl.setPMFOptions(pmf, p);
                pmf.freezeConfiguration();
                if (JPOXLogger.NAMING.isDebugEnabled()) {
                    JPOXLogger.NAMING.debug(LOCALISER.msg("PMF.JNDI.PMFBoundToName", name.toString()));
                }
            } else {
                JPOXLogger.NAMING.warn(LOCALISER.msg("PMF.JNDI.PMFReferenceClassIncorrect", ref.getClassName(), ClassNameConstants.PersistenceManagerFactoryImpl));
            }
        } else {
            JPOXLogger.NAMING.warn(LOCALISER.msg("PMF.JNDI.ObjectReferenceInvalid", obj.getClass().getName()));
        }
        return pmf;
    }

    public Reference getReference() {
        Reference rc = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            rc = new Reference(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory, ClassNameConstants.PersistenceManagerFactoryImpl, null);
            Map p = this.getOptions();
            Iterator i = p.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (p.get(key) instanceof String) {
                    String value = (String)p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!JPOXLogger.NAMING.isDebugEnabled()) continue;
                    JPOXLogger.NAMING.debug(LOCALISER.msg("PMF.JNDI.AddOptionToReference", key, value));
                    continue;
                }
                JPOXLogger.NAMING.warn(LOCALISER.msg("PMF.JNDI.NotAddingOptionToReference", key));
            }
            if (JPOXLogger.NAMING.isDebugEnabled() && p.isEmpty()) {
                JPOXLogger.NAMING.debug(LOCALISER.msg("PMF.JNDI.NoOptionsAddedToReference"));
            }
        }
        catch (IOException ex) {
            JPOXLogger.NAMING.error(ex.getMessage());
            throw new JPOXException(ex.getMessage(), ex);
        }
        return rc;
    }

    public PersistenceManager getPersistenceManagerProxy() {
        throw new UnsupportedOperationException("PMF.getPersistenceManagerProxy() not yet implemented");
    }
}

