/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.jpox.AbstractPersistenceManager;
import org.jpox.ClassLoaderResolver;
import org.jpox.OMFContext;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.PersistenceConfiguration;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.PersistenceUnitMetaData;
import org.jpox.store.StoreManager;
import org.jpox.util.ClassUtils;
import org.jpox.util.CommandLine;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class SchemaTool
extends PersistenceConfiguration {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private OMFContext omfContext = new OMFContext(this);
    private CommandLine cmd = new CommandLine();
    private String[] defaultArgs;
    private boolean verbose;
    private boolean help;
    private String ddlFile;
    private boolean completeDdl = false;
    private String api = "JDO";
    private String modeName;
    private String propsFileName = null;
    public static final int SCHEMATOOL_CREATE_MODE = 1;
    public static final int SCHEMATOOL_DELETE_MODE = 2;
    public static final int SCHEMATOOL_VALIDATE_MODE = 3;
    public static final int SCHEMATOOL_DATABASE_INFO_MODE = 4;
    public static final int SCHEMATOOL_SCHEMA_INFO_MODE = 5;
    public static final String SCHEMATOOL_OPTION_MODE = "org.jpox.schemaTool.mode";
    public static final String SCHEMATOOL_OPTION_VERBOSE = "org.jpox.schemaTool.verbose";
    public static final String SCHEMATOOL_OPTION_PROPERTIES_FILE = "org.jpox.schemaTool.propertiesFile";
    public static final String SCHEMATOOL_OPTION_DDLFILE = "org.jpox.schemaTool.ddlFile";
    public static final String SCHEMATOOL_OPTION_DUMPDDL = "org.jpox.schemaTool.dumpDdl";
    public static final String SCHEMATOOL_OPTION_COMPLETEDDL = "org.jpox.schemaTool.completeDdl";
    public static final String SCHEMATOOL_OPTION_HELP = "org.jpox.schemaTool.help";

    public static void main(String[] args) throws Exception {
        String ddlFilename;
        SchemaTool tool = new SchemaTool();
        tool.setCommandLineArgs(args);
        if (tool.isHelp()) {
            System.out.println(LOCALISER.msg("SchemaTool.HelpTitle"));
            System.out.println(LOCALISER.msg("SchemaTool.HelpCommand"));
            System.out.println(LOCALISER.msg("SchemaTool.HelpOptions"));
            System.out.println(tool.cmd.toString());
            System.out.println(LOCALISER.msg("SchemaTool.HelpInputFiles.1"));
            System.out.println(LOCALISER.msg("SchemaTool.HelpInputFiles.2"));
            System.exit(0);
        }
        int mode = 1;
        String msg = null;
        if (tool.getModeName() != null) {
            if (tool.getModeName().equals("create")) {
                mode = 1;
                msg = LOCALISER.msg("SchemaTool.Title.SchemaCreation", ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("delete")) {
                mode = 2;
                msg = LOCALISER.msg("SchemaTool.Title.SchemaDeletion", ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("validate")) {
                mode = 3;
                msg = LOCALISER.msg("SchemaTool.Title.SchemaValidation", ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("dbinfo")) {
                mode = 4;
                msg = LOCALISER.msg("SchemaTool.Title.DBInfo", ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("schemainfo")) {
                mode = 5;
                msg = LOCALISER.msg("SchemaTool.Title.SchemaInfo", ObjectManagerFactoryImpl.getVersionNumber());
            }
        } else {
            msg = LOCALISER.msg("SchemaTool.Title.SchemaCreation", ObjectManagerFactoryImpl.getVersionNumber());
        }
        JPOXLogger.SCHEMATOOL.info(msg);
        System.out.println(msg);
        msg = LOCALISER.msg("SchemaTool.Classpath");
        JPOXLogger.SCHEMATOOL.info(msg);
        if (tool.isVerbose()) {
            System.out.println(msg);
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            msg = LOCALISER.msg("SchemaTool.Classpath.Entry", tokeniser.nextToken());
            JPOXLogger.SCHEMATOOL.info(msg);
            if (!tool.isVerbose()) continue;
            System.out.println(msg);
        }
        if (tool.isVerbose()) {
            System.out.println();
        }
        if ((ddlFilename = tool.getDdlFile()) != null) {
            msg = LOCALISER.msg(tool.completeDdl ? "SchemaTool.OutputDDLComplete" : "SchemaTool.OutputDDLMissing", ddlFilename);
            JPOXLogger.SCHEMATOOL.info(msg);
            if (tool.isVerbose()) {
                System.out.println(msg);
                System.out.println();
            }
        }
        PersistenceManagerFactory pmf = null;
        try {
            pmf = tool.getPropsFileName() != null ? SchemaTool.getPMFForMode(mode, tool.getPropsFileName(), tool.getOptions(), ddlFilename, tool.verbose) : SchemaTool.getPMFForMode(mode, null, null, ddlFilename, tool.verbose);
            ((ObjectManagerFactoryImpl)pmf).getOMFContext().setApi(tool.getApi());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(LOCALISER.msg("SchemaTool.PMFError", e.getMessage()));
            System.exit(1);
            return;
        }
        ArrayList<String> classNames = null;
        if (mode != 5 && mode != 4) {
            ClassLoaderResolver clr;
            MetaDataManager metaDataMgr;
            try {
                metaDataMgr = ((ObjectManagerFactoryImpl)pmf).getOMFContext().getMetaDataManager();
                clr = ((ObjectManagerFactoryImpl)pmf).getOMFContext().getClassLoaderResolver(null);
            }
            catch (Exception e) {
                msg = LOCALISER.msg("SchemaTool.Error", StringUtils.getStringFromStackTrace(e));
                System.out.println(msg);
                JPOXLogger.SCHEMATOOL.error(msg, e);
                System.exit(2);
                return;
            }
            try {
                FileMetaData[] filemds = SchemaTool.getFileMetaDataForInput(metaDataMgr, clr, tool.isVerbose(), tool.getPersistenceUnitName(), tool.getDefaultArgs());
                classNames = new ArrayList<String>();
                for (int i = 0; i < filemds.length; ++i) {
                    for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                        for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                            classNames.add(filemds[i].getPackage(j).getClass(k).getFullClassName());
                        }
                    }
                }
            }
            catch (Exception e) {
                System.exit(2);
                return;
            }
        }
        try {
            StoreManager srm;
            if (mode == 1) {
                SchemaTool.createSchema(pmf, classNames, ddlFilename, tool.completeDdl);
            } else if (mode == 2) {
                SchemaTool.deleteSchema(pmf, classNames);
            } else if (mode == 3) {
                SchemaTool.validateSchema(pmf, classNames);
            } else if (mode == 4) {
                srm = ((AbstractPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getStoreManager();
                srm.outputDatastoreInformation(System.out);
            } else if (mode == 5) {
                srm = ((AbstractPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getStoreManager();
                srm.outputSchemaInformation(System.out);
            }
            msg = LOCALISER.msg("SchemaTool.Success");
            JPOXLogger.SCHEMATOOL.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            msg = LOCALISER.msg("SchemaTool.Error", e.getMessage());
            System.out.println(msg);
            JPOXLogger.SCHEMATOOL.error(msg, e);
            System.exit(2);
            return;
        }
    }

    public SchemaTool() {
        this.cmd.addOption("create", "create", null, LOCALISER.msg("SchemaTool.HelpOption.Create"));
        this.cmd.addOption("delete", "delete", null, LOCALISER.msg("SchemaTool.HelpOption.Delete"));
        this.cmd.addOption("validate", "validate", null, LOCALISER.msg("SchemaTool.HelpOption.Validate"));
        this.cmd.addOption("dbinfo", "dbinfo", null, LOCALISER.msg("SchemaTool.HelpOption.DBInfo"));
        this.cmd.addOption("schemainfo", "schemainfo", null, LOCALISER.msg("SchemaTool.HelpOption.SchemaInfo"));
        this.cmd.addOption("ddlFile", "ddlFile", "ddlFile", LOCALISER.msg("SchemaTool.HelpOption.DDLFile"));
        this.cmd.addOption("dumpDdl", "dumpDdl", "dumpDdl", LOCALISER.msg("SchemaTool.HelpOption.DDLFile"));
        this.cmd.addOption("completeDdl", "completeDdl", null, LOCALISER.msg("SchemaTool.HelpOption.CompleteDDL"));
        this.cmd.addOption("api", "api", "<adapter-name>", "API Adapter (JDO, JPA, etc)");
        this.cmd.addOption("help", "help", null, LOCALISER.msg("SchemaTool.HelpOption.Help"));
        this.cmd.addOption("v", "verbose", null, "verbose output");
        this.cmd.addOption("persistenceUnit", "persistenceUnit", "<persistence-unit>", "name of the persistence unit to handle the schema for");
        this.cmd.addOption("props", "jpoxproperties", "props", "path to a properties file");
    }

    protected static PersistenceManagerFactory getPMFForMode(int mode, String propsFileName, Map userProps, String ddlFile, boolean verbose) {
        Properties props = new Properties();
        if (userProps != null) {
            props.putAll((Map<?, ?>)userProps);
        } else {
            if (System.getProperty("javax.jdo.option.ConnectionDriverName") == null || System.getProperty("javax.jdo.option.ConnectionURL") == null) {
                File file = new File(System.getProperty("user.home") + "/.jdo/PMFProperties.properties");
                if (file.exists()) {
                    try {
                        FileInputStream is = new FileInputStream(file);
                        props.load(is);
                        ((InputStream)is).close();
                    }
                    catch (IOException ioe) {}
                } else {
                    throw new JPOXException(LOCALISER.msg("SchemaTool.DatabaseDriverNotSpecifiedError"));
                }
            }
            props.setProperty("javax.jdo.PersistenceManagerFactoryClass", "org.jpox.PersistenceManagerFactoryImpl");
            if (System.getProperty("javax.jdo.option.ConnectionDriverName") != null) {
                props.setProperty("javax.jdo.option.ConnectionDriverName", System.getProperty("javax.jdo.option.ConnectionDriverName"));
            }
            if (System.getProperty("javax.jdo.option.ConnectionURL") != null) {
                props.setProperty("javax.jdo.option.ConnectionURL", System.getProperty("javax.jdo.option.ConnectionURL"));
            }
            if (System.getProperty("javax.jdo.option.ConnectionUserName") != null) {
                props.setProperty("javax.jdo.option.ConnectionUserName", System.getProperty("javax.jdo.option.ConnectionUserName"));
            }
            if (System.getProperty("javax.jdo.option.ConnectionPassword") != null) {
                props.setProperty("javax.jdo.option.ConnectionPassword", System.getProperty("javax.jdo.option.ConnectionPassword"));
            }
            if (System.getProperty("javax.jdo.option.Mapping") != null) {
                props.setProperty("javax.jdo.option.Mapping", System.getProperty("javax.jdo.option.Mapping"));
            }
        }
        props.setProperty("org.jpox.autoStartMechanism", "None");
        if (mode == 1) {
            if (ddlFile != null) {
                props.setProperty("org.jpox.validateConstraints", "false");
                props.setProperty("org.jpox.validateColumns", "false");
                props.setProperty("org.jpox.validateTables", "false");
            }
            props.setProperty("org.jpox.autoCreateSchema", "true");
            props.setProperty("org.jpox.autoCreateTables", "true");
            props.setProperty("org.jpox.autoCreateConstraints", "true");
            props.setProperty("org.jpox.fixedDatastore", "false");
            props.setProperty("org.jpox.readOnlyDatastore", "false");
        } else if (mode == 2) {
            props.setProperty("org.jpox.fixedDatastore", "false");
            props.setProperty("org.jpox.readOnlyDatastore", "false");
        } else if (mode == 3) {
            props.setProperty("org.jpox.autoCreateSchema", "false");
            props.setProperty("org.jpox.autoCreateConstraints", "false");
            props.setProperty("org.jpox.autoCreateColumns", "false");
            props.setProperty("org.jpox.validateTables", "true");
            props.setProperty("org.jpox.validateColumns", "true");
            props.setProperty("org.jpox.validateConstraints", "true");
        }
        if (verbose) {
            String msg = null;
            msg = propsFileName != null ? LOCALISER.msg("SchemaTool.PropertiesFromFile", propsFileName) : LOCALISER.msg("SchemaTool.Properties");
            JPOXLogger.SCHEMATOOL.info(msg);
            System.out.println(msg);
            Set<Object> keys = props.keySet();
            ArrayList<Object> keyNames = new ArrayList<Object>(keys);
            Collections.sort(keyNames);
            Iterator keyNamesIter = keyNames.iterator();
            while (keyNamesIter.hasNext()) {
                String key = (String)keyNamesIter.next();
                if (key.equals("javax.jdo.option.ConnectionPassword")) continue;
                msg = LOCALISER.msg("SchemaTool.Property", key, props.getProperty(key));
                JPOXLogger.SCHEMATOOL.info(msg);
                System.out.println(msg);
            }
            System.out.println();
        }
        return JDOHelper.getPersistenceManagerFactory((Map)props);
    }

    protected static FileMetaData[] getFileMetaDataForInput(MetaDataManager metaDataMgr, ClassLoaderResolver clr, boolean verbose, String persistenceUnitName, String[] inputFiles) {
        FileMetaData[] filemds = null;
        String msg = null;
        if (inputFiles == null && persistenceUnitName == null) {
            msg = LOCALISER.msg("SchemaTool.NoInputError");
            JPOXLogger.SCHEMATOOL.error(msg);
            System.out.println(msg);
            throw new JPOXUserException(msg);
        }
        if (persistenceUnitName != null) {
            msg = LOCALISER.msg("SchemaTool.PersistenceUnit", persistenceUnitName);
            JPOXLogger.SCHEMATOOL.info(msg);
            if (verbose) {
                System.out.println(msg);
                System.out.println();
            }
            PersistenceUnitMetaData pumd = null;
            try {
                pumd = metaDataMgr.getMetaDataForPersistenceUnit(persistenceUnitName);
            }
            catch (JPOXException jpe) {
                msg = LOCALISER.msg("SchemaTool.PersistenceUnit.NoPersistenceFiles", persistenceUnitName);
                JPOXLogger.SCHEMATOOL.error(msg);
                System.out.println(msg);
                throw new JPOXUserException(msg);
            }
            if (pumd == null) {
                msg = LOCALISER.msg("SchemaTool.PersistenceUnit.NoSuchUnit", persistenceUnitName);
                JPOXLogger.SCHEMATOOL.error(msg);
                System.out.println(msg);
                throw new JPOXUserException(msg);
            }
            pumd.clearJarFiles();
            filemds = metaDataMgr.initialise(pumd, clr);
        } else {
            msg = LOCALISER.msg("SchemaTool.InputFiles");
            JPOXLogger.SCHEMATOOL.info(msg);
            if (verbose) {
                System.out.println(msg);
            }
            for (int i = 0; i < inputFiles.length; ++i) {
                String entry = LOCALISER.msg("SchemaTool.InputFiles.Entry", inputFiles[i]);
                JPOXLogger.SCHEMATOOL.info(entry);
                if (!verbose) continue;
                System.out.println(entry);
            }
            if (verbose) {
                System.out.println();
            }
            try {
                JPOXLogger.SCHEMATOOL.debug(LOCALISER.msg("SchemaTool.InputFiles.ReadStart", "" + inputFiles.length));
                HashSet<String> metadataFiles = new HashSet<String>();
                HashSet<String> classNames = new HashSet<String>();
                for (int i = 0; i < inputFiles.length; ++i) {
                    if (inputFiles[i].endsWith(".class")) {
                        URL classFileURL = null;
                        try {
                            classFileURL = new URL("file:" + inputFiles[i]);
                        }
                        catch (Exception e) {
                            msg = LOCALISER.msg("SchemaTool.InputFiles.ClassFileError", inputFiles[i]);
                            JPOXLogger.SCHEMATOOL.error(msg);
                            throw new JPOXUserException(msg);
                        }
                        String className = ClassUtils.getClassNameForFileURL(classFileURL);
                        classNames.add(className);
                        continue;
                    }
                    metadataFiles.add(inputFiles[i]);
                }
                filemds = metaDataMgr.initialise(metadataFiles.toArray(new String[metadataFiles.size()]), classNames.toArray(new String[classNames.size()]), clr);
                JPOXLogger.SCHEMATOOL.debug(LOCALISER.msg("SchemaTool.InputFiles.ReadEnd", "" + inputFiles.length));
            }
            catch (Exception e) {
                msg = LOCALISER.msg("SchemaTool.InputFiles.ReadError", e.getMessage());
                JPOXLogger.SCHEMATOOL.error(msg, e);
                System.out.println(msg);
                if (e instanceof JPOXException) {
                    throw (JPOXException)e;
                }
                throw new JPOXUserException(msg, e);
            }
        }
        return filemds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSchema(PersistenceManagerFactory pmf, List classNames, String ddlFilename, boolean completeDdl) throws Exception {
        if (classNames != null && classNames.size() > 0) {
            ObjectManager om = ((AbstractPersistenceManager)pmf.getPersistenceManager()).getObjectManager();
            StoreManager storeMgr = om.getStoreManager();
            OutputStreamWriter ddlFileWriter = null;
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename(ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- JPOX SchemaTool (version " + ObjectManagerFactoryImpl.getVersionNumber() + ")" + " ran at " + fmt.format(new Date()) + "\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                if (completeDdl) {
                    ddlFileWriter.write("-- Complete schema required for the following classes:-\n");
                } else {
                    ddlFileWriter.write("-- Schema diff for " + pmf.getConnectionURL() + " and the following classes:-\n");
                }
                Iterator classNameIter = classNames.iterator();
                while (classNameIter.hasNext()) {
                    ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                }
                ddlFileWriter.write("--\n");
            }
            try {
                String[] classNameArray = classNames.toArray(new String[classNames.size()]);
                storeMgr.addClasses(classNameArray, om.getClassLoaderResolver(), ddlFileWriter, completeDdl);
            }
            finally {
                if (ddlFileWriter != null) {
                    ddlFileWriter.close();
                }
            }
        } else {
            String msg = LOCALISER.msg("SchemaTool.NoClassesError");
            JPOXLogger.SCHEMATOOL.error(msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
    }

    public static void deleteSchema(PersistenceManagerFactory pmf, List classNames) throws Exception {
        if (classNames == null || classNames.size() <= 0) {
            String msg = LOCALISER.msg("SchemaTool.NoClassesError");
            JPOXLogger.SCHEMATOOL.info(msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
        ObjectManager om = ((AbstractPersistenceManager)pmf.getPersistenceManager()).getObjectManager();
        StoreManager storeMgr = om.getStoreManager();
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        storeMgr.addClasses(classNameArray, om.getClassLoaderResolver());
        storeMgr.removeAllClasses(om.getClassLoaderResolver());
    }

    public static void validateSchema(PersistenceManagerFactory pmf, List classNames) throws Exception {
        if (classNames == null || classNames.size() <= 0) {
            String msg = LOCALISER.msg("SchemaTool.NoClassesError");
            JPOXLogger.SCHEMATOOL.error(msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
        ObjectManager om = ((AbstractPersistenceManager)pmf.getPersistenceManager()).getObjectManager();
        StoreManager storeMgr = om.getStoreManager();
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        storeMgr.addClasses(classNameArray, om.getClassLoaderResolver());
    }

    public void setCommandLineArgs(String[] args) {
        this.cmd.parse(args);
        this.defaultArgs = this.cmd.getDefaultArgs();
        if (this.cmd.hasOption("api")) {
            this.api = this.cmd.getOptionArg("api");
            this.omfContext.setApi(this.api);
        }
        Map map = this.omfContext.getApiAdapter().getDefaultFactoryProperties();
        if (this.cmd.hasOption("create")) {
            map.put(SCHEMATOOL_OPTION_MODE, "create");
        } else if (this.cmd.hasOption("delete")) {
            map.put(SCHEMATOOL_OPTION_MODE, "delete");
        } else if (this.cmd.hasOption("validate")) {
            map.put(SCHEMATOOL_OPTION_MODE, "validate");
        } else if (this.cmd.hasOption("dbinfo")) {
            map.put(SCHEMATOOL_OPTION_MODE, "dbinfo");
        } else if (this.cmd.hasOption("schemainfo")) {
            map.put(SCHEMATOOL_OPTION_MODE, "schemainfo");
        }
        if (this.cmd.hasOption("help")) {
            map.put(SCHEMATOOL_OPTION_HELP, Boolean.TRUE.toString());
        }
        if (this.cmd.hasOption("ddlFile")) {
            map.put(SCHEMATOOL_OPTION_DDLFILE, this.cmd.getOptionArg("ddlFile"));
        }
        if (this.cmd.hasOption("dumpDdl")) {
            map.put(SCHEMATOOL_OPTION_DUMPDDL, this.cmd.getOptionArg("dumpDdl"));
        }
        if (this.cmd.hasOption("completeDdl")) {
            map.put(SCHEMATOOL_OPTION_COMPLETEDDL, Boolean.TRUE.toString());
        }
        if (this.cmd.hasOption("persistenceUnit")) {
            map.put("javax.jdo.option.PersistenceUnitName", this.cmd.getOptionArg("persistenceUnit"));
        }
        if (this.cmd.hasOption("props")) {
            this.propsFileName = this.cmd.getOptionArg("props");
            map.put("org.jpox.propertiesFile", this.cmd.getOptionArg("props"));
        }
        if (this.cmd.hasOption("v")) {
            map.put(SCHEMATOOL_OPTION_VERBOSE, Boolean.TRUE.toString());
        }
        this.setOptions(map);
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public void setCompleteDdl(boolean completeDdl) {
        this.completeDdl = true;
    }

    public boolean getCompleteDdl() {
        return this.completeDdl;
    }

    public String getModeName() {
        return this.modeName;
    }

    public void setModeName(String mode) {
        this.modeName = mode;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String[] getDefaultArgs() {
        return this.defaultArgs;
    }

    public String getDdlFile() {
        return this.ddlFile;
    }

    public void setDdlFile(String file) {
        this.ddlFile = file;
    }

    public String getPropsFileName() {
        return this.propsFileName;
    }

    protected Map initPropertySetters() {
        Map map = super.initPropertySetters();
        map.put(SCHEMATOOL_OPTION_DDLFILE, new PersistenceConfiguration.StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                ((SchemaTool)configuration).setDdlFile(s);
            }
        });
        map.put(SCHEMATOOL_OPTION_DUMPDDL, new PersistenceConfiguration.StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                ((SchemaTool)configuration).setDdlFile(s);
            }
        });
        map.put(SCHEMATOOL_OPTION_HELP, new PersistenceConfiguration.StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                ((SchemaTool)configuration).setHelp(Boolean.valueOf(s));
            }
        });
        map.put(SCHEMATOOL_OPTION_COMPLETEDDL, new PersistenceConfiguration.StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                ((SchemaTool)configuration).setCompleteDdl(Boolean.valueOf(s));
            }
        });
        map.put(SCHEMATOOL_OPTION_MODE, new PersistenceConfiguration.StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                ((SchemaTool)configuration).setModeName(s);
            }
        });
        map.put(SCHEMATOOL_OPTION_VERBOSE, new PersistenceConfiguration.StringPropertySetter(){

            public void set(PersistenceConfiguration configuration, String s) {
                ((SchemaTool)configuration).setVerbose(Boolean.valueOf(s));
            }
        });
        return map;
    }
}

