/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.jpox.ObjectManager;
import org.jpox.PersistenceConfiguration;
import org.jpox.TransactionEventListener;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.exceptions.TransactionActiveOnBeginException;
import org.jpox.exceptions.TransactionNotActiveException;
import org.jpox.management.runtime.TransactionRuntime;
import org.jpox.transaction.JPOXTransactionException;
import org.jpox.transaction.Transaction;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class TransactionImpl
implements org.jpox.Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    ObjectManager om;
    Transaction tx;
    boolean active = false;
    private TransactionRuntime txRuntime;
    boolean committing;
    Synchronization sync;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    Set listener = new HashSet();
    Map options = new HashMap();

    TransactionImpl(ObjectManager om) {
        this.om = om;
        this.txRuntime = new TransactionRuntime();
        PersistenceConfiguration config = om.getOMFContext().getPersistenceConfiguration();
        this.optimistic = config.getOptimistic();
        this.retainValues = config.getRetainValues();
        this.restoreValues = config.getRestoreValues();
        this.nontransactionalRead = config.getNontransactionalRead();
        this.nontransactionalWrite = config.getNontransactionalWrite();
        this.setOption("transaction.isolation", config.getTransactionIsolation());
        this.setOption("transaction.serializeReadObjects", config.getUseUpdateLock());
    }

    public void begin() {
        this.om.getOMFContext().getTransactionManager().begin(this.om);
        this.tx = this.om.getOMFContext().getTransactionManager().getTransaction(this.om);
        this.internalBegin();
    }

    protected void internalBegin() {
        if (this.active) {
            throw new TransactionActiveOnBeginException(this);
        }
        this.active = true;
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.StartedForObjectManager", this.om, "" + this.optimistic));
        }
        TransactionEventListener[] tel = this.listener.toArray(new TransactionEventListener[this.listener.size()]);
        for (int i = 0; i < tel.length; ++i) {
            tel[i].transactionStarted();
        }
        this.om.postBegin();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        if (this.om.getOMFContext().getConnectionManager().hasLockedConnection(this.om)) {
            throw new JPOXUserException(LOCALISER.msg("Connection.DataStoreConnectionLocked"));
        }
        if (this.rollbackOnly) {
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.CommitWithRollbackOnly"));
            }
            throw new JPOXDataStoreException(LOCALISER.msg("Transaction.CommitWithRollbackOnly")).setFatal();
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        ArrayList<JPOXException> errors = new ArrayList<JPOXException>();
        try {
            this.internalPreCommit();
            this.om.getOMFContext().getTransactionManager().commit(this.om);
            success = true;
        }
        catch (JPOXException e) {
            errors.add(e);
        }
        finally {
            try {
                if (!success) {
                    this.rollback();
                } else {
                    this.internalPostCommit();
                }
            }
            catch (JPOXException e) {
                errors.add(e);
            }
            this.tx = null;
        }
        if (errors.size() > 0) {
            throw new JPOXTransactionException(LOCALISER.msg("Transaction.FailedToCommit"), errors.toArray(new Throwable[errors.size()]));
        }
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.Commit.ExecutionTime", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreCommit() {
        this.committing = true;
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.CommitForObjectManager", this.om));
        }
        if (this.sync != null) {
            this.sync.beforeCompletion();
        }
        this.om.preCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rollback() {
        long startTime;
        block16: {
            if (!this.active) {
                throw new TransactionNotActiveException();
            }
            if (this.om.getOMFContext().getConnectionManager().hasLockedConnection(this.om)) {
                throw new JPOXUserException(LOCALISER.msg("Connection.DataStoreConnectionLocked"));
            }
            startTime = System.currentTimeMillis();
            try {
                this.committing = true;
                this.internalRollback();
                Object var4_2 = null;
                this.active = false;
                this.txRuntime.incrementTransactionRolledBackTotalCount();
                TransactionEventListener[] tel = this.listener.toArray(new TransactionEventListener[this.listener.size()]);
                for (int i = 0; i < tel.length; ++i) {
                    tel[i].transactionRolledBack();
                }
                break block16;
                finally {
                    this.committing = false;
                    this.rollbackOnly = false;
                    this.tx = null;
                    if (this.sync != null) {
                        this.sync.afterCompletion(4);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    try {
                        this.active = false;
                        this.txRuntime.incrementTransactionRolledBackTotalCount();
                        tel = this.listener.toArray(new TransactionEventListener[this.listener.size()]);
                        for (int i = 0; i < tel.length; ++i) {
                            tel[i].transactionRolledBack();
                        }
                    }
                    finally {
                        this.committing = false;
                        this.rollbackOnly = false;
                        this.tx = null;
                        if (this.sync != null) {
                            this.sync.afterCompletion(4);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new JPOXDataStoreException(LOCALISER.msg("Transaction.FailedToRollback"), e);
            }
        }
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.Rollback.ExecutionTime", System.currentTimeMillis() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRollback() {
        try {
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.RollbackForObjectManager", this.om));
            }
            this.om.preRollback();
        }
        finally {
            this.om.getOMFContext().getTransactionManager().rollback(this.om);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalPostCommit() {
        try {
            this.active = false;
            this.txRuntime.incrementTransactionCommittedTotalCount();
            TransactionEventListener[] tel = this.listener.toArray(new TransactionEventListener[this.listener.size()]);
            for (int i = 0; i < tel.length; ++i) {
                tel[i].transactionCommitted();
            }
        }
        finally {
            try {
                this.om.postCommit();
            }
            finally {
                this.committing = false;
                if (this.sync != null) {
                    this.sync.afterCompletion(3);
                }
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCommitting() {
        return this.committing;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public Synchronization getSynchronization() {
        return this.sync;
    }

    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead = nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite = nontransactionalWrite;
    }

    public synchronized void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    public synchronized void setRestoreValues(boolean restoreValues) {
        this.restoreValues = restoreValues;
    }

    public synchronized void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    public synchronized void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listener.add(listener);
    }

    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listener.remove(listener);
    }

    public Map getOptions() {
        return this.options;
    }

    public void setOption(String option, int value) {
        this.options.put(option, new Integer(value));
    }

    public void setOption(String option, boolean value) {
        this.options.put(option, new Boolean(value));
    }

    public void setOption(String option, String value) {
        this.options.put(option, value);
    }
}

