/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.PluginManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class TypeManager {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    Map types = new HashMap();
    private static String[] DEFAULT_PERSISTENT_TYPE;
    private static String[] DEFAULT_FETCH_GROUP_TRUE;
    private static String[] DEFAULT_EMBEDDED_TYPE;
    static /* synthetic */ Class class$org$jpox$sco$SCOList;
    static /* synthetic */ Class class$org$jpox$sco$SCOMap;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public TypeManager(PluginManager mgr, ClassLoaderResolver clr) {
        this.loadUserTypes(mgr, clr);
    }

    public void addType(PluginManager mgr, String pluginId, String className, String mappingClassName, String scoMutableWrapperType, boolean dfg, String javaVersion, boolean dftPersistent, boolean javaRestricted, boolean dftEmbedded, ClassLoaderResolver clr) {
        if (className == null) {
            return;
        }
        if (JavaUtils.isGreaterEqualsThan(javaVersion) && !javaRestricted || JavaUtils.isEqualsThan(javaVersion) && javaRestricted) {
            Class wrapperType = null;
            Class mappingType = null;
            if (mappingClassName != null && !StringUtils.isWhitespace(mappingClassName)) {
                try {
                    mappingType = mgr.loadClass(pluginId, mappingClassName);
                }
                catch (JPOXException jpe) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("Types.User.MappingNotFound", mappingClassName));
                    return;
                }
            }
            if (scoMutableWrapperType != null && !StringUtils.isWhitespace(scoMutableWrapperType)) {
                try {
                    wrapperType = mgr.loadClass(pluginId, scoMutableWrapperType);
                }
                catch (JPOXException jpe) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("Types.User.SCOWrapperNotFound", scoMutableWrapperType));
                    return;
                }
            }
            JPOXType type = new JPOXType(className, mappingType, wrapperType, dfg, javaVersion, dftPersistent, javaRestricted, dftEmbedded);
            if (dftPersistent) {
                this.addDefaultPersistent(className);
            }
            if (dfg) {
                this.addDefaultFetchGroup(className);
            }
            if (dftEmbedded) {
                this.addDefaultEmbedded(className);
            }
            this.types.put(className, type);
            if (JPOXLogger.GENERAL.isDebugEnabled()) {
                JPOXLogger.GENERAL.debug(LOCALISER.msg("Type.AddType", className, "" + dftPersistent, "" + dfg, "" + dftEmbedded));
            }
        }
    }

    public boolean isReferenceType(Class cls) {
        if (cls == null) {
            return false;
        }
        return cls.isInterface() || cls.getName().equals("java.lang.Object");
    }

    public boolean isSupportedType(String className) {
        if (className == null) {
            return false;
        }
        JPOXType type = this.getType(className);
        if (type == null) {
            return false;
        }
        return type.getSCOMappingType() != null;
    }

    public Set getSupportedTypes() {
        return new HashSet(this.types.keySet());
    }

    public boolean isSecondClassMutableType(String class_name) {
        return this.getSecondClassWrapper(class_name) != null;
    }

    public boolean isSCOList(Class c) {
        if (c == null) {
            return false;
        }
        if (c.isInterface() && !this.isSupportedType(c.getName())) {
            return false;
        }
        JPOXType type = this.getType(c.getName());
        return type != null ? (class$org$jpox$sco$SCOList == null ? (class$org$jpox$sco$SCOList = TypeManager.class$("org.jpox.sco.SCOList")) : class$org$jpox$sco$SCOList).isAssignableFrom(type.getSCOMutableWrapperType()) : false;
    }

    public boolean isSCOMap(Class c) {
        if (c == null) {
            return false;
        }
        if (c.isInterface() && !this.isSupportedType(c.getName())) {
            return false;
        }
        JPOXType type = this.getType(c.getName());
        return type != null ? (class$org$jpox$sco$SCOMap == null ? (class$org$jpox$sco$SCOMap = TypeManager.class$("org.jpox.sco.SCOMap")) : class$org$jpox$sco$SCOMap).isAssignableFrom(type.getSCOMutableWrapperType()) : false;
    }

    public Class getMappingType(String className) {
        if (className == null) {
            return null;
        }
        JPOXType type = this.getType(className);
        return type == null ? null : type.getSCOMappingType();
    }

    public Class getSecondClassWrapper(String className) {
        if (className == null) {
            return null;
        }
        JPOXType type = this.getType(className);
        return type == null ? null : type.getSCOMutableWrapperType();
    }

    public boolean isSecondClassWrapper(String className) {
        if (className == null) {
            return false;
        }
        Iterator iter = this.types.values().iterator();
        while (iter.hasNext()) {
            JPOXType type = (JPOXType)iter.next();
            if (type.getSCOMutableWrapperType() == null || !type.getSCOMutableWrapperType().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    protected JPOXType getType(String className) {
        if (className == null) {
            return null;
        }
        return (JPOXType)this.types.get(className);
    }

    private synchronized void addDefaultPersistent(String className) {
        if (DEFAULT_PERSISTENT_TYPE == null) {
            DEFAULT_PERSISTENT_TYPE = new String[1];
            TypeManager.DEFAULT_PERSISTENT_TYPE[0] = className;
        } else {
            Object[] temp = new String[DEFAULT_PERSISTENT_TYPE.length + 1];
            System.arraycopy(DEFAULT_PERSISTENT_TYPE, 0, temp, 0, DEFAULT_PERSISTENT_TYPE.length);
            temp[temp.length - 1] = className;
            Arrays.sort(temp);
            DEFAULT_PERSISTENT_TYPE = temp;
        }
    }

    private synchronized void addDefaultFetchGroup(String className) {
        if (DEFAULT_FETCH_GROUP_TRUE == null) {
            DEFAULT_FETCH_GROUP_TRUE = new String[1];
            TypeManager.DEFAULT_FETCH_GROUP_TRUE[0] = className;
        } else {
            Object[] temp = new String[DEFAULT_FETCH_GROUP_TRUE.length + 1];
            System.arraycopy(DEFAULT_FETCH_GROUP_TRUE, 0, temp, 0, DEFAULT_FETCH_GROUP_TRUE.length);
            temp[temp.length - 1] = className;
            Arrays.sort(temp);
            DEFAULT_FETCH_GROUP_TRUE = temp;
        }
    }

    private synchronized void addDefaultEmbedded(String className) {
        if (DEFAULT_EMBEDDED_TYPE == null) {
            DEFAULT_EMBEDDED_TYPE = new String[1];
            TypeManager.DEFAULT_EMBEDDED_TYPE[0] = className;
        } else {
            Object[] temp = new String[DEFAULT_EMBEDDED_TYPE.length + 1];
            System.arraycopy(DEFAULT_EMBEDDED_TYPE, 0, temp, 0, DEFAULT_EMBEDDED_TYPE.length);
            temp[temp.length - 1] = className;
            Arrays.sort(temp);
            DEFAULT_EMBEDDED_TYPE = temp;
        }
    }

    public final FieldPersistenceModifier getDefaultFieldPersistenceModifier(Class c, int modifier, boolean isPCclass) {
        if (Modifier.isStatic(modifier) || Modifier.isTransient(modifier) || Modifier.isFinal(modifier)) {
            return FieldPersistenceModifier.NONE;
        }
        if (isPCclass) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        if (c == null) {
            throw new JPOXException("class is null");
        }
        if (Arrays.binarySearch(DEFAULT_PERSISTENT_TYPE, c.getName()) >= 0) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        if (c.isArray() && (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = TypeManager.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(c.getComponentType())) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        return FieldPersistenceModifier.NONE;
    }

    public boolean isDefaultFetchGroup(Class c) {
        if (c == null) {
            return false;
        }
        return Arrays.binarySearch(DEFAULT_FETCH_GROUP_TRUE, c.getName()) >= 0;
    }

    public boolean isDefaultEmbeddedType(Class type) {
        if (type == null) {
            return false;
        }
        return Arrays.binarySearch(DEFAULT_EMBEDDED_TYPE, type.getName()) >= 0;
    }

    private void loadUserTypes(PluginManager mgr, ClassLoaderResolver clr) {
        ExtensionPoint exPoint = mgr.getExtensionPoint("org.jpox.store_mapping");
        for (int i = 0; i < exPoint.getExtensions().length; ++i) {
            ConfigurationElement[] elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (int e = 0; e < elms.length; ++e) {
                String javaVersion;
                String javaName = elms[e].getAttribute("java-type").trim();
                String mappingClassName = elms[e].getAttribute("mapping-class");
                String scoWrapperClassName = elms[e].getAttribute("sco-wrapper");
                String defaultFetchGroup = elms[e].getAttribute("default-fetch-group");
                String defaultPersistent = elms[e].getAttribute("default-persistent");
                String defaultEmbedded = elms[e].getAttribute("default-embedded");
                String javaVersionRestrict = elms[e].getAttribute("java-version-restrict");
                boolean dfg = false;
                if (defaultFetchGroup != null && defaultFetchGroup.equalsIgnoreCase("true")) {
                    dfg = Boolean.TRUE;
                }
                boolean dftPersistent = false;
                if (defaultPersistent != null && defaultPersistent.equalsIgnoreCase("true")) {
                    dftPersistent = Boolean.TRUE;
                }
                boolean dftEmbedded = false;
                if (defaultEmbedded != null && defaultEmbedded.equalsIgnoreCase("true")) {
                    dftEmbedded = Boolean.TRUE;
                }
                boolean javaRestricted = false;
                if (javaVersionRestrict != null && javaVersionRestrict.equalsIgnoreCase("true")) {
                    javaRestricted = Boolean.TRUE;
                }
                if ((javaVersion = elms[e].getAttribute("java-version")) == null || javaVersion.length() < 1) {
                    javaVersion = "1.3";
                }
                this.addType(mgr, elms[e].getExtension().getPlugin().getSymbolicName(), javaName, mappingClassName, scoWrapperClassName, dfg, javaVersion, dftPersistent, javaRestricted, dftEmbedded, clr);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class JPOXType {
        final String className;
        final Class scoMappingType;
        final Class scoMutableWrapperType;
        final boolean dfg;
        final String javaVersion;
        final boolean dftPersistent;
        final boolean dftEmbedded;
        final boolean javaRestricted;

        public JPOXType(String className, Class sco_mapping_type, Class sco_wrapper_type, boolean dfg, String javaVersion, boolean dftPersistent, boolean javaRestricted, boolean dftEmbedded) {
            this.className = className;
            this.scoMappingType = sco_mapping_type;
            this.scoMutableWrapperType = sco_wrapper_type;
            this.dfg = dfg;
            this.javaVersion = javaVersion;
            this.dftPersistent = dftPersistent;
            this.javaRestricted = javaRestricted;
            this.dftEmbedded = dftEmbedded;
        }

        public Class getSCOMappingType() {
            return this.scoMappingType;
        }

        public Class getSCOMutableWrapperType() {
            return this.scoMutableWrapperType;
        }

        public String toString() {
            StringBuffer str = new StringBuffer(this.className + " [");
            if (this.scoMappingType != null) {
                str.append(" SCO : mapping=" + this.scoMappingType);
            }
            if (this.scoMutableWrapperType != null) {
                str.append(" SCO : mutable wrapper=" + this.scoMutableWrapperType);
            }
            str.append(" default-fetch-group : " + this.dfg);
            str.append(" java version : " + this.javaVersion + (this.javaRestricted ? " restricted" : ""));
            str.append(" default persisted : " + this.dftPersistent);
            str.append(" default embedded : " + this.dftEmbedded);
            str.append("]");
            return str.toString();
        }
    }
}

