/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXException;
import org.jpox.jdo.JDOClassNameConstants;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InvalidPrimaryKeyException;
import org.jpox.state.LifeCycleState;
import org.jpox.state.jdo.LifeCycleStateFactory;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class JDOAdapter
implements ApiAdapter {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$jdo$identity$LongIdentity;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$jdo$identity$IntIdentity;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$jdo$identity$ShortIdentity;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$javax$jdo$identity$ByteIdentity;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$javax$jdo$identity$CharIdentity;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$javax$jdo$identity$StringIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$ObjectIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$SingleFieldIdentity;
    static /* synthetic */ Class class$java$lang$Class;

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public boolean isPersistent(Object obj) {
        return JDOHelper.isPersistent((Object)obj);
    }

    public boolean isNew(Object obj) {
        return JDOHelper.isNew((Object)obj);
    }

    public boolean isDirty(Object obj) {
        return JDOHelper.isDirty((Object)obj);
    }

    public boolean isDeleted(Object obj) {
        return JDOHelper.isDeleted((Object)obj);
    }

    public boolean isDetached(Object obj) {
        return JDOHelper.isDetached((Object)obj);
    }

    public boolean isTransactional(Object obj) {
        return JDOHelper.isTransactional((Object)obj);
    }

    public boolean isPersistable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof PersistenceCapable;
    }

    public boolean isPersistable(Class cls) {
        if (cls == null) {
            return false;
        }
        return (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = JDOAdapter.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(cls);
    }

    public boolean isDetachable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Detachable;
    }

    public Object getIdForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((PersistenceCapable)obj).jdoGetObjectId();
    }

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields) {
        if (ClassUtils.isInnerClass(pkClass.getName()) && !Modifier.isStatic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.InnerNotStaticError", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (!Modifier.isPublic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.NotPublicError", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = JDOAdapter.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(pkClass)) {
            throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.NotSerializableError", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (this.isSingleFieldIdentityClass(pkClass.getName())) {
            if (noOfPkFields != 1) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.SingleFieldIdMultipleFieldsError", (Object)cmd.getFullClassName());
            }
        } else {
            Constructor constructor;
            try {
                constructor = pkClass.getConstructor(new Class[0]);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.DefaultConstructorError", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException ex) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.DefaultConstructorError", (Object)cmd.getFullClassName(), pkClass.getName());
            }
            try {
                constructor = pkClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = JDOAdapter.class$("java.lang.String")) : class$java$lang$String);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.StringConstructorError", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                Method method = pkClass.getMethod("toString", new Class[0]);
                if (method == null || !Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = JDOAdapter.class$("java.lang.Object")) : class$java$lang$Object)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.ToStringError", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            int noPkFields = this.processPrimaryKeyClass(pkClass, cmd, clr);
            Collection superclasses = ClassUtils.getSuperclasses(pkClass);
            if (superclasses != null && superclasses.size() > 0) {
                Iterator superclassIter = superclasses.iterator();
                while (superclassIter.hasNext()) {
                    Class supercls = (Class)superclassIter.next();
                    noPkFields += this.processPrimaryKeyClass(supercls, cmd, clr);
                }
            }
            if (noOfPkFields != noPkFields && cmd.getIdentityType() == IdentityType.APPLICATION) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.IncorrectNumberOfPKFieldsError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)("" + noOfPkFields), "" + noPkFields);
            }
        }
        return true;
    }

    private int processPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        int noOfPkFields = 0;
        Field[] fieldsInPkClass = pkClass.getDeclaredFields();
        for (int i = 0; i < fieldsInPkClass.length; ++i) {
            if (Modifier.isStatic(fieldsInPkClass[i].getModifiers())) continue;
            if (!fieldsInPkClass[i].getType().isPrimitive() && !(class$java$io$Serializable == null ? JDOAdapter.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(fieldsInPkClass[i].getType())) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldNotSerializableError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            if (!Modifier.isPublic(fieldsInPkClass[i].getModifiers())) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldNotPublicError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            AbstractMemberMetaData fieldInPcClass = cmd.getMetaDataForMember(fieldsInPkClass[i].getName());
            boolean found_field = false;
            if (fieldInPcClass == null) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldNotFound", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            if (fieldInPcClass.getTypeName().equals(fieldsInPkClass[i].getType().getName())) {
                found_field = true;
            }
            if (!found_field) {
                String fieldTypePkClass = fieldsInPkClass[i].getType().getName();
                AbstractClassMetaData ref_cmd = cmd.getMetaDataManager().getMetaDataForClassInternal(fieldInPcClass.getType(), clr);
                if (ref_cmd == null) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldPersistenceCapableError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName());
                }
                if (ref_cmd.getObjectidClass() == null && this.isSingleFieldIdentityClass(fieldTypePkClass)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldShouldReferSingleFieldIdentityObjectIdClass", cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, ref_cmd.getFullClassName());
                }
                if (!fieldTypePkClass.equals(ref_cmd.getObjectidClass())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldShouldReferObjectIdClass", cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, ref_cmd.getObjectidClass());
                }
                found_field = true;
            }
            if (!found_field) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldPersistenceCapableError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName());
            }
            ++noOfPkFields;
        }
        return noOfPkFields;
    }

    public boolean isSingleFieldIdentity(Object id) {
        return id instanceof SingleFieldIdentity;
    }

    public boolean isSingleFieldIdentityClass(String className) {
        if (className == null || className.length() < 1) {
            return false;
        }
        return className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_BYTE_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_CHAR_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_INT_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_LONG_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_OBJECT_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_SHORT_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_STRING_IDENTITY);
    }

    public String getSingleFieldIdentityClassNameForLong() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_LONG_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForInt() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_INT_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForShort() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_SHORT_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForByte() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_BYTE_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForChar() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_CHAR_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForString() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_STRING_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForObject() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_OBJECT_IDENTITY;
    }

    public Class getTargetClassForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getTargetClass();
        }
        return null;
    }

    public Object getTargetKeyForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getKeyAsObject();
        }
        return null;
    }

    public Class getKeyTypeForSingleFieldIdentityType(Class idType) {
        if (idType == null) {
            return null;
        }
        if (!this.isSingleFieldIdentityClass(idType.getName())) {
            return null;
        }
        if ((class$javax$jdo$identity$LongIdentity == null ? (class$javax$jdo$identity$LongIdentity = JDOAdapter.class$("javax.jdo.identity.LongIdentity")) : class$javax$jdo$identity$LongIdentity).isAssignableFrom(idType)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = JDOAdapter.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if ((class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = JDOAdapter.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity).isAssignableFrom(idType)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = JDOAdapter.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if ((class$javax$jdo$identity$ShortIdentity == null ? (class$javax$jdo$identity$ShortIdentity = JDOAdapter.class$("javax.jdo.identity.ShortIdentity")) : class$javax$jdo$identity$ShortIdentity).isAssignableFrom(idType)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = JDOAdapter.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if ((class$javax$jdo$identity$ByteIdentity == null ? (class$javax$jdo$identity$ByteIdentity = JDOAdapter.class$("javax.jdo.identity.ByteIdentity")) : class$javax$jdo$identity$ByteIdentity).isAssignableFrom(idType)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = JDOAdapter.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if ((class$javax$jdo$identity$CharIdentity == null ? (class$javax$jdo$identity$CharIdentity = JDOAdapter.class$("javax.jdo.identity.CharIdentity")) : class$javax$jdo$identity$CharIdentity).isAssignableFrom(idType)) {
            return class$java$lang$Character == null ? (class$java$lang$Character = JDOAdapter.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if ((class$javax$jdo$identity$StringIdentity == null ? (class$javax$jdo$identity$StringIdentity = JDOAdapter.class$("javax.jdo.identity.StringIdentity")) : class$javax$jdo$identity$StringIdentity).isAssignableFrom(idType)) {
            return class$java$lang$String == null ? (class$java$lang$String = JDOAdapter.class$("java.lang.String")) : class$java$lang$String;
        }
        if ((class$javax$jdo$identity$ObjectIdentity == null ? (class$javax$jdo$identity$ObjectIdentity = JDOAdapter.class$("javax.jdo.identity.ObjectIdentity")) : class$javax$jdo$identity$ObjectIdentity).isAssignableFrom(idType)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JDOAdapter.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return null;
    }

    public Object getNewSingleFieldIdentity(Class idType, Class pcType, Object value) {
        if (idType == null) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.IdTypeNull", pcType)).setFatal();
        }
        if (pcType == null) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.PcTypeNull", idType)).setFatal();
        }
        if (value == null) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueNull", idType, pcType)).setFatal();
        }
        if (!(class$javax$jdo$identity$SingleFieldIdentity == null ? (class$javax$jdo$identity$SingleFieldIdentity = JDOAdapter.class$("javax.jdo.identity.SingleFieldIdentity")) : class$javax$jdo$identity$SingleFieldIdentity).isAssignableFrom(idType)) {
            throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.IdTypeInvalid", idType.getName(), pcType.getName())).setFatal();
        }
        SingleFieldIdentity id = null;
        Class keyType = null;
        if (idType == (class$javax$jdo$identity$LongIdentity == null ? (class$javax$jdo$identity$LongIdentity = JDOAdapter.class$("javax.jdo.identity.LongIdentity")) : class$javax$jdo$identity$LongIdentity)) {
            Class clazz = keyType = class$java$lang$Long == null ? (class$java$lang$Long = JDOAdapter.class$("java.lang.Long")) : class$java$lang$Long;
            if (!(value instanceof Long)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Long")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = JDOAdapter.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity)) {
            Class clazz = keyType = class$java$lang$Integer == null ? (class$java$lang$Integer = JDOAdapter.class$("java.lang.Integer")) : class$java$lang$Integer;
            if (!(value instanceof Integer)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Integer")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$StringIdentity == null ? (class$javax$jdo$identity$StringIdentity = JDOAdapter.class$("javax.jdo.identity.StringIdentity")) : class$javax$jdo$identity$StringIdentity)) {
            Class clazz = keyType = class$java$lang$String == null ? (class$java$lang$String = JDOAdapter.class$("java.lang.String")) : class$java$lang$String;
            if (!(value instanceof String)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "String")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$ByteIdentity == null ? (class$javax$jdo$identity$ByteIdentity = JDOAdapter.class$("javax.jdo.identity.ByteIdentity")) : class$javax$jdo$identity$ByteIdentity)) {
            Class clazz = keyType = class$java$lang$Byte == null ? (class$java$lang$Byte = JDOAdapter.class$("java.lang.Byte")) : class$java$lang$Byte;
            if (!(value instanceof Byte)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Byte")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$ShortIdentity == null ? (class$javax$jdo$identity$ShortIdentity = JDOAdapter.class$("javax.jdo.identity.ShortIdentity")) : class$javax$jdo$identity$ShortIdentity)) {
            Class clazz = keyType = class$java$lang$Short == null ? (class$java$lang$Short = JDOAdapter.class$("java.lang.Short")) : class$java$lang$Short;
            if (!(value instanceof Short)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Short")).setFatal();
            }
        } else if (idType == (class$javax$jdo$identity$CharIdentity == null ? (class$javax$jdo$identity$CharIdentity = JDOAdapter.class$("javax.jdo.identity.CharIdentity")) : class$javax$jdo$identity$CharIdentity)) {
            Class clazz = keyType = class$java$lang$Character == null ? (class$java$lang$Character = JDOAdapter.class$("java.lang.Character")) : class$java$lang$Character;
            if (!(value instanceof Character)) {
                throw new JPOXException(LOCALISER.msg("SingleFieldIdentity.ValueTypeInvalid", idType.getName(), pcType.getName(), value.getClass().getName(), "Character")).setFatal();
            }
        } else {
            keyType = class$java$lang$Object == null ? (class$java$lang$Object = JDOAdapter.class$("java.lang.Object")) : class$java$lang$Object;
        }
        try {
            Class[] ctrArgs = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = JDOAdapter.class$("java.lang.Class")) : class$java$lang$Class, keyType};
            Constructor ctr = idType.getConstructor(ctrArgs);
            Object[] args = new Object[]{pcType, value};
            id = (SingleFieldIdentity)ctr.newInstance(args);
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error("Error encountered while creating SingleFieldIdentity instance of type \"" + idType.getName() + "\"");
            JPOXLogger.PERSISTENCE.error(e);
            return null;
        }
        return id;
    }

    public Object getNewApplicationIdentityObjectId(Object pc, AbstractClassMetaData cmd) {
        if (pc == null || cmd == null) {
            return null;
        }
        Object id = ((PersistenceCapable)pc).jdoNewObjectIdInstance();
        if (!cmd.usesSingleFieldIdentityClass()) {
            ((PersistenceCapable)pc).jdoCopyKeyFieldsToObjectId(id);
        }
        return id;
    }

    public boolean getDefaultCascadePersistForField() {
        return true;
    }

    public boolean getDefaultCascadeUpdateForField() {
        return true;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public Map getDefaultFactoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.jpox.identifierFactory", "jpox");
        props.put("org.jpox.query.allowAllSQLStatements", "false");
        props.put("javax.jdo.option.NontransactionalRead", "false");
        props.put("javax.jdo.option.DetachAllOnCommit", "false");
        props.put("org.jpox.persistenceByReachabilityAtCommit", "true");
        props.put("org.jpox.rdbms.stringDefaultLength", "256");
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

