/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jpox.identity.SingleFieldIdentity;

public class ByteIdentity
extends SingleFieldIdentity {
    private byte key;

    public ByteIdentity(Class pcClass, byte key) {
        super(pcClass);
        this.key = key;
        this.hashCode = super.hashClassName() ^ this.key;
    }

    public ByteIdentity(Class pcClass, Byte key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = super.hashClassName() ^ this.key;
    }

    public ByteIdentity(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Byte.parseByte(str);
        this.hashCode = super.hashClassName() ^ this.key;
    }

    public ByteIdentity() {
    }

    public byte getKey() {
        return this.key;
    }

    public String toString() {
        return Byte.toString(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ByteIdentity other = (ByteIdentity)obj;
        return this.key == other.key;
    }

    protected Object createKeyAsObject() {
        return new Byte(this.key);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readByte();
    }
}

