/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jpox.identity.SingleFieldIdentity;

public class ShortIdentity
extends SingleFieldIdentity {
    private short key;

    public ShortIdentity(Class pcClass, short key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public ShortIdentity(Class pcClass, Short key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public ShortIdentity(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Short.parseShort(str);
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public ShortIdentity() {
    }

    public short getKey() {
        return this.key;
    }

    public String toString() {
        return Short.toString(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ShortIdentity other = (ShortIdentity)obj;
        return this.key == other.key;
    }

    protected Object createKeyAsObject() {
        return new Short(this.key);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readShort();
    }
}

