/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.jdo;

import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.transaction.Synchronization;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.jdo.JPOXJDOHelper;
import org.jpox.jdo.exceptions.TransactionActiveException;
import org.jpox.jdo.exceptions.TransactionCommitingException;

public class JDOTransaction
implements javax.jdo.Transaction {
    Transaction tx;
    PersistenceManager pm;

    public JDOTransaction(PersistenceManager pm, Transaction tx) {
        this.tx = tx;
        this.pm = pm;
    }

    public boolean isActive() {
        return this.tx.isActive();
    }

    public void begin() {
        this.tx.begin();
    }

    public void commit() {
        try {
            this.tx.commit();
        }
        catch (JPOXException jpe) {
            if (jpe.getNestedExceptions() != null) {
                JPOXException ex = (JPOXException)jpe.getNestedExceptions()[0];
                if (ex instanceof JPOXOptimisticException) {
                    Throwable[] nested = ex.getNestedExceptions();
                    JDOOptimisticVerificationException[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                    for (int i = 0; i < nested.length; ++i) {
                        jdoNested[i] = (JDOOptimisticVerificationException)JPOXJDOHelper.getJDOExceptionForJPOXException((JPOXException)nested[i]);
                    }
                    throw new JDOOptimisticVerificationException(jpe.getMessage(), (Throwable[])jdoNested);
                }
                throw JPOXJDOHelper.getJDOExceptionForJPOXException(ex);
            }
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public void rollback() {
        try {
            this.tx.rollback();
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public boolean getNontransactionalRead() {
        return this.tx.getNontransactionalRead();
    }

    public boolean getNontransactionalWrite() {
        return this.tx.getNontransactionalWrite();
    }

    public boolean getOptimistic() {
        return this.tx.getOptimistic();
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public boolean getRestoreValues() {
        return this.tx.getRestoreValues();
    }

    public boolean getRetainValues() {
        return this.tx.getRetainValues();
    }

    public boolean getRollbackOnly() {
        return this.tx.getRollbackOnly();
    }

    public Synchronization getSynchronization() {
        return this.tx.getSynchronization();
    }

    public void setNontransactionalRead(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalRead(flag);
    }

    public void setNontransactionalWrite(boolean flag) {
        this.assertNotCommitting();
        try {
            this.tx.setNontransactionalWrite(flag);
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public void setOptimistic(boolean opt) {
        this.assertNotInUse();
        this.assertNotCommitting();
        this.tx.setOptimistic(opt);
    }

    public void setRestoreValues(boolean restore) {
        this.assertNotInUse();
        this.assertNotCommitting();
        this.tx.setRestoreValues(restore);
    }

    public void setRetainValues(boolean retain) {
        this.assertNotCommitting();
        this.tx.setRetainValues(retain);
    }

    public void setRollbackOnly() {
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        }
    }

    public void setSynchronization(Synchronization synch) {
        this.tx.setSynchronization(synch);
    }

    protected void assertNotCommitting() {
        if (this.tx.isCommitting()) {
            throw new TransactionCommitingException(this);
        }
    }

    protected void assertNotInUse() {
        if (this.tx.isActive()) {
            throw new TransactionActiveException(this);
        }
    }

    public void setOption(String option, int value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, boolean value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, String value) {
        this.tx.setOption(option, value);
    }
}

