/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.jdo;

import java.util.Collection;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.AbstractPersistenceManager;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.ClassNotPersistableException;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.exceptions.JPOXUnsupportedOptionException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.jdo.exceptions.ClassNotPersistenceCapableException;
import org.jpox.jdo.exceptions.NoPersistenceInformationException;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.state.StateManagerFactory;
import org.jpox.util.Localiser;

public class JPOXJDOHelper
extends JDOHelper {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");

    public static ClassMetaData getMetaDataForClass(PersistenceManagerFactory pmf, Class cls) {
        if (pmf == null || cls == null) {
            return null;
        }
        if (!(pmf instanceof AbstractPersistenceManagerFactory)) {
            return null;
        }
        AbstractPersistenceManagerFactory jpoxPMF = (AbstractPersistenceManagerFactory)pmf;
        MetaDataManager mdmgr = jpoxPMF.getOMFContext().getMetaDataManager();
        return (ClassMetaData)mdmgr.getMetaDataForClass(cls, jpoxPMF.getOMFContext().getClassLoaderResolver(null));
    }

    public static String[] getClassesWithMetaData(PersistenceManagerFactory pmf) {
        if (pmf == null || !(pmf instanceof AbstractPersistenceManagerFactory)) {
            return null;
        }
        AbstractPersistenceManagerFactory jpoxPMF = (AbstractPersistenceManagerFactory)pmf;
        Collection classes = jpoxPMF.getOMFContext().getMetaDataManager().getClassesWithMetaData();
        return classes.toArray(new String[classes.size()]);
    }

    public static String getObjectStateAsString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (JPOXJDOHelper.isDetached((Object)obj) && JPOXJDOHelper.isDirty((Object)obj)) {
            return "detached-dirty";
        }
        if (JPOXJDOHelper.isDetached((Object)obj) && !JPOXJDOHelper.isDirty((Object)obj)) {
            return "detached-clean";
        }
        if (JPOXJDOHelper.isPersistent((Object)obj) && JPOXJDOHelper.isDirty((Object)obj) && !JPOXJDOHelper.isNew((Object)obj) && JPOXJDOHelper.isTransactional((Object)obj) && !JPOXJDOHelper.isDeleted((Object)obj)) {
            return "persistent-dirty";
        }
        if (JPOXJDOHelper.isPersistent((Object)obj) && !JPOXJDOHelper.isNew((Object)obj) && !JPOXJDOHelper.isDirty((Object)obj) && JPOXJDOHelper.isTransactional((Object)obj) && !JPOXJDOHelper.isDeleted((Object)obj)) {
            return "persistent-clean";
        }
        if (JPOXJDOHelper.isPersistent((Object)obj) && JPOXJDOHelper.isNew((Object)obj) && JPOXJDOHelper.isDirty((Object)obj) && JPOXJDOHelper.isTransactional((Object)obj) && !JPOXJDOHelper.isDeleted((Object)obj)) {
            return "persistent-new";
        }
        if (JPOXJDOHelper.isPersistent((Object)obj) && JPOXJDOHelper.isNew((Object)obj) && JPOXJDOHelper.isDirty((Object)obj) && JPOXJDOHelper.isTransactional((Object)obj) && JPOXJDOHelper.isDeleted((Object)obj)) {
            return "persistent-new-deleted";
        }
        if (JPOXJDOHelper.isPersistent((Object)obj) && !JPOXJDOHelper.isNew((Object)obj) && JPOXJDOHelper.isDirty((Object)obj) && JPOXJDOHelper.isTransactional((Object)obj) && JPOXJDOHelper.isDeleted((Object)obj)) {
            return "persistent-deleted";
        }
        if (!(!JPOXJDOHelper.isPersistent((Object)obj) || JPOXJDOHelper.isNew((Object)obj) || JPOXJDOHelper.isDirty((Object)obj) || JPOXJDOHelper.isDeleted((Object)obj) || JPOXJDOHelper.isTransactional((Object)obj))) {
            return "hollow / persistent-nontransactional";
        }
        if (JPOXJDOHelper.isPersistent((Object)obj) && !JPOXJDOHelper.isNew((Object)obj) && JPOXJDOHelper.isDirty((Object)obj) && !JPOXJDOHelper.isDeleted((Object)obj) && !JPOXJDOHelper.isTransactional((Object)obj)) {
            return "persistent-nontransactional-dirty";
        }
        if (!JPOXJDOHelper.isPersistent((Object)obj) && !JPOXJDOHelper.isNew((Object)obj) && JPOXJDOHelper.isDirty((Object)obj) && JPOXJDOHelper.isTransactional((Object)obj) && !JPOXJDOHelper.isDeleted((Object)obj)) {
            return "transient-dirty";
        }
        if (!(JPOXJDOHelper.isPersistent((Object)obj) || JPOXJDOHelper.isNew((Object)obj) || JPOXJDOHelper.isDirty((Object)obj) || !JPOXJDOHelper.isTransactional((Object)obj) || JPOXJDOHelper.isDeleted((Object)obj))) {
            return "transient-clean";
        }
        if (!(JPOXJDOHelper.isPersistent((Object)obj) || JPOXJDOHelper.isNew((Object)obj) || JPOXJDOHelper.isDirty((Object)obj) || JPOXJDOHelper.isTransactional((Object)obj) || JPOXJDOHelper.isDeleted((Object)obj))) {
            return "transient-clean";
        }
        return "transient";
    }

    public static String[] getDetachedObjectDirtyFields(Object obj, PersistenceManager pm) {
        if (obj == null) {
            return null;
        }
        if (!JPOXJDOHelper.isDetached((Object)obj)) {
            throw new JPOXUserException(LOCALISER.msg("OM.ObjectNotDetached"));
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        ObjectManager thePM = ((AbstractPersistenceManager)pm).getObjectManager();
        StateManager sm = StateManagerFactory.newStateManagerForDetached(thePM, pc, JPOXJDOHelper.getObjectId((Object)pc), null);
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)sm);
        sm.retrieveDetachState(sm);
        String[] dirtyFieldNames = sm.getDirtyFieldNames();
        pc.jdoReplaceStateManager(null);
        return dirtyFieldNames;
    }

    public static String[] getDetachedObjectLoadedFields(Object obj, PersistenceManager pm) {
        if (obj == null) {
            return null;
        }
        if (!JPOXJDOHelper.isDetached((Object)obj)) {
            throw new JPOXUserException(LOCALISER.msg("OM.ObjectNotDetached"));
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        ObjectManager thePM = ((AbstractPersistenceManager)pm).getObjectManager();
        StateManager sm = StateManagerFactory.newStateManagerForDetached(thePM, pc, JPOXJDOHelper.getObjectId((Object)pc), null);
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)sm);
        sm.retrieveDetachState(sm);
        String[] loadedFieldNames = sm.getLoadedFieldNames();
        pc.jdoReplaceStateManager(null);
        return loadedFieldNames;
    }

    public static JDOException getJDOExceptionForJPOXException(JPOXException jpe) {
        if (jpe instanceof ClassNotPersistableException) {
            return new ClassNotPersistenceCapableException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof org.jpox.exceptions.NoPersistenceInformationException) {
            return new NoPersistenceInformationException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof JPOXUnsupportedOptionException) {
            return new JDOUnsupportedOptionException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof JPOXDataStoreException) {
            if (jpe.isFatal()) {
                if (jpe.getFailedObject() != null) {
                    return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getFailedObject());
                }
                if (jpe.getNestedExceptions() != null) {
                    return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
                }
                return new JDOFatalDataStoreException(jpe.getMessage(), (Throwable)jpe);
            }
            if (jpe.getFailedObject() != null) {
                return new JDODataStoreException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDODataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDODataStoreException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof JPOXObjectNotFoundException) {
            if (jpe.getFailedObject() != null) {
                return new JDOObjectNotFoundException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOFatalDataStoreException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof JPOXUserException) {
            if (jpe.isFatal()) {
                if (jpe.getFailedObject() != null) {
                    return new JDOFatalUserException(jpe.getMessage(), jpe.getFailedObject());
                }
                if (jpe.getNestedExceptions() != null) {
                    return new JDOFatalUserException(jpe.getMessage(), jpe.getNestedExceptions());
                }
                return new JDOFatalUserException(jpe.getMessage(), (Throwable)jpe);
            }
            if (jpe.getFailedObject() != null) {
                return new JDOUserException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOUserException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOUserException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof JPOXOptimisticException) {
            if (jpe.getFailedObject() != null) {
                return new JDOOptimisticVerificationException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOOptimisticVerificationException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOOptimisticVerificationException(jpe.getMessage(), (Object)jpe);
        }
        if (jpe.isFatal()) {
            if (jpe.getNestedExceptions() != null) {
                return new JDOFatalInternalException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOFatalInternalException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe.getNestedExceptions() != null) {
            return new JDOException(jpe.getMessage(), jpe.getNestedExceptions());
        }
        return new JDOException(jpe.getMessage(), (Throwable)jpe);
    }
}

