/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.ImplementsMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;

public class ClassMetaData
extends AbstractClassMetaData {
    protected List implementations = new ArrayList();
    protected ImplementsMetaData[] implementsMetaData;
    protected boolean isAbstractPersistenceCapable;
    private boolean populating = false;

    public ClassMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, String entityName) {
        super(parent, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table, entityName);
    }

    public ClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyFields) {
        super(imd, implClassName, copyFields);
    }

    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary) {
        if (this.isInitialised() || this.isPopulated()) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", this.name));
            throw new JPOXException(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", this.fullName)).setFatal();
        }
        if (this.populating) {
            return;
        }
        try {
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.PopulatingMetaData", this.fullName));
            }
            this.populating = true;
            Class cls = this.loadClass(clr, primary);
            this.isAbstractPersistenceCapable = Modifier.isAbstract(cls.getModifiers());
            if (!this.isMetaDataComplete()) {
                this.getMetaDataManager().addAnnotationsDataToClass(cls, this, clr);
            }
            this.getMetaDataManager().addORMDataToClass(cls, clr);
            if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.NonStaticInnerClassNotPersistable", (Object)this.fullName);
            }
            if (this.entityName == null) {
                this.entityName = this.name;
            }
            this.determineSuperClassName(clr, cls);
            this.inheritDetachableSettings();
            this.inheritIdentity();
            this.determineIdentity();
            this.validateUserInputForIdentity();
            this.addMetaDataForMembersNotInMetaData(cls);
            if (this.objectidClass == null) {
                this.populateMemberMetaData(clr, cls, true, primary);
                this.determineObjectIdClass(clr);
                this.populateMemberMetaData(clr, cls, false, primary);
            } else {
                this.populateMemberMetaData(clr, cls, true, primary);
                this.populateMemberMetaData(clr, cls, false, primary);
                this.determineObjectIdClass(clr);
            }
            this.validateUserInputForInheritanceMetaData();
            this.determineInheritanceMetaData();
            this.validateDeprecatedMetaData();
            this.validateUnmappedColumns();
            for (int i = 0; i < this.implementations.size(); ++i) {
                ((ImplementsMetaData)this.implementations.get(i)).populate(clr);
            }
            if (this.persistentInterfaceImplNeedingTableFromSuperclass) {
                AbstractClassMetaData acmd = this.getMetaDataForSuperinterfaceManagingTable(cls, clr);
                if (acmd != null) {
                    this.table = acmd.table;
                    this.schema = acmd.schema;
                    this.catalog = acmd.catalog;
                }
                this.persistentInterfaceImplNeedingTableFromSuperclass = false;
            } else if (this.persistentInterfaceImplNeedingTableFromSubclass) {
                this.persistentInterfaceImplNeedingTableFromSubclass = false;
            }
            this.setPopulated();
        }
        catch (RuntimeException e) {
            JPOXLogger.METADATA.debug(e);
            throw e;
        }
        finally {
            this.populating = false;
        }
    }

    private AbstractClassMetaData getMetaDataForSuperinterfaceManagingTable(Class cls, ClassLoaderResolver clr) {
        Collection superinterfaces = ClassUtils.getSuperinterfaces(cls);
        Iterator iter = superinterfaces.iterator();
        while (iter.hasNext()) {
            Class superintf = (Class)iter.next();
            InterfaceMetaData acmd = this.getMetaDataManager().getMetaDataForInterface(superintf, clr);
            if (acmd == null || acmd.getInheritanceMetaData() == null) continue;
            if (acmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                return acmd;
            }
            if (acmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
            return this.getMetaDataForSuperinterfaceManagingTable(superintf, clr);
        }
        return null;
    }

    protected void addMetaDataForMembersNotInMetaData(Class cls) {
        String api = this.getMetaDataManager().getOMFContext().getApi();
        Collections.sort(this.members);
        try {
            int i;
            boolean hasProperties = false;
            for (int i2 = 0; i2 < this.members.size(); ++i2) {
                if (!((AbstractMemberMetaData)this.members.get(i2)).isProperty()) continue;
                hasProperties = true;
                break;
            }
            if (hasProperties && api.equalsIgnoreCase("JPA")) {
                Method[] clsMethods = cls.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String propertyName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(this.fullName) || clsMethods[i].getName().startsWith("jdo") || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Modifier.isStatic(clsMethods[i].getModifiers()) || Collections.binarySearch(this.members, propertyName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.AddingUnspecifiedField", propertyName, this.name));
                    PropertyMetaData fmd = this.getMetaDataManager().getMetaDataFactory().newPropertyObject(this, propertyName, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                    this.members.add(fmd);
                    Collections.sort(this.members);
                }
            }
            Field[] clsFields = cls.getDeclaredFields();
            for (i = 0; i < clsFields.length; ++i) {
                FieldMetaData fmd;
                if (!clsFields[i].getDeclaringClass().getName().equals(this.fullName) || clsFields[i].getName().startsWith("jdo") || ClassUtils.isInnerClass(clsFields[i].getName()) || Modifier.isStatic(clsFields[i].getModifiers()) || Collections.binarySearch(this.members, clsFields[i].getName()) >= 0) continue;
                if (hasProperties && api.equalsIgnoreCase("JPA")) {
                    fmd = this.getMetaDataManager().getMetaDataFactory().newFieldObject(this, clsFields[i].getName(), null, "none", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                    this.members.add(fmd);
                    Collections.sort(this.members);
                    continue;
                }
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.AddingUnspecifiedField", clsFields[i].getName(), this.name));
                fmd = this.getMetaDataManager().getMetaDataFactory().newFieldObject(this, clsFields[i].getName(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                this.members.add(fmd);
                Collections.sort(this.members);
            }
        }
        catch (Exception e) {
            JPOXLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void populateMemberMetaData(ClassLoaderResolver clr, Class cls, boolean pkMembers, ClassLoader primary) {
        Collections.sort(this.members);
        Iterator fields_iter = this.members.iterator();
        while (fields_iter.hasNext()) {
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)fields_iter.next();
            if (pkMembers != fmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (fmd.className != null && fmd.className.equals("#UNKNOWN")) {
                if (this.pcSuperclassMetaData != null) {
                    AbstractMemberMetaData superFmd = this.pcSuperclassMetaData.getMetaDataForMember(fmd.getName());
                    if (superFmd != null) {
                        fmd.className = superFmd.className != null ? superFmd.className : superFmd.getClassName();
                    }
                } else {
                    fmd.className = null;
                }
            }
            if (!fmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(fmd.getClassName());
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + fmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName);
                        fmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.ClassNotFoundError", fieldClassName));
                        throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.ClassNotFoundError", (Object)fieldClassName);
                    }
                }
            }
            boolean populated = false;
            if (fmd.isProperty()) {
                Method getMethod = null;
                try {
                    getMethod = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), false), null);
                }
                catch (Exception e) {
                    try {
                        getMethod = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), true), null);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (getMethod == null && fmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredPropertyGetterNotFoundError", (Object)this.fullName, fmd.getName());
                }
                Method setMethod = null;
                try {
                    String setterName = ClassUtils.getJavaBeanSetterName(fmd.getName());
                    Method[] methods = fieldCls.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) continue;
                        setMethod = methods[i];
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (setMethod == null && fmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredPropertySetterNotFoundError", (Object)this.fullName, fmd.getName());
                }
                if (getMethod != null) {
                    fmd.populate(clr, null, getMethod, primary);
                    populated = true;
                }
            }
            if (!populated) {
                Field cls_field = null;
                try {
                    cls_field = fieldCls.getDeclaredField(fmd.getName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (cls_field != null) {
                    fmd.populate(clr, cls_field, null, primary);
                    populated = true;
                }
            }
            if (populated) continue;
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredFieldNotFoundError", (Object)this.fullName, fmd.getFullFieldName());
        }
    }

    public synchronized void initialise() {
        int i;
        int total_field_count;
        if (this.populating) {
            return;
        }
        this.checkPopulated();
        if (this.isInitialised()) {
            return;
        }
        if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
            this.pcSuperclassMetaData.initialise();
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.InitialisingMetaData", this.fullName));
        }
        Iterator membersIter = this.members.iterator();
        int numManaged = 0;
        int numOverridden = 0;
        while (membersIter.hasNext()) {
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)membersIter.next();
            fmd.initialise();
            if (!fmd.isJdoField()) continue;
            if (fmd.fieldBelongsToClass()) {
                ++numManaged;
                continue;
            }
            ++numOverridden;
        }
        this.managedMembers = new AbstractMemberMetaData[numManaged];
        this.overriddenMembers = new AbstractMemberMetaData[numOverridden];
        membersIter = this.members.iterator();
        int field_id = 0;
        int overridden_field_id = 0;
        this.memberPositionsByName = new HashMap();
        while (membersIter.hasNext()) {
            AbstractMemberMetaData mmd = (AbstractMemberMetaData)membersIter.next();
            if (!mmd.isJdoField()) continue;
            if (mmd.fieldBelongsToClass()) {
                mmd.setFieldId(field_id);
                this.managedMembers[field_id] = mmd;
                this.memberPositionsByName.put(mmd.getName(), new Integer(field_id));
                ++field_id;
                continue;
            }
            this.overriddenMembers[overridden_field_id++] = mmd;
            AbstractMemberMetaData superFmd = this.pcSuperclassMetaData.getMemberBeingOverridden(mmd.getName());
            if (superFmd == null || !superFmd.isPrimaryKey()) continue;
            mmd.setPrimaryKey();
        }
        if (this.pcSuperclassMetaData != null) {
            if (!this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise();
            }
            this.noOfInheritedManagedMembers = this.pcSuperclassMetaData.getNoOfInheritedManagedMembers() + this.pcSuperclassMetaData.getNoOfManagedMembers();
        }
        this.memberCount = total_field_count = this.noOfInheritedManagedMembers + this.managedMembers.length;
        this.allMemberPositions = new int[total_field_count];
        this.dfgMemberFlags = new boolean[total_field_count];
        this.scoMutableMemberFlags = new boolean[total_field_count];
        this.nonPkMemberFlags = new boolean[total_field_count];
        int pk_field_count = 0;
        int dfg_field_count = 0;
        int scm_field_count = 0;
        int pc_field_count = 0;
        for (i = 0; i < total_field_count; ++i) {
            this.allMemberPositions[i] = i;
            AbstractMemberMetaData fmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
            if (fmd.isPrimaryKey()) {
                ++pk_field_count;
            } else {
                this.nonPkMemberFlags[i] = true;
            }
            if (fmd.isDefaultFetchGroup()) {
                this.dfgMemberFlags[i] = true;
                ++dfg_field_count;
            }
            if (fmd.calcIsSecondClassMutable()) {
                this.scoMutableMemberFlags[i] = true;
                ++scm_field_count;
            }
            if (!fmd.isFieldTypePersistable()) continue;
            ++pc_field_count;
        }
        if (pk_field_count > 0 && this.identityType != IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyFieldsFoundButNotUsingApplicationIdentity", (Object)this.fullName, (Object)new Integer(pk_field_count), this.identityType);
        }
        if (pk_field_count > 0) {
            this.pkMemberPositions = new int[pk_field_count];
            int pk_num = 0;
            for (i = 0; i < total_field_count; ++i) {
                AbstractMemberMetaData fmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
                if (!fmd.isPrimaryKey()) continue;
                this.pkMemberPositions[pk_num++] = i;
            }
        } else if (pk_field_count == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyNotSpecifiedError", (Object)this.fullName, this.objectidClass);
        }
        this.nonPkMemberPositions = new int[total_field_count - pk_field_count];
        this.persistenceCapableMemberPositions = new int[pc_field_count];
        int npkf = 0;
        int npc = 0;
        for (i = 0; i < total_field_count; ++i) {
            AbstractMemberMetaData fmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
            if (!fmd.isPrimaryKey()) {
                this.nonPkMemberPositions[npkf++] = i;
            }
            if (!fmd.isFieldTypePersistable()) continue;
            this.persistenceCapableMemberPositions[npc++] = i;
        }
        this.dfgMemberPositions = new int[dfg_field_count];
        this.scoMutableMemberPositions = new int[scm_field_count];
        int dfg_num = 0;
        int scm_num = 0;
        for (i = 0; i < total_field_count; ++i) {
            if (this.dfgMemberFlags[i]) {
                this.dfgMemberPositions[dfg_num++] = i;
            }
            if (!this.scoMutableMemberFlags[i]) continue;
            this.scoMutableMemberPositions[scm_num++] = i;
        }
        this.implementsMetaData = new ImplementsMetaData[this.implementations.size()];
        for (i = 0; i < this.implementations.size(); ++i) {
            this.implementsMetaData[i] = (ImplementsMetaData)this.implementations.get(i);
            this.implementsMetaData[i].initialise();
        }
        this.joinMetaData = new JoinMetaData[this.joins.size()];
        for (i = 0; i < this.joinMetaData.length; ++i) {
            this.joinMetaData[i] = (JoinMetaData)this.joins.get(i);
            this.joinMetaData[i].initialise();
        }
        this.indexMetaData = new IndexMetaData[this.indexes.size()];
        for (i = 0; i < this.indexMetaData.length; ++i) {
            this.indexMetaData[i] = (IndexMetaData)this.indexes.get(i);
            this.indexMetaData[i].initialise();
        }
        this.foreignKeyMetaData = new ForeignKeyMetaData[this.foreignKeys.size()];
        for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
            this.foreignKeyMetaData[i] = (ForeignKeyMetaData)this.foreignKeys.get(i);
            this.foreignKeyMetaData[i].initialise();
        }
        this.uniqueMetaData = new UniqueMetaData[this.uniqueConstraints.size()];
        for (i = 0; i < this.uniqueMetaData.length; ++i) {
            this.uniqueMetaData[i] = (UniqueMetaData)this.uniqueConstraints.get(i);
            this.uniqueMetaData[i].initialise();
        }
        this.fetchGroupMetaData = new FetchGroupMetaData[this.fetchGroups.size()];
        this.fetchGroupMetaDataByName = new HashMap();
        for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
            this.fetchGroupMetaData[i] = (FetchGroupMetaData)this.fetchGroups.get(i);
            this.fetchGroupMetaData[i].initialise();
            this.fetchGroupMetaDataByName.put(this.fetchGroupMetaData[i].getName(), this.fetchGroupMetaData[i]);
        }
        if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
            if (this.pcSuperclassMetaData != null) {
                IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                this.identityMetaData = new IdentityMetaData(this, superImd.getColumnName(), superImd.getValueStrategy().toString(), superImd.getSequence());
            } else {
                this.identityMetaData = new IdentityMetaData(this, null, null, null);
            }
        }
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.initialise();
        }
        if (this.versionMetaData != null) {
            this.versionMetaData.initialise();
        }
        if (this.identityMetaData != null) {
            this.identityMetaData.initialise();
        }
        if (this.inheritanceMetaData != null) {
            this.inheritanceMetaData.initialise();
        }
        if (this.identityType == IdentityType.APPLICATION) {
            this.usesSingleFieldIdentityClass = this.getMetaDataManager().getApiAdapter().isSingleFieldIdentityClass(this.getObjectidClass());
        }
        this.joins.clear();
        this.joins = null;
        this.fetchGroups.clear();
        this.fetchGroups = null;
        this.foreignKeys.clear();
        this.foreignKeys = null;
        this.indexes.clear();
        this.indexes = null;
        this.uniqueConstraints.clear();
        this.uniqueConstraints = null;
        this.implementations.clear();
        this.implementations = null;
        this.setInitialised();
    }

    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new FieldMetaData((MetaData)this, name);
    }

    public final ImplementsMetaData[] getImplementsMetaData() {
        return this.implementsMetaData;
    }

    public boolean implementsInterface(String interfaceName) {
        if (this.implementsMetaData != null) {
            for (int i = 0; i < this.implementsMetaData.length; ++i) {
                if (!this.implementsMetaData[i].getName().equals(interfaceName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAbstractPersistenceCapable() {
        return this.isAbstractPersistenceCapable;
    }

    public void addImplements(ImplementsMetaData implmd) {
        if (implmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new RuntimeException("Already initialised");
        }
        this.implementations.add(implmd);
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<class name=\"" + this.name + "\"\n");
        if (this.identityType != null) {
            sb.append(prefix).append("       identity-type=\"" + this.identityType + "\"\n");
        }
        if (this.objectidClass != null) {
            sb.append(prefix).append("       objectid-class=\"" + this.objectidClass + "\"\n");
        }
        if (!this.requiresExtent) {
            sb.append(prefix).append("       requires-extent=\"" + this.requiresExtent + "\"");
        }
        if (this.embeddedOnly) {
            sb.append(prefix).append("       embedded-only=\"" + this.embeddedOnly + "\"\n");
        }
        if (this.persistenceModifier != null) {
            sb.append(prefix).append("       persistence-modifier=\"" + this.persistenceModifier + "\"\n");
        }
        if (this.catalog != null) {
            sb.append(prefix).append("       catalog=\"" + this.catalog + "\"\n");
        }
        if (this.schema != null) {
            sb.append(prefix).append("       schema=\"" + this.schema + "\"\n");
        }
        if (this.table != null) {
            sb.append(prefix).append("       table=\"" + this.table + "\"\n");
        }
        if (this.detachable) {
            sb.append(prefix).append("       detachable=\"" + this.detachable + "\">\n");
        }
        if (this.implementsMetaData != null) {
            for (i = 0; i < this.implementsMetaData.length; ++i) {
                sb.append(this.implementsMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.identityMetaData != null) {
            sb.append(this.identityMetaData.toString(prefix + indent, indent));
        }
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.inheritanceMetaData != null) {
            sb.append(this.inheritanceMetaData.toString(prefix + indent, indent));
        }
        if (this.versionMetaData != null) {
            sb.append(this.versionMetaData.toString(prefix + indent, indent));
        }
        if (this.joinMetaData != null) {
            for (i = 0; i < this.joinMetaData.length; ++i) {
                sb.append(this.joinMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
                sb.append(this.foreignKeyMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.indexMetaData != null) {
            for (i = 0; i < this.indexMetaData.length; ++i) {
                sb.append(this.indexMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.uniqueMetaData != null) {
            for (i = 0; i < this.uniqueMetaData.length; ++i) {
                sb.append(this.uniqueMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.managedMembers != null) {
            for (i = 0; i < this.managedMembers.length; ++i) {
                sb.append(this.managedMembers[i].toString(prefix + indent, indent));
            }
        }
        if (this.unmappedColumns != null) {
            for (i = 0; i < this.unmappedColumns.size(); ++i) {
                ColumnMetaData col = (ColumnMetaData)this.unmappedColumns.get(i);
                sb.append(col.toString(prefix + indent, indent));
            }
        }
        if (this.queries != null) {
            Iterator iter = this.queries.iterator();
            while (iter.hasNext()) {
                QueryMetaData q = (QueryMetaData)iter.next();
                sb.append(q.toString(prefix + indent, indent));
            }
        }
        if (this.fetchGroupMetaData != null) {
            for (int i2 = 0; i2 < this.fetchGroupMetaData.length; ++i2) {
                sb.append(this.fetchGroupMetaData[i2].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</class>\n");
        return sb.toString();
    }
}

