/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;

public class ImplementsMetaData
extends MetaData {
    protected String name;
    protected final List properties = new ArrayList();

    public ImplementsMetaData(ClassMetaData parent, String name) {
        super(parent);
        this.name = ClassUtils.createFullClassName(parent.getPackageName(), name);
    }

    public String getName() {
        return this.name;
    }

    public void addProperty(PropertyMetaData pmd) {
        if (pmd == null) {
            return;
        }
        this.properties.add(pmd);
    }

    public synchronized void populate(ClassLoaderResolver clr) {
        try {
            clr.classForName(this.name).getName();
        }
        catch (ClassNotResolvedException cnre) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Implements.ClassNotFoundError", ((ClassMetaData)this.parent).getFullClassName(), this.name));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Implements.ClassNotFoundError", (Object)((ClassMetaData)this.parent).getFullClassName(), this.name);
        }
        super.populate();
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<implements name=\"" + this.name + "\">\n");
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyMetaData pmd = (PropertyMetaData)this.properties.get(i);
            sb.append(pmd.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</implements>\n");
        return sb.toString();
    }
}

