/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpox.ClassLoaderResolver;
import org.jpox.OMFContext;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.ImplementsMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataMerger;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.xml.MetaDataParser;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class JDOMetaDataManager
extends MetaDataManager {
    protected String jdoFileSuffix = "jdo";
    protected String ormFileSuffix = "orm";
    protected String jdoqueryFileSuffix = "jdoquery";
    protected String ormMappingName = null;
    public static final int ALL_JDO_LOCATIONS = 1;
    public static final int JDO_1_0_0_LOCATIONS = 2;
    public static final int JDO_1_0_1_LOCATIONS = 3;
    protected int locationDefinition = 1;
    protected Map ormClassMetaDataByClass = new HashMap();
    protected Map classMetaDataByInterface = new HashMap();
    private static final char CLASS_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String METADATA_PACKAGE = "package";
    private static final String METADATA_LOCATION_METAINF = "/META-INF/package";
    private static final String METADATA_LOCATION_WEBINF = "/WEB-INF/package";

    public JDOMetaDataManager(OMFContext ctxt) {
        super(ctxt);
        String ormMapping;
        String jdoquerySuffix;
        String ormSuffix;
        String jdoSuffix = ctxt.getPersistenceConfiguration().getJdoMetaDataFileExtension();
        if (!StringUtils.isWhitespace(jdoSuffix)) {
            this.jdoFileSuffix = jdoSuffix;
        }
        if (!StringUtils.isWhitespace(ormSuffix = ctxt.getPersistenceConfiguration().getOrmMetaDataFileExtension())) {
            this.ormFileSuffix = ormSuffix;
        }
        if (!StringUtils.isWhitespace(jdoquerySuffix = ctxt.getPersistenceConfiguration().getJdoqueryMetaDataFileExtension())) {
            this.jdoqueryFileSuffix = jdoquerySuffix;
        }
        if (!StringUtils.isWhitespace(ormMapping = ctxt.getPersistenceConfiguration().getMapping())) {
            this.ormMappingName = ormMapping;
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            this.logConfiguration();
        }
    }

    protected void logConfiguration() {
        String inputTypes = null;
        inputTypes = this.annotationManager != null ? "XML, Annotations" : "XML";
        JPOXLogger.METADATA.debug("MetaDataManager :  Input=(" + inputTypes + ")" + " XML-Validation=" + this.validateMetaData + " File-Suffices=(JDO=" + this.jdoFileSuffix + ", ORM=" + this.ormFileSuffix + ", JDOQUERY=" + this.jdoqueryFileSuffix + ")" + (this.ormMappingName != null ? " ORM-name=" + this.ormMappingName : ""));
    }

    public void close() {
        super.close();
        this.ormClassMetaDataByClass.clear();
        this.ormClassMetaDataByClass = null;
    }

    protected FileMetaData parseFile(URL fileURL) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
        }
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(fileURL, "jdo");
    }

    public void registerFile(String fileURLString, FileMetaData filemd, ClassLoaderResolver clr) {
        if (fileURLString == null) {
            return;
        }
        if (this.fileMetaDataByURLString.get(fileURLString) != null) {
            return;
        }
        this.fileMetaDataByURLString.put(fileURLString, filemd);
        this.registerQueriesForFile(filemd);
        this.registerSequencesForFile(filemd);
        this.registerTableGeneratorsForFile(filemd);
        if (filemd.getType() != 3) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                int j;
                PackageMetaData pmd = filemd.getPackage(i);
                for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    if (filemd.getType() == 1 || filemd.getType() == 4) {
                        this.classMetaDataByClass.put(cmd.getFullClassName(), cmd);
                    } else if (filemd.getType() == 2) {
                        this.ormClassMetaDataByClass.put(cmd.getFullClassName(), cmd);
                    }
                    if (cmd.getEntityName() == null) continue;
                    this.classMetaDataByEntityName.put(cmd.getEntityName(), cmd);
                }
                for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                    InterfaceMetaData intfmd = pmd.getInterface(j);
                    if (filemd.getType() == 1 || filemd.getType() == 4) {
                        this.classMetaDataByClass.put(intfmd.getFullClassName(), intfmd);
                        continue;
                    }
                    if (filemd.getType() != 2) continue;
                    this.ormClassMetaDataByClass.put(intfmd.getFullClassName(), intfmd);
                }
            }
        }
    }

    public boolean hasMetaDataForClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return false;
        }
        return this.classMetaDataByClass.get(className) != null;
    }

    public synchronized AbstractClassMetaData getMetaDataForClassInternal(Class c, ClassLoaderResolver clr) {
        String className = c.getName();
        if (this.isClassWithoutPersistenceInfo(className)) {
            return null;
        }
        AbstractClassMetaData the_md = (AbstractClassMetaData)this.classMetaDataByClass.get(className);
        if (the_md != null) {
            return the_md;
        }
        FileMetaData filemd = this.loadMetaDataForClass(c, clr, null, this.jdoFileSuffix, true);
        if (filemd != null) {
            this.utilisedFileMetaData.add(filemd);
            the_md = (AbstractClassMetaData)this.classMetaDataByClass.get(className);
            return the_md;
        }
        FileMetaData annFilemd = this.loadAnnotationsForClass(c, clr, true, true);
        if (annFilemd != null) {
            if (c.isInterface()) {
                return annFilemd.getPackage(0).getInterface(0);
            }
            return annFilemd.getPackage(0).getClass(0);
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.RegisterClassWithoutMetaData", className));
        }
        this.classesWithoutPersistenceInfo.add(className);
        return null;
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        QueryMetaData qmd = super.getMetaDataForQuery(cls, clr, queryName);
        if (qmd != null) {
            return qmd;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        if (cls != null) {
            AbstractClassMetaData cmd = this.getMetaDataForClass(cls, clr);
            if (cmd == null) {
                return null;
            }
            Object obj = this.queryMetaDataByName.get(query_key);
            if (obj != null) {
                return (QueryMetaData)obj;
            }
            ArrayList locations = new ArrayList();
            locations.addAll(this.getValidMetaDataLocationsForClass(this.jdoqueryFileSuffix, null, cls.getName()));
            for (int i = 0; i < locations.size(); ++i) {
                String location = (String)locations.get(i);
                URL fileURL = clr.getResource(location, cls != null ? cls.getClassLoader() : null);
                if (fileURL != null && this.fileMetaDataByURLString.get(fileURL.toString()) == null) {
                    FileMetaData filemd = this.parseFile(fileURL);
                    filemd.setType(3);
                    this.registerFile(fileURL.toString(), filemd, clr);
                }
                cmd = this.getMetaDataForClass(cls, clr);
                qmd = (QueryMetaData)this.queryMetaDataByName.get(query_key);
                if (qmd != null) {
                    if (JPOXLogger.METADATA.isDebugEnabled()) {
                        JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundQuery", query_key, location));
                    }
                    return qmd;
                }
                if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForQueryAtLocationError", query_key, location));
            }
            return null;
        }
        ArrayList locations = new ArrayList();
        locations.addAll(this.getValidMetaDataLocationsForItem(this.jdoFileSuffix, null, null, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.ormFileSuffix, this.ormMappingName, null, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.jdoqueryFileSuffix, null, null, false));
        for (int i = 0; i < locations.size(); ++i) {
            String location = (String)locations.get(i);
            URL fileURL = clr.getResource(location, cls != null ? cls.getClassLoader() : null);
            if (fileURL != null && this.fileMetaDataByURLString.get(fileURL.toString()) == null) {
                FileMetaData filemd = this.parseFile(fileURL);
                this.registerFile(fileURL.toString(), filemd, clr);
            }
            if ((qmd = (QueryMetaData)this.queryMetaDataByName.get(query_key)) != null) {
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundQuery", query_key, location));
                }
                return qmd;
            }
            if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForQueryAtLocationError", query_key, location));
        }
        return null;
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String packageSequenceName) {
        SequenceMetaData seqmd = super.getMetaDataForSequence(clr, packageSequenceName);
        if (seqmd != null) {
            return seqmd;
        }
        String packageName = packageSequenceName;
        if (packageSequenceName.lastIndexOf(46) >= 0) {
            packageName = packageSequenceName.substring(0, packageSequenceName.lastIndexOf(46));
        }
        ArrayList locations = new ArrayList();
        locations.addAll(this.getValidMetaDataLocationsForItem(this.jdoFileSuffix, null, packageName, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.ormFileSuffix, this.ormMappingName, packageName, false));
        for (int i = 0; i < locations.size(); ++i) {
            String location = (String)locations.get(i);
            URL fileURL = clr.getResource(location, null);
            if (fileURL != null && this.fileMetaDataByURLString.get(fileURL.toString()) == null) {
                FileMetaData filemd = this.parseFile(fileURL);
                this.registerFile(fileURL.toString(), filemd, clr);
            }
            if ((seqmd = (SequenceMetaData)this.sequenceMetaDataByPackageSequence.get(packageSequenceName)) != null) {
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundQuery", packageSequenceName, location));
                }
                return seqmd;
            }
            if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForSequenceAtLocationError", packageSequenceName, location));
        }
        return null;
    }

    public void addORMDataToClass(Class c, ClassLoaderResolver clr) {
        if (this.enhancing) {
            return;
        }
        AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        AbstractClassMetaData ormCmd = (AbstractClassMetaData)this.ormClassMetaDataByClass.get(c.getName());
        if (ormCmd != null) {
            MetaDataMerger.mergeClassORMData(cmd, ormCmd);
            this.ormClassMetaDataByClass.remove(c.getName());
            return;
        }
        FileMetaData filemdORM = this.loadMetaDataForClass(c, clr, this.ormMappingName, this.ormFileSuffix, false);
        if (filemdORM != null && (ormCmd = (AbstractClassMetaData)this.ormClassMetaDataByClass.get(c.getName())) != null) {
            MetaDataMerger.mergeFileORMData((FileMetaData)cmd.getPackageMetaData().getParent(), (FileMetaData)ormCmd.getPackageMetaData().getParent());
            MetaDataMerger.mergeClassORMData(cmd, ormCmd);
            this.ormClassMetaDataByClass.remove(c.getName());
        }
    }

    protected FileMetaData loadMetaDataForClass(Class pc_class, ClassLoaderResolver clr, String metadata_file_modifier, String metadata_file_extension, boolean populate) {
        List validLocations = this.getValidMetaDataLocationsForClass(metadata_file_extension, metadata_file_modifier, pc_class.getName());
        Iterator locationsIter = validLocations.iterator();
        while (locationsIter.hasNext()) {
            String location = (String)locationsIter.next();
            URL url = clr.getResource(location, pc_class.getClassLoader());
            if (url != null) {
                FileMetaData filemd = (FileMetaData)this.fileMetaDataByURLString.get(url.toString());
                if (filemd == null) {
                    filemd = this.parseFile(url);
                    this.registerFile(url.toString(), filemd, clr);
                    if (populate) {
                        this.populateFileMetaData(filemd, clr, pc_class.getClassLoader());
                    }
                }
                if ((filemd.getType() != 1 || this.classMetaDataByClass.get(pc_class.getName()) == null) && (filemd.getType() != 2 || this.ormClassMetaDataByClass.get(pc_class.getName()) == null)) continue;
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundClass", metadata_file_extension, pc_class.getName(), url));
                }
                return filemd;
            }
            if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForClassAtLocationError", metadata_file_extension, pc_class.getName(), location));
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForClassError", metadata_file_extension, pc_class.getName()));
        }
        return null;
    }

    List getValidMetaDataLocationsForPackage(String fileExtension, String fileModifier, String packageName) {
        return this.getValidMetaDataLocationsForItem(fileExtension, fileModifier, packageName, false);
    }

    List getValidMetaDataLocationsForClass(String fileExtension, String fileModifier, String className) {
        return this.getValidMetaDataLocationsForItem(fileExtension, fileModifier, className, true);
    }

    List getValidMetaDataLocationsForItem(String fileExtension, String fileModifier, String itemName, boolean isClass) {
        ArrayList locations = new ArrayList();
        if (fileExtension == null) {
            fileExtension = "jdo";
        }
        StringTokenizer tokens = new StringTokenizer(fileExtension, ",");
        while (tokens.hasMoreTokens()) {
            locations.addAll(this.getValidMetaDataLocationsForSingleExtension(tokens.nextToken(), fileModifier, itemName, isClass));
        }
        return locations;
    }

    private List getValidMetaDataLocationsForSingleExtension(String fileExtension, String fileModifier, String itemName, boolean isClass) {
        ArrayList<String> locations = new ArrayList<String>();
        String suffix = null;
        if (fileExtension == null) {
            fileExtension = "jdo";
        }
        suffix = fileModifier != null ? "-" + fileModifier + '.' + fileExtension : '.' + fileExtension;
        if (this.locationDefinition == 1 || this.locationDefinition == 3) {
            locations.add(METADATA_LOCATION_METAINF + suffix);
            locations.add(METADATA_LOCATION_WEBINF + suffix);
            locations.add("/package" + suffix);
        }
        if (itemName != null && itemName.length() > 0) {
            int separatorPosition = itemName.indexOf(46);
            if (separatorPosition < 0) {
                if (this.locationDefinition == 1 || this.locationDefinition == 3) {
                    locations.add('/' + itemName + '/' + METADATA_PACKAGE + suffix);
                }
                if (this.locationDefinition == 1 || this.locationDefinition == 2) {
                    locations.add('/' + itemName + suffix);
                }
            } else {
                while (separatorPosition >= 0) {
                    String name = itemName.substring(0, separatorPosition);
                    if (this.locationDefinition == 1 || this.locationDefinition == 3) {
                        locations.add('/' + name.replace('.', '/') + '/' + METADATA_PACKAGE + suffix);
                    }
                    if (this.locationDefinition == 1 || this.locationDefinition == 2) {
                        locations.add('/' + name.replace('.', '/') + suffix);
                    }
                    if ((separatorPosition = itemName.indexOf(46, separatorPosition + 1)) >= 0) continue;
                    if (!(isClass || this.locationDefinition != 1 && this.locationDefinition != 3)) {
                        locations.add('/' + itemName.replace('.', '/') + '/' + METADATA_PACKAGE + suffix);
                    }
                    if (this.locationDefinition != 1 && this.locationDefinition != 2) continue;
                    locations.add('/' + itemName.replace('.', '/') + suffix);
                }
            }
        }
        return locations;
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        if (c == null || !c.isInterface()) {
            return null;
        }
        InterfaceMetaData imd = (InterfaceMetaData)this.getMetaDataForClassInternal(c, clr);
        if (imd != null) {
            if (!imd.isPopulated() && !imd.isInitialised()) {
                imd.populate(clr, c.getClassLoader());
            }
            if (!imd.isInitialised()) {
                imd.initialise();
            }
            if (this.utilisedFileMetaData.size() > 0) {
                Iterator iter = this.utilisedFileMetaData.iterator();
                while (iter.hasNext()) {
                    FileMetaData filemd = (FileMetaData)iter.next();
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
            }
        }
        this.utilisedFileMetaData.clear();
        return imd;
    }

    public boolean isPersistentInterface(String name) {
        AbstractClassMetaData acmd = (AbstractClassMetaData)this.classMetaDataByClass.get(name);
        return acmd != null && acmd instanceof InterfaceMetaData;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
        return cmd != null && cmd.getFullClassName().equals(implName);
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
        return cmd != null ? cmd.getFullClassName() : null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
        ClassMetaData cmd = new ClassMetaData(imd, implClass.getName(), true);
        cmd.addImplements(new ImplementsMetaData(cmd, imd.getFullClassName()));
        this.classMetaDataByClass.put(cmd.getFullClassName(), cmd);
        this.classMetaDataByInterface.put(imd.getFullClassName(), cmd);
        this.initialiseClassMetaData(cmd, implClass, clr);
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.DeregisterClassWithoutMetaData", implClass.getName()));
        }
        this.classesWithoutPersistenceInfo.remove(implClass.getName());
    }
}

