/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.util.Localiser;

public class MetaData
implements Serializable {
    protected static Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    public static final int METADATA_CREATED_STATE = 0;
    public static final int METADATA_POPULATED_STATE = 1;
    public static final int METADATA_INITIALISED_STATE = 2;
    public static final int METADATA_USED_STATE = 3;
    protected int metaDataState = 0;
    protected MetaData parent;
    public static final String JPOX_VENDOR_NAME = "jpox";
    protected Collection extensions = null;

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public void populate() {
        this.setPopulated();
    }

    public void initialise() {
        this.setInitialised();
    }

    public void setInitialised() {
        this.metaDataState = 2;
    }

    public void setPopulated() {
        this.metaDataState = 1;
    }

    public void setUsed() {
        this.metaDataState = 3;
    }

    public void setParent(MetaData md) {
        if (this.isPopulated() || this.isInitialised()) {
            throw new JPOXException("Cannot set parent of " + this + " since it is already populated/initialised");
        }
        this.parent = md;
    }

    public void addExtension(String vendor, String key, String value) {
        if (vendor == null || vendor.equalsIgnoreCase(JPOX_VENDOR_NAME) && (key == null || value == null)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Extendable.Invalid", (Object)vendor, (Object)key, value);
        }
        if (vendor.equals(JPOX_VENDOR_NAME) && this.hasExtension(key)) {
            this.removeExtension(key);
        }
        if (this.extensions == null) {
            this.extensions = new HashSet(2);
        }
        this.extensions.add(new ExtensionMetaData(vendor, key, value));
    }

    public void addExtension(String key, String value) {
        this.addExtension(JPOX_VENDOR_NAME, key, value);
    }

    public void removeExtension(String key) {
        if (this.extensions == null) {
            return;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME) || !ex.getKey().equals(key)) continue;
            iter.remove();
            break;
        }
    }

    public MetaData getParent() {
        return this.parent;
    }

    public boolean isPopulated() {
        return this.metaDataState >= 1;
    }

    public boolean isInitialised() {
        return this.metaDataState >= 2;
    }

    public boolean isUsed() {
        return this.metaDataState == 3;
    }

    public int getNoOfExtensions() {
        if (this.extensions == null) {
            return 0;
        }
        return this.extensions.size();
    }

    public ExtensionMetaData[] getExtensions() {
        if (this.extensions == null || this.extensions.size() == 0) {
            return null;
        }
        return this.extensions.toArray(new ExtensionMetaData[this.extensions.size()]);
    }

    public boolean hasExtension(String key) {
        if (this.extensions == null || key == null) {
            return false;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            return true;
        }
        return false;
    }

    public String getValueForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            return ex.getValue();
        }
        return null;
    }

    public String[] getValuesForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            return MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(ex.getValue());
        }
        return null;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        if (this.extensions == null || this.extensions.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            sb.append(prefix).append(ex.toString()).append("\n");
        }
        return sb.toString();
    }
}

