/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.RegisterClassEvent;
import javax.jdo.spi.RegisterClassListener;
import org.jpox.ClassLoaderResolver;
import org.jpox.OMFContext;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.DefaultMetaDataFactory;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataFactory;
import org.jpox.metadata.MetaDataMerger;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PersistenceFileMetaData;
import org.jpox.metadata.PersistenceUnitMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.QueryResultMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.TableGeneratorMetaData;
import org.jpox.metadata.annotations.AnnotationManager;
import org.jpox.metadata.xml.MetaDataParser;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class MetaDataManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    protected OMFContext omfContext = null;
    protected AnnotationManager annotationManager = null;
    protected MetaDataParser metaDataParser = null;
    protected boolean validateMetaData = true;
    protected Collection classesWithoutPersistenceInfo = new HashSet();
    protected Map fileMetaDataByURLString = new HashMap();
    protected Map classMetaDataByClass = new HashMap();
    protected Map classMetaDataByEntityName = new HashMap();
    protected Map queryMetaDataByName = new HashMap();
    protected Map sequenceMetaDataByPackageSequence = new HashMap();
    protected Map tableGeneratorMetaDataByPackageSequence = new HashMap();
    protected Map queryResultMetaDataByName = new HashMap();
    protected boolean enhancing = false;
    protected boolean initialised = false;
    protected List listeners = new ArrayList();
    private MetaDataFactory metaDataFactory;
    ArrayList utilisedFileMetaData = new ArrayList();
    static /* synthetic */ Class class$org$jpox$metadata$MetaDataManager;
    static /* synthetic */ Class class$java$lang$Object;

    public MetaDataManager(OMFContext ctxt) {
        this.omfContext = ctxt;
        JDOImplHelper.getInstance().removeRegisterClassListener((RegisterClassListener)new MetaDataRegisterClassListener());
        this.setValidate(ctxt.getPersistenceConfiguration().getMetaDataValidate());
        if (JavaUtils.isJRE1_5OrAbove()) {
            try {
                ClassLoaderResolver clr = ctxt.getClassLoaderResolver(null);
                Class annotationReaderClass = clr.classForName(ctxt.getPersistenceConfiguration().getMetaDataAnnotationsManager());
                Class[] ctrArgs = new Class[]{class$org$jpox$metadata$MetaDataManager == null ? (class$org$jpox$metadata$MetaDataManager = MetaDataManager.class$("org.jpox.metadata.MetaDataManager")) : class$org$jpox$metadata$MetaDataManager};
                Object[] ctrParams = new Object[]{this};
                Constructor ctor = annotationReaderClass.getConstructor(ctrArgs);
                this.annotationManager = (AnnotationManager)ctor.newInstance(ctrParams);
            }
            catch (Exception e) {
                JPOXLogger.METADATA.info(LOCALISER.msg("MetaData.AnnotationManagerNotFound"));
            }
        }
        Set supportedClasses = this.getOMFContext().getTypeManager().getSupportedTypes();
        Iterator iter = supportedClasses.iterator();
        while (iter.hasNext()) {
            this.classesWithoutPersistenceInfo.add(iter.next());
        }
    }

    protected void logConfiguration() {
        String inputTypes = null;
        inputTypes = this.annotationManager != null ? "XML, Annotations" : "XML";
        JPOXLogger.METADATA.debug("MetaDataManager :  Input=(" + inputTypes + ")" + " XML-Validation=" + this.validateMetaData);
    }

    public FileMetaData[] initialise(String[] metadataFiles, String[] classNames, ClassLoaderResolver clr) {
        int i;
        if (this.initialised) {
            return null;
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses"));
        }
        HashSet<Exception> exceptions = new HashSet<Exception>();
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        for (i = 0; i < metadataFiles.length; ++i) {
            try {
                URL fileURL = null;
                try {
                    fileURL = new URL("file:" + metadataFiles[i]);
                }
                catch (MalformedURLException mue) {
                    fileURL = clr.getResource(metadataFiles[i], null);
                }
                if (fileURL == null || this.fileMetaDataByURLString.get(fileURL.toString()) != null) continue;
                FileMetaData filemd = this.parseFile(fileURL);
                if (filemd != null) {
                    this.registerFile(fileURL.toString(), filemd, clr);
                    fileMetaData.add(filemd);
                    continue;
                }
                throw new JPOXUserException(LOCALISER.msg("MetaDataManager.Initialise.MetaDataFileNotValid", metadataFiles[i]));
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        for (i = 0; i < classNames.length; ++i) {
            try {
                Class cls = clr.classForName(classNames[i]);
                AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(classNames[i]);
                if (cmd != null) continue;
                FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                if (filemd != null) {
                    this.registerFile("annotations:" + classNames[i], filemd, clr);
                    fileMetaData.add(filemd);
                    continue;
                }
                JPOXLogger.METADATA.info(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses.NoMetaDataForClass", classNames[i]));
                continue;
            }
            catch (ClassNotResolvedException e) {
                JPOXLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                continue;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new JPOXUserException(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses.ErrorLoading"), exceptions.toArray(new Throwable[exceptions.size()]), null);
        }
        if (fileMetaData.size() > 0) {
            FileMetaData filemd;
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses.Populating"));
            }
            Iterator iter = fileMetaData.iterator();
            while (iter.hasNext()) {
                filemd = (FileMetaData)iter.next();
                this.populateFileMetaData(filemd, clr, null);
            }
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses.Initialising"));
            }
            iter = fileMetaData.iterator();
            while (iter.hasNext()) {
                filemd = (FileMetaData)iter.next();
                try {
                    this.initialiseFileMetaData(filemd, clr, null);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (exceptions.size() > 0) {
                throw new JPOXUserException(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses.ErrorInitialising"), exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.MetaDataAndClasses.Success"));
        }
        this.initialised = true;
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] initialise(String persistenceUnitName, ClassLoaderResolver clr) {
        PersistenceUnitMetaData pumd = null;
        pumd = this.getMetaDataForPersistenceUnit(persistenceUnitName);
        if (pumd == null) {
            throw new JPOXUserException(LOCALISER.msg("MetaData.Persistence.InvalidPersistenceUnit", persistenceUnitName));
        }
        return this.initialise(pumd, clr);
    }

    public FileMetaData[] initialise(PersistenceUnitMetaData pumd, ClassLoaderResolver clr) {
        Iterator iter;
        HashSet jarFileNames;
        if (this.initialised) {
            return null;
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.PersistenceUnit", pumd.getName()));
        }
        HashSet<Exception> exceptions = new HashSet<Exception>();
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<String> mappingFiles = new HashSet<String>();
        mappingFiles.add("META-INF/orm.xml");
        if (pumd.getMappingFiles() != null) {
            mappingFiles.addAll(pumd.getMappingFiles());
        }
        if (mappingFiles != null && mappingFiles.size() > 0) {
            Iterator iter2 = mappingFiles.iterator();
            while (iter2.hasNext()) {
                String mappingFileName = (String)iter2.next();
                try {
                    Enumeration files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                    while (files.hasMoreElements()) {
                        FileMetaData filemd;
                        URL url = (URL)files.nextElement();
                        if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                        this.registerFile(url.toString(), filemd, clr);
                        fileMetaData.add(filemd);
                    }
                }
                catch (InvalidMetaDataException imde) {
                    JPOXLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                    exceptions.add(imde);
                }
                catch (IOException ioe) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("MetaDataManager.Initialise.MappingFileReadError", pumd.getName(), mappingFileName, ioe.getMessage()), ioe);
                }
            }
        }
        HashSet<String> classNames = new HashSet<String>();
        if (!this.enhancing && (jarFileNames = pumd.getJarFiles()) != null) {
            Iterator iter3 = jarFileNames.iterator();
            while (iter3.hasNext()) {
                int i;
                String[] jarClassNames;
                Object jarFile = iter3.next();
                if (jarFile instanceof String) {
                    jarClassNames = ClassUtils.getClassNamesForJarFile((String)jarFile);
                    if (jarClassNames == null) continue;
                    for (i = 0; i < jarClassNames.length; ++i) {
                        classNames.add(jarClassNames[i]);
                    }
                    continue;
                }
                if (!(jarFile instanceof URL) || (jarClassNames = ClassUtils.getClassNamesForJarFile((URL)jarFile)) == null) continue;
                for (i = 0; i < jarClassNames.length; ++i) {
                    classNames.add(jarClassNames[i]);
                }
            }
        }
        if (pumd.getClassNames() != null) {
            classNames.addAll(pumd.getClassNames());
        }
        if (classNames.size() > 0 && this.annotationManager != null) {
            iter = classNames.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(className);
                if (cmd != null) continue;
                try {
                    Class cls = clr.classForName(className);
                    FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd == null) continue;
                    fileMetaData.add(filemd);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new JPOXUserException(LOCALISER.msg("MetaDataManager.Initialise.PersistenceUnit.ErrorInitialising", pumd.getName()), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (fileMetaData.size() > 0) {
            FileMetaData filemd;
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.PersistenceUnit.Populating", pumd.getName()));
            }
            iter = fileMetaData.iterator();
            while (iter.hasNext()) {
                filemd = (FileMetaData)iter.next();
                this.populateFileMetaData(filemd, clr, null);
            }
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.PersistenceUnit.Initialising", pumd.getName()));
            }
            iter = fileMetaData.iterator();
            while (iter.hasNext()) {
                filemd = (FileMetaData)iter.next();
                try {
                    this.initialiseFileMetaData(filemd, clr, null);
                }
                catch (Exception e) {
                    JPOXLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                    exceptions.add(e);
                }
            }
            if (exceptions.size() > 0) {
                throw new JPOXUserException(LOCALISER.msg("MetaDataManager.Initialise.PersistenceUnit.ErrorInitialising", pumd.getName()), exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaDataManager.Initialise.PersistenceUnit.Success", pumd.getName()));
        }
        this.initialised = true;
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public void setValidate(boolean validate) {
        this.validateMetaData = validate;
    }

    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    public ApiAdapter getApiAdapter() {
        return this.omfContext.getApiAdapter();
    }

    public void close() {
        this.classMetaDataByClass.clear();
        this.queryMetaDataByName.clear();
        this.sequenceMetaDataByPackageSequence.clear();
        this.tableGeneratorMetaDataByPackageSequence.clear();
        this.queryResultMetaDataByName.clear();
        this.fileMetaDataByURLString.clear();
        this.classesWithoutPersistenceInfo.clear();
        this.classMetaDataByClass = null;
        this.queryMetaDataByName = null;
        this.sequenceMetaDataByPackageSequence = null;
        this.tableGeneratorMetaDataByPackageSequence = null;
        this.fileMetaDataByURLString = null;
        this.classesWithoutPersistenceInfo = null;
    }

    public boolean isEnhancing() {
        return this.enhancing;
    }

    public boolean isClassPersistable(String className) {
        AbstractClassMetaData acmd = this.readMetaDataForClass(className);
        if (acmd == null) {
            return false;
        }
        return acmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    public Collection getClassesWithMetaData() {
        return Collections.unmodifiableCollection(this.classMetaDataByClass.keySet());
    }

    public boolean hasMetaDataForClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return false;
        }
        return this.classMetaDataByClass.get(className) != null;
    }

    protected boolean isClassWithoutPersistenceInfo(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return true;
        }
        return this.classesWithoutPersistenceInfo.contains(className);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(String className, ClassLoaderResolver clr) {
        if (className == null) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return null;
        }
        Class c = null;
        try {
            c = clr == null ? Class.forName(className) : clr.classForName(className, null, false);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (ClassNotResolvedException cnre) {
            // empty catch block
        }
        if (c == null) {
            return null;
        }
        return this.getMetaDataForClass(c, clr);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(Class c, ClassLoaderResolver clr) {
        if (c == null) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(c.getName())) {
            return null;
        }
        AbstractClassMetaData cmd = null;
        cmd = c.isInterface() ? this.getClassMetaDataForImplementationOfPersistentInterface(c.getName()) : this.getMetaDataForClassInternal(c, clr);
        if (cmd != null) {
            if (!cmd.isPopulated()) {
                cmd.populate();
            }
            if (!cmd.isInitialised()) {
                cmd.initialise();
            }
            if (this.utilisedFileMetaData.size() > 0) {
                Iterator iter = this.utilisedFileMetaData.iterator();
                while (iter.hasNext()) {
                    FileMetaData filemd = (FileMetaData)iter.next();
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
            }
        } else if (!c.isInterface()) {
            this.classesWithoutPersistenceInfo.add(c.getName());
        }
        this.utilisedFileMetaData.clear();
        return cmd;
    }

    public synchronized AbstractClassMetaData getMetaDataForEntityName(String entityName) {
        return (AbstractClassMetaData)this.classMetaDataByEntityName.get(entityName);
    }

    public AbstractClassMetaData readMetaDataForClass(String className) {
        return (AbstractClassMetaData)this.classMetaDataByClass.get(className);
    }

    public AbstractMemberMetaData readMetaDataForMember(String className, String memberName) {
        AbstractClassMetaData cmd = this.readMetaDataForClass(className);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public abstract AbstractClassMetaData getMetaDataForClassInternal(Class var1, ClassLoaderResolver var2);

    public String[] getSubclassesForClass(String className, boolean includeDescendents) {
        HashSet subclassNames = new HashSet();
        this.provideSubclassesForClass(className, includeDescendents, subclassNames);
        if (subclassNames.size() > 0) {
            return subclassNames.toArray(new String[subclassNames.size()]);
        }
        return null;
    }

    private void provideSubclassesForClass(String className, boolean includeDescendents, Collection consumer) {
        Collection cmds = this.classMetaDataByClass.values();
        Iterator cmdIter = cmds.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData cmd;
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            if (!(acmd instanceof ClassMetaData) || (cmd = (ClassMetaData)acmd).getPersistenceCapableSuperclass() == null || !cmd.getPersistenceCapableSuperclass().equals(className) || !consumer.add(cmd.getFullClassName()) || !includeDescendents) continue;
            this.provideSubclassesForClass(cmd.getFullClassName(), includeDescendents, consumer);
        }
    }

    public String[] getClassesImplementingInterface(String interfaceName, ClassLoaderResolver clr) {
        HashSet classes = new HashSet();
        Class intfClass = clr.classForName(interfaceName);
        Collection cmds = this.classMetaDataByClass.values();
        Iterator cmdIter = cmds.iterator();
        boolean isPersistentInterface = false;
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            Class implClass = clr.classForName(acmd.getFullClassName());
            if (acmd instanceof ClassMetaData) {
                if (!acmd.isInitialised()) {
                    acmd.initialise();
                }
                if (!intfClass.isAssignableFrom(implClass) || ((ClassMetaData)acmd).isAbstractPersistenceCapable()) continue;
                classes.add(implClass);
                continue;
            }
            if (!(acmd instanceof InterfaceMetaData) || !intfClass.isAssignableFrom(implClass)) continue;
            isPersistentInterface = true;
        }
        if (isPersistentInterface) {
            classes.add(this.omfContext.getImplementationCreator().newInstance(intfClass, this, clr).getClass());
            String[] classNames = new String[classes.size()];
            Iterator iter = classes.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        if (classes.size() > 0) {
            TreeSet classesSorted = new TreeSet(new InterfaceClassComparator());
            Iterator classesIter = classes.iterator();
            while (classesIter.hasNext()) {
                classesSorted.add(classesIter.next());
            }
            String[] classNames = new String[classesSorted.size()];
            Iterator iter = classesSorted.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        return null;
    }

    void addORMDataToClass(Class c, ClassLoaderResolver clr) {
    }

    void addAnnotationsDataToClass(Class c, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        ClassMetaData annotCmd;
        if (cmd.getPackageMetaData() != null && cmd.getPackageMetaData().getFileMetaData() != null && cmd.getPackageMetaData().getFileMetaData().getType() == 4) {
            return;
        }
        FileMetaData filemd = this.loadAnnotationsForClass(c, clr, false, false);
        if (filemd != null && (annotCmd = filemd.getPackage(0).getClass(0)) != null) {
            MetaDataMerger.mergeClassAnnotationsData(cmd, annotCmd);
        }
    }

    public ClassMetaData getMetaDataForImplementationOfReference(Class referenceClass, Object implValue, ClassLoaderResolver clr) {
        if (referenceClass == null || !referenceClass.isInterface() && referenceClass != (class$java$lang$Object == null ? (class$java$lang$Object = MetaDataManager.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        ClassMetaData intfMetaData = this.getClassMetaDataForImplementationOfPersistentInterface(referenceClass.getName());
        if (intfMetaData != null) {
            return intfMetaData;
        }
        ClassMetaData cmd = null;
        Set classMetaDataClasses = this.classMetaDataByClass.keySet();
        Iterator classMetaDataClassesIter = classMetaDataClasses.iterator();
        block2: while (classMetaDataClassesIter.hasNext()) {
            String class_name = (String)classMetaDataClassesIter.next();
            AbstractClassMetaData acmd_cls = (AbstractClassMetaData)this.classMetaDataByClass.get(class_name);
            if (!(acmd_cls instanceof ClassMetaData)) continue;
            try {
                Class<?> cls = referenceClass.getClassLoader().loadClass(class_name);
                if (!referenceClass.isAssignableFrom(cls)) continue;
                cmd = (ClassMetaData)acmd_cls;
                if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) {
                    return cmd;
                }
                AbstractClassMetaData cmd_superclass = cmd.getSuperAbstractClassMetaData();
                while (cmd_superclass != null && referenceClass.isAssignableFrom(clr.classForName(((ClassMetaData)cmd_superclass).getFullClassName()))) {
                    cmd = (ClassMetaData)cmd_superclass;
                    if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) continue block2;
                    if ((cmd_superclass = cmd_superclass.getSuperAbstractClassMetaData()) != null) continue;
                }
            }
            catch (Exception e) {}
        }
        return cmd;
    }

    public AbstractMemberMetaData getMetaDataForMember(String className, String memberName, ClassLoaderResolver clr) {
        if (className == null || memberName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(className, clr);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public AbstractMemberMetaData getMetaDataForMember(Class c, ClassLoaderResolver clr, String memberName) {
        if (c == null || memberName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(c, clr);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return (QueryMetaData)this.queryMetaDataByName.get(query_key);
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String seqName) {
        if (seqName == null) {
            return null;
        }
        return (SequenceMetaData)this.sequenceMetaDataByPackageSequence.get(seqName);
    }

    public TableGeneratorMetaData getMetaDataForTableGenerator(ClassLoaderResolver clr, String genName) {
        if (genName == null) {
            return null;
        }
        return (TableGeneratorMetaData)this.tableGeneratorMetaDataByPackageSequence.get(genName);
    }

    public QueryResultMetaData getMetaDataForQueryResult(String name) {
        if (name == null) {
            return null;
        }
        return (QueryResultMetaData)this.queryResultMetaDataByName.get(name);
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        return null;
    }

    public boolean isPersistentInterface(String name) {
        return false;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        return false;
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        return null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return null;
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
    }

    public PersistenceUnitMetaData getMetaDataForPersistenceUnit(String unitName) {
        PersistenceFileMetaData[] files = this.parsePersistenceFiles();
        if (files == null) {
            throw new JPOXUserException(LOCALISER.msg("MetaData.Persistence.NoPersistenceFiles"));
        }
        for (int i = 0; i < files.length; ++i) {
            PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
            for (int j = 0; j < unitmds.length; ++j) {
                if (!unitmds[j].getName().equals(unitName)) continue;
                return unitmds[j];
            }
        }
        return null;
    }

    public PersistenceFileMetaData[] parsePersistenceFiles() {
        HashSet<MetaData> metadata = new HashSet<MetaData>();
        try {
            Enumeration<URL> files = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            if (!files.hasMoreElements()) {
                return null;
            }
            this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
            while (files.hasMoreElements()) {
                URL fileURL = files.nextElement();
                MetaData permd = this.metaDataParser.parseMetaDataURL(fileURL, "persistence");
                metadata.add(permd);
            }
        }
        catch (IOException ioe) {
            JPOXLogger.METADATA.warn(StringUtils.getStringFromStackTrace(ioe));
        }
        return metadata.toArray(new PersistenceFileMetaData[metadata.size()]);
    }

    protected abstract FileMetaData parseFile(URL var1);

    public abstract void registerFile(String var1, FileMetaData var2, ClassLoaderResolver var3);

    protected void registerSequencesForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            SequenceMetaData[] seqmds = pmd.getSequences();
            if (seqmds == null) continue;
            for (int j = 0; j < seqmds.length; ++j) {
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getFullyQualifiedName(), seqmds[j]);
            }
        }
    }

    protected void registerTableGeneratorsForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            TableGeneratorMetaData[] tgmds = pmd.getTableGenerators();
            if (tgmds == null) continue;
            for (int j = 0; j < tgmds.length; ++j) {
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getFullyQualifiedName(), tgmds[j]);
            }
        }
    }

    protected void registerQueryResultMetaDataForFile(FileMetaData filemd) {
        int i;
        QueryResultMetaData[] fqrmds = filemd.getQueryResultMetaData();
        if (fqrmds != null) {
            for (i = 0; i < fqrmds.length; ++i) {
                this.queryResultMetaDataByName.put(fqrmds[i].getName(), fqrmds[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryResultMetaData[] qrmds = cmd.getQueryResultMetaData();
                if (qrmds == null) continue;
                for (int k = 0; k < qrmds.length; ++k) {
                    this.queryResultMetaDataByName.put(qrmds[k].getName(), qrmds[k]);
                }
            }
        }
    }

    protected void registerQueriesForFile(FileMetaData filemd) {
        int i;
        QueryMetaData[] queries = filemd.getQueries();
        if (queries != null) {
            for (i = 0; i < queries.length; ++i) {
                String scope = queries[i].getScope();
                String key = queries[i].getName();
                if (scope != null) {
                    key = scope + "_" + key;
                }
                this.queryMetaDataByName.put(key, queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            String key;
            String scope;
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryMetaData[] classQueries = cmd.getQueries();
                if (classQueries == null) continue;
                for (k = 0; k < classQueries.length; ++k) {
                    scope = classQueries[k].getScope();
                    key = classQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, classQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                QueryMetaData[] interfaceQueries = intfmd.getQueries();
                if (interfaceQueries == null) continue;
                for (k = 0; k < interfaceQueries.length; ++k) {
                    scope = interfaceQueries[k].getScope();
                    key = interfaceQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, interfaceQueries[k]);
                }
            }
        }
    }

    protected void populateFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            AbstractClassMetaData cmd;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                cmd = pmd.getClass(j);
                if (cmd.isPopulated() || cmd.isInitialised()) continue;
                cmd.populate(clr, primary);
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                cmd = pmd.getInterface(j);
                if (cmd.isPopulated() || cmd.isInitialised()) continue;
                cmd.populate(clr, primary);
            }
        }
    }

    protected void initialiseFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                try {
                    this.initialiseClassMetaData(cmd, clr.classForName(cmd.getFullClassName(), primary), clr);
                    continue;
                }
                catch (JPOXException jpex) {
                    throw jpex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                try {
                    this.initialiseInterfaceMetaData(imd, clr, primary);
                    continue;
                }
                catch (JPOXException jpex) {
                    throw jpex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseClassMetaData(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        ClassMetaData classMetaData = cmd;
        synchronized (classMetaData) {
            if (!this.enhancing && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE && !this.getOMFContext().getApiAdapter().isPersistable(cls)) {
                throw new JPOXUserException(LOCALISER.msg("MetaData.Class.NotEnhancedError", cls.getName()));
            }
            if (!cmd.isPopulated() && !cmd.isInitialised()) {
                cmd.populate(clr, cls.getClassLoader());
            }
            if (!cmd.isInitialised()) {
                cmd.initialise();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseInterfaceMetaData(InterfaceMetaData imd, ClassLoaderResolver clr, ClassLoader primary) {
        InterfaceMetaData interfaceMetaData = imd;
        synchronized (interfaceMetaData) {
            if (!imd.isPopulated() && !imd.isInitialised()) {
                imd.populate(clr, primary);
            }
            if (!imd.isInitialised()) {
                imd.initialise();
            }
        }
    }

    protected FileMetaData loadAnnotationsForClass(Class cls, ClassLoaderResolver clr, boolean register, boolean populate) {
        if (this.annotationManager != null) {
            if (this.isClassWithoutPersistenceInfo(cls.getName())) {
                return null;
            }
            String clsPackageName = ClassUtils.getPackageNameForClass(cls);
            if (clsPackageName == null) {
                return null;
            }
            FileMetaData filemd = new FileMetaData(null, this, null, null);
            filemd.setType(4);
            PackageMetaData pmd = new PackageMetaData(filemd, clsPackageName, null, null);
            filemd.addPackage(pmd);
            AbstractClassMetaData cmd = this.annotationManager.getMetaDataForClass(cls, pmd, clr);
            if (cmd != null) {
                if (register) {
                    this.registerFile("annotations:" + cls.getName(), filemd, clr);
                    if (populate) {
                        this.populateFileMetaData(filemd, clr, cls.getClassLoader());
                    }
                }
                return filemd;
            }
        }
        return null;
    }

    public List getReferencedClassMetaData(AbstractClassMetaData cmd, String dba_vendor_id, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        ArrayList orderedCMDs = new ArrayList();
        HashSet referencedCMDs = new HashSet();
        cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        return orderedCMDs;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void setEnhancing() {
        this.enhancing = true;
    }

    public void unsetEnhancing() {
        this.enhancing = false;
    }

    public MetaDataFactory getMetaDataFactory() {
        if (this.metaDataFactory == null) {
            this.metaDataFactory = new DefaultMetaDataFactory();
        }
        return this.metaDataFactory;
    }

    public void setMetaDataFactory(MetaDataFactory factory) {
        this.metaDataFactory = factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MetaDataRegisterClassListener
    implements RegisterClassListener {
        private MetaDataRegisterClassListener() {
        }

        public void registerClass(RegisterClassEvent arg0) {
            MetaDataManager.this.getMetaDataForClassInternal(arg0.getRegisteredClass(), MetaDataManager.this.omfContext.getClassLoaderResolver(arg0.getRegisteredClass().getClassLoader()));
        }
    }

    private class InterfaceClassComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || o2 == null) {
                return Integer.MIN_VALUE;
            }
            Class cls1 = (Class)o1;
            Class cls2 = (Class)o2;
            return cls1.hashCode() - cls2.hashCode();
        }
    }
}

