/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.IndexedValue;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.util.StringUtils;

public class OrderMetaData
extends MetaData
implements ColumnMetaDataContainer {
    final String columnName;
    final List columns = new ArrayList();
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected final String mappedBy;
    protected String ordering;
    protected FieldOrder[] fieldOrders = null;
    protected ColumnMetaData[] columnMetaData;

    public OrderMetaData(MetaData parent, OrderMetaData omd) {
        super(parent);
        this.indexed = omd.indexed;
        this.columnName = omd.columnName;
        if (omd.indexMetaData != null) {
            this.indexMetaData = omd.indexMetaData;
        }
        for (int i = 0; i < omd.columns.size(); ++i) {
            this.addColumn((ColumnMetaData)omd.columns.get(i));
        }
        this.mappedBy = omd.mappedBy;
        this.ordering = omd.ordering;
    }

    public OrderMetaData(String column, String indexed, String mappedBy) {
        super(null);
        this.columnName = StringUtils.isWhitespace(column) ? null : column;
        this.indexed = IndexedValue.getIndexedValue(indexed);
        this.mappedBy = StringUtils.isWhitespace(mappedBy) ? null : mappedBy;
        this.ordering = null;
    }

    public OrderMetaData(String ordering) {
        super(null);
        this.columnName = null;
        this.mappedBy = null;
        this.ordering = StringUtils.isWhitespace(ordering) ? null : ordering;
    }

    public void initialise() {
        AbstractClassMetaData elementCmd;
        AbstractMemberMetaData fmd;
        String val;
        if (this.hasExtension("list-ordering") && !StringUtils.isWhitespace(val = this.getValueForExtension("list-ordering"))) {
            this.ordering = val;
        }
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        if (this.columns.size() == 0 && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData((MetaData)this, this.columnName);
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData(null, null, this.indexed == IndexedValue.UNIQUE ? "true" : "false");
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.mappedBy != null) {
            fmd = (AbstractMemberMetaData)this.parent;
            elementCmd = fmd.getCollection().element.classMetaData;
            if (elementCmd != null && !elementCmd.hasMember(this.mappedBy)) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Collection.OrderMappedByInvalid", (Object)fmd.getFullFieldName(), (Object)elementCmd.getFullClassName(), this.mappedBy);
            }
        }
        if (this.ordering != null) {
            fmd = (AbstractMemberMetaData)this.parent;
            elementCmd = fmd.getCollection().element.classMetaData;
            if (this.ordering.equals("#PK")) {
                this.fieldOrders = new FieldOrder[elementCmd.getNoOfPrimaryKeyMembers()];
                String[] pkFieldNames = elementCmd.getPrimaryKeyMemberNames();
                int i = 0;
                for (int pkFieldNum = 0; pkFieldNum < this.fieldOrders.length; ++pkFieldNum) {
                    this.fieldOrders[i++] = new FieldOrder(pkFieldNames[pkFieldNum]);
                }
            } else {
                StringTokenizer tokeniser = new StringTokenizer(this.ordering, ",");
                int num = tokeniser.countTokens();
                this.fieldOrders = new FieldOrder[num];
                int i = 0;
                while (tokeniser.hasMoreTokens()) {
                    String nextToken = tokeniser.nextToken().trim();
                    String fieldName = null;
                    boolean forward = true;
                    int spacePos = nextToken.indexOf(32);
                    if (spacePos > 0) {
                        fieldName = nextToken.substring(0, spacePos);
                        String direction = nextToken.substring(spacePos + 1).trim();
                        if (direction.equalsIgnoreCase("DESC")) {
                            forward = false;
                        } else if (!direction.equalsIgnoreCase("ASC")) {
                            throw new InvalidMetaDataException(LOCALISER, "MetaData.Collection.OrderOrderingDirectionInvalid", (Object)fmd.getFullFieldName(), direction);
                        }
                    } else {
                        fieldName = nextToken;
                    }
                    if (elementCmd != null && !elementCmd.hasMember(fieldName)) {
                        throw new InvalidMetaDataException(LOCALISER, "MetaData.Collection.OrderOrderingFieldInvalid", (Object)fmd.getFullFieldName(), (Object)elementCmd.getFullClassName(), fieldName);
                    }
                    this.fieldOrders[i] = new FieldOrder(fieldName);
                    if (!forward) {
                        this.fieldOrders[i].setBackward();
                    }
                    ++i;
                }
            }
        }
        this.setInitialised();
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public boolean isIndexedList() {
        return this.fieldOrders == null;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public FieldOrder[] getFieldOrders() {
        return this.fieldOrders;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<order");
        if (this.columnName != null) {
            sb.append(" column=\"" + this.columnName + "\"");
        }
        if (this.indexed != null) {
            sb.append(" indexed=\"" + this.indexed.toString() + "\"");
        }
        if (this.mappedBy != null) {
            sb.append(" mapped-by=\"" + this.mappedBy + "\"");
        }
        sb.append(">\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnMetaData c = (ColumnMetaData)this.columns.get(i);
            sb.append(c.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</order>\n");
        return sb.toString();
    }

    public static class FieldOrder {
        String fieldName;
        boolean forward = true;

        public FieldOrder(String name) {
            this.fieldName = name;
        }

        public void setBackward() {
            this.forward = false;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean isForward() {
            return this.forward;
        }
    }
}

