/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.QueryLanguage;
import org.jpox.util.StringUtils;

public class QueryMetaData
extends MetaData {
    protected String scope;
    protected final String name;
    protected QueryLanguage language;
    protected boolean unmodifiable = false;
    protected String query;
    protected String resultClass = null;
    protected String resultMetaDataName = null;
    protected boolean unique = false;

    public QueryMetaData(MetaData parent, String scope, String name, String language, String unmodifiable, String resultClass, String resultMetaDataName, String unique) {
        super(parent);
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Query.QueryNameNotSpecifiedError");
        }
        this.scope = StringUtils.isWhitespace(scope) ? null : scope;
        this.name = name;
        this.unmodifiable = unmodifiable != null && unmodifiable.equalsIgnoreCase("true");
        this.language = QueryLanguage.getQueryLanguage(language);
        this.resultClass = StringUtils.isWhitespace(resultClass) ? null : resultClass;
        this.resultMetaDataName = resultMetaDataName;
        if (unique != null && unique.equalsIgnoreCase("true")) {
            this.unique = true;
        }
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public QueryLanguage getLanguage() {
        return this.language;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public String getQuery() {
        return this.query;
    }

    public String getResultClass() {
        return this.resultClass;
    }

    public String getResultMetaDataName() {
        return this.resultMetaDataName;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<query name=\"" + this.name + "\"\n");
        sb.append(prefix).append("       language=\"" + this.language + "\"\n");
        if (this.unique) {
            sb.append(prefix).append("       unique=\"true\"\n");
        }
        if (this.resultClass != null) {
            sb.append(prefix).append("       result-class=\"" + this.resultClass + "\"\n");
        }
        sb.append(prefix).append("       unmodifiable=\"" + this.unmodifiable + "\">\n");
        sb.append(prefix).append(this.query).append("\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</query>\n");
        return sb.toString();
    }
}

