/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.SequenceStrategy;
import org.jpox.util.StringUtils;

public class SequenceMetaData
extends MetaData {
    protected final String name;
    protected String datastoreSequence;
    protected String factoryClass;
    protected SequenceStrategy strategy;
    protected long initialValue = 1L;
    protected long allocationSize = 50L;

    public SequenceMetaData(MetaData parent, String name, String datastoreSequence, String factoryClass, String strategyValue, String initialValue, String allocationSize) {
        super(parent);
        this.name = name;
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Sequence.SequenceNameNotSpecifiedError");
        }
        this.datastoreSequence = StringUtils.isWhitespace(datastoreSequence) ? null : datastoreSequence;
        this.factoryClass = factoryClass;
        this.strategy = SequenceStrategy.getStrategy(strategyValue);
        if (!StringUtils.isWhitespace(initialValue)) {
            this.initialValue = new Long(initialValue);
        }
        if (!StringUtils.isWhitespace(allocationSize)) {
            this.allocationSize = new Long(allocationSize);
        }
    }

    public String getFullyQualifiedName() {
        PackageMetaData pmd = (PackageMetaData)this.getParent();
        return pmd.getName() + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public SequenceStrategy getStrategy() {
        return this.strategy;
    }

    public String getDatastoreSequence() {
        return this.datastoreSequence;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<sequence name=\"" + this.name + "\"\n");
        if (this.datastoreSequence != null) {
            sb.append(prefix).append("       datastore-sequence=\"" + this.datastoreSequence + "\"\n");
        }
        if (this.factoryClass != null) {
            sb.append(prefix).append("       factory-class=\"" + this.factoryClass + "\"\n");
        }
        sb.append(prefix).append("       strategy=\"" + this.strategy.toString() + "\">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</sequence>\n");
        return sb.toString();
    }
}

