/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.AbstractConstraintMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;

public class UniqueMetaData
extends AbstractConstraintMetaData
implements ColumnMetaDataContainer {
    final boolean deferred;

    public UniqueMetaData(UniqueMetaData umd) {
        super(null, umd.name, umd.table);
        int i;
        this.deferred = umd.deferred;
        for (i = 0; i < umd.members.size(); ++i) {
            this.addMember((AbstractMemberMetaData)umd.members.get(i));
        }
        for (i = 0; i < umd.columns.size(); ++i) {
            this.addColumn((ColumnMetaData)umd.columns.get(i));
        }
    }

    public UniqueMetaData(String name, String table, String deferredValue) {
        super(null, name, table);
        this.deferred = deferredValue != null && deferredValue.equalsIgnoreCase("true");
    }

    public void initialise() {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.members.size() == 0) {
            this.memberMetaData = null;
        } else {
            this.memberMetaData = new AbstractMemberMetaData[this.members.size()];
            for (i = 0; i < this.memberMetaData.length; ++i) {
                this.memberMetaData[i] = (AbstractMemberMetaData)this.members.get(i);
                this.memberMetaData[i].initialise();
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.members.clear();
        this.members = null;
        this.columns.clear();
        this.columns = null;
        this.setInitialised();
    }

    public final boolean isDeferred() {
        return this.deferred;
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<unique");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.deferred) {
            sb.append(" deferred=\"true\"");
        }
        sb.append(this.name != null ? " name=\"" + this.name + "\">\n" : ">\n");
        if (this.memberMetaData != null) {
            for (i = 0; i < this.memberMetaData.length; ++i) {
                sb.append(this.memberMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.columnMetaData != null) {
            for (i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</unique>\n");
        return sb.toString();
    }
}

