/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.IndexedValue;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.util.StringUtils;

public class VersionMetaData
extends MetaData {
    private final VersionStrategy versionStrategy;
    private String columnName;
    protected final List columns = new ArrayList();
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected String fieldName = null;
    protected ColumnMetaData[] columnMetaData;

    public VersionMetaData(String versionStrategy, String columnName, String indexed) {
        super(null);
        if (StringUtils.isWhitespace(versionStrategy) || VersionStrategy.getVersionStrategy(versionStrategy) == null) {
            throw new RuntimeException(LOCALISER.msg("MetaData.Version.StrategyNotSpecifiedError"));
        }
        this.versionStrategy = VersionStrategy.getVersionStrategy(versionStrategy);
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
        this.indexed = IndexedValue.getIndexedValue(indexed);
    }

    public VersionMetaData(String versionStrategy, String fieldName) {
        super(null);
        if (StringUtils.isWhitespace(versionStrategy) || VersionStrategy.getVersionStrategy(versionStrategy) == null) {
            throw new RuntimeException(LOCALISER.msg("MetaData.Version.StrategyNotSpecifiedError"));
        }
        this.versionStrategy = VersionStrategy.getVersionStrategy(versionStrategy);
        this.fieldName = StringUtils.isWhitespace(fieldName) ? null : fieldName;
    }

    public void initialise() {
        String val;
        if (this.hasExtension("field-name") && !StringUtils.isWhitespace(val = this.getValueForExtension("field-name"))) {
            this.fieldName = val;
            this.columnName = null;
        }
        if (this.fieldName == null) {
            if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
                this.indexMetaData = new IndexMetaData(null, null, this.indexed == IndexedValue.UNIQUE ? "true" : "false");
                for (int i = 0; i < this.columnMetaData.length; ++i) {
                    this.indexMetaData.addColumn(this.columnMetaData[i]);
                }
            }
            if (this.indexMetaData != null) {
                this.indexMetaData.initialise();
            }
            if (this.columns.size() == 0 && this.columnName != null) {
                this.columnMetaData = new ColumnMetaData[1];
                this.columnMetaData[0] = new ColumnMetaData((MetaData)this, this.columnName);
            } else {
                this.columnMetaData = new ColumnMetaData[this.columns.size()];
                for (int i = 0; i < this.columnMetaData.length; ++i) {
                    this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                    this.columnMetaData[i].initialise();
                }
            }
        }
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final VersionStrategy getVersionStrategy() {
        return this.versionStrategy;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
        }
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<version strategy=\"" + this.versionStrategy.toString() + "\"" + (this.indexed != null ? " indexed=\"" + this.indexed.toString() + "\"" : "") + ">\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnMetaData c = (ColumnMetaData)this.columns.get(i);
            sb.append(c.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</version>\n");
        return sb.toString();
    }
}

