/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata.xml;

import java.io.IOException;
import java.util.Stack;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AbstractMetaDataHandler
extends DefaultHandler {
    protected static Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    protected final MetaDataManager mgr;
    protected final String filename;
    protected MetaData metadata;
    protected final EntityResolver entityResolver;
    protected StringBuffer charactersBuffer = new StringBuffer();
    protected Stack stack = new Stack();

    public AbstractMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        this.mgr = mgr;
        this.filename = filename;
        this.entityResolver = resolver;
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    public void error(SAXParseException e) throws SAXException {
        if (e.getColumnNumber() >= 0) {
            JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.Parser.ColumnError", this.filename, "" + e.getLineNumber(), "" + e.getColumnNumber(), e.getMessage()));
        } else {
            JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.Parser.LineError", this.filename, "" + e.getLineNumber(), e.getMessage()));
        }
    }

    protected String getAttr(Attributes attrs, String key, String defaultValue) {
        String result = attrs.getValue(key);
        if (result == null) {
            return defaultValue;
        }
        if (result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    protected String getAttr(Attributes attrs, String key) {
        return this.getAttr(attrs, key, null);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource source = null;
        if (this.entityResolver != null) {
            try {
                source = this.entityResolver.resolveEntity(publicId, systemId);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (source == null) {
            // empty if block
        }
        return source;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charactersBuffer.append(ch, start, length);
    }

    public String getString() {
        String result = this.charactersBuffer.toString();
        this.charactersBuffer = new StringBuffer();
        return result;
    }

    protected MetaData getStack() {
        Object o = this.stack.lastElement();
        if (o != null) {
            return (MetaData)o;
        }
        return null;
    }

    protected MetaData popStack() {
        return (MetaData)this.stack.pop();
    }

    protected void pushStack(MetaData md) {
        this.stack.push(md);
    }
}

