/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata.xml;

import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractElementMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ArrayMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.ElementMetaData;
import org.jpox.metadata.EmbeddedMetaData;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityMetaData;
import org.jpox.metadata.ImplementsMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.KeyMetaData;
import org.jpox.metadata.MapMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.OrderMetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.metadata.ValueMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.metadata.xml.AbstractMetaDataHandler;
import org.jpox.util.JPOXLogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JDOMetaDataHandler
extends AbstractMetaDataHandler {
    public JDOMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData(filename, mgr, null, null);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs) {
        return this.mgr.getMetaDataFactory().newClassObject(pmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "identity-type"), this.getAttr(attrs, "objectid-class"), this.getAttr(attrs, "requires-extent"), this.getAttr(attrs, "detachable"), this.getAttr(attrs, "embedded-only"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "persistence-capable-superclass"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "table"), null);
    }

    protected FieldMetaData newFieldObject(MetaData md, Attributes attrs) {
        return this.mgr.getMetaDataFactory().newFieldObject(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "primary-key"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "default-fetch-group"), this.getAttr(attrs, "null-value"), this.getAttr(attrs, "embedded"), this.getAttr(attrs, "serialized"), this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), this.getAttr(attrs, "column"), this.getAttr(attrs, "table"), null, null, this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "recursion-depth"), this.getAttr(attrs, "load-fetch-group"), this.getAttr(attrs, "value-strategy"), this.getAttr(attrs, "sequence"), this.getAttr(attrs, "field-type"));
    }

    protected PropertyMetaData newPropertyObject(MetaData md, Attributes attrs) {
        return this.mgr.getMetaDataFactory().newPropertyObject(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "primary-key"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "default-fetch-group"), this.getAttr(attrs, "null-value"), this.getAttr(attrs, "embedded"), this.getAttr(attrs, "serialized"), this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), this.getAttr(attrs, "column"), this.getAttr(attrs, "table"), null, null, this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "recursion-depth"), this.getAttr(attrs, "load-fetch-group"), this.getAttr(attrs, "value-strategy"), this.getAttr(attrs, "sequence"), this.getAttr(attrs, "field-type"), this.getAttr(attrs, "field-name"));
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block125: {
            if (this.charactersBuffer.length() > 0) {
                String currentString = this.getString().trim();
                if (this.getStack() instanceof QueryMetaData) {
                    ((QueryMetaData)this.getStack()).setQuery(currentString.trim());
                }
            }
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.StartElement", sb.toString(), "" + this.stack.size()));
            }
            try {
                AbstractMemberMetaData fmd;
                MetaData emd;
                MetaData parent;
                AbstractClassMetaData cmd;
                MetaData md;
                PackageMetaData pmd;
                FileMetaData filemd;
                if (qName.equals("jdo")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(1);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block125;
                }
                if (qName.equals("orm")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(2);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block125;
                }
                if (qName.equals("jdoquery")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(3);
                    break block125;
                }
                if (qName.equals("package")) {
                    filemd = (FileMetaData)this.getStack();
                    PackageMetaData pmd2 = new PackageMetaData(filemd, this.getAttr(attrs, "name"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"));
                    ((FileMetaData)this.metadata).addPackage(pmd2);
                    this.pushStack(pmd2);
                    break block125;
                }
                if (qName.equals("class")) {
                    pmd = (PackageMetaData)this.getStack();
                    ClassMetaData cmd2 = this.newClassObject(pmd, attrs);
                    pmd.addClass(cmd2);
                    this.pushStack(cmd2);
                    break block125;
                }
                if (qName.equals("interface")) {
                    pmd = (PackageMetaData)this.getStack();
                    InterfaceMetaData imd = this.mgr.getMetaDataFactory().newInterfaceObject(pmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "identity-type"), this.getAttr(attrs, "objectid-class"), this.getAttr(attrs, "requires-extent"), this.getAttr(attrs, "detachable"), this.getAttr(attrs, "embedded-only"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "table"), null);
                    pmd.addInterface(imd);
                    this.pushStack(imd);
                    break block125;
                }
                if (qName.equals("primary-key")) {
                    md = this.getStack();
                    PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "column"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).setPrimaryKeyMetaData(pkmd);
                    } else if (md instanceof JoinMetaData) {
                        ((JoinMetaData)md).setPrimaryKeyMetaData(pkmd);
                    }
                    this.pushStack(pkmd);
                    break block125;
                }
                if (qName.equals("implements")) {
                    cmd = (ClassMetaData)this.getStack();
                    ImplementsMetaData imd = new ImplementsMetaData((ClassMetaData)cmd, this.getAttr(attrs, "name"));
                    ((ClassMetaData)cmd).addImplements(imd);
                    this.pushStack(imd);
                    break block125;
                }
                if (qName.equals("property")) {
                    parent = this.getStack();
                    if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(acmd, attrs);
                        acmd.addMember(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd2 = (EmbeddedMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(emd2, attrs);
                        emd2.addMember(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof ImplementsMetaData) {
                        ImplementsMetaData implmd = (ImplementsMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(implmd, attrs);
                        implmd.addProperty(propmd);
                        this.pushStack(propmd);
                    }
                    break block125;
                }
                if (qName.equals("datastore-identity")) {
                    AbstractClassMetaData acmd = (AbstractClassMetaData)this.getStack();
                    IdentityMetaData imd = new IdentityMetaData(acmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "strategy"), this.getAttr(attrs, "sequence"));
                    acmd.setIdentityMetaData(imd);
                    this.pushStack(imd);
                    break block125;
                }
                if (qName.equals("inheritance")) {
                    parent = this.getStack();
                    AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                    InheritanceMetaData imd = new InheritanceMetaData(acmd, this.getAttr(attrs, "strategy"));
                    acmd.setInheritanceMetaData(imd);
                    this.pushStack(imd);
                    break block125;
                }
                if (qName.equals("discriminator")) {
                    InheritanceMetaData imd = (InheritanceMetaData)this.getStack();
                    DiscriminatorMetaData dismd = new DiscriminatorMetaData(imd, this.getAttr(attrs, "column"), this.getAttr(attrs, "value"), this.getAttr(attrs, "strategy"), this.getAttr(attrs, "indexed"));
                    imd.setDiscriminatorMetaData(dismd);
                    this.pushStack(dismd);
                    break block125;
                }
                if (qName.equals("query")) {
                    QueryMetaData qmd = new QueryMetaData(emd, (emd = this.getStack()) instanceof ClassMetaData ? ((ClassMetaData)emd).getFullClassName() : null, this.getAttr(attrs, "name"), this.getAttr(attrs, "language"), this.getAttr(attrs, "unmodifiable"), this.getAttr(attrs, "result-class"), null, this.getAttr(attrs, "unique"));
                    if (emd instanceof ClassMetaData) {
                        ClassMetaData cmd3 = (ClassMetaData)emd;
                        cmd3.addQuery(qmd);
                    } else if (emd instanceof FileMetaData) {
                        FileMetaData fmd2 = (FileMetaData)emd;
                        fmd2.addQuery(qmd);
                    }
                    this.pushStack(qmd);
                    break block125;
                }
                if (qName.equals("sequence")) {
                    emd = this.getStack();
                    SequenceMetaData seqmd = new SequenceMetaData(emd, this.getAttr(attrs, "name"), this.getAttr(attrs, "datastore-sequence"), this.getAttr(attrs, "factory-class"), this.getAttr(attrs, "strategy"), null, null);
                    if (emd instanceof PackageMetaData) {
                        PackageMetaData pmd3 = (PackageMetaData)emd;
                        pmd3.addSequence(seqmd);
                    }
                    this.pushStack(seqmd);
                    break block125;
                }
                if (qName.equals("field")) {
                    md = this.getStack();
                    FieldMetaData fmd3 = this.newFieldObject(md, attrs);
                    if (md instanceof ClassMetaData) {
                        ClassMetaData cmd4 = (ClassMetaData)md;
                        cmd4.addMember(fmd3);
                    } else if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)md;
                        fgmd.addMember(fmd3);
                    } else if (md instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd3 = (EmbeddedMetaData)md;
                        emd3.addMember(fmd3);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addMember(fmd3);
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData imd = (IndexMetaData)md;
                        imd.addMember(fmd3);
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData umd = (UniqueMetaData)md;
                        umd.addMember(fmd3);
                    }
                    this.pushStack(fmd3);
                    break block125;
                }
                if (qName.equals("join")) {
                    parent = this.getStack();
                    JoinMetaData jnmd = new JoinMetaData(parent, this.getAttr(attrs, "table"), null, null, this.getAttr(attrs, "column"), this.getAttr(attrs, "outer"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"));
                    if (parent instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd4 = (AbstractMemberMetaData)parent;
                        fmd4.setJoinMetaData(jnmd);
                    } else if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd5 = (AbstractClassMetaData)parent;
                        cmd5.addJoin(jnmd);
                    } else if (parent instanceof InheritanceMetaData) {
                        InheritanceMetaData imd = (InheritanceMetaData)parent;
                        imd.setJoinMetaData(jnmd);
                    }
                    this.pushStack(jnmd);
                    break block125;
                }
                if (qName.equals("map")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    MapMetaData map = new MapMetaData(fmd, this.getAttr(attrs, "key-type"), this.getAttr(attrs, "embedded-key"), this.getAttr(attrs, "dependent-key"), this.getAttr(attrs, "serialized-key"), this.getAttr(attrs, "value-type"), this.getAttr(attrs, "embedded-value"), this.getAttr(attrs, "dependent-value"), this.getAttr(attrs, "serialized-value"));
                    fmd.setContainer(map);
                    this.pushStack(map);
                    break block125;
                }
                if (qName.equals("array")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ArrayMetaData amd = new ArrayMetaData(fmd, this.getAttr(attrs, "element-type"), this.getAttr(attrs, "embedded-element"), this.getAttr(attrs, "dependent-element"), this.getAttr(attrs, "serialized-element"));
                    fmd.setContainer(amd);
                    this.pushStack(amd);
                    break block125;
                }
                if (qName.equals("collection")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    CollectionMetaData colmd = new CollectionMetaData(fmd, this.getAttr(attrs, "element-type"), this.getAttr(attrs, "embedded-element"), this.getAttr(attrs, "dependent-element"), this.getAttr(attrs, "serialized-element"));
                    fmd.setContainer(colmd);
                    this.pushStack(colmd);
                    break block125;
                }
                if (qName.equals("column")) {
                    md = this.getStack();
                    ColumnMetaData clnmd = new ColumnMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "target"), this.getAttr(attrs, "target-field"), this.getAttr(attrs, "jdbc-type"), this.getAttr(attrs, "sql-type"), this.getAttr(attrs, "length"), this.getAttr(attrs, "scale"), this.getAttr(attrs, "allows-null"), this.getAttr(attrs, "default-value"), this.getAttr(attrs, "insert-value"), null, null, null);
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd5 = (AbstractMemberMetaData)md;
                        fmd5.addColumn(clnmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elemd = (AbstractElementMetaData)md;
                        elemd.addColumn(clnmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jnmd = (JoinMetaData)md;
                        jnmd.addColumn(clnmd);
                    } else if (md instanceof IdentityMetaData) {
                        IdentityMetaData idmd = (IdentityMetaData)md;
                        idmd.addColumn(clnmd);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addColumn(clnmd);
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData idxmd = (IndexMetaData)md;
                        idxmd.addColumn(clnmd);
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData unimd = (UniqueMetaData)md;
                        unimd.addColumn(clnmd);
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData ormd = (OrderMetaData)md;
                        ormd.addColumn(clnmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setColumnMetaData(clnmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.addColumn(clnmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd6 = (AbstractClassMetaData)md;
                        cmd6.addUnmappedColumn(clnmd);
                    } else if (md instanceof PrimaryKeyMetaData) {
                        PrimaryKeyMetaData pkmd = (PrimaryKeyMetaData)md;
                        pkmd.addColumn(clnmd);
                    }
                    this.pushStack(clnmd);
                    break block125;
                }
                if (qName.equals("element")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ElementMetaData elemd = new ElementMetaData(fmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "mapped-by"));
                    fmd.setElementMetaData(elemd);
                    this.pushStack(elemd);
                    break block125;
                }
                if (qName.equals("key")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    KeyMetaData keymd = new KeyMetaData(fmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "mapped-by"));
                    fmd.setKeyMetaData(keymd);
                    this.pushStack(keymd);
                    break block125;
                }
                if (qName.equals("value")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ValueMetaData valuemd = new ValueMetaData(fmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "mapped-by"));
                    fmd.setValueMetaData(valuemd);
                    this.pushStack(valuemd);
                    break block125;
                }
                if (qName.equals("fetch-group")) {
                    md = this.getStack();
                    FetchGroupMetaData fgmd = new FetchGroupMetaData(md, this.getAttr(attrs, "post-load"), this.getAttr(attrs, "name"));
                    if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmdParent = (FetchGroupMetaData)md;
                        fgmdParent.addFetchGroup(fgmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd7 = (AbstractClassMetaData)md;
                        cmd7.addFetchGroup(fgmd);
                    }
                    this.pushStack(fgmd);
                    break block125;
                }
                if (qName.equals("extension")) {
                    md = this.getStack();
                    md.addExtension(this.getAttr(attrs, "vendor-name"), this.getAttr(attrs, "key"), this.getAttr(attrs, "value"));
                    break block125;
                }
                if (qName.equals("version")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    VersionMetaData vermd = new VersionMetaData(this.getAttr(attrs, "strategy"), this.getAttr(attrs, "column"), this.getAttr(attrs, "indexed"));
                    cmd.setVersionMetaData(vermd);
                    this.pushStack(vermd);
                    break block125;
                }
                if (qName.equals("index")) {
                    md = this.getStack();
                    IndexMetaData idxmd = new IndexMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "unique"));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd8 = (AbstractClassMetaData)md;
                        cmd8.addIndex(idxmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd6 = (AbstractMemberMetaData)md;
                        fmd6.setIndexMetaData(idxmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setIndexMetaData(idxmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setIndexMetaData(idxmd);
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData omd = (OrderMetaData)md;
                        omd.setIndexMetaData(idxmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.setIndexMetaData(idxmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setIndexMetaData(idxmd);
                    }
                    this.pushStack(idxmd);
                    break block125;
                }
                if (qName.equals("unique")) {
                    md = this.getStack();
                    UniqueMetaData unimd = new UniqueMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "deferred"));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd9 = (AbstractClassMetaData)md;
                        cmd9.addUniqueConstraint(unimd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd7 = (AbstractMemberMetaData)md;
                        fmd7.setUniqueMetaData(unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setUniqueMetaData(unimd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setUniqueMetaData(unimd);
                    }
                    this.pushStack(unimd);
                    break block125;
                }
                if (qName.equals("foreign-key")) {
                    md = this.getStack();
                    ForeignKeyMetaData fkmd = new ForeignKeyMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "deferred"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd10 = (AbstractClassMetaData)md;
                        cmd10.addForeignKey(fkmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd8 = (AbstractMemberMetaData)md;
                        fmd8.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setForeignKeyMetaData(fkmd);
                    }
                    this.pushStack(fkmd);
                    break block125;
                }
                if (qName.equals("order")) {
                    OrderMetaData ormd = new OrderMetaData(this.getAttr(attrs, "column"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "mapped-by"));
                    AbstractMemberMetaData fmd9 = (AbstractMemberMetaData)this.getStack();
                    fmd9.setOrderMetaData(ormd);
                    this.pushStack(ormd);
                    break block125;
                }
                if (qName.equals("embedded")) {
                    md = this.getStack();
                    EmbeddedMetaData emd4 = new EmbeddedMetaData(md, this.getAttr(attrs, "owner-field"), this.getAttr(attrs, "null-indicator-column"), this.getAttr(attrs, "null-indicator-value"));
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd10 = (AbstractMemberMetaData)md;
                        fmd10.setEmbeddedMetaData(emd4);
                    } else if (md instanceof KeyMetaData) {
                        KeyMetaData kmd = (KeyMetaData)md;
                        kmd.setEmbeddedMetaData(emd4);
                    } else if (md instanceof ValueMetaData) {
                        ValueMetaData vmd = (ValueMetaData)md;
                        vmd.setEmbeddedMetaData(emd4);
                    } else if (md instanceof ElementMetaData) {
                        ElementMetaData elmd = (ElementMetaData)md;
                        elmd.setEmbeddedMetaData(emd4);
                    }
                    this.pushStack(emd4);
                    break block125;
                }
                String message = LOCALISER.msg("MetaData.Parser.UnknownTag.Error", qName);
                JPOXLogger.METADATA.error(message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Parser.ErrorInHandler", qName, this.getStack(), uri), ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.EndElement", "<" + qName + ">", "" + this.stack.size()));
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (qName.equals("query")) {
                ((QueryMetaData)md).setQuery(currentString);
            }
        }
        if (qName.equals("package") || qName.equals("class") || qName.equals("interface") || qName.equals("implements") || qName.equals("property") || qName.equals("datastore-identity") || qName.equals("inheritance") || qName.equals("primary-key") || qName.equals("version") || qName.equals("unmapped") || qName.equals("query") || qName.equals("sequence") || qName.equals("field") || qName.equals("map") || qName.equals("element") || qName.equals("embedded") || qName.equals("key") || qName.equals("value") || qName.equals("array") || qName.equals("collection") || qName.equals("join") || qName.equals("index") || qName.equals("unique") || qName.equals("foreign-key") || qName.equals("order") || qName.equals("fetch-group") || qName.equals("column") || qName.equals("discriminator")) {
            this.popStack();
        }
    }
}

