/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata.xml;

import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.PersistenceFileMetaData;
import org.jpox.metadata.PersistenceUnitMetaData;
import org.jpox.metadata.xml.AbstractMetaDataHandler;
import org.jpox.util.JPOXLogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class PersistenceFileMetaDataHandler
extends AbstractMetaDataHandler {
    public PersistenceFileMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new PersistenceFileMetaData(filename);
        this.pushStack(this.metadata);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block7: {
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.StartElement", sb.toString(), "" + this.stack.size()));
            }
            try {
                PersistenceUnitMetaData pumd;
                if (qName.equals("persistence")) break block7;
                if (qName.equals("persistence-unit")) {
                    PersistenceFileMetaData filemd = (PersistenceFileMetaData)this.getStack();
                    PersistenceUnitMetaData pumd2 = new PersistenceUnitMetaData(filemd, this.getAttr(attrs, "name"), this.getAttr(attrs, "transaction-type"));
                    filemd.addPersistenceUnit(pumd2);
                    this.pushStack(pumd2);
                    break block7;
                }
                if (qName.equals("properties")) break block7;
                if (qName.equals("property")) {
                    pumd = (PersistenceUnitMetaData)this.getStack();
                    pumd.addProperty(this.getAttr(attrs, "name"), this.getAttr(attrs, "value"));
                    break block7;
                }
                if (qName.equals("mapping-file") || qName.equals("class") || qName.equals("jar-file") || qName.equals("jta-data-source") || qName.equals("non-jta-data-source") || qName.equals("description") || qName.equals("provider")) break block7;
                if (qName.equals("exclude-unlisted-classes")) {
                    pumd = (PersistenceUnitMetaData)this.getStack();
                    pumd.setExcludeUnlistedClasses();
                    break block7;
                }
                String message = LOCALISER.msg("MetaData.Parser.UnknownTag.Error", qName);
                JPOXLogger.METADATA.error(message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Parser.ErrorInHandler", qName, this.getStack(), uri), ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.EndElement", "<" + qName + ">", "" + this.stack.size()));
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (qName.equals("description")) {
                ((PersistenceUnitMetaData)md).setDescription(currentString);
            } else if (qName.equals("provider")) {
                ((PersistenceUnitMetaData)md).setProvider(currentString);
            } else if (qName.equals("jta-data-source")) {
                ((PersistenceUnitMetaData)md).setJtaDataSource(currentString);
            } else if (qName.equals("non-jta-data-source")) {
                ((PersistenceUnitMetaData)md).setNonJtaDataSource(currentString);
            } else if (qName.equals("class")) {
                ((PersistenceUnitMetaData)md).addClassName(currentString);
            } else if (qName.equals("mapping-file")) {
                ((PersistenceUnitMetaData)md).addMappingFile(currentString);
            } else if (qName.equals("jar-file")) {
                ((PersistenceUnitMetaData)md).addJarFile(currentString);
            }
        }
        if (qName.equals("persistence-unit")) {
            this.popStack();
        }
    }
}

