/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXException;
import org.jpox.plugin.Bundle;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.PluginParser;
import org.jpox.plugin.PluginRegistry;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class NonManagedPluginRegistry
implements PluginRegistry {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private final ClassLoaderResolver clr;
    private static final String PLUGIN_DIR = "/";
    private static final FilenameFilter MANIFEST_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (name.equalsIgnoreCase("meta-inf")) {
                return true;
            }
            if (!dir.getName().equalsIgnoreCase("meta-inf")) {
                return false;
            }
            return name.equalsIgnoreCase("manifest.mf");
        }
    };
    private static final char JAR_SEPARATOR = '!';
    Map extensionPointsByUniqueId = new HashMap();
    Map registeredPluginBypluginId = new HashMap();
    Map registeredPluginByManifestURL = new HashMap();
    ExtensionPoint[] extensionPoints;
    private boolean registeredExtensions;
    private String bundleCheckType;
    static /* synthetic */ Class class$org$jpox$AbstractPersistenceManagerFactory;

    public NonManagedPluginRegistry(ClassLoaderResolver clr, String bundleCheckType) {
        this.clr = clr;
        this.extensionPoints = new ExtensionPoint[0];
        this.bundleCheckType = bundleCheckType;
    }

    public ExtensionPoint getExtensionPoint(String id) {
        return (ExtensionPoint)this.extensionPointsByUniqueId.get(id);
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    public void registerPluginExtensions(URL plugin, Bundle bundle) {
        int i;
        ArrayList registeringExtensions = new ArrayList();
        List[] elements = PluginParser.parsePluginElements(this, plugin, bundle, this.clr);
        for (i = 0; i < elements[0].size(); ++i) {
            ExtensionPoint exPoint = (ExtensionPoint)elements[0].get(i);
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        registeringExtensions.addAll(elements[1]);
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                JPOXLogger.PLUGIN.warn(LOCALISER.msg("Plugin.ExtensionPointNotRegistered", extension.getExtensionPointId(), extension.getPlugin().getSymbolicName(), extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
    }

    public void registerExtensions() {
        if (this.registeredExtensions) {
            return;
        }
        Set set = this.getPluginURLs();
        ArrayList registeringExtensions = new ArrayList();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            URL plugin = (URL)it.next();
            URL manifest = this.getManifestURL(plugin);
            if (manifest == null) continue;
            Bundle bundle = this.registerBundle(manifest);
            List[] elements = PluginParser.parsePluginElements(this, plugin, bundle, this.clr);
            for (int i = 0; i < elements[0].size(); ++i) {
                ExtensionPoint exPoint = (ExtensionPoint)elements[0].get(i);
                this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
            }
            registeringExtensions.addAll(elements[1]);
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (int i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                JPOXLogger.PLUGIN.warn(LOCALISER.msg("Plugin.ExtensionPointNotRegistered", extension.getExtensionPointId(), extension.getPlugin().getSymbolicName(), extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
        this.registeredExtensions = true;
    }

    private Set getPluginURLs() {
        HashSet set = new HashSet();
        try {
            Enumeration paths = this.clr.getResources("/plugin.xml", (class$org$jpox$AbstractPersistenceManagerFactory == null ? (class$org$jpox$AbstractPersistenceManagerFactory = NonManagedPluginRegistry.class$("org.jpox.AbstractPersistenceManagerFactory")) : class$org$jpox$AbstractPersistenceManagerFactory).getClassLoader());
            while (paths.hasMoreElements()) {
                set.add(paths.nextElement());
            }
        }
        catch (IOException e) {
            throw new JPOXException("Error loading resource", e).setFatal();
        }
        return set;
    }

    protected Bundle registerBundle(URL manifest) {
        Bundle bundle;
        if (manifest == null) {
            throw new IllegalArgumentException("Error registering Bundle since URL to manifest.mf is null");
        }
        InputStream is = null;
        try {
            Manifest mf = null;
            if (manifest.getProtocol().equals("jar")) {
                String path = manifest.getFile();
                String jarPath = path.substring(0, path.indexOf(33));
                URL jarUrl = null;
                try {
                    jarUrl = new URL(jarPath);
                }
                catch (MalformedURLException e) {
                    throw new JPOXException("Malformed URL for file: " + jarPath, e).setFatal();
                }
                mf = StringUtils.getJarFileForFilename(jarUrl.getFile()).getManifest();
                Bundle bundle2 = this.registerBundle(mf, jarUrl);
                return bundle2;
            }
            is = manifest.openStream();
            mf = new Manifest(is);
            bundle = this.registerBundle(mf, manifest);
        }
        catch (IOException e) {
            throw new JPOXException("Error reading manifest file", e).setFatal();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bundle;
    }

    protected Bundle registerBundle(Manifest mf, URL manifest) {
        Bundle bundle = PluginParser.parseManifest(mf, manifest);
        if (this.registeredPluginBypluginId.get(bundle.getSymbolicName()) == null) {
            if (JPOXLogger.PLUGIN.isDebugEnabled()) {
                JPOXLogger.PLUGIN.debug("Registering bundle " + bundle.getSymbolicName() + " version " + bundle.getVersion() + " at URL " + bundle.getManifestLocation() + ".");
            }
            this.registeredPluginBypluginId.put(bundle.getSymbolicName(), bundle);
            this.registeredPluginByManifestURL.put(bundle.getManifestLocation(), bundle);
        } else {
            Bundle previousBundle = (Bundle)this.registeredPluginBypluginId.get(bundle.getSymbolicName());
            if (!bundle.getManifestLocation().toExternalForm().equals(previousBundle.getManifestLocation().toExternalForm())) {
                String msg = "Plugin (Bundle) " + bundle.getSymbolicName() + " is already registered. " + "Ensure you don't have multiple JAR versions of the same plugin in the classpath. " + "The URL " + bundle.getManifestLocation() + " is already registered, " + "and you are trying to register an identical plugin located " + "at URL " + previousBundle.getManifestLocation() + ".";
                if (this.bundleCheckType.equalsIgnoreCase("EXCEPTION")) {
                    throw new JPOXException(msg);
                }
                if (this.bundleCheckType.equalsIgnoreCase("LOG")) {
                    JPOXLogger.PLUGIN.warn(msg);
                }
            }
        }
        return bundle;
    }

    private URL getManifestURL(URL plugin) {
        File[] files;
        if (plugin.toString().startsWith("jar")) {
            return plugin;
        }
        File[] dirs = new File(new File(plugin.getFile()).getParent()).listFiles(MANIFEST_FILE_FILTER);
        if (dirs != null && dirs.length > 0 && (files = dirs[0].listFiles(MANIFEST_FILE_FILTER)) != null && files.length > 0) {
            try {
                return files[0].toURI().toURL();
            }
            catch (MalformedURLException e) {
                JPOXLogger.PLUGIN.warn("Error reading MANIFEST.MF for " + plugin, e);
                return null;
            }
        }
        JPOXLogger.PLUGIN.warn("Could not find MANIFEST.MF file for plugin file " + plugin + " so ignoring it");
        return null;
    }

    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = this.clr.classForName(confElm.getAttribute(name));
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.clr.classForName(className);
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return url;
    }

    public void resolveConstraints() {
        Iterator it = this.registeredPluginBypluginId.values().iterator();
        while (it.hasNext()) {
            Bundle bundle = (Bundle)it.next();
            List set = bundle.getRequireBundle();
            Iterator requiredBundles = set.iterator();
            while (requiredBundles.hasNext()) {
                Bundle.BundleDescription bd = (Bundle.BundleDescription)requiredBundles.next();
                String symbolicName = bd.getBundleSymbolicName();
                Bundle requiredBundle = (Bundle)this.registeredPluginBypluginId.get(symbolicName);
                if (requiredBundle == null) {
                    if (bd.getParameter("resolution") != null && bd.getParameter("resolution").equalsIgnoreCase("optional")) {
                        JPOXLogger.PLUGIN.warn("Bundle " + bundle.getSymbolicName() + " has an optional dependency to " + symbolicName + " but it cannot be resolved.");
                    } else {
                        JPOXLogger.PLUGIN.error("Bundle " + bundle.getSymbolicName() + " requires " + symbolicName + " but it cannot be resolved.");
                    }
                }
                if (bd.getParameter("bundle-version") == null || this.isVersionInInterval(bundle.getVersion(), bd.getParameter("bundle-version"))) continue;
                JPOXLogger.PLUGIN.error("Bundle " + bundle.getSymbolicName() + " requires " + symbolicName + " version " + bd.getParameter("bundle-version") + " but the resolved bundle has version " + bundle.getVersion() + " which is outside the expected range.");
            }
        }
    }

    private boolean isVersionInInterval(String version, String interval) {
        Bundle.BundleVersionRange versionRange = PluginParser.parseVersionRange(version);
        Bundle.BundleVersionRange intervalRange = PluginParser.parseVersionRange(interval);
        int compare_floor = versionRange.floor.compareTo(intervalRange.floor);
        boolean result = true;
        if (intervalRange.floor_inclusive) {
            result = compare_floor >= 0;
        } else {
            boolean bl = result = compare_floor > 0;
        }
        if (intervalRange.ceiling != null) {
            int compare_ceiling = versionRange.floor.compareTo(intervalRange.ceiling);
            result = intervalRange.ceiling_inclusive ? compare_ceiling <= 0 : compare_ceiling < 0;
        }
        return result;
    }

    public Bundle[] getBundles() {
        return this.registeredPluginBypluginId.values().toArray(new Bundle[this.registeredPluginBypluginId.values().size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

