/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.sco;

import java.io.ObjectStreamException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.sco.SCOMap;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.Set;
import org.jpox.sco.exceptions.IncompatibleFieldTypeException;
import org.jpox.sco.exceptions.NullsNotAllowedException;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.sco.queued.ClearOperation;
import org.jpox.sco.queued.PutOperation;
import org.jpox.sco.queued.QueuedOperation;
import org.jpox.sco.queued.RemoveOperation;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreClass;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MapMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class SortedMap
extends AbstractMap
implements java.util.SortedMap,
SCOMap,
Cloneable,
Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private transient Object owner;
    private transient StateManager ownerSM;
    private transient String fieldName;
    private transient int fieldNumber;
    private transient Class valueType;
    private transient boolean allowNulls;
    protected MapStore backingStore;
    protected TreeMap delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    boolean queued = false;
    private ArrayList queuedOperations = null;
    static /* synthetic */ Class class$java$util$SortedMap;

    public SortedMap(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        if (ownerSM == null) {
            this.delegate = new TreeMap();
        }
        if (ownerSM != null) {
            Comparator comparator;
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.owner = ownerSM.getObject();
            this.fieldNumber = fmd.getAbsoluteFieldNumber();
            this.queued = SCOUtils.useContainerQueueing(ownerSM);
            this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
            this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
            boolean serialised = SCOUtils.mapHasSerialisedKeysAndValues(fmd);
            if (ownerSM.getStoreManager().usesDatastoreClass() && !serialised && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                DatastoreClass ownerTable = ownerSM.getStoreManager().getDatastoreClass(this.owner.getClass().getName(), ownerSM.getObjectManager().getClassLoaderResolver());
                JavaTypeMapping m = ownerTable.getFieldMapping(fmd);
                if (!(m instanceof MapMapping)) {
                    throw new IncompatibleFieldTypeException(ownerSM, fieldName, (class$java$util$SortedMap == null ? (class$java$util$SortedMap = SortedMap.class$("java.util.SortedMap")) : class$java$util$SortedMap).getName(), fmd.getTypeName());
                }
                this.backingStore = ((MapMapping)m).getBackingStore(ownerSM.getObjectManager().getClassLoaderResolver());
                this.valueType = ownerSM.getObjectManager().getClassLoaderResolver().classForName(this.backingStore.getValueType());
            }
            this.delegate = (comparator = SCOUtils.getComparator(fmd, ownerSM.getObjectManager().getClassLoaderResolver())) != null ? new TreeMap(comparator) : new TreeMap();
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
            }
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Map m = (Map)o;
        if (m != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.mapHasSerialisedKeysAndValues(fmd) && (fmd.getMap().getKeyClassMetaData() != null || fmd.getMap().getValueClassMetaData() != null)) {
                ObjectManager om = this.ownerSM.getObjectManager();
                Iterator iter = m.entrySet().iterator();
                while (iter.hasNext()) {
                    StateManager objSM;
                    Map.Entry entry = iter.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (fmd.getMap().getKeyClassMetaData() != null && (objSM = om.findStateManager(key)) == null) {
                        objSM = StateManagerFactory.newStateManagerForEmbedded(om, key, false);
                        objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                    }
                    if (fmd.getMap().getValueClassMetaData() == null || (objSM = om.findStateManager(value)) != null) continue;
                    objSM = StateManagerFactory.newStateManagerForEmbedded(om, value, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                this.putAll(m);
            } else if (forUpdate) {
                this.clear();
                this.putAll(m);
            } else {
                this.delegate.clear();
                this.delegate.putAll(m);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("SCO.Container.Loading", StringUtils.toJVMIDString(this.ownerSM.getObject()), this.fieldName));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerSM);
            this.isCacheLoaded = true;
        }
    }

    public void flush() {
        if (this.queued && this.queuedOperations != null) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("SCO.Container.Flushing", StringUtils.toJVMIDString(this.ownerSM.getObject()), this.fieldName));
            }
            Iterator iter = this.queuedOperations.iterator();
            while (iter.hasNext()) {
                QueuedOperation op = (QueuedOperation)iter.next();
                op.perform(this.backingStore, this.ownerSM);
            }
            this.queuedOperations.clear();
            this.queuedOperations = null;
        }
    }

    protected void addQueuedOperation(QueuedOperation op) {
        if (this.queuedOperations == null) {
            this.queuedOperations = new ArrayList();
        }
        this.queuedOperations.add(op);
    }

    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerSM, key, fieldNumber, newValue);
        }
    }

    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerSM, value, fieldNumber, newValue);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        TreeMap detached = new TreeMap();
        SCOUtils.detachCopyForMap(this.ownerSM, this.entrySet(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Map m = (Map)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean keysWithoutIdentity = SCOUtils.mapHasKeysWithoutIdentity(fmd);
        boolean valuesWithoutIdentity = SCOUtils.mapHasValuesWithoutIdentity(fmd);
        TreeMap attachedKeysValues = new TreeMap();
        SCOUtils.attachCopyForMap(this.ownerSM, m.entrySet(), attachedKeysValues, keysWithoutIdentity, valuesWithoutIdentity);
        SCOUtils.updateMapWithMapKeysValues(this, attachedKeysValues);
    }

    public synchronized QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.valueType);
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newQueryStatement(this.ownerSM, candidate_class.getName());
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newResultObjectFactory(this.ownerSM, stmt, ignoreCache, useFetchPlan);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerSM, key);
        }
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerSM, value);
        }
        return this.delegate.containsValue(value);
    }

    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return ((Object)this.entrySet()).equals(m.entrySet());
    }

    public Object firstKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.firstKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            return keysIter.next();
        }
        this.loadFromStore();
        return this.delegate.firstKey();
    }

    public Object lastKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.lastKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            Object last = null;
            while (keysIter.hasNext()) {
                last = keysIter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.lastKey();
    }

    public java.util.SortedMap headMap(Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(toKey);
        }
        if (!this.useCache) {
            throw new JPOXUserException("JPOX doesn't currently support SortedMap.headMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(toKey);
    }

    public java.util.SortedMap subMap(Object fromKey, Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subMap(fromKey, toKey);
        }
        if (!this.useCache) {
            throw new JPOXUserException("JPOX doesn't currently support SortedMap.subMap() when not using cached container");
        }
        this.loadFromStore();
        return this.delegate.subMap(fromKey, toKey);
    }

    public java.util.SortedMap tailMap(Object fromKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(fromKey);
        }
        if (!this.useCache) {
            throw new JPOXUserException("JPOX doesn't currently support SortedMap.tailMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(fromKey);
    }

    public Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, key);
        }
        return this.delegate.get(key);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.keySetStore(this.ownerSM.getObjectManager().getClassLoaderResolver()));
        }
        return this.delegate.keySet();
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, true, this.backingStore.valueSetStore(this.ownerSM.getObjectManager().getClassLoaderResolver()));
        }
        return this.delegate.values();
    }

    public void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new ClearOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    public Object put(Object key, Object value) {
        if (value == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new PutOperation(key, value));
            } else {
                oldValue = this.backingStore.put(this.ownerSM, key, value);
            }
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (this.queued) {
            oldValue = delegateOldValue;
        }
        return oldValue;
    }

    public void putAll(Map m) {
        this.makeDirty();
        if (this.backingStore != null) {
            if (this.queued) {
                Iterator iter = m.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.addQueuedOperation(new PutOperation(entry.getKey(), entry.getValue()));
                }
            } else {
                this.backingStore.putAll(this.ownerSM, m);
            }
        }
        this.delegate.putAll(m);
    }

    public Object remove(Object key) {
        this.makeDirty();
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new RemoveOperation(key));
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerSM, key);
            }
        } else {
            removed = delegateRemoved;
        }
        return removed;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new TreeMap(this.delegate);
        }
        return new TreeMap(this.delegate);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

