/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.sco;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.sco.SCOList;
import org.jpox.sco.SCOListIterator;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.exceptions.IncompatibleFieldTypeException;
import org.jpox.sco.exceptions.NullsNotAllowedException;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.sco.queued.AddAtOperation;
import org.jpox.sco.queued.AddOperation;
import org.jpox.sco.queued.ClearOperation;
import org.jpox.sco.queued.QueuedOperation;
import org.jpox.sco.queued.RemoveAtOperation;
import org.jpox.sco.queued.RemoveOperation;
import org.jpox.sco.queued.SetOperation;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreClass;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.CollectionMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.scostore.ListStore;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class Vector
extends java.util.Vector
implements SCOList,
Cloneable,
Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private transient Object owner;
    private transient StateManager ownerSM;
    private transient String fieldName;
    private transient int fieldNumber;
    private transient ListStore backingStore;
    private transient Class elementType;
    private transient boolean allowNulls;
    private java.util.Vector delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    boolean queued = false;
    private ArrayList queuedOperations = null;
    static /* synthetic */ Class class$java$util$Vector;

    public Vector(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        this.delegate = new java.util.Vector();
        if (ownerSM != null) {
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.owner = ownerSM.getObject();
            this.fieldNumber = fmd.getAbsoluteFieldNumber();
            this.queued = SCOUtils.useContainerQueueing(ownerSM);
            this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
            this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
            boolean serialised = SCOUtils.collectionHasSerialisedElements(fmd);
            if (ownerSM.getStoreManager().usesDatastoreClass() && !serialised && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                DatastoreClass ownerTable = ownerSM.getStoreManager().getDatastoreClass(this.owner.getClass().getName(), ownerSM.getObjectManager().getClassLoaderResolver());
                JavaTypeMapping m = ownerTable.getFieldMapping(fmd);
                if (!(m instanceof CollectionMapping)) {
                    throw new IncompatibleFieldTypeException(ownerSM, fieldName, (class$java$util$Vector == null ? (class$java$util$Vector = Vector.class$("java.util.Vector")) : class$java$util$Vector).getName(), fmd.getTypeName());
                }
                ((CollectionMapping)m).setInstantiatedType(class$java$util$Vector == null ? (class$java$util$Vector = Vector.class$("java.util.Vector")) : class$java$util$Vector);
                this.backingStore = (ListStore)((CollectionMapping)m).getBackingStore(ownerSM.getObjectManager().getClassLoaderResolver());
                this.elementType = ownerSM.getObjectManager().getClassLoaderResolver().classForName(this.backingStore.getElementType());
            }
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
            }
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getCollection().getElementClassMetaData() != null) {
                ObjectManager om = this.ownerSM.getObjectManager();
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    Object pc = iter.next();
                    StateManager objSM = om.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = StateManagerFactory.newStateManagerForEmbedded(om, pc, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                this.addAll(c);
            } else if (forUpdate) {
                this.clear();
                this.addAll(c);
            } else {
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    public Class getElementType() {
        return this.elementType;
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("SCO.Container.Loading", StringUtils.toJVMIDString(this.ownerSM.getObject()), this.fieldName));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    public void flush() {
        if (this.queued && this.queuedOperations != null) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("SCO.Container.Flushing", StringUtils.toJVMIDString(this.ownerSM.getObject()), this.fieldName));
            }
            Iterator iter = this.queuedOperations.iterator();
            while (iter.hasNext()) {
                QueuedOperation op = (QueuedOperation)iter.next();
                op.perform(this.backingStore, this.ownerSM);
            }
            this.queuedOperations.clear();
            this.queuedOperations = null;
        }
    }

    protected void addQueuedOperation(QueuedOperation op) {
        if (this.queuedOperations == null) {
            this.queuedOperations = new ArrayList();
        }
        this.queuedOperations.add(op);
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.Vector detached = new java.util.Vector();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        ArrayList attachedElements = new ArrayList(c.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    public synchronized QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.elementType);
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newQueryStatement(this.ownerSM, candidate_class.getName());
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newResultObjectFactory(this.ownerSM, stmt, ignoreCache, useFetchPlan);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public Object elementAt(int index) {
        return this.get(index);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        Object[] elements = this.toArray();
        Object[] otherElements = l.toArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].equals(otherElements[i])) continue;
            return false;
        }
        return true;
    }

    public Enumeration elements() {
        if (this.useCache) {
            this.loadFromStore();
            return this.delegate.elements();
        }
        final SCOListIterator iter = new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public Object firstElement() {
        return this.get(0);
    }

    public Object get(int index) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, index);
        }
        return this.delegate.get(index);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    public int indexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.indexOf(this.ownerSM, element);
        }
        return this.delegate.indexOf(element);
    }

    public int indexOf(Object element, int startIndex) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.indexOf(this.ownerSM, element);
        }
        return this.delegate.indexOf(element, startIndex);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
    }

    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    public int lastIndexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.lastIndexOf(this.ownerSM, element);
        }
        return this.delegate.lastIndexOf(element);
    }

    public int lastIndexOf(Object element, int startIndex) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.lastIndexOf(this.ownerSM, element);
        }
        return this.delegate.lastIndexOf(element, startIndex);
    }

    public ListIterator listIterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
    }

    public ListIterator listIterator(int index) {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, index);
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public synchronized List subList(int from, int to) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.subList(this.ownerSM, from, to);
        }
        return this.delegate.subList(from, to);
    }

    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    public void add(int index, Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new AddAtOperation(index, element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "add", this.fieldName, dse));
                }
            }
        }
        this.makeDirty();
        this.delegate.add(index, element);
    }

    public boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new AddOperation(element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "add", this.fieldName, dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.addQueuedOperation(new AddOperation(iter.next()));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "addAll", this.fieldName, dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean addAll(int index, Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.addQueuedOperation(new AddOperation(iter.next()));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "addAll", this.fieldName, dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(index, elements);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public void addElement(Object element) {
        this.add(element);
    }

    public synchronized void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new ClearOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    public boolean remove(Object element) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new RemoveOperation(element));
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "remove", this.fieldName, dse));
                    backingSuccess = false;
                }
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public Object remove(int index) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        Object delegateObject = this.delegate.remove(index);
        Object backingObject = null;
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new RemoveAtOperation(index));
            } else {
                try {
                    backingObject = this.backingStore.remove(this.ownerSM, index, size);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "remove", this.fieldName, dse));
                    backingObject = null;
                }
            }
        }
        return this.backingStore != null ? backingObject : (Object)delegateObject;
    }

    public boolean removeAll(Collection elements) {
        boolean backingSuccess;
        boolean delegateSuccess;
        block6: {
            this.makeDirty();
            if (this.useCache) {
                this.loadFromStore();
            }
            int size = this.useCache ? this.delegate.size() : -1;
            delegateSuccess = this.delegate.removeAll(elements);
            backingSuccess = true;
            if (this.backingStore == null) break block6;
            if (this.queued) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.addQueuedOperation(new RemoveOperation(iter.next()));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (JPOXDataStoreException dse) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "removeAll", this.fieldName, dse));
                    backingSuccess = false;
                }
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean removeElement(Object element) {
        return this.remove(element);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public void removeAllElements() {
        this.clear();
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    public Object set(int index, Object element, boolean allowDependentField) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (this.queued) {
                this.addQueuedOperation(new SetOperation(index, element, allowDependentField));
            } else {
                this.backingStore.set(this.ownerSM, index, element, allowDependentField);
            }
        }
        return this.delegate.set(index, element);
    }

    public Object set(int index, Object element) {
        return this.set(index, element, true);
    }

    public void setElementAt(Object element, int index) {
        this.set(index, element);
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.Vector(this.delegate);
        }
        return new java.util.Vector(this.delegate);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

