/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlan;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.api.JDOAdapter;
import org.jpox.cache.CachedPC;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.identity.OID;
import org.jpox.identity.OIDFactory;
import org.jpox.jdo.JPOXJDOHelper;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOCollection;
import org.jpox.sco.SCOContainer;
import org.jpox.sco.SCOMap;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.UnsetOwners;
import org.jpox.state.AbstractStateManager;
import org.jpox.state.ActivityState;
import org.jpox.state.FetchPlanState;
import org.jpox.state.RelationConstraint;
import org.jpox.store.DatastoreClass;
import org.jpox.store.FieldValues;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.fieldmanager.AbstractFetchFieldManager;
import org.jpox.store.fieldmanager.AttachFieldManager;
import org.jpox.store.fieldmanager.DeleteFieldManager;
import org.jpox.store.fieldmanager.DetachFieldManager;
import org.jpox.store.fieldmanager.FieldManager;
import org.jpox.store.fieldmanager.LoadFieldManager;
import org.jpox.store.fieldmanager.MakeTransientFieldManager;
import org.jpox.store.fieldmanager.NullifyRelationFieldManager;
import org.jpox.store.fieldmanager.PersistFieldManager;
import org.jpox.store.fieldmanager.ReachabilityFieldManager;
import org.jpox.store.fieldmanager.SingleTypeFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;
import org.jpox.util.TypeConversionHelper;

final class JDOStateManagerImpl
extends AbstractStateManager
implements javax.jdo.spi.StateManager {
    private static final JDOImplHelper HELPER;
    private static final SingleTypeFieldManager HOLLOWFIELDMANAGER;
    private static final byte MISC_RETRIEVING_DETACHED_STATE = -128;
    private static final byte MISC_RESETTING_DETACHED_STATE = 64;
    private static final byte MISC_UPDATING_EMBEDDING_FIELDS_WITH_OWNER = 32;
    private byte miscFlags;
    private byte jdoFlags;
    private PersistenceCapable savedImage = null;
    private byte savedFlags;
    private boolean[] savedLoadedFields = null;
    private boolean flushedNew = false;
    private ActivityState activity = ActivityState.NONE;
    private boolean changingState = false;
    private boolean postLoadPending = false;
    private boolean flushing = false;
    private boolean disconnecting = false;
    private boolean detaching = false;
    private boolean attaching = false;
    private PersistenceCapable referencedPC = null;
    private List insertionNotifyList = null;
    private Map fieldsToBeUpdatedAfterObjectInsertion = null;
    private List embeddedOwners = null;
    private HashMap externalFieldValuesByMapping = null;
    boolean loadingFieldsInFetchPlan = false;
    private DatastoreClass latestInsertedDatastoreClass = null;
    private boolean storingPC = false;
    private HashSet managedRelationConstraints = null;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public JDOStateManagerImpl(ObjectManager om, AbstractClassMetaData cmd) {
        super(om, cmd);
    }

    public void initialiseForHollow(Object id, FieldValues fv, Class pcClass) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        this.myPC = id instanceof OID || id == null ? HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this) : HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this, this.myID);
        if (fv != null) {
            this.loadFieldValues(fv);
        }
    }

    public void initialiseForHollowAppId(FieldValues fv, Class pcClass) {
        if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new JDOFatalUserException("This constructor is only for objects using application identity.");
        }
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
        if (this.myPC == null) {
            if (!HELPER.getRegisteredClasses().contains(pcClass)) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotRegistered", pcClass.getName()));
            }
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotConstructable", pcClass.getName()));
        }
        this.loadFieldValues(fv);
        this.myID = this.myPC.jdoNewObjectIdInstance();
        if (!this.cmd.usesSingleFieldIdentityClass()) {
            this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
        }
    }

    public void initialiseForHollowPreConstructed(Object id, PersistenceCapable pc) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this);
        this.myPC.jdoReplaceFlags();
    }

    public void initialiseForPersistentClean(Object id, PersistenceCapable pc) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this);
        this.myPC.jdoReplaceFlags();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myOM.putObjectIntoCache(this, true, true);
    }

    public void initialiseForEmbedded(PersistenceCapable pc, boolean copyPc) {
        this.pcObjectType = 1;
        this.myID = null;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this);
        if (copyPc) {
            PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
            pcCopy.jdoCopyFields((Object)this.myPC, this.getAllFieldNumbers());
            pcCopy.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
            this.myPC = pcCopy;
            this.disconnectClone(pc);
        }
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForPersistentNew(PersistenceCapable pc, FieldValues preInsertChanges) {
        this.myPC = pc;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this);
        this.myPC.jdoReplaceFlags();
        this.saveFields();
        this.populateStrategyFields();
        if (preInsertChanges != null) {
            preInsertChanges.fetchFields(this);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            for (int fieldNumber = 0; fieldNumber < this.getAllFieldNumbers().length; ++fieldNumber) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!fmd.isPrimaryKey() || this.myOM.getMetaDataManager().getMetaDataForClass(fmd.getType(), this.getObjectManager().getClassLoaderResolver()) == null) continue;
                Object object = this.currFMmonitor;
                synchronized (object) {
                    FieldManager prevFM = this.currFM;
                    try {
                        this.currFM = new SingleValueFieldManager();
                        this.myPC.jdoProvideField(fieldNumber);
                        PersistenceCapable pkFieldPC = (PersistenceCapable)((SingleValueFieldManager)this.currFM).fetchObjectField(fieldNumber);
                        if (pkFieldPC == null) {
                            throw new JDOUserException(LOCALISER.msg("StateManager.PrimaryKeyFieldIsNull", fmd.getFullFieldName()));
                        }
                        if (!this.myOM.getApiAdapter().isPersistent(pkFieldPC)) {
                            this.myOM.persistObjectInternal(pkFieldPC, null);
                        }
                    }
                    finally {
                        this.currFM = prevFM;
                    }
                    continue;
                }
            }
        }
        this.setIdentity();
        if (this.getObjectManager().getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
        this.getCallbackHandler().postCreate(this.myPC);
    }

    public void initialiseForTransactionalTransient(PersistenceCapable pc) {
        this.myPC = pc;
        this.myLC = null;
        this.jdoFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceFlags();
        this.populateStrategyFields();
        this.setIdentity();
        if (this.myOM.getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
    }

    public void initialiseForDetached(PersistenceCapable pc, Object id, Object version) {
        this.myID = id;
        this.myPC = pc;
        this.setVersion(version);
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(11);
        this.myFP = null;
        this.myPC.jdoReplaceFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForCachedPC(PersistenceCapable pc, Object id, boolean[] loaded, Class pcClass) {
        this.initialiseForHollow(id, null, pcClass);
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoFlags = (byte)-1;
        PersistenceCapable persistenceCapable = pc;
        synchronized (persistenceCapable) {
            int i;
            pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
            int[] fieldsToLoad = JDOStateManagerImpl.getFlagsSetTo(loaded, this.getAllFieldNumbers(), true);
            if (fieldsToLoad != null) {
                this.myPC.jdoCopyFields((Object)pc, fieldsToLoad);
            }
            for (i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = loaded[i];
            }
            for (i = 0; i < this.cmd.getPersistenceCapableMemberPositions().length; ++i) {
                this.loadedFields[this.cmd.getPersistenceCapableMemberPositions()[i]] = false;
            }
            int[] secondClassMutableFieldNumbers = this.getSecondClassMutableFieldNumbers();
            for (int i2 = 0; i2 < secondClassMutableFieldNumbers.length; ++i2) {
                this.loadedFields[secondClassMutableFieldNumbers[i2]] = false;
            }
            this.disconnectClone(pc);
        }
        if (this.isFetchPlanLoaded()) {
            this.postLoad();
        }
    }

    public void checkInheritance(FieldValues fv) {
        ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
        String className = this.getStoreManager().getClassNameForObjectID(this.myID, clr, this.myOM);
        if (className == null) {
            throw new JPOXObjectNotFoundException(LOCALISER.msg("StateManager.ObjectDoesntExist"), this.myID);
        }
        if (!this.cmd.getFullClassName().equals(className)) {
            Class pcClass;
            try {
                pcClass = this.getObjectManager().getClassLoaderResolver().classForName(className, this.myID.getClass().getClassLoader(), true);
                this.cmd = this.myOM.getMetaDataManager().getMetaDataForClass(pcClass, this.getObjectManager().getClassLoaderResolver());
            }
            catch (ClassNotResolvedException e) {
                JPOXLogger.JDO.warn(LOCALISER.msg("StateManager.GetObjectByIdClassNotFound", this.myID));
                throw new JDOUserException(LOCALISER.msg("StateManager.GetObjectByIdClassNotFound", this.myID), (Throwable)e);
            }
            if (this.cmd == null) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass));
            }
            if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
                throw new JDOFatalUserException("This method should only be used for objects using application identity.");
            }
            this.myFP = this.myOM.getFetchPlan().manageFetchPlanForClass(this.cmd);
            this.initialiseFieldInformation();
            this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
            if (this.myPC == null) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotRegistered", this.cmd.getFullClassName()));
            }
            this.loadFieldValues(fv);
            this.myID = this.myPC.jdoNewObjectIdInstance();
            if (!this.cmd.usesSingleFieldIdentityClass()) {
                this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
            }
        }
    }

    private void populateStrategyFields() {
        int totalFieldCount = this.cmd.getNoOfInheritedManagedMembers() + this.cmd.getNoOfManagedMembers();
        DatastoreClass table = null;
        if (!this.cmd.isEmbeddedOnly() && this.getStoreManager().usesDatastoreClass()) {
            table = this.getStoreManager().getDatastoreClass(this.cmd.getFullClassName(), this.myOM.getClassLoaderResolver());
        }
        for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            IdentityStrategy strategy = fmd.getValueStrategy();
            if (strategy == null || this.getStoreManager().isStrategyDatastoreAttributed(strategy, false)) continue;
            boolean applyStrategy = true;
            if (!fmd.getType().isPrimitive() && strategy != null && fmd.hasExtension("strategy-when-notnull") && fmd.getValueForExtension("strategy-when-notnull").equalsIgnoreCase("false") && this.provideField(fieldNumber) != null) {
                applyStrategy = false;
            }
            if (!applyStrategy) continue;
            DatastoreClass fieldTable = null;
            if (this.getStoreManager().usesDatastoreClass()) {
                fieldTable = table.getBaseDatastoreClassWithField(fmd);
            }
            Object obj = this.getStoreManager().getStrategyValue(this.myOM, fieldTable, this.cmd, fieldNumber);
            this.replaceField(fieldNumber, obj, true);
        }
    }

    public void loadFieldValues(FieldValues fv) {
        FetchPlan.FetchPlanForClass origFetchPlan = this.myFP;
        FetchPlan loadFetchPlan = fv.getFetchPlanForLoading();
        if (loadFetchPlan != null) {
            this.myFP = loadFetchPlan.manageFetchPlanForClass(this.cmd);
        }
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        if (this.loadedFields.length == 0) {
            callPostLoad = true;
        }
        fv.fetchFields(this);
        if (callPostLoad && this.isFetchPlanLoaded() && this.myOM.getOMFContext().getApiAdapter() instanceof JDOAdapter) {
            this.postLoad();
        }
        this.myFP = origFetchPlan;
    }

    private void setIdentity() {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (this.cmd.getIdentityMetaData() == null || !this.getStoreManager().isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), true)) {
                this.myID = this.getStoreManager().newObjectID(this.myOM, this.cmd.getFullClassName(), this.myPC);
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            boolean isObjectIDDatastoreAttributed = false;
            int totalFieldCount = this.cmd.getNoOfInheritedManagedMembers() + this.cmd.getNoOfManagedMembers();
            for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!fmd.isPrimaryKey()) continue;
                if (this.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) {
                    isObjectIDDatastoreAttributed = true;
                    break;
                }
                if (!this.cmd.usesSingleFieldIdentityClass() || this.provideField(fieldNumber) != null) continue;
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.SingleFieldIdentityPKFieldIsNull", this.cmd.getFullClassName(), fmd.getName()));
            }
            if (!isObjectIDDatastoreAttributed) {
                this.myID = this.getStoreManager().newObjectID(this.myOM, this.cmd.getFullClassName(), this.myPC);
            }
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myOM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public void migrateToPersistentClean() {
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    public CachedPC getL2CacheableObject() {
        PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this, this.myPC.jdoGetObjectId());
        int[] allFieldNumbers = this.getAllFieldNumbers();
        boolean[] l2loadedFields = new boolean[allFieldNumbers.length];
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        int numCacheableFields = 0;
        for (int i = 0; i < allFieldNumbers.length; ++i) {
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            if (fmd.getRelationType(clr) != 0) continue;
            ++numCacheableFields;
        }
        int[] cacheableFieldNumbers = new int[numCacheableFields];
        int cacheableNum = 0;
        for (int i = 0; i < allFieldNumbers.length; ++i) {
            boolean cacheable = true;
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            if (fmd.getRelationType(clr) != 0) {
                cacheable = false;
            }
            if (cacheable) {
                cacheableFieldNumbers[cacheableNum++] = allFieldNumbers[i];
                l2loadedFields[i] = cacheable && this.loadedFields[i];
                continue;
            }
            l2loadedFields[i] = false;
        }
        if (cacheableFieldNumbers != null && cacheableFieldNumbers.length > 0) {
            pcCopy.jdoCopyFields((Object)this.myPC, cacheableFieldNumbers);
        }
        pcCopy.jdoReplaceFlags();
        pcCopy.jdoReplaceStateManager(null);
        return new CachedPC(pcCopy, l2loadedFields);
    }

    public void replaceManagedPC(PersistenceCapable pc) {
        if (pc == null) {
            return;
        }
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceStateManager(null);
        this.myPC = pc;
        this.myOM.putObjectIntoCache(this, true, true);
    }

    public void copyFieldsFromObject(PersistenceCapable pc, int[] fieldNumbers) {
        if (pc == null) {
            return;
        }
        if (!pc.getClass().getName().equals(this.myPC.getClass().getName())) {
            return;
        }
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
        this.myPC.jdoCopyFields((Object)pc, fieldNumbers);
        pc.jdoReplaceStateManager(null);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.flush();
        }
        finally {
            super.finalize();
        }
    }

    private void replaceStateManager(javax.jdo.spi.StateManager sm) {
        try {
            this.myPC.jdoReplaceStateManager(sm);
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.SecurityProblem"), (Throwable)e);
        }
    }

    public void enlistInTransaction() {
        if (!this.getObjectManager().getTransaction().isActive()) {
            return;
        }
        this.myOM.enlistInTransaction(this);
        if (this.jdoFlags == 1 && this.isFetchPlanLoaded()) {
            this.jdoFlags = (byte)-1;
            this.myPC.jdoReplaceFlags();
        }
    }

    public void evictFromTransaction() {
        this.myOM.evictFromTransaction(this);
        this.jdoFlags = 1;
        this.myPC.jdoReplaceFlags();
    }

    public void saveFields() {
        this.savedImage = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        this.savedImage.jdoCopyFields((Object)this.myPC, this.getAllFieldNumbers());
        this.savedFlags = this.jdoFlags;
        this.savedLoadedFields = (boolean[])this.loadedFields.clone();
    }

    public void restoreFields() {
        if (this.savedImage != null) {
            this.loadedFields = this.savedLoadedFields;
            this.jdoFlags = this.savedFlags;
            this.myPC.jdoReplaceFlags();
            this.myPC.jdoCopyFields((Object)this.savedImage, this.getAllFieldNumbers());
            this.clearDirtyFlags();
            this.clearSavedFields();
        }
    }

    public void clearFields() {
        this.clearFieldsByNumbers(this.getAllFieldNumbers());
    }

    public void clearNonPrimaryKeyFields() {
        this.clearFieldsByNumbers(this.getNonPrimaryKeyFieldNumbers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFieldsByNumbers(int[] fieldNumbers) {
        try {
            this.getCallbackHandler().preClear(this.myPC);
        }
        finally {
            this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
            this.clearLoadedFlags();
            this.clearDirtyFlags();
            this.getCallbackHandler().postClear(this.myPC);
        }
    }

    public void clearSavedFields() {
        this.savedImage = null;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
    }

    public void clearLoadedFlags() {
        this.getStoreManager().notifyObjectIsOutdated(this);
        this.jdoFlags = 1;
        this.myPC.jdoReplaceFlags();
        JDOStateManagerImpl.clearFlags(this.loadedFields);
    }

    public void makeDirty(int field) {
        if (this.activity != ActivityState.DELETING) {
            boolean wasDirty = this.preWriteField(field);
            this.postWriteField(wasDirty);
        }
    }

    public void makeDirty(PersistenceCapable pc, String fieldName) {
        if (!this.disconnectClone(pc)) {
            int fieldNumber = this.cmd.getAbsolutePositionOfMember(fieldName);
            if (fieldNumber == -1) {
                throw new JDOUserException(LOCALISER.msg("StateManager.InvalidFieldForClass", fieldName, this.cmd.getFullClassName()));
            }
            this.makeDirty(fieldNumber);
        }
    }

    public PersistenceManager getPersistenceManager(PersistenceCapable pc) {
        if (this.myPC != null && this.disconnectClone(pc)) {
            return null;
        }
        if (this.myOM == null) {
            return null;
        }
        this.myOM.hereIsStateManager(this, this.myPC);
        return (PersistenceManager)this.myOM.getOwner();
    }

    public Object getObjectId(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return null;
        }
        return this.getExternalObjectId(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostStoreNewObjectId(Object id) {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            this.myID = id instanceof OID ? id : OIDFactory.getInstance(this.myOM, this.cmd.getFullClassName(), id);
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.myID = null;
                int fieldCount = this.getHighestFieldNumber();
                for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                    if (!fmd.isPrimaryKey() || !this.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) continue;
                    this.replaceField(fieldNumber, TypeConversionHelper.convertTo(id, fmd.getType()), true);
                }
            }
            catch (Exception e) {
                JPOXLogger.JDO.error(e);
            }
            finally {
                this.myID = this.myOM.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
            }
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myOM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public Object getExternalObjectId(PersistenceCapable pc) {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (!this.flushing && !this.flushedNew && this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS && this.myLC.stateType() == 1 && this.getStoreManager().isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), true)) {
                this.flush();
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            if (!this.flushing && !this.flushedNew && this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS && this.myLC.stateType() == 1) {
                int[] pkFieldNumbers = this.cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
                    if (!this.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) continue;
                    this.flush();
                    break;
                }
            }
            if (this.cmd.usesSingleFieldIdentityClass()) {
                return this.myID;
            }
            return this.myOM.getApiAdapter().getNewApplicationIdentityObjectId(this.myPC, this.cmd);
        }
        return this.myID;
    }

    public javax.jdo.spi.StateManager replacingStateManager(PersistenceCapable pc, javax.jdo.spi.StateManager sm) {
        if (this.myLC == null) {
            throw new JDOFatalInternalException("Null LifeCycleState");
        }
        if (this.myLC.stateType() == 11) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myOM == ((AbstractStateManager)sm).myOM) {
                ((JDOStateManagerImpl)sm).disconnect();
                return this;
            }
            if (sm != null) {
                throw new JDOUserException(LOCALISER.msg("StateManager.StateManagerChangeError"));
            }
            if (!this.disconnecting) {
                throw new JDOUserException(LOCALISER.msg("StateManager.StateManagerDisconnectError"));
            }
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ClearingStateManager", StringUtils.toJVMIDString(pc)));
            }
            return null;
        }
        if (pc == this.savedImage) {
            return null;
        }
        return sm;
    }

    public Object getTransactionalObjectId(PersistenceCapable pc) {
        return this.getObjectId(pc);
    }

    private void loadSCONonContainerFields() {
        int[] noncontainerFieldNumbers = this.cmd.getSCONonContainerMemberPositions();
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, noncontainerFieldNumbers, false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.getStoreManager().fetchObject(this, fieldNumbers);
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    private void loadSpecifiedFields(int[] fieldNumbers) {
        if (this.myOM.getApiAdapter().isDetached(this.myPC)) {
            return;
        }
        if (!this.isEmbedded()) {
            this.getStoreManager().fetchObject(this, fieldNumbers);
        }
        this.myOM.putObjectIntoCache(this, false, true);
    }

    public void loadUnloadedFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().fetchObject(this, fieldNumbers);
            int[] secondClassMutableFieldNumbers = this.getSecondClassMutableFieldNumbers();
            for (int i = 0; i < secondClassMutableFieldNumbers.length; ++i) {
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if (this.loadingFieldsInFetchPlan) {
            return;
        }
        this.loadingFieldsInFetchPlan = true;
        this.loadUnloadedFieldsInFetchPlan();
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state));
        }
        this.loadingFieldsInFetchPlan = false;
    }

    public void loadUnloadedFieldsInFetchPlan() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().fetchObject(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan fetchPlan) {
        FetchPlan.FetchPlanForClass fpc = fetchPlan.manageFetchPlanForClass(this.cmd);
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, fpc.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = fpc.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().fetchObject(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void unloadField(String fieldName) {
        if (this.pcObjectType != 0) {
            throw new JPOXUserException("Cannot unload field/property of embedded object");
        }
        AbstractMemberMetaData mmd = this.getClassMetaData().getMetaDataForMember(fieldName);
        this.loadedFields[mmd.getAbsoluteFieldNumber()] = false;
    }

    public void refreshFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags(fieldNumbers);
            JDOStateManagerImpl.clearFlags(this.loadedFields, fieldNumbers);
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.setTransactionalVersion(null);
            this.getStoreManager().fetchObject(this, fieldNumbers);
            if (this.cmd.hasRelations(this.myOM.getClassLoaderResolver())) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    Object value;
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    int relationType = fmd.getRelationType(this.myOM.getClassLoaderResolver());
                    if (relationType == 0 || !fmd.isCascadeRefresh() || (value = this.provideField(fieldNumbers[i])) == null) continue;
                    if (value instanceof Collection) {
                        SCOUtils.refreshFetchPlanFieldsForCollection(this, ((Collection)value).toArray());
                        continue;
                    }
                    if (value instanceof Map) {
                        SCOUtils.refreshFetchPlanFieldsForMap(this, ((Map)value).entrySet());
                        continue;
                    }
                    if (!(value instanceof PersistenceCapable)) continue;
                    this.myOM.refreshObject(value);
                }
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.getCallbackHandler().postRefresh(this.myPC);
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void refreshLoadedFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags();
            JDOStateManagerImpl.clearFlags(this.loadedFields);
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().fetchObject(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void unloadNonFetchPlanFields() {
        int[] fpFieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        int[] nonfpFieldNumbers = null;
        if (fpFieldNumbers == null || fpFieldNumbers.length == 0) {
            nonfpFieldNumbers = this.getAllFieldNumbers();
        } else {
            int fieldCount = this.getHighestFieldNumber();
            if (fieldCount == fpFieldNumbers.length) {
                return;
            }
            nonfpFieldNumbers = new int[fieldCount - fpFieldNumbers.length];
            int currentFPFieldIndex = 0;
            int j = 0;
            for (int i = 0; i < fieldCount; ++i) {
                if (currentFPFieldIndex >= fpFieldNumbers.length) {
                    nonfpFieldNumbers[j++] = i;
                    continue;
                }
                if (fpFieldNumbers[currentFPFieldIndex] == i) {
                    ++currentFPFieldIndex;
                    continue;
                }
                nonfpFieldNumbers[j++] = i;
            }
        }
        for (int i = 0; i < nonfpFieldNumbers.length; ++i) {
            this.loadedFields[nonfpFieldNumbers[i]] = false;
        }
    }

    public void loadFieldFromDatastore(int fieldNumber) {
        this.getStoreManager().fetchObject(this, new int[]{fieldNumber});
    }

    public boolean isLoaded(PersistenceCapable pc, int field) {
        try {
            if (this.disconnectClone(pc)) {
                return true;
            }
            boolean checkRead = true;
            if (this.myLC.isDeleted && this.myOM.isFlushing() || this.activity == ActivityState.DELETING) {
                checkRead = false;
            }
            if (checkRead) {
                this.transitionReadField(this.loadedFields[field]);
            }
            if (!this.loadedFields[field]) {
                if (this.pcObjectType != 0) {
                    return true;
                }
                if (this.myFP.isFieldInActualFetchPlan(field)) {
                    this.loadUnloadedFieldsInFetchPlan();
                } else {
                    this.loadSpecifiedFields(new int[]{field});
                }
            }
            return true;
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public boolean getAllFieldsLoaded() {
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean[] getDirtyFields() {
        boolean[] copy = new boolean[this.dirtyFields.length];
        System.arraycopy(this.dirtyFields, 0, copy, 0, this.dirtyFields.length);
        return copy;
    }

    private void writeField(int field, Object newValue) {
        this.replaceField(field, newValue, true);
    }

    public void setBooleanField(PersistenceCapable pc, int field, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue ? Boolean.TRUE : Boolean.FALSE);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
        }
    }

    public void setByteField(PersistenceCapable pc, int field, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Byte(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Byte(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Byte(newValue), true);
        }
    }

    public void setCharField(PersistenceCapable pc, int field, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Character(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Character(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Character(newValue), true);
        }
    }

    public void setDoubleField(PersistenceCapable pc, int field, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Double(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Double(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Double(newValue), true);
        }
    }

    public void setFloatField(PersistenceCapable pc, int field, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Float(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Float(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Float(newValue), true);
        }
    }

    public void setIntField(PersistenceCapable pc, int field, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Integer(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Integer(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Integer(newValue), true);
        }
    }

    public void setLongField(PersistenceCapable pc, int field, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Long(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Long(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Long(newValue), true);
        }
    }

    public void setShortField(PersistenceCapable pc, int field, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Short(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Short(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Short(newValue), true);
        }
    }

    public void setStringField(PersistenceCapable pc, int field, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || !JDOStateManagerImpl.equals(currentValue, newValue)) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue, true);
        }
    }

    public void setObjectField(PersistenceCapable pc, int field, Object currentValue, Object newValue) {
        block30: {
            block31: {
                AbstractMemberMetaData fmd;
                Object oldValue;
                block32: {
                    StateManager oldSM;
                    int relationType;
                    ClassLoaderResolver clr;
                    block33: {
                        boolean wasDirty;
                        block29: {
                            JDOStateManagerImpl currentSM;
                            if (currentValue != null && currentValue != newValue && currentValue instanceof PersistenceCapable && (currentSM = (JDOStateManagerImpl)this.myOM.findStateManager(currentValue)) != null && currentSM.isEmbedded()) {
                                currentSM.removeEmbeddedOwner(this, field);
                            }
                            if (pc == this.myPC) break block29;
                            this.replaceField(pc, field, newValue, true);
                            this.disconnectClone(pc);
                            break block30;
                        }
                        if (this.myLC == null) break block31;
                        boolean loadedOldValue = false;
                        oldValue = currentValue;
                        fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(field);
                        clr = this.myOM.getClassLoaderResolver();
                        relationType = fmd.getRelationType(clr);
                        if (!this.loadedFields[field] && currentValue == null && relationType != 0 && fmd.isDependent() && newValue == null) {
                            this.loadSpecifiedFields(new int[]{field});
                            loadedOldValue = true;
                            oldValue = this.provideField(field);
                        }
                        boolean equal = false;
                        if (oldValue == null && newValue == null) {
                            equal = true;
                        } else if (oldValue != null && newValue != null) {
                            if (oldValue instanceof PersistenceCapable) {
                                if (oldValue == newValue) {
                                    equal = true;
                                }
                            } else if (oldValue.equals(newValue)) {
                                equal = true;
                            }
                        }
                        if (!this.loadedFields[field] || !equal || fmd.hasArray()) {
                            SCO sco;
                            Object owner;
                            wasDirty = this.preWriteField(field);
                            if (oldValue instanceof SCO) {
                                if (oldValue instanceof SCOContainer) {
                                    ((SCOContainer)oldValue).load();
                                }
                                ((SCO)oldValue).unsetOwner();
                            }
                            if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                                throw new JDOUserException(LOCALISER.msg("StateManager.SecondClassObjectShareError", sco.getFieldName(), owner));
                            }
                            this.writeField(field, newValue);
                            this.postWriteField(wasDirty);
                        } else if (loadedOldValue) {
                            wasDirty = this.preWriteField(field);
                            this.writeField(field, newValue);
                            this.postWriteField(wasDirty);
                        }
                        if (equal) break block32;
                        if (relationType != 2) break block33;
                        if (newValue != null) {
                            AbstractMemberMetaData relatedMmd = fmd.getRelatedMemberMetaDataForObject(clr, this.myPC, newValue);
                            JDOStateManagerImpl newSM = (JDOStateManagerImpl)this.myOM.findStateManager(newValue);
                            if (newSM != null && this.getReferencedPC() == null && newSM.getReferencedPC() == null) {
                                JDOStateManagerImpl newRelatedSM;
                                Object newRelatedValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                                if (newRelatedValue != null && (newRelatedSM = (JDOStateManagerImpl)this.myOM.findStateManager(newRelatedValue)) != null) {
                                    if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                                        JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelations.OneToOneUpdateNulling", StringUtils.toJVMIDString(newRelatedValue), fmd.getFullFieldName(), StringUtils.toJVMIDString(newValue), StringUtils.toJVMIDString(this.myPC)));
                                    }
                                    boolean newRelatedWasDirty = newRelatedSM.preWriteField(fmd.getAbsoluteFieldNumber());
                                    newRelatedSM.writeField(fmd.getAbsoluteFieldNumber(), null);
                                    newRelatedSM.postWriteField(newRelatedWasDirty);
                                }
                                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelations.OneToOneUpdate", StringUtils.toJVMIDString(newValue), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(this.myPC)));
                                }
                                boolean newWasDirty = newSM.preWriteField(relatedMmd.getAbsoluteFieldNumber());
                                newSM.writeField(relatedMmd.getAbsoluteFieldNumber(), this.myPC);
                                newSM.postWriteField(newWasDirty);
                            }
                        }
                        if (oldValue == null) break block32;
                        AbstractMemberMetaData relatedMmd = fmd.getRelatedMemberMetaDataForObject(clr, this.myPC, oldValue);
                        oldSM = (JDOStateManagerImpl)this.myOM.findStateManager(oldValue);
                        if (oldSM == null || this.getReferencedPC() != null || ((JDOStateManagerImpl)oldSM).getReferencedPC() != null) break block32;
                        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelations.OneToOneUpdateNulling", StringUtils.toJVMIDString(oldValue), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(this.myPC), StringUtils.toJVMIDString(newValue)));
                        }
                        boolean currentWasDirty = super.preWriteField(relatedMmd.getAbsoluteFieldNumber());
                        super.writeField(relatedMmd.getAbsoluteFieldNumber(), null);
                        super.postWriteField(currentWasDirty);
                        break block32;
                    }
                    if (relationType == 6) {
                        Collection relatedColl;
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
                        if (relatedMmds[0].hasCollection() && (oldSM = this.myOM.findStateManager(oldValue)) != null && this.getReferencedPC() == null && oldSM.getReferencedPC() == null && (relatedColl = (Collection)oldSM.provideField(relatedMmds[0].getAbsoluteFieldNumber())) != null && relatedColl.contains(this.myPC)) {
                            relatedColl.remove(this.myPC);
                        }
                    } else if (relationType == 4 && fmd.hasCollection()) {
                        AbstractMemberMetaData relatedMmd = fmd.getRelatedMemberMetaData(clr)[0];
                        if (oldValue != null) {
                            Collection oldColl = (Collection)oldValue;
                            Iterator iter = oldColl.iterator();
                            while (iter.hasNext()) {
                                Object oldElement = iter.next();
                                StateManager oldElementSM = this.myOM.findStateManager(oldElement);
                                if (oldElementSM == null) continue;
                                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelations.OneToManyReplace", StringUtils.toJVMIDString(this.myPC), fmd.getFullFieldName(), StringUtils.toJVMIDString(oldElement), relatedMmd.getFullFieldName()));
                                }
                                oldElementSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), null, true);
                            }
                        }
                    }
                }
                if (fmd.isDependent() && oldValue != null && newValue == null && oldValue instanceof PersistenceCapable) {
                    this.flush();
                    JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DeleteDependentNulledField", oldValue, fmd.getFullFieldName()));
                    this.myOM.deleteObjectInternal(oldValue);
                }
                break block30;
            }
            this.replaceField(field, newValue, true);
        }
    }

    public byte replacingFlags(PersistenceCapable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.jdoFlags;
    }

    public Object provideField(int fieldNumber) {
        return this.provideField(this.myPC, fieldNumber);
    }

    public void replaceField(int fieldNumber, Object value, boolean makeDirty) {
        this.replaceField(this.myPC, fieldNumber, value, makeDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object provideField(PersistenceCapable pc, int fieldNumber) {
        Object obj;
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                pc.jdoProvideField(fieldNumber);
                obj = this.currFM.fetchObjectField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceField(PersistenceCapable pc, int fieldNumber, Object value, boolean makeDirty) {
        if (this.embeddedOwners != null) {
            Iterator ownerIter = this.embeddedOwners.iterator();
            while (ownerIter.hasNext()) {
                EmbeddedOwnerRelation owner = (EmbeddedOwnerRelation)ownerIter.next();
                JDOStateManagerImpl ownerSM = (JDOStateManagerImpl)owner.sm;
                if (ownerSM == null || ownerSM.cmd == null) continue;
                AbstractMemberMetaData ownerFmd = ownerSM.cmd.getMetaDataForManagedMemberAtAbsolutePosition(owner.fieldNumber);
                if (ownerFmd.getCollection() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOCollection)) continue;
                    ((SCOCollection)ownerField).updateEmbeddedElement(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerFmd.getMap() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOMap)) continue;
                    if (this.pcObjectType == 3) {
                        ((SCOMap)ownerField).updateEmbeddedKey(this.myPC, fieldNumber, value);
                    }
                    if (this.pcObjectType != 4) continue;
                    ((SCOMap)ownerField).updateEmbeddedValue(this.myPC, fieldNumber, value);
                    continue;
                }
                if ((ownerSM.miscFlags & 0x20) != 0) continue;
                if (ownerSM.isEmbedded()) {
                    ownerSM.replaceField(owner.fieldNumber, pc, makeDirty);
                    continue;
                }
                if (makeDirty) {
                    boolean wasDirty = ownerSM.preWriteField(owner.fieldNumber);
                    ownerSM.replaceField(owner.fieldNumber, pc, true);
                    ownerSM.postWriteField(wasDirty);
                    continue;
                }
                ownerSM.replaceField(owner.fieldNumber, pc, false);
            }
        }
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                this.currFM.storeObjectField(fieldNumber, value);
                pc.jdoReplaceField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                this.myPC.jdoProvideFields(fieldNumbers);
            }
            finally {
                this.currFM = prevFM;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                int[] fieldsToReplace = fieldNumbers;
                if (!replaceWhenDirty) {
                    int numberToReplace = fieldNumbers.length;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (!this.dirtyFields[fieldNumbers[i]]) continue;
                        --numberToReplace;
                    }
                    if (numberToReplace > 0 && numberToReplace != fieldNumbers.length) {
                        fieldsToReplace = new int[numberToReplace];
                        int n = 0;
                        for (int i = 0; i < fieldNumbers.length; ++i) {
                            if (this.dirtyFields[fieldNumbers[i]]) continue;
                            fieldsToReplace[n++] = fieldNumbers[i];
                        }
                    } else if (numberToReplace == 0) {
                        fieldsToReplace = null;
                    }
                }
                if (fieldsToReplace != null) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
            }
            finally {
                this.currFM = prevFM;
            }
        }
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm) {
        this.replaceFields(fieldNumbers, fm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            try {
                int[] fieldsToReplace = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
                if (fieldsToReplace != null && fieldsToReplace.length > 0) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
            }
            finally {
                this.currFM = prevFM;
            }
            if (callPostLoad && this.isFetchPlanLoaded()) {
                this.postLoad();
            }
        }
    }

    public void addEmbeddedOwner(StateManager ownerSM, int ownerFieldNumber) {
        if (ownerSM == null) {
            return;
        }
        if (this.embeddedOwners == null) {
            this.embeddedOwners = new ArrayList();
        }
        this.embeddedOwners.add(new EmbeddedOwnerRelation(ownerSM, ownerFieldNumber));
    }

    public void removeEmbeddedOwner(javax.jdo.spi.StateManager ownerSM, int ownerFieldNumber) {
        if (this.embeddedOwners != null) {
            Iterator iter = this.embeddedOwners.iterator();
            while (iter.hasNext()) {
                EmbeddedOwnerRelation relation = (EmbeddedOwnerRelation)iter.next();
                if (relation.sm != ownerSM || relation.fieldNumber != ownerFieldNumber) continue;
                iter.remove();
                break;
            }
        }
    }

    public StateManager[] getEmbeddedOwners() {
        if (this.embeddedOwners == null) {
            return null;
        }
        StateManager[] owners = new StateManager[this.embeddedOwners.size()];
        for (int i = 0; i < owners.length; ++i) {
            EmbeddedOwnerRelation relation = (EmbeddedOwnerRelation)this.embeddedOwners.get(i);
            owners[i] = relation.sm;
        }
        return owners;
    }

    public Object getSCOWrapperForField(int fieldNumber, Object value, boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged) {
        AbstractMemberMetaData fmd;
        if (value == null) {
            return value;
        }
        if (value instanceof PersistenceCapable && (fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getEmbeddedMetaData() != null && fmd.getEmbeddedMetaData().getOwnerMember() != null) {
            JDOStateManagerImpl subSM = (JDOStateManagerImpl)this.myOM.findStateManager(value);
            int ownerAbsFieldNum = subSM.cmd.getAbsolutePositionOfMember(fmd.getEmbeddedMetaData().getOwnerMember());
            if (ownerAbsFieldNum >= 0) {
                this.miscFlags = (byte)(this.miscFlags | 0x20);
                subSM.replaceField(ownerAbsFieldNum, this.myPC, true);
                this.miscFlags = (byte)(this.miscFlags & 0xFFFFFFDF);
            }
        }
        if (this.getSecondClassMutableFields()[fieldNumber] && (!(value instanceof SCO) || this.myPC != ((SCO)value).getOwner())) {
            fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (replaceFieldIfChanged && JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ReplacingSCO", fmd.getFullFieldName()));
            }
            return SCOUtils.newSCOInstance(this, fmd, fmd.getType(), value != null ? value.getClass() : null, value, forInsert, forUpdate, replaceFieldIfChanged);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionReadField(boolean isLoaded) {
        if (this.myLC == null) {
            return;
        }
        PersistenceCapable persistenceCapable = this.myPC;
        synchronized (persistenceCapable) {
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionReadField(this, isLoaded);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionWriteField() {
        PersistenceCapable persistenceCapable = this.myPC;
        synchronized (persistenceCapable) {
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionWriteField(this);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    public void runReachability(Set reachables) {
        if (reachables == null) {
            return;
        }
        if (!reachables.contains(this.getInternalObjectId())) {
            this.flush();
            if (this.isDeleted(this.myPC)) {
                return;
            }
            if (this.getObjectManager().isEnlistedInTransaction(this.getInternalObjectId())) {
                this.loadUnloadedFields();
            }
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.AddingInstanceToReachables", StringUtils.toJVMIDString(this.myPC), this.getObjectId(this.myPC), this.myLC));
            }
            reachables.add(this.getInternalObjectId());
            int[] loadedFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), true);
            if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                this.provideFields(loadedFieldNumbers, new ReachabilityFieldManager(this, reachables));
            }
        }
    }

    public void makePersistent() {
        if (this.myLC.isDeleted() && this.myOM.getOMFContext().getApiAdapter() instanceof JDOAdapter) {
            return;
        }
        if (this.dirty && !this.myLC.isDeleted && this.myLC.isTransactional && this.myOM.isDelayDatastoreOperationsEnabled()) {
            this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
            return;
        }
        this.getCallbackHandler().prePersist(this.myPC);
        if (this.flushedNew) {
            this.registerTransactional();
            return;
        }
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        if (this.myID == null) {
            this.setIdentity();
        }
        this.dirty = true;
        if (this.myOM.isDelayDatastoreOperationsEnabled()) {
            this.myOM.markDirty(this);
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.PersistenceDelayed", StringUtils.toJVMIDString(this.myPC)));
            }
            this.registerTransactional();
            if (this.myLC.isTransactional && this.myLC.isDeleted()) {
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
            this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
        } else {
            this.internalMakePersistent();
            this.registerTransactional();
        }
    }

    private void internalMakePersistent() {
        this.activity = ActivityState.INSERTING;
        boolean[] tmpDirtyFields = this.dirtyFields;
        try {
            this.getCallbackHandler().preStore(this.myPC);
            this.clearDirtyFlags();
            this.getStoreManager().insertObject(this);
            this.flushedNew = true;
            this.getCallbackHandler().postStore(this.myPC);
        }
        catch (NotYetFlushedException ex) {
            this.dirtyFields = tmpDirtyFields;
            this.myOM.markDirty(this);
            this.dirty = true;
            throw ex;
        }
        finally {
            this.activity = ActivityState.NONE;
        }
    }

    public boolean isInserting() {
        return this.activity == ActivityState.INSERTING;
    }

    public boolean isDeleting() {
        return this.activity == ActivityState.DELETING;
    }

    public boolean isWaitingToBeFlushedToDatastore() {
        return this.myLC.stateType() == 1 && !this.flushedNew;
    }

    public boolean isInserted(int fieldNumber) {
        if (!this.isInserting()) {
            return true;
        }
        if (this.latestInsertedDatastoreClass == null) {
            return false;
        }
        AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (fmd == null) {
            return false;
        }
        return this.latestInsertedDatastoreClass.managesClass(fmd.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActivityState(ActivityState activityState, DatastoreClass table) {
        if (activityState == ActivityState.INSERTING_CALLBACKS) {
            this.latestInsertedDatastoreClass = table;
            if (table.managesClass(this.cmd.getFullClassName())) {
                this.activity = activityState;
                if (this.insertionNotifyList != null) {
                    List list = this.insertionNotifyList;
                    synchronized (list) {
                        for (int i = 0; i < this.insertionNotifyList.size(); ++i) {
                            JDOStateManagerImpl notifySM = (JDOStateManagerImpl)this.insertionNotifyList.get(i);
                            notifySM.insertionCompleted(this);
                        }
                        this.insertionNotifyList.clear();
                        this.insertionNotifyList = null;
                    }
                }
            }
        } else {
            this.activity = activityState;
        }
    }

    public void addInsertionNotifier(javax.jdo.spi.StateManager sm, ActivityState activityState) {
        if (this.insertionNotifyList == null) {
            this.insertionNotifyList = new ArrayList();
        }
        this.insertionNotifyList.add(sm);
    }

    public void updateFieldAfterInsert(Object pc, int fieldNumber) {
        FieldContainer cont;
        JDOStateManagerImpl otherSM = (JDOStateManagerImpl)this.myOM.findStateManager(pc);
        otherSM.addInsertionNotifier(this, ActivityState.INSERTING_CALLBACKS);
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            this.fieldsToBeUpdatedAfterObjectInsertion = new HashMap();
        }
        if ((cont = (FieldContainer)this.fieldsToBeUpdatedAfterObjectInsertion.get(otherSM)) == null) {
            cont = new FieldContainer(fieldNumber);
        } else {
            cont.set(fieldNumber);
        }
        this.fieldsToBeUpdatedAfterObjectInsertion.put(otherSM, cont);
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.FieldRegisteredForUpdateAfterInsertion", this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), StringUtils.toJVMIDString(this.myPC)));
        }
    }

    void insertionCompleted(JDOStateManagerImpl sm) {
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            return;
        }
        FieldContainer fldCont = (FieldContainer)this.fieldsToBeUpdatedAfterObjectInsertion.get(sm);
        if (fldCont != null) {
            this.dirty = true;
            int[] fieldsToUpdate = fldCont.getFields();
            for (int i = 0; i < fieldsToUpdate.length; ++i) {
                if (JPOXLogger.JDO.isDebugEnabled()) {
                    JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.FieldBeingUpdatedNowValueInserted", this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldsToUpdate[i]).getFullFieldName(), this.myID));
                }
                this.dirtyFields[fieldsToUpdate[i]] = true;
            }
            this.fieldsToBeUpdatedAfterObjectInsertion.remove(sm);
            if (this.fieldsToBeUpdatedAfterObjectInsertion.size() == 0) {
                this.fieldsToBeUpdatedAfterObjectInsertion = null;
            }
            this.flush();
        }
    }

    public void setExternalFieldValueForMapping(JavaTypeMapping mapping, Object value) {
        if (this.externalFieldValuesByMapping == null) {
            this.externalFieldValuesByMapping = new HashMap();
        }
        this.externalFieldValuesByMapping.put(mapping, value);
    }

    public Object getValueForExternalField(JavaTypeMapping mapping) {
        if (this.externalFieldValuesByMapping == null) {
            return null;
        }
        return this.externalFieldValuesByMapping.get(mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransactional() {
        this.preStateChange();
        try {
            if (this.myLC == null) {
                this.initializeSM(5);
                this.setRestoreValues(true);
            } else {
                this.myLC = this.myLC.transitionMakeTransactional(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransient(FetchPlanState state) {
        if (state == null) {
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getSecondClassMutableFieldNumbers(), true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.provideFields(fieldNumbers, new UnsetOwners());
            }
        } else {
            this.loadUnloadedFieldsInFetchPlan();
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getSecondClassMutableFieldNumbers(), true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.replaceFields(fieldNumbers, new MakeTransientFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state));
            }
        }
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeTransient(this, state != null, this.myOM.getDetachAllOnCommit());
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(FetchPlanState state) {
        if (this.myLC.isDeleted() || this.myOM.getApiAdapter().isDetached(this.myPC) || this.detaching) {
            return;
        }
        boolean detachable = this.myOM.getApiAdapter().isDetachable(this.myPC);
        if (detachable) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("OM.Detach", StringUtils.toJVMIDString(this.myPC), "" + state.getCurrentFetchDepth()));
            }
            this.getCallbackHandler().preDetach(this.myPC);
        }
        try {
            this.detaching = true;
            if ((this.myOM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                this.loadUnloadedFieldsInFetchPlan();
            }
            DetachFieldManager detachFieldManager = new DetachFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state, false);
            for (int i = 0; i < this.loadedFields.length; ++i) {
                if (!this.loadedFields[i]) continue;
                try {
                    detachFieldManager.fetchObjectField(i);
                    continue;
                }
                catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eofpge) {
                    // empty catch block
                }
            }
            if (detachable) {
                this.myLC = this.myLC.transitionDetach(this);
                this.myPC.jdoReplaceFlags();
                ((Detachable)this.myPC).jdoReplaceDetachedState();
                this.getCallbackHandler().postDetach(this.myPC, this.myPC);
                PersistenceCapable toCheckPC = this.myPC;
                Object toCheckID = this.myID;
                this.disconnect();
                if (!toCheckPC.jdoIsDetached()) {
                    throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfObjectFailed", toCheckPC.getClass().getName(), toCheckID));
                }
            } else {
                this.makeTransient(null);
            }
        }
        finally {
            this.detaching = false;
        }
    }

    private int[] getFieldsNumbersToDetach() {
        int[] allFieldNumbers;
        int[] loadedFieldNumbers;
        int[] fieldsToDetach = this.myFP.getFieldsInActualFetchPlan();
        if ((this.myOM.getFetchPlan().getDetachmentOptions() & 2) == 0 && (loadedFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, allFieldNumbers = this.getAllFieldNumbers(), true)) != null && loadedFieldNumbers.length > 0) {
            int i;
            boolean[] flds = new boolean[allFieldNumbers.length];
            for (i = 0; i < fieldsToDetach.length; ++i) {
                flds[fieldsToDetach[i]] = true;
            }
            for (i = 0; i < loadedFieldNumbers.length; ++i) {
                flds[loadedFieldNumbers[i]] = true;
            }
            fieldsToDetach = JDOStateManagerImpl.getFlagsSetTo(flds, true);
        }
        return fieldsToDetach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachCopy(FetchPlanState state) {
        PersistenceCapable detachedPC;
        if (this.myLC.isDeleted()) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfDeletedObjectNotPossible", this.myPC.getClass().getName(), this.myID));
        }
        if (this.myOM.getApiAdapter().isDetached(this.myPC)) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfAlreadyDetachedObjectNotPossible", this.myPC.getClass().getName(), this.myID));
        }
        if (this.dirty) {
            this.myOM.flush(false);
        }
        if (this.detaching) {
            return this.referencedPC;
        }
        this.referencedPC = detachedPC = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        boolean detachable = this.myOM.getApiAdapter().isDetachable(this.myPC);
        PersistenceCapable persistenceCapable = this.referencedPC;
        synchronized (persistenceCapable) {
            if (detachable) {
                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("OM.DetachCopy", StringUtils.toJVMIDString(this.myPC), "" + state.getCurrentFetchDepth()));
                }
                this.getCallbackHandler().preDetach(this.myPC);
            }
            try {
                this.detaching = true;
                if ((this.myOM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                    this.loadUnloadedFieldsInFetchPlan();
                }
                if (this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(9)) {
                    this.myLC = this.myLC.transitionReadField(this, true);
                }
                JDOStateManagerImpl smDetachedPC = new JDOStateManagerImpl(this.myOM, this.cmd);
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(this.myPC), this.getVersion(this.myPC));
                detachedPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)smDetachedPC);
                smDetachedPC.referencedPC = this.myPC;
                smDetachedPC.replaceFields(this.getFieldsNumbersToDetach(), new DetachFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state, true));
                smDetachedPC.referencedPC = null;
                if (detachable) {
                    detachedPC.jdoReplaceFlags();
                    ((Detachable)detachedPC).jdoReplaceDetachedState();
                } else {
                    smDetachedPC.makeTransient(null);
                }
                detachedPC.jdoReplaceStateManager(null);
            }
            catch (Exception e) {
                JPOXLogger.JDO.debug("DETACH ERROR : Error thrown while detaching " + StringUtils.toJVMIDString(this.myPC) + " (id=" + this.myID + ")", e);
            }
            finally {
                this.detaching = false;
                this.referencedPC = null;
            }
            if (detachable && !this.myOM.getApiAdapter().isDetached(detachedPC)) {
                throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfObjectFailed", detachedPC.getClass().getName(), this.myID));
            }
            if (detachable) {
                this.getCallbackHandler().postDetach(this.myPC, detachedPC);
            }
        }
        return detachedPC;
    }

    public Object getReferencedPC() {
        return this.referencedPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachCopy(Object obj, boolean embedded) {
        if (this.attaching) {
            return this.myPC;
        }
        this.attaching = true;
        PersistenceCapable detachedPC = (PersistenceCapable)obj;
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myOM.getOMFContext().getPersistenceConfiguration().getAttachSameDatastore()) {
                try {
                    this.getStoreManager().locateObject(this);
                    persistent = true;
                }
                catch (JPOXObjectNotFoundException onfe) {}
            } else {
                persistent = true;
            }
            this.getCallbackHandler().preAttach(detachedPC);
            if (this.myOM.getApiAdapter().isDeleted(detachedPC)) {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            if (this.myLC == this.myOM.getApiAdapter().getLifeCycleState(4) || this.myLC == this.myOM.getApiAdapter().getLifeCycleState(9)) {
                this.myLC = this.myLC.transitionMakeTransactional(this);
            }
            if (persistent) {
                this.loadSCONonContainerFields();
            }
            JDOStateManagerImpl smDetachedPC = new JDOStateManagerImpl(this.myOM, this.cmd);
            smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(detachedPC), null);
            detachedPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)smDetachedPC);
            smDetachedPC.referencedPC = this.myPC;
            this.referencedPC = detachedPC;
            this.retrieveDetachState(smDetachedPC);
            if (!persistent) {
                this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, false);
                this.makePersistent();
            }
            this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, true);
            detachedPC.jdoReplaceStateManager(null);
            smDetachedPC.referencedPC = null;
            this.referencedPC = null;
            this.getCallbackHandler().postAttach(this.myPC, detachedPC);
        }
        finally {
            this.attaching = false;
        }
        return this.myPC;
    }

    private void internalAttachCopy(StateManager sm, StateManager smDetached, boolean[] loadedFields, boolean[] dirtyFields, boolean persistent, Object version, boolean cascade) {
        int[] attachFieldNumbers = null;
        int numberOfAttachFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numberOfAttachFields;
        }
        attachFieldNumbers = new int[numberOfAttachFields];
        int n = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            attachFieldNumbers[n++] = this.getAllFieldNumbers()[i];
        }
        sm.setVersion(version);
        if (attachFieldNumbers != null) {
            smDetached.provideFields(attachFieldNumbers, new AttachFieldManager(sm, this.getSecondClassMutableFields(), dirtyFields, persistent, cascade));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (!this.myLC.isDeleted()) {
            if (this.myOM.isDelayDatastoreOperationsEnabled()) {
                this.getCallbackHandler().preDelete(this.myPC);
                this.myOM.markDirty(this);
                if (this.myLC.stateType() == 2 || this.myLC.stateType() == 3 || this.myLC.stateType() == 4 || this.myLC.stateType() == 9 || this.myLC.stateType() == 10) {
                    this.loadUnloadedFields();
                }
                this.provideFields(this.getAllFieldNumbers(), new DeleteFieldManager(this));
                this.dirty = true;
                this.preStateChange();
                try {
                    this.myLC = this.myLC.transitionDeletePersistent(this);
                }
                finally {
                    this.postStateChange();
                }
            }
            this.getCallbackHandler().preDelete(this.myPC);
            this.dirty = true;
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            finally {
                this.postStateChange();
            }
            this.internalDeletePersistent();
            this.getCallbackHandler().postDelete(this.myPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeletePersistent() {
        if (this.isDeleting()) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DeleteRecursiveError"));
        }
        this.activity = ActivityState.DELETING;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myOM.flush(false);
            }
            this.getStoreManager().deleteObject(this);
        }
        finally {
            this.activity = ActivityState.NONE;
        }
    }

    public void locate() {
        this.getStoreManager().locateObject(this);
    }

    public void nullifyFields() {
        if (!this.myLC.isDeleted() && !this.myOM.getApiAdapter().isDetached(this.myPC)) {
            this.replaceFields(this.getNonPrimaryKeyFieldNumbers(), new NullifyRelationFieldManager(this));
            this.flush();
        }
    }

    public void validate() {
        if (!this.myLC.isTransactional) {
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.getNonPrimaryKeyFields(), fieldNumbers, true);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.getSecondClassMutableFields(), fieldNumbers, false);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.transitionReadField(false);
                fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
                if (fieldNumbers != null) {
                    boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
                    this.setTransactionalVersion(null);
                    this.getStoreManager().fetchObject(this, fieldNumbers);
                    if (callPostLoad) {
                        this.postLoad();
                    }
                    this.myOM.putObjectIntoCache(this, false, true);
                }
            } else {
                this.getStoreManager().locateObject(this);
                this.transitionReadField(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        if (this.myLC != this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.getCallbackHandler().preClear(this.myPC);
                this.getCallbackHandler().postClear(this.myPC);
            }
            finally {
                this.myLC = this.myLC.transitionEvict(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fgOnly);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(FetchPlan fetchPlan) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fetchPlan);
        }
        finally {
            this.postStateChange();
        }
    }

    private void preStateChange() {
        this.changingState = true;
    }

    private void postStateChange() {
        this.changingState = false;
        if (this.postLoadPending && this.isFetchPlanLoaded()) {
            this.postLoadPending = false;
            this.postLoad();
        }
    }

    private boolean preWriteField(int field) {
        boolean wasDirty = this.dirty;
        if (this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS) {
            if (!wasDirty) {
                this.getCallbackHandler().preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[field] = true;
            this.loadedFields[field] = true;
        }
        return wasDirty;
    }

    private void postWriteField(boolean wasDirty) {
        if (this.dirty && !wasDirty) {
            this.getCallbackHandler().postDirty(this.myPC);
        }
        if (!(this.activity != ActivityState.NONE || this.flushing || this.myLC.isTransactional && !this.myLC.isPersistent)) {
            this.myOM.markDirty(this);
        }
    }

    private void postLoad() {
        if (this.changingState) {
            this.postLoadPending = true;
        } else {
            if (this.jdoFlags == 1 && this.myLC.isTransactional()) {
                this.jdoFlags = (byte)-1;
                this.myPC.jdoReplaceFlags();
            }
            this.getCallbackHandler().postLoad(this.myPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBegin(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionBegin(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myOM.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    public void setStoringPC() {
        this.storingPC = true;
    }

    public void unsetStoringPC() {
        this.storingPC = false;
    }

    public void preSerialize(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return;
        }
        this.retrieve(false);
        this.myLC = this.myLC.transitionSerialize(this);
        if (!this.storingPC && pc instanceof Detachable && !this.myLC.isDeleted && this.myLC.isPersistent) {
            if (this.myLC.isDirty) {
                this.flush();
            }
            ((Detachable)pc).jdoReplaceDetachedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.dirty) {
            if (this.flushing) {
                return;
            }
            this.flushing = true;
            try {
                if (this.myLC.stateType() == 1 && !this.flushedNew) {
                    if (!this.isEmbedded()) {
                        this.internalMakePersistent();
                    } else {
                        this.getCallbackHandler().preStore(this.myPC);
                        this.getCallbackHandler().postStore(this.myPC);
                    }
                    this.dirty = false;
                } else if (this.myLC.stateType() == 8) {
                    this.getCallbackHandler().preDelete(this.myPC);
                    if (!this.isEmbedded()) {
                        this.internalDeletePersistent();
                    }
                    this.getCallbackHandler().postDelete(this.myPC);
                } else if (this.myLC.stateType() == 7) {
                    if (this.flushedNew) {
                        this.getCallbackHandler().preDelete(this.myPC);
                        if (!this.isEmbedded()) {
                            this.internalDeletePersistent();
                        }
                        this.flushedNew = false;
                        this.getCallbackHandler().postDelete(this.myPC);
                    } else {
                        this.dirty = false;
                    }
                } else {
                    int[] dirtyFieldNumbers;
                    if (!this.isDeleting()) {
                        this.getCallbackHandler().preStore(this.myPC);
                    }
                    if ((dirtyFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.dirtyFields, true)) == null) {
                        throw new JDOFatalInternalException(LOCALISER.msg("StateManager.InconsistentDirtyStateError"));
                    }
                    if (!this.isEmbedded()) {
                        this.getStoreManager().updateObject(this, dirtyFieldNumbers);
                        this.myOM.putObjectIntoCache(this, true, true);
                    }
                    this.clearDirtyFlags();
                    this.getCallbackHandler().postStore(this.myPC);
                }
            }
            finally {
                this.flushing = false;
            }
        }
    }

    public void manageRelationships() {
        if (this.managedRelationConstraints == null) {
            return;
        }
        ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
        Iterator iter = this.managedRelationConstraints.iterator();
        while (iter.hasNext()) {
            RelationConstraint constr = (RelationConstraint)iter.next();
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(constr.getFieldNumber());
            mmd.getRelationType(clr);
        }
        this.managedRelationConstraints.clear();
        this.managedRelationConstraints = null;
    }

    public void addManagedRelationConstraint(int fieldNumber, int operation, Object value) {
        if (this.managedRelationConstraints == null) {
            this.managedRelationConstraints = new HashSet();
        }
        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            if (operation == RelationConstraint.OPERATION_CONTAINS) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelationsContain", StringUtils.toJVMIDString(this.myPC), this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), StringUtils.toJVMIDString(value)));
            } else if (operation == RelationConstraint.OPERATION_NOTCONTAINS) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelationsNotContain", StringUtils.toJVMIDString(this.myPC), this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), StringUtils.toJVMIDString(value)));
            } else if (operation == RelationConstraint.OPERATION_EQUALS) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.ManagedRelationsEqual", StringUtils.toJVMIDString(this.myPC), this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), StringUtils.toJVMIDString(value)));
            }
        }
        RelationConstraint constr = new RelationConstraint(fieldNumber, operation, value);
        this.managedRelationConstraints.add(constr);
    }

    private void initializeSM(int newState) {
        final JDOStateManagerImpl thisSM = this;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(newState);
        try {
            if (this.myLC.isPersistent()) {
                this.myOM.addStateManager(this);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        JDOStateManagerImpl.this.myPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)thisSM);
                        return null;
                    }
                    catch (SecurityException e) {
                        throw new JDOFatalUserException("EXC_CannotSetStateManager", (Throwable)e);
                    }
                }
            });
        }
        catch (SecurityException e) {
            throw new JDOUserException(e.getMessage());
        }
        catch (JDOException jdoException) {
            if (this.myOM.getStateManagerById(this.myID) == this) {
                this.myOM.removeStateManager(this);
            }
            throw jdoException;
        }
    }

    protected boolean disconnectClone(PersistenceCapable pc) {
        if (this.detaching) {
            return false;
        }
        if (pc != this.myPC) {
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DisconnectClone", StringUtils.toJVMIDString(pc), this));
            }
            pc.jdoReplaceFlags();
            pc.jdoReplaceStateManager(null);
            return true;
        }
        return false;
    }

    private void unsetOwnerInSCOFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getSecondClassMutableFieldNumbers(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.provideFields(fieldNumbers, new UnsetOwners());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.Disconnect", StringUtils.toJVMIDString(this.myPC), this));
        }
        if (this.postLoadPending) {
            this.changingState = false;
            this.postLoadPending = false;
            this.postLoad();
        }
        this.unsetOwnerInSCOFields();
        this.myOM.removeStateManager(this);
        this.jdoFlags = 0;
        this.myPC.jdoReplaceFlags();
        this.disconnecting = true;
        try {
            this.replaceStateManager(null);
        }
        finally {
            this.disconnecting = false;
        }
        this.clearSavedFields();
        this.myOM = null;
        this.myFP = null;
        this.myPC = null;
        this.myID = null;
        this.myLC = null;
        this.cmd = null;
    }

    public void registerTransactional() {
        this.myOM.addStateManager(this);
    }

    public void retrieveDetachState(StateManager sm) {
        if (sm.getObject() instanceof Detachable) {
            ((JDOStateManagerImpl)sm).miscFlags = (byte)(((JDOStateManagerImpl)sm).miscFlags | 0xFFFFFF80);
            ((Detachable)sm.getObject()).jdoReplaceDetachedState();
            ((JDOStateManagerImpl)sm).miscFlags = (byte)(((JDOStateManagerImpl)sm).miscFlags & 0x7F);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.miscFlags = (byte)(this.miscFlags | 0x40);
            try {
                ((Detachable)this.getObject()).jdoReplaceDetachedState();
            }
            finally {
                this.miscFlags = (byte)(this.miscFlags & 0xFFFFFFBF);
            }
        }
    }

    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        int i;
        if ((this.miscFlags & 0x40) != 0) {
            return null;
        }
        if ((this.miscFlags & 0xFFFFFF80) != 0) {
            BitSet jdoLoadedFields = (BitSet)currentState[2];
            for (int i2 = 0; i2 < this.loadedFields.length; ++i2) {
                this.loadedFields[i2] = jdoLoadedFields.get(i2);
            }
            BitSet jdoModifiedFields = (BitSet)currentState[3];
            for (int i3 = 0; i3 < this.dirtyFields.length; ++i3) {
                this.dirtyFields[i3] = jdoModifiedFields.get(i3);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.getVersion(this.myPC);
        if (currentState == null || currentState[2] == null) {
            BitSet loadedState = new BitSet();
            for (i = 0; i < this.loadedFields.length; ++i) {
                if (this.loadedFields[i]) {
                    loadedState.set(i);
                    continue;
                }
                loadedState.clear(i);
            }
            state[2] = loadedState;
        } else {
            state[2] = currentState[2];
        }
        if (currentState == null || currentState[3] == null) {
            BitSet modifiedState = new BitSet();
            for (i = 0; i < this.dirtyFields.length; ++i) {
                if (this.dirtyFields[i]) {
                    modifiedState.set(i);
                    continue;
                }
                modifiedState.clear(i);
            }
            state[3] = modifiedState;
        } else {
            state[3] = currentState[3];
        }
        return state;
    }

    private static void dumpPC(PersistenceCapable pc, PrintWriter out) {
        out.println(StringUtils.toJVMIDString(pc));
        if (pc == null) {
            return;
        }
        out.print("jdoStateManager = " + JDOStateManagerImpl.peekField(pc, "jdoStateManager"));
        out.print("jdoFlags = ");
        Object flagsObj = JDOStateManagerImpl.peekField(pc, "jdoFlags");
        if (flagsObj instanceof Byte) {
            out.println(JDOStateManagerImpl.jdoFlagsToString((Byte)flagsObj));
        } else {
            out.println(flagsObj);
        }
        Class<?> c = pc.getClass();
        do {
            String[] fieldNames = HELPER.getFieldNames(c);
            for (int i = 0; i < fieldNames.length; ++i) {
                out.print(fieldNames[i]);
                out.print(" = ");
                out.println(JDOStateManagerImpl.peekField(pc, fieldNames[i]));
            }
        } while ((c = c.getSuperclass()) != null && (class$javax$jdo$spi$PersistenceCapable == null ? JDOStateManagerImpl.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(c));
    }

    public void dump(PrintWriter out) {
        out.println("myPM = " + this.myOM);
        out.println("myID = " + this.myID);
        out.println("myLC = " + this.myLC);
        out.println("cmd = " + this.cmd);
        out.println("srm = " + this.getStoreManager());
        out.println("fieldCount = " + this.getHighestFieldNumber());
        out.println("dirty = " + this.dirty);
        out.println("flushing = " + this.flushing);
        out.println("changingState = " + this.changingState);
        out.println("postLoadPending = " + this.postLoadPending);
        out.println("disconnecting = " + this.disconnecting);
        out.println("dirtyFields = " + StringUtils.booleanArrayToString(this.dirtyFields));
        out.println("getSecondClassMutableFields() = " + StringUtils.booleanArrayToString(this.getSecondClassMutableFields()));
        out.println("getAllFieldNumbers() = " + StringUtils.intArrayToString(this.getAllFieldNumbers()));
        out.println("secondClassMutableFieldNumbers = " + StringUtils.intArrayToString(this.getSecondClassMutableFieldNumbers()));
        out.println();
        out.println("jdoFlags = " + JDOStateManagerImpl.jdoFlagsToString(this.jdoFlags));
        out.println("loadedFields = " + StringUtils.booleanArrayToString(this.loadedFields));
        out.print("myPC = ");
        JDOStateManagerImpl.dumpPC(this.myPC, out);
        out.println();
        out.println("savedFlags = " + JDOStateManagerImpl.jdoFlagsToString(this.savedFlags));
        out.println("savedLoadedFields = " + StringUtils.booleanArrayToString(this.savedLoadedFields));
        out.print("savedImage = ");
        JDOStateManagerImpl.dumpPC(this.savedImage, out);
    }

    private static String jdoFlagsToString(byte flags) {
        switch (flags) {
            case 1: {
                return "LOAD_REQUIRED";
            }
            case -1: {
                return "READ_OK";
            }
            case 0: {
                return "READ_WRITE_OK";
            }
        }
        return "???";
    }

    public String toString() {
        return "JDOStateManagerImpl[pc=" + StringUtils.toJVMIDString(this.myPC) + ", lifecycle=" + this.myLC + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
        HELPER = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(AbstractStateManager.LOCALISER.msg("StateManager.SecurityProblem"), (Throwable)e);
                }
            }
        });
    }

    private class FieldContainer {
        boolean[] fieldsToUpdate;

        public FieldContainer(int fieldNumber) {
            this.fieldsToUpdate = new boolean[JDOStateManagerImpl.this.getAllFieldNumbers().length];
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public void set(int fieldNumber) {
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public int[] getFields() {
            return AbstractStateManager.getFlagsSetTo(this.fieldsToUpdate, true);
        }
    }

    private class EmbeddedOwnerRelation {
        private StateManager sm;
        private int fieldNumber;

        public EmbeddedOwnerRelation(StateManager ownerSM, int ownerFieldNumber) {
            this.sm = ownerSM;
            this.fieldNumber = ownerFieldNumber;
        }
    }
}

