/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import org.jpox.FetchPlan;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class LifeCycleState {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    public static final int TRANSIENT = 0;
    public static final int P_NEW = 1;
    public static final int P_CLEAN = 2;
    public static final int P_DIRTY = 3;
    public static final int HOLLOW = 4;
    public static final int T_CLEAN = 5;
    public static final int T_DIRTY = 6;
    public static final int P_NEW_DELETED = 7;
    public static final int P_DELETED = 8;
    public static final int P_NONTRANS = 9;
    public static final int P_NONTRANS_DIRTY = 10;
    public static final int DETACHED_CLEAN = 11;
    public static final int DETACHED_DIRTY = 12;
    public static final int TOTAL = 13;
    public static final int ILLEGAL_STATE = 13;
    protected boolean isDirty;
    protected boolean isNew;
    protected boolean isDeleted;
    protected boolean isTransactional;
    protected boolean isPersistent;
    protected int stateType;

    public final int stateType() {
        return this.stateType;
    }

    protected final LifeCycleState changeState(StateManager sm, int newStateType) {
        LifeCycleState newState = sm.getObjectManager().getOMFContext().getApiAdapter().getLifeCycleState(newStateType);
        if (JPOXLogger.LIFECYCLE.isDebugEnabled()) {
            JPOXLogger.LIFECYCLE.debug(LOCALISER.msg("Lifecycle.StateChange", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId().toString(), this, newState));
        }
        if (this.isTransactional) {
            if (newState == null || !newState.isTransactional) {
                sm.evictFromTransaction();
            }
        } else if (newState != null && newState.isTransactional) {
            sm.enlistInTransaction();
        }
        if (newState == null) {
            sm.disconnect();
        }
        return newState;
    }

    protected final LifeCycleState changeTransientState(StateManager sm, int newStateType) {
        LifeCycleState newState = sm.getObjectManager().getOMFContext().getApiAdapter().getLifeCycleState(newStateType);
        try {
            sm.enlistInTransaction();
        }
        catch (Exception e) {
            // empty catch block
        }
        return newState;
    }

    public LifeCycleState transitionMakePersistent(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionMakeTransactional(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionMakeNontransactional(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        return this;
    }

    public LifeCycleState transitionBegin(StateManager sm, Transaction tx) {
        return this;
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        return this;
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        return this;
    }

    public LifeCycleState transitionRefresh(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionEvict(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionReadField(StateManager sm, boolean isLoaded) {
        return this;
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionRetrieve(StateManager sm, boolean fgOnly) {
        return this;
    }

    public LifeCycleState transitionRetrieve(StateManager sm, FetchPlan fetchPlan) {
        return this;
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionSerialize(StateManager sm) {
        return this;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final boolean isNew() {
        return this.isNew;
    }

    public final boolean isDeleted() {
        return this.isDeleted;
    }

    public final boolean isTransactional() {
        return this.isTransactional;
    }

    public final boolean isPersistent() {
        return this.isPersistent;
    }

    public abstract String toString();
}

