/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.state.JDOStateManagerImpl;
import org.jpox.store.FieldValues;
import org.jpox.util.Localiser;

public class StateManagerFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");

    public static StateManager newStateManagerForHollow(ObjectManager om, Class pcClass, Object id) {
        Initialization stateManagerInitialization = new Initialization(om, pcClass);
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, null, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForHollowPreConstructed(ObjectManager om, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowPreConstructed(id, (PersistenceCapable)pc);
        return sm;
    }

    public static StateManager newStateManagerForHollowPopulated(ObjectManager om, Class pcClass, Object id, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(om, pcClass);
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForPersistentClean(ObjectManager om, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentClean(id, (PersistenceCapable)pc);
        return sm;
    }

    public static StateManager newStateManagerForHollowPopulatedAppId(ObjectManager om, Class pcClass, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(om, pcClass);
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowAppId(fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForEmbedded(ObjectManager om, Object pc, boolean copyPc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForEmbedded((PersistenceCapable)pc, copyPc);
        return sm;
    }

    public static StateManager newStateManagerForPersistentNew(ObjectManager om, Object pc, FieldValues preInsertChanges) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentNew((PersistenceCapable)pc, preInsertChanges);
        return sm;
    }

    public static StateManager newStateManagerForTransactionalTransient(ObjectManager om, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForTransactionalTransient((PersistenceCapable)pc);
        return sm;
    }

    public static StateManager newStateManagerForDetached(ObjectManager om, Object pc, Object id, Object version) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForDetached((PersistenceCapable)pc, id, version);
        return sm;
    }

    public static StateManager newStateManagerForCachedPC(ObjectManager om, Object pc, Object id, boolean[] loaded) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        JDOStateManagerImpl sm = new JDOStateManagerImpl(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForCachedPC((PersistenceCapable)pc, id, loaded, stateManagerInitialization.getPCClass());
        return sm;
    }

    protected static class Initialization {
        protected Class pcClass;
        protected AbstractClassMetaData cmd;

        protected Initialization(ObjectManager myOM, Class pcClass) {
            ClassLoaderResolver clr = myOM.getClassLoaderResolver();
            if (myOM.getOMFContext().getTypeManager().isReferenceType(pcClass)) {
                this.cmd = myOM.getMetaDataManager().getMetaDataForImplementationOfReference(pcClass, null, clr);
                this.pcClass = clr.classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
            } else {
                try {
                    this.pcClass = clr.classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                    this.cmd = myOM.getMetaDataManager().getMetaDataForClass(pcClass, clr);
                }
                catch (ClassNotResolvedException e) {
                    throw new JPOXUserException(LOCALISER.msg("StateManager.ClassNotFoundError", pcClass.getName())).setFatal();
                }
            }
            if (this.cmd == null) {
                throw new JPOXUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass)).setFatal();
            }
        }

        protected Class getPCClass() {
            return this.pcClass;
        }

        protected AbstractClassMetaData getClassMetaData() {
            return this.cmd;
        }
    }
}

