/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state.jdo;

import org.jpox.FetchPlan;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.jdo.exceptions.TransactionNotActiveException;
import org.jpox.state.IllegalStateTransitionException;
import org.jpox.state.LifeCycleState;

class Hollow
extends LifeCycleState {
    protected Hollow() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 4;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeTransactional(StateManager sm) {
        sm.refreshLoadedFields();
        return this.changeState(sm, 2);
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(StateManager sm) {
        throw new IllegalStateTransitionException(this, "commit", sm);
    }

    public LifeCycleState transitionRollback(StateManager sm) {
        throw new IllegalStateTransitionException(this, "rollback", sm);
    }

    public LifeCycleState transitionReadField(StateManager sm, boolean isLoaded) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (!(tx.getOptimistic() || tx.isActive() || tx.getNontransactionalRead())) {
            throw new TransactionNotActiveException(LOCALISER.msg("LifeCycle.HollowReadFieldNotAllowedNotActiveTx"), sm.getInternalObjectId());
        }
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!(tx.getOptimistic() || tx.isActive() || tx.getNontransactionalWrite())) {
            throw new TransactionNotActiveException(LOCALISER.msg("LifeCycle.HollowWriteFieldNotAllowedNotActiveTx"), sm.getInternalObjectId());
        }
        return this.changeState(sm, tx.isActive() ? 3 : 9);
    }

    public LifeCycleState transitionRetrieve(StateManager sm, boolean fgOnly) {
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (tx.getOptimistic()) {
            return this.changeState(sm, 9);
        }
        return super.transitionRetrieve(sm, fgOnly);
    }

    public LifeCycleState transitionRetrieve(StateManager sm, FetchPlan fetchPlan) {
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (tx.getOptimistic()) {
            return this.changeState(sm, 9);
        }
        return super.transitionRetrieve(sm, fetchPlan);
    }

    public LifeCycleState transitionRefresh(StateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        return this;
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this.changeState(sm, 11);
    }

    public LifeCycleState transitionSerialize(StateManager sm) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this;
    }

    public String toString() {
        return "HOLLOW";
    }
}

