/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.store.Extent;
import org.jpox.store.StoreManager;
import org.jpox.util.Localiser;

public abstract class AbstractExtent
implements Extent {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected final ObjectManager om;
    protected final Class candidateClass;
    protected final boolean subclasses;
    protected final AbstractClassMetaData cmd;
    protected final StoreManager storeMgr;

    public AbstractExtent(ObjectManager om, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        if (cls == null) {
            throw new JPOXUserException(LOCALISER.msg("Extent.ClassNameNotSpecified")).setFatal();
        }
        this.storeMgr = om.getStoreManager();
        this.cmd = cmd;
        if (cmd == null) {
            throw new JPOXUserException(LOCALISER.msg("Extent.ClassHasNoMetaData", cls.getName())).setFatal();
        }
        this.om = om;
        this.candidateClass = cls;
        this.subclasses = subclasses;
    }

    public boolean hasSubclasses() {
        return this.subclasses;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public ObjectManager getObjectManager() {
        return this.om;
    }

    public String toString() {
        return LOCALISER.msg("Extent.ClassExtentInfo", this.candidateClass.getName(), "" + this.subclasses);
    }
}

