/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.IdentifierFactory;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class AbstractIdentifierFactory
implements IdentifierFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    public static final int CASE_PRESERVE = 1;
    public static final int CASE_UPPER = 2;
    public static final int CASE_LOWER = 3;
    protected DatastoreAdapter dba;
    protected int identifierCase;
    private static final int HASH_RANGE = 648;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractIdentifierFactory(DatastoreAdapter dba, String requiredCase) {
        this.dba = dba;
        int userIdentifierCase = 2;
        if (requiredCase.equalsIgnoreCase("UpperCase")) {
            userIdentifierCase = 2;
        } else if (requiredCase.equalsIgnoreCase("LowerCase")) {
            userIdentifierCase = 3;
        } else if (requiredCase.equalsIgnoreCase("PreserveCase")) {
            userIdentifierCase = 1;
        }
        if (userIdentifierCase == 2) {
            if (dba.isStoresUpperCaseIdentifiers()) {
                this.identifierCase = 0;
                return;
            } else if (dba.isStoresUpperCaseQuotedIdentifiers()) {
                this.identifierCase = 1;
                return;
            } else if (dba.isStoresMixedCaseIdentifiers()) {
                this.identifierCase = 0;
                return;
            } else if (dba.isStoresMixedCaseQuotedIdentifiers()) {
                this.identifierCase = 1;
                return;
            } else if (dba.isStoresLowerCaseIdentifiers()) {
                this.identifierCase = 2;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "UPPERCASE", "LOWERCASE"));
                return;
            } else {
                if (!dba.isStoresLowerCaseQuotedIdentifiers()) throw new JPOXUserException(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastore", "UPPERCASE")).setFatal();
                this.identifierCase = 3;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "UPPERCASE", "LOWERCASEQUOTED"));
            }
            return;
        } else if (userIdentifierCase == 3) {
            if (dba.isStoresLowerCaseIdentifiers()) {
                this.identifierCase = 2;
                return;
            } else if (dba.isStoresLowerCaseQuotedIdentifiers()) {
                this.identifierCase = 3;
                return;
            } else if (dba.isStoresMixedCaseIdentifiers()) {
                this.identifierCase = 2;
                return;
            } else if (dba.isStoresMixedCaseQuotedIdentifiers()) {
                this.identifierCase = 3;
                return;
            } else if (dba.isStoresUpperCaseIdentifiers()) {
                this.identifierCase = 0;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "LOWERCASE", "UPPERCASE"));
                return;
            } else {
                if (!dba.isStoresUpperCaseQuotedIdentifiers()) throw new JPOXUserException(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastore", "LOWERCASE")).setFatal();
                this.identifierCase = 1;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "LOWERCASE", "UPPERCASEQUOTED"));
            }
            return;
        } else {
            if (userIdentifierCase != 1) throw new JPOXUserException(LOCALISER.msg("IdentifierFactory.CaseNotSupported", userIdentifierCase)).setFatal();
            if (dba.isStoresMixedCaseIdentifiers()) {
                this.identifierCase = 4;
                return;
            } else if (dba.isStoresMixedCaseQuotedIdentifiers()) {
                this.identifierCase = 5;
                return;
            } else if (dba.isStoresLowerCaseIdentifiers()) {
                this.identifierCase = 2;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "MIXEDCASE", "LOWERCASE"));
                return;
            } else if (dba.isStoresLowerCaseQuotedIdentifiers()) {
                this.identifierCase = 3;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "MIXEDCASE", "LOWERCASEQUOTED"));
                return;
            } else if (dba.isStoresUpperCaseIdentifiers()) {
                this.identifierCase = 0;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "MIXEDCASE", "UPPERCASE"));
                return;
            } else {
                if (!dba.isStoresUpperCaseQuotedIdentifiers()) throw new JPOXUserException(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastore", "MIXEDCASE")).setFatal();
                this.identifierCase = 1;
                JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("IdentifierFactory.CaseNotAvailableForDatastoreUsingAlternative", "MIXEDCASE", "UPPERCASEQUOTED"));
            }
        }
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public int getIdentifierCase() {
        return this.identifierCase;
    }

    public String getNameOfIdentifierCase() {
        if (this.identifierCase == 2) {
            return "lowercase";
        }
        if (this.identifierCase == 3) {
            return "\"lowercase\"";
        }
        if (this.identifierCase == 4) {
            return "\"MixedCase\"";
        }
        if (this.identifierCase == 5) {
            return "\"MixedCase\"";
        }
        if (this.identifierCase == 0) {
            return "UPPERCASE";
        }
        if (this.identifierCase == 1) {
            return "\"UPPERCASE\"";
        }
        return "UNKNOWN";
    }

    protected static String truncate(String identifier, int length) {
        if (identifier.length() > length) {
            int tailIndex = length - 2;
            int tailHash = identifier.substring(tailIndex).hashCode();
            tailHash = tailHash < 0 ? tailHash % 648 + 647 : tailHash % 648 + 648;
            String suffix = "0" + Integer.toString(tailHash, 36);
            return identifier.substring(0, tailIndex) + suffix.substring(suffix.length() - 2);
        }
        return identifier;
    }

    protected abstract int getMaxLengthForIdentifierType(int var1);
}

