/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.util.HashMap;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.DatastoreObject;
import org.jpox.store.FetchStatement;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.TableStoreData;
import org.jpox.store.exceptions.DatastorePermissionException;
import org.jpox.store.fieldmanager.FieldManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public abstract class MappedStoreManager
extends StoreManager {
    protected final boolean autoCreateTables;
    protected final boolean autoCreateColumns;
    protected final boolean autoCreateConstraints;
    protected final boolean autoCreateWarnOnError;
    protected final boolean validateTables;
    protected final boolean validateColumns;
    protected final boolean validateConstraints;
    protected final boolean checkExistTablesOrViews;
    protected Map datastoreContainerByIdentifier = new HashMap();

    protected MappedStoreManager(ClassLoaderResolver clr, ObjectManagerFactoryImpl omf) {
        super(clr, omf);
        this.autoCreateColumns = omf.getPersistenceConfiguration().getAutoCreateColumns();
        this.autoCreateTables = omf.getPersistenceConfiguration().getAutoCreateTables();
        this.autoCreateConstraints = omf.getPersistenceConfiguration().getAutoCreateConstraints();
        this.autoCreateWarnOnError = omf.getPersistenceConfiguration().getAutoCreateWarnOnError();
        this.validateTables = omf.getPersistenceConfiguration().getValidateTables();
        this.validateColumns = omf.getPersistenceConfiguration().getValidateColumns();
        this.validateConstraints = omf.getPersistenceConfiguration().getValidateConstraints();
        this.checkExistTablesOrViews = omf.getPersistenceConfiguration().getCheckExistTablesOrViews();
    }

    public MappingManager getMappingManager() {
        return this.dba.getMappingManager();
    }

    public boolean usesDatastoreClass() {
        return true;
    }

    public void insertObject(StateManager sm) {
        if (this.readOnlyDatastore) {
            if (this.readOnlyDatastoreAction.equalsIgnoreCase("EXCEPTION")) {
                throw new DatastorePermissionException(LOCALISER.msg("StoreManager.InsertObjectWhileReadOnlyError", StringUtils.toJVMIDString(sm.getObject())));
            }
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StoreManager.InsertObjectWhileReadOnlyIgnore", StringUtils.toJVMIDString(sm.getObject())));
            }
            return;
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        String className = sm.getObject().getClass().getName();
        DatastoreClass dc = this.getDatastoreClass(className, clr);
        if (dc == null) {
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new JPOXUserException(LOCALISER.msg("StoreManager.NoTableForClass", className));
            }
            throw new JPOXException(LOCALISER.msg("StoreManager.CantFindTableForClass", className, cmd.getInheritanceMetaData().getStrategyValue())).setFatal();
        }
        this.storeManagerRuntime.incrementInsertCount();
        dc.insert(sm);
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (sm.getPcObjectType() != 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < fmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(fmds[i].getName());
                }
                JPOXLogger.PERSISTENCE.info("Request to load fields \"" + str.toString() + "\" of class " + sm.getClassMetaData().getFullClassName() + " but object is embedded, so ignored");
            } else {
                this.storeManagerRuntime.incrementFetchCount();
                this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).fetch(sm, fmds);
            }
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        if (this.readOnlyDatastore) {
            if (this.readOnlyDatastoreAction.equalsIgnoreCase("EXCEPTION")) {
                throw new DatastorePermissionException(LOCALISER.msg("StoreManager.UpdateObjectWhileReadOnlyError", StringUtils.toJVMIDString(sm.getObject())));
            }
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StoreManager.UpdateObjectWhileReadOnlyIgnore", StringUtils.toJVMIDString(sm.getObject())));
            }
            return;
        }
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            this.storeManagerRuntime.incrementUpdateCount();
            this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).update(sm, fmds);
        }
    }

    public void deleteObject(StateManager sm) {
        if (this.readOnlyDatastore) {
            if (this.readOnlyDatastoreAction.equalsIgnoreCase("EXCEPTION")) {
                throw new DatastorePermissionException(LOCALISER.msg("StoreManager.DeleteObjectWhileReadOnlyError", StringUtils.toJVMIDString(sm.getObject())));
            }
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StoreManager.DeleteObjectWhileReadOnlyIgnore", StringUtils.toJVMIDString(sm.getObject())));
            }
            return;
        }
        this.storeManagerRuntime.incrementDeleteCount();
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).delete(sm);
    }

    public void locateObject(StateManager sm) {
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).locate(sm);
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public abstract CollectionStore getBackingStoreForCollection(AbstractMemberMetaData var1, DatastoreObject var2, ClassLoaderResolver var3, boolean var4, boolean var5);

    public abstract MapStore getBackingStoreForMap(AbstractMemberMetaData var1, DatastoreObject var2, ClassLoaderResolver var3);

    public abstract ArrayStore getBackingStoreForArray(AbstractMemberMetaData var1, DatastoreObject var2, ClassLoaderResolver var3);

    public abstract FetchStatement getFetchStatement(DatastoreContainerObject var1);

    public abstract DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData var1, ClassLoaderResolver var2);

    public synchronized TableStoreData[] getStoreDataForDatastoreContainerObject(DatastoreIdentifier tableIdentifier) {
        return this.storeDataMgr.getStoreDataForDatastoreContainerObject(tableIdentifier);
    }

    public synchronized DatastoreContainerObject getDatastoreContainerObject(AbstractMemberMetaData fmd) {
        StoreData sd = this.storeDataMgr.get(fmd);
        if (sd != null && sd instanceof TableStoreData) {
            return ((TableStoreData)sd).getDatastoreContainerObject();
        }
        return null;
    }

    public void addDatastoreContainer(DatastoreContainerObject table) {
        if (table != null && this.datastoreContainerByIdentifier.get(table.getIdentifier()) == null) {
            this.datastoreContainerByIdentifier.put(table, table.getIdentifier());
        }
    }

    public abstract void createDatastoreColumnsForReferenceField(JavaTypeMapping var1, DatastoreContainerObject var2, AbstractMemberMetaData var3, ClassLoaderResolver var4, boolean var5);

    public abstract void createDatastoreColumnsForFieldUsingSubclassTable(JavaTypeMapping var1, DatastoreContainerObject var2, AbstractMemberMetaData var3, ClassLoaderResolver var4);

    public abstract FieldManager getFieldManagerForResultProcessing(StateManager var1, Object var2, StatementExpressionIndex[] var3);
}

