/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.util.Localiser;

public class StoreData {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    public static final int FCO_TYPE = 1;
    public static final int SCO_TYPE = 2;
    protected final String name;
    protected MetaData metadata;
    protected final int type;
    protected final String interfaceName;

    public StoreData(String name, MetaData metadata, int type, String interfaceName) {
        this.name = name;
        this.metadata = metadata;
        this.type = type;
        this.interfaceName = interfaceName;
    }

    public String getName() {
        return this.name;
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    public void setMetaData(MetaData md) {
        this.metadata = md;
    }

    public String getSuperclass() {
        if (this.metadata instanceof ClassMetaData) {
            return ((ClassMetaData)this.metadata).getPersistenceCapableSuperclass();
        }
        return null;
    }

    public boolean isFCO() {
        return this.type == 1;
    }

    public boolean isSCO() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String toString() {
        if (this.metadata instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)this.metadata;
            return LOCALISER.msg("StoreData.DataForClass", this.name, "(none)", cmd.getInheritanceMetaData().getStrategyValue().toString());
        }
        if (this.metadata instanceof AbstractMemberMetaData) {
            return LOCALISER.msg("StoreData.DataForField", this.name, null);
        }
        return LOCALISER.msg("StoreData.DataForClass", this.name, null);
    }
}

