/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreData;
import org.jpox.store.TableStoreData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.MultiMap;

public class StoreDataManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected Map storeDataByClass = new HashMap();
    protected MultiMap storeDataByAppIdClass = new MultiMap();
    protected Map savedStoreDataByClass;
    protected MultiMap savedStoreDataByAppIdClass;

    public void clear() {
        if (JPOXLogger.PERSISTENCE.isInfoEnabled()) {
            JPOXLogger.PERSISTENCE.info(LOCALISER.msg("StoreManager.RemoveStoreData"));
        }
        this.storeDataByClass.clear();
        this.storeDataByAppIdClass.clear();
    }

    protected void registerStoreData(StoreData data) {
        if (data.isFCO()) {
            this.storeDataByClass.put(data.getName(), data);
            ClassMetaData cmd = (ClassMetaData)data.getMetaData();
            if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                this.storeDataByAppIdClass.put(cmd.getObjectidClass(), data);
            }
        } else {
            this.storeDataByClass.put(data.getMetaData(), data);
        }
        if (JPOXLogger.PERSISTENCE.isInfoEnabled()) {
            JPOXLogger.PERSISTENCE.info(LOCALISER.msg("StoreManager.AddStoreData", data));
        }
    }

    public synchronized TableStoreData[] getStoreDataForDatastoreContainerObject(DatastoreIdentifier tableIdentifier) {
        HashSet<StoreData> dataForTable = null;
        Iterator iterator = this.storeDataByClass.values().iterator();
        while (iterator.hasNext()) {
            TableStoreData tableData;
            StoreData data = (StoreData)iterator.next();
            if (!(data instanceof TableStoreData) || (tableData = (TableStoreData)data).getDatastoreIdentifier() == null || !tableData.getDatastoreIdentifier().equals(tableIdentifier) || !tableData.isTableOwner()) continue;
            if (dataForTable == null) {
                dataForTable = new HashSet<StoreData>();
            }
            dataForTable.add(data);
        }
        if (dataForTable != null) {
            return dataForTable.toArray(new TableStoreData[dataForTable.size()]);
        }
        return null;
    }

    public boolean managesClass(String className) {
        return this.storeDataByClass.containsKey(className);
    }

    public Collection getManagedStoreData() {
        return Collections.unmodifiableCollection(this.storeDataByClass.values());
    }

    public StoreData get(String className) {
        return (StoreData)this.storeDataByClass.get(className);
    }

    public StoreData get(AbstractMemberMetaData apmd) {
        return (StoreData)this.storeDataByClass.get(apmd);
    }

    public Collection getByPrimaryKeyClass(String className) {
        return (Collection)this.storeDataByAppIdClass.get(className);
    }

    public int size() {
        return this.storeDataByClass.size();
    }

    public void begin() {
        this.savedStoreDataByClass = new HashMap(this.storeDataByClass);
        this.savedStoreDataByAppIdClass = new MultiMap(this.storeDataByAppIdClass);
    }

    public void rollback() {
        this.storeDataByClass = this.savedStoreDataByClass;
        this.storeDataByAppIdClass = this.savedStoreDataByAppIdClass;
    }

    public void commit() {
        this.savedStoreDataByClass = null;
        this.savedStoreDataByAppIdClass = null;
    }
}

