/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.io.PrintStream;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.ConnectionFactory;
import org.jpox.OMFContext;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.identity.OID;
import org.jpox.identity.OIDFactory;
import org.jpox.management.ManagementServer;
import org.jpox.management.runtime.StoreManagerRuntime;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.store.AutoStartMechanism;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.Extent;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.JPOXConnection;
import org.jpox.store.JPOXSequence;
import org.jpox.store.SCOID;
import org.jpox.store.StoreData;
import org.jpox.store.StoreDataManager;
import org.jpox.store.TableStoreData;
import org.jpox.store.exceptions.DatastoreInitialisationException;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.poid.PoidManager;
import org.jpox.store.query.Query;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.MacroString;
import org.jpox.util.StringUtils;

public abstract class StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected DatastoreAdapter dba;
    protected final boolean readOnlyDatastore;
    protected final String readOnlyDatastoreAction;
    protected final boolean fixedDatastore;
    protected AutoStartMechanism starter = null;
    protected boolean starterInitialised = false;
    protected final OMFContext omfContext;
    protected final PoidManager poidManager;
    protected IdentifierFactory identifierFactory;
    protected StoreManagerRuntime storeManagerRuntime;
    protected StoreDataManager storeDataMgr = new StoreDataManager();
    protected String autoStartMechanism = null;
    static /* synthetic */ Class class$org$jpox$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$jpox$store$StoreManager;
    static /* synthetic */ Class class$org$jpox$ClassLoaderResolver;
    static /* synthetic */ Class class$org$jpox$ObjectManager;

    protected StoreManager(ClassLoaderResolver clr, ObjectManagerFactoryImpl omf) {
        this.omfContext = omf.getOMFContext();
        this.readOnlyDatastore = omf.getReadOnlyDatastore();
        this.readOnlyDatastoreAction = omf.getReadOnlyDatastoreAction();
        this.fixedDatastore = omf.getFixedDatastore();
        this.omfContext.setStoreManager(this);
        this.poidManager = new PoidManager();
        this.storeManagerRuntime = new StoreManagerRuntime();
        String mbeanName = this.omfContext.getDomainName() + ":InstanceName=" + this.omfContext.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.storeManagerRuntime.getClass()) + ",Name=StoreManager";
        ManagementServer mgntServer = this.omfContext.getManagement().getManagementServer();
        if (mgntServer != null) {
            mgntServer.registerMBean(this.storeManagerRuntime, mbeanName);
        }
    }

    public void close() {
        this.poidManager.clear();
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.starter = null;
        this.dba = null;
    }

    public abstract ConnectionFactory getConnectionFactory();

    public abstract JPOXSequence getJPOXSequence(ObjectManager var1, SequenceMetaData var2);

    public abstract JPOXConnection getJPOXConnection(ObjectManager var1);

    public PoidManager getPoidManager() {
        return this.poidManager;
    }

    public ApiAdapter getApiAdapter() {
        return this.omfContext.getApiAdapter();
    }

    protected void registerStoreData(StoreData data) {
        this.storeDataMgr.registerStoreData(data);
        if (this.starter != null && this.starterInitialised) {
            this.starter.addClass(data);
        }
    }

    protected void deregisterAllStoreData() {
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.clearAutoStarter();
    }

    public abstract void outputDatastoreInformation(PrintStream var1) throws Exception;

    public abstract void outputSchemaInformation(PrintStream var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAutoStart(String mechanism, String mode, ClassLoaderResolver clr) throws DatastoreInitialisationException {
        block23: {
            if (this.starterInitialised) {
                return;
            }
            this.autoStartMechanism = mechanism;
            String autoStarterClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.autostart", "name", mechanism, "class-name");
            if (autoStarterClassName != null) {
                this.starter = (AutoStartMechanism)ClassUtils.newInstance(clr.classForName(autoStarterClassName, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = StoreManager.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), new Class[]{class$org$jpox$store$StoreManager == null ? (class$org$jpox$store$StoreManager = StoreManager.class$("org.jpox.store.StoreManager")) : class$org$jpox$store$StoreManager, class$org$jpox$ClassLoaderResolver == null ? (class$org$jpox$ClassLoaderResolver = StoreManager.class$("org.jpox.ClassLoaderResolver")) : class$org$jpox$ClassLoaderResolver}, new Object[]{this, clr});
                this.starter.setMode(mode);
            }
            if (this.starter == null) {
                this.starterInitialised = true;
                return;
            }
            boolean illegalState = false;
            try {
                Collection existingData;
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                if ((existingData = this.starter.getAllClassData()) == null || existingData.size() <= 0) break block23;
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                Iterator existingDataIter = existingData.iterator();
                while (existingDataIter.hasNext()) {
                    Class classFound;
                    StoreData data;
                    block24: {
                        data = (StoreData)existingDataIter.next();
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block24;
                            try {
                                this.getOMFContext().getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), this.getMetaDataManager(), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException cnre2) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        JPOXLogger.PERSISTENCE.info(LOCALISER.msg("StoreManager.AddPreviousStoreData", data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = LOCALISER.msg("AutoStarter.MetaDataNotFoundError", data.getName());
                        if (this.starter.getMode().equals("Checked")) {
                            JPOXLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (this.starter.getMode().equals("Ignored")) {
                            JPOXLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (!this.starter.getMode().equals("Quiet")) continue;
                        JPOXLogger.PERSISTENCE.warn(msg);
                        JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.DeleteClass", data.getName()));
                        this.starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = LOCALISER.msg("AutoStarter.ClassNotFoundError", data.getName());
                    if (this.starter.getMode().equals("Checked")) {
                        JPOXLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode().equals("Ignored")) {
                        JPOXLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (!this.starter.getMode().equals("Quiet")) continue;
                    JPOXLogger.PERSISTENCE.warn(msg);
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.DeleteClass", data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.addClasses(classesToLoad, clr);
                }
                catch (Exception e) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.UnknownError", e));
                    illegalState = true;
                }
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
                if (illegalState) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.IllegalStateDisablingAutoStart"));
                    this.starter = null;
                }
            }
        }
        this.starterInitialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAutoStarter() {
        if (this.starter != null) {
            try {
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                this.starter.deleteAllClasses();
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
            }
        }
    }

    public AutoStartMechanism getAutoStartMechanism() {
        return this.starter;
    }

    public boolean managesClass(String className) {
        return this.storeDataMgr.managesClass(className);
    }

    public void addClass(String className, ClassLoaderResolver clr) {
        this.addClasses(new String[]{className}, clr, null, false);
    }

    public abstract void addClasses(String[] var1, ClassLoaderResolver var2, Writer var3, boolean var4);

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        this.addClasses(classNames, clr, null, false);
    }

    public abstract void removeAllClasses(ClassLoaderResolver var1);

    public AbstractClassMetaData[] getClassesManagingTableForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE || cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
            return new AbstractClassMetaData[]{cmd};
        }
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
            int i;
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), true);
            if (subclasses != null) {
                for (int i2 = 0; i2 < subclasses.length; ++i2) {
                    if (this.storeDataMgr.managesClass(subclasses[i2])) continue;
                    this.addClass(subclasses[i2], clr);
                }
            }
            HashSet<AbstractClassMetaData> managingClasses = new HashSet<AbstractClassMetaData>();
            Iterator managedClassesIter = this.storeDataMgr.getManagedStoreData().iterator();
            while (managedClassesIter.hasNext()) {
                AbstractClassMetaData[] superCmds;
                StoreData data = (StoreData)managedClassesIter.next();
                if (!data.isFCO() || ((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData() == null || !((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData().getFullClassName().equals(cmd.getFullClassName()) || (superCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)data.getMetaData(), clr)) == null) continue;
                for (i = 0; i < superCmds.length; ++i) {
                    managingClasses.add(superCmds[i]);
                }
            }
            Iterator managingClassesIter = managingClasses.iterator();
            AbstractClassMetaData[] managingCmds = new AbstractClassMetaData[managingClasses.size()];
            i = 0;
            while (managingClassesIter.hasNext()) {
                managingCmds[i++] = (AbstractClassMetaData)managingClassesIter.next();
            }
            return managingCmds;
        }
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.getClassesManagingTableForClass(cmd.getSuperAbstractClassMetaData(), clr);
        }
        return null;
    }

    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        String className = null;
        if (id instanceof OID) {
            className = ((OID)id).getPcClass();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.DATASTORE) {
                throw new JPOXUserException(LOCALISER.msg("Identity.AssignedToIncorrectClass", id, cmd.getFullClassName()));
            }
        } else if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            className = this.getApiAdapter().getTargetClassForSingleFieldIdentity(id).getName();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new JPOXUserException(LOCALISER.msg("Identity.AssignedToIncorrectClass", id, cmd.getFullClassName()));
            }
        } else {
            throw new JPOXException("StoreManager.manageClassForIdentity called for id=" + id + " yet should only be called for datastore-identity/SingleFieldIdentity");
        }
        if (!this.managesClass(className)) {
            this.addClass(className, clr);
        }
        return className;
    }

    public boolean usesDatastoreClass() {
        return false;
    }

    public abstract Extent getExtent(ObjectManager var1, Class var2, boolean var3);

    public abstract boolean supportsQueryLanguage(String var1);

    public Query newQuery(String language, ObjectManager om, Object query) {
        if (language == null) {
            return null;
        }
        String queryClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.store_query_query", "name", language, "class-name");
        if (queryClassName != null) {
            if (query == null) {
                return (Query)ClassUtils.newInstance(om.getClassLoaderResolver().classForName(queryClassName, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = StoreManager.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), new Class[]{class$org$jpox$ObjectManager == null ? (class$org$jpox$ObjectManager = StoreManager.class$("org.jpox.ObjectManager")) : class$org$jpox$ObjectManager}, new Object[]{om});
            }
            return (Query)ClassUtils.newInstance(om.getClassLoaderResolver().classForName(queryClassName, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = StoreManager.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), new Class[]{class$org$jpox$ObjectManager == null ? (class$org$jpox$ObjectManager = StoreManager.class$("org.jpox.ObjectManager")) : class$org$jpox$ObjectManager, query.getClass()}, new Object[]{om, query});
        }
        return null;
    }

    public abstract String getClassNameForObjectID(Object var1, ClassLoaderResolver var2, ObjectManager var3);

    public boolean isStrategyDatastoreAttributed(IdentityStrategy identityStrategy, boolean datastoreIdentityField) {
        if (identityStrategy == null) {
            return false;
        }
        return identityStrategy == IdentityStrategy.IDENTITY;
    }

    public abstract Object getStrategyValue(ObjectManager var1, DatastoreClass var2, AbstractClassMetaData var3, int var4);

    public Object newObjectID(ObjectManager om, String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, om.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            DatastoreClass t = null;
            if (this.usesDatastoreClass()) {
                t = this.getDatastoreClass(className, om.getClassLoaderResolver());
                if (t == null && cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                    throw new JPOXUserException(LOCALISER.msg("StoreManager.NoTableForClass", className));
                }
                boolean has_superclass = true;
                while (has_superclass) {
                    DatastoreClass supert = t.getSuperDatastoreClass();
                    if (supert != null) {
                        t = supert;
                        continue;
                    }
                    has_superclass = false;
                }
            }
            Object nextIdentifier = this.getStrategyValue(om, t, cmd, -1);
            return OIDFactory.getInstance(om, cmd.getFullClassName(), nextIdentifier);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getApiAdapter().getNewApplicationIdentityObjectId(pc, cmd);
        }
        return new SCOID(className);
    }

    public abstract void insertObject(StateManager var1);

    public abstract void fetchObject(StateManager var1, int[] var2);

    public abstract void updateObject(StateManager var1, int[] var2);

    public abstract void deleteObject(StateManager var1);

    public abstract void locateObject(StateManager var1);

    public abstract Object findObject(ObjectManager var1, Object var2);

    public void performVersionCheck(StateManager sm, Object versionDatastore, VersionMetaData versionMetaData) {
        boolean valid;
        Object versionObject = sm.getTransactionalVersion(sm.getObject());
        if (versionObject == null) {
            return;
        }
        if (versionMetaData == null) {
            JPOXLogger.JDO.info(sm.getClassMetaData().getFullClassName() + " has no version metadata so no check of version is required, since this will not have the version flag in its table");
            return;
        }
        if (versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
            valid = ((Timestamp)versionObject).getTime() == ((Timestamp)versionDatastore).getTime();
        } else if (versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
            valid = ((Number)versionObject).longValue() == ((Number)versionDatastore).longValue();
        } else {
            if (versionMetaData.getVersionStrategy() == VersionStrategy.STATE_IMAGE) {
                throw new JPOXUserException(LOCALISER.msg("StoreManager.OptimisticStrategyNotSupported", sm.getClassMetaData().getFullClassName(), versionMetaData.getVersionStrategy()));
            }
            throw new JPOXUserException(LOCALISER.msg("StoreManager.OptimisticStrategyNotSupported", sm.getClassMetaData().getFullClassName(), versionMetaData.getVersionStrategy()));
        }
        if (!valid) {
            String msg = LOCALISER.msg("StoreManager.OptimisticVersionMismatch", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId(), "" + versionDatastore, "" + versionObject);
            JPOXLogger.PERSISTENCE.error(msg);
            throw new JPOXOptimisticException(msg, sm.getObject());
        }
    }

    public abstract void flush(ObjectManager var1);

    public void postCommit() {
    }

    public HashSet getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        HashSet<String> subclasses = new HashSet<String>();
        String[] subclassNames = this.getMetaDataManager().getSubclassesForClass(className, includeDescendents);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                if (!this.storeDataMgr.managesClass(subclassNames[i])) {
                    this.addClass(subclassNames[i], clr);
                }
                subclasses.add(subclassNames[i]);
            }
        }
        return subclasses;
    }

    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    public MetaDataManager getMetaDataManager() {
        return this.omfContext.getMetaDataManager();
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public abstract Date getDatastoreDate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreClass getDatastoreClass(String className, ClassLoaderResolver clr) {
        DatastoreClass ct = null;
        if (className == null) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("StoreManager.TableRetrievalError"));
            return null;
        }
        StoreData sd = this.storeDataMgr.get(className);
        if (sd != null && sd instanceof TableStoreData && (ct = (DatastoreClass)((TableStoreData)sd).getDatastoreContainerObject()) != null) {
            return ct;
        }
        boolean toBeAdded = false;
        if (clr != null) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && api.isPersistable(cls)) {
                toBeAdded = true;
            }
        } else {
            toBeAdded = true;
        }
        boolean classKnown = false;
        if (toBeAdded) {
            this.addClass(className, clr);
            StoreDataManager storeDataManager = this.storeDataMgr;
            synchronized (storeDataManager) {
                sd = this.storeDataMgr.get(className);
                if (sd != null && sd instanceof TableStoreData) {
                    classKnown = true;
                    ct = (DatastoreClass)((TableStoreData)sd).getDatastoreContainerObject();
                }
            }
        }
        if (!classKnown && ct == null) {
            throw new NoTableManagedException(className);
        }
        return ct;
    }

    public synchronized DatastoreClass getDatastoreClass(DatastoreIdentifier name) {
        Iterator iterator = this.storeDataMgr.getManagedStoreData().iterator();
        while (iterator.hasNext()) {
            TableStoreData tsd;
            StoreData sd = (StoreData)iterator.next();
            if (!(sd instanceof TableStoreData) || !(tsd = (TableStoreData)sd).hasTable() || !tsd.getDatastoreIdentifier().equals(name)) continue;
            return (DatastoreClass)tsd.getDatastoreContainerObject();
        }
        return null;
    }

    public AbstractClassMetaData getClassWithPrimaryKeyForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getSuperAbstractClassMetaData() == null) {
            return cmd;
        }
        if (this.getDatastoreClass(cmd.getFullClassName(), clr) != null) {
            return cmd;
        }
        return this.getClassWithPrimaryKeyForClass(cmd.getSuperAbstractClassMetaData(), clr);
    }

    public void notifyObjectIsOutdated(StateManager sm) {
    }

    public abstract void resolveIdentifierMacro(MacroString.IdentifierMacro var1, ClassLoaderResolver var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

