/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.ContainerSizeExpression;
import org.jpox.store.expression.ExistsExpression;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.UnboundVariable;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.scostore.ArrayStore;

public class ArrayExpression
extends ScalarExpression {
    ScalarExpression[] exprs;
    private ArrayStore arrayStore;
    private String fieldName;
    static /* synthetic */ Class class$java$lang$Integer;

    protected ArrayExpression(QueryExpression qs) {
        super(qs);
    }

    public ArrayExpression(QueryExpression qs, ScalarExpression[] expr) {
        super(qs);
        this.exprs = expr;
    }

    public ArrayExpression(QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, ArrayStore arrayStore, String fieldName) {
        super(qs);
        this.mapping = ownerMapping;
        this.arrayStore = arrayStore;
        this.fieldName = fieldName;
        this.te = te;
    }

    public NumericExpression sizeMethod() {
        if (this.arrayStore != null) {
            IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
            String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
            DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
            return new ContainerSizeExpression(this.qs, this.arrayStore.getSizeSubquery(this.qs, this.mapping, this.te, ctRangeVar));
        }
        JavaTypeMapping mapping = this.qs.getStoreManager().getDatastoreAdapter().getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = ArrayExpression.class$("java.lang.Integer")) : class$java$lang$Integer, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
        return new IntegerLiteral(this.qs, mapping, new Integer(this.exprs.length));
    }

    public NumericExpression lengthMethod() {
        return this.sizeMethod();
    }

    public ScalarExpression accessField(String subfieldName, boolean innerJoin) {
        if (!subfieldName.endsWith("length")) {
            throw new JPOXUserException("The field " + subfieldName + " is not accessible in an array");
        }
        return this.sizeMethod();
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        DatastoreIdentifier etRangeVar;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        if (this.exprs != null) {
            ScalarExpression bExpr = null;
            for (int i = 0; i < this.exprs.length; ++i) {
                bExpr = bExpr == null ? this.exprs[i].eq(expr) : ((BooleanExpression)bExpr).ior(this.exprs[i].eq(expr));
            }
            bExpr.encloseWithInParentheses();
            return bExpr;
        }
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(this.qs.getClassLoaderResolver().classForName(this.arrayStore.getElementType()));
            }
            String etIdentifier = "UNBOUND." + var.getVariableName();
            String ctIdentifier = idFactory.newIdentifier(idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName), var.getVariableName()).getIdentifier();
            DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
            DatastoreIdentifier etRangeVar2 = idFactory.newIdentifier(0, etIdentifier);
            QueryExpression qexpr = this.arrayStore.getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
            var.bindTo(this.arrayStore.joinElementsTo(qexpr, this.qs, this.mapping, this.te, ctRangeVar, var.getVariableType(), expr, expr.te == null ? etRangeVar2 : expr.te.getRangeVariable()));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        if (expr instanceof Literal) {
            DatastoreIdentifier etRangeVar3;
            String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
            DatastoreIdentifier ctRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, ctIdentifier);
            if (expr.te == null) {
                String etIdentifier;
                int n = 0;
                do {
                    etIdentifier = ctIdentifier + '.' + ++n;
                } while (this.qs.getTableExpression(etRangeVar3 = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, etIdentifier)) != null);
            } else {
                etRangeVar3 = expr.te.getRangeVariable();
            }
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            QueryExpression qexpr = this.arrayStore.getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
            ScalarExpression expr1 = this.arrayStore.joinElementsTo(qexpr, this.qs, this.mapping, this.te, ctRangeVar, clr.classForName(expr.getMapping().getType()), expr, expr.te == null ? etRangeVar3 : expr.te.getRangeVariable());
            qexpr.andCondition(expr.eq(expr1));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
        DatastoreIdentifier ctRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, ctIdentifier);
        if (expr.te == null) {
            String etIdentifier;
            int n = 0;
            do {
                etIdentifier = ctIdentifier + '.' + ++n;
            } while (this.qs.getTableExpression(etRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, etIdentifier)) != null);
        } else {
            etRangeVar = expr.te.getRangeVariable();
        }
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        ScalarExpression joinExpr = this.arrayStore.joinElementsTo(expr.getQueryExpression(), this.qs, this.mapping, this.te, ctRangeVar, clr.classForName(this.arrayStore.getElementType()), expr, etRangeVar);
        return joinExpr.eq(expr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

