/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class CharacterLiteral
extends CharacterExpression
implements Literal {
    private final String value;

    public CharacterLiteral(QueryExpression qs, JavaTypeMapping mapping, char value) {
        super(qs);
        this.mapping = mapping;
        this.value = String.valueOf(value);
        this.st.append('\'').append(value).append('\'');
    }

    public CharacterLiteral(QueryExpression qs, JavaTypeMapping mapping, String value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.appendParameter(mapping, value);
    }

    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        return new Character(this.value.charAt(0));
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.equals(((CharacterLiteral)expr).value));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, !this.value.equals(((CharacterLiteral)expr).value));
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) <= 0);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((CharacterLiteral)expr).value) >= 0);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) + ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) + ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) - ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) - ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
        }
        return super.add(expr);
    }

    public ScalarExpression mod(ScalarExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) % ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) % ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
        }
        return super.mod(expr);
    }

    public CharacterExpression toLowerCaseMethod() {
        return new CharacterLiteral(this.qs, this.mapping, this.value.toLowerCase());
    }

    public CharacterExpression toUpperCaseMethod() {
        return new CharacterLiteral(this.qs, this.mapping, this.value.toUpperCase());
    }

    public ScalarExpression neg() {
        char v = -this.value.charAt(0);
        return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
    }

    public ScalarExpression com() {
        int v = ~this.value.charAt(0);
        return new IntegerLiteral(this.qs, this.mapping, new Integer(v));
    }
}

