/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class MapValueLiteral
extends ScalarExpression {
    private final boolean isEmpty;
    private final boolean containsNull;
    private final DatastoreAdapter dba;
    private List scalarExpressions;

    public MapValueLiteral(QueryExpression qs, JavaTypeMapping mapping, Map map) {
        super(qs);
        this.mapping = mapping;
        this.containsNull = map != null && map.containsValue(null);
        this.dba = qs.getStoreManager().getDatastoreAdapter();
        boolean bl = this.isEmpty = map == null || map.isEmpty() || map.size() == 1 && this.containsNull;
        if (!this.isEmpty) {
            this.scalarExpressions = new ArrayList();
            this.st.append("(");
            boolean hadPrev = false;
            Collection values = map.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object current = it.next();
                if (null == current) continue;
                JavaTypeMapping m = this.dba.getMapping(current.getClass(), qs.getStoreManager(), qs.getClassLoaderResolver());
                ScalarExpression expr = m.newLiteral(qs, current);
                this.st.append(hadPrev ? "," : "");
                this.st.append(expr);
                this.scalarExpressions.add(expr);
                hadPrev = true;
            }
            this.st.append(")");
        }
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        if (this.isEmpty) {
            return new BooleanLiteral(this.qs, this.mapping, false);
        }
        ScalarExpression bExpr = null;
        for (int i = 0; i < this.scalarExpressions.size(); ++i) {
            bExpr = bExpr == null ? ((ScalarExpression)this.scalarExpressions.get(i)).eq(expr) : ((BooleanExpression)bExpr).ior(((ScalarExpression)this.scalarExpressions.get(i)).eq(expr));
        }
        bExpr.encloseWithInParentheses();
        return bExpr;
    }

    public BooleanExpression isEmptyMethod() {
        return new BooleanLiteral(this.qs, this.mapping, this.isEmpty);
    }
}

