/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.OIDMapping;
import org.jpox.util.ClassUtils;

public class NewObjectExpression
extends ScalarExpression {
    Class newClass = null;
    List ctrArgs = null;
    final Constructor ctr;

    public NewObjectExpression(QueryExpression qs, Class cls, List args) {
        super(qs);
        this.newClass = cls;
        this.ctrArgs = new ArrayList(args);
        Class[] ctrTypes = new Class[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            ctrTypes[i] = ((ScalarExpression)args.get(i)).getMapping() instanceof OIDMapping ? qs.getClassLoaderResolver().classForName(((OIDMapping)((ScalarExpression)args.get(i)).getMapping()).getType()) : (args.get(i) instanceof NewObjectExpression ? ((NewObjectExpression)args.get(i)).getNewClass() : ((ScalarExpression)args.get(i)).getMapping().getJavaType());
        }
        this.ctr = ClassUtils.getConstructorWithArguments(this.newClass, ctrTypes);
        if (this.ctr == null) {
            throw new JPOXUserException(LOCALISER.msg("NewObjectExpression.ConstructorNotFound", this.newClass.getName() + NewObjectExpression.typeList(Arrays.asList(ctrTypes))));
        }
    }

    private static String typeList(List exprs) {
        StringBuffer s = new StringBuffer("(");
        Iterator i = exprs.iterator();
        while (i.hasNext()) {
            s.append(i.next()).append(i.hasNext() ? (char)',' : ')');
        }
        return s.toString();
    }

    public Class getNewClass() {
        return this.newClass;
    }

    public List getArgumentExpressions() {
        return this.ctrArgs;
    }

    public Object createNewObject(Object[] values) {
        if ((values == null || values.length == 0) && this.ctrArgs.size() > 0) {
            throw new JPOXUserException(LOCALISER.msg("NewObjectExpression.ConstructorArgumentMismatch", "0", "" + this.ctrArgs.size()));
        }
        if (values.length != this.ctrArgs.size()) {
            throw new JPOXUserException(LOCALISER.msg("NewObjectExpression.ConstructorArgumentMismatch", "" + values.length, "" + this.ctrArgs.size()));
        }
        Object obj = null;
        if (this.ctr != null) {
            try {
                obj = this.ctr.newInstance(values);
            }
            catch (Exception e) {
                throw new JPOXUserException(LOCALISER.msg("NewObjectExpression.ConstructorFailure", this.newClass.getName(), e));
            }
        }
        return obj;
    }
}

