/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.NullComparisonExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.NullMapping;

public class NullLiteral
extends ScalarExpression
implements Literal {
    public NullLiteral(QueryExpression qs) {
        super(qs);
        this.mapping = new NullMapping(qs.getStoreManager().getDatastoreAdapter());
        this.st.append("NULL");
    }

    public Object getValue() {
        return null;
    }

    public ScalarExpression add(ScalarExpression expr) {
        return this;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        if (expr instanceof ObjectExpression) {
            return expr.eq(this);
        }
        return new NullComparisonExpression(expr, true, this);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, false);
        }
        if (expr instanceof ObjectExpression) {
            return expr.noteq(this);
        }
        return new NullComparisonExpression(expr.encloseWithInParentheses(), false, this);
    }
}

